const config = require('./config');
const actions = require('nightmare/lib/actions');
const Nightmare = require('nightmare');
const expect = require('chai').expect;
const fs = require('fs');

var customActions = {

  // Simule un evenement clavier sur un élément
  keydown(selector, options, done){
    this.evaluate_now((selector, options) => {
      var e = $.Event("keydown");
      $.extend(e, options);
      $(selector).trigger(e);
      return true;
    }, done, selector, options);
  },

  // Aller à la page d'accueil de l'application
  start(done) {
    headers = {};
    for (var key in this._headers) {
      headers[key] = headers[key] || this._headers[key];
    }
    this.child.call('goto', `http://${config.MACHINE_HOST}:8080/test.html`, headers, this.options.gotoTimeout, () => {
	  console.log('1');
      customActions.injectJs.call(this, 'inject.js', () => {
		console.log('2');
        actions.wait.call(this, 'tiramisu-form', () => {
		  console.log('3');
		  done();
        });
      });
    });
    return this;
  },

  injectJs(file, done) {
    var js = fs.readFileSync(file, { encoding: 'utf-8' });
    this.evaluate_now((js) => {
      var s = document.createElement('script');
      s.setAttribute('type', 'text/javascript');
      s.text = js;
      document.getElementsByTagName('head')[0].appendChild(s);
      return true;
    }, done, js);
    return this;
  }

};

Object.keys(customActions).forEach(function (name) {
  Nightmare.action(name, customActions[name]);
});
