from tiramisu.option import UnicodeOption, OptionDescription
from tiramisu_web import MasterSlaves

def get_description():
    """generate description for this test
    """
    option = UnicodeOption('unicode', "Unicode master", multi=True, properties=('hidden',))
    option1 = UnicodeOption('unicode1', "Unicode slave 1", multi=True)
    option2 = UnicodeOption('unicode2', "Unicode slave 2", multi=True)
    option3 = UnicodeOption('unicode3', "Unicode slave 3", multi=True)
    descr1 = MasterSlaves("unicode", "Common configuration",
                          [option, option1, option2, option3])
    descr = OptionDescription("options", "Common configuration", [descr1])
    descr = OptionDescription("unicode1_master_hidden_slaves", "Master slave with unicode and hidden master", [descr])
    return descr
