from tiramisu.option import UnicodeOption, OptionDescription
from tiramisu_web import MasterSlaves
from tiramisu.setting import groups

def get_description():
    """generate description for this test
    """
    option = UnicodeOption('unicode', "Unicode master", ['val1', 'val2'], multi=True)
    option1 = UnicodeOption('unicode1', "Unicode slave 1", multi=True)
    option2 = UnicodeOption('unicode2', "Unicode slave 2 with default multi", default_multi="slave2", multi=True)
    option3 = UnicodeOption('unicode3', "Unicode slave 3", multi=True)
    descr1 = MasterSlaves("unicode", "Common configuration 1",
                          [option, option1, option2, option3])
    descr = OptionDescription("options", "Common configuration 2", [descr1])
    descr = OptionDescription("unicode1_master_slaves_default_value", "Master slaves with unicode with default value", [descr])
    return descr
