from tiramisu.option import UnicodeOption, OptionDescription
from tiramisu_web import MasterSlaves


def get_description():
    """generate description for this test
    """
    option = UnicodeOption('unicode', "Unicode master", multi=True)
    option1 = UnicodeOption('unicode1', "Unicode slave 1", multi=True)
    option2 = UnicodeOption('unicode2', "Unicode slave 2 hidden", multi=True, properties=('hidden',))
    option3 = UnicodeOption('unicode3', "Unicode slave 3", multi=True)
    descr1 = MasterSlaves("unicode", "Common configuration",
                          [option, option1, option2, option3])
    descr = OptionDescription("options", "Common configuration", [descr1])
    descr = OptionDescription("unicode1_master_slaves_hidden", "Master slaves with second slave hidden", [descr])
    return descr


def get_values(api, allpath=False):
    if allpath:
        root = 'unicode1_master_slaves_hidden.'
    else:
        root = ''
    api.option(root + 'options.unicode.unicode').value.set([u'val1', u'val2'])
    api.option(root + 'options.unicode.unicode2', 0).value.set(u'super')
