from tiramisu.option import UnicodeOption, OptionDescription
from tiramisu_web import MasterSlaves


def get_description():
    """generate description for this test
    """
    option = UnicodeOption('unicode', "Unicode master", multi=True)
    option1 = UnicodeOption('unicode1', "Unicode slave 1", multi=True)
    option2 = UnicodeOption('unicode2', "Values 'test' must show 'Unicode slave 3'", multi=True)
    option3 = UnicodeOption('unicode3', "Unicode slave 3", requires=[{'option': option2,
                                                                      'expected': u'test',
                                                                      'action': 'hidden',
                                                                      'inverse': True}],
                            multi=True)
    descr1 = MasterSlaves("unicode", "Common configuration 1",
                          [option, option1, option2, option3])
    descr = OptionDescription("options", "Common configuration 2", [descr1])
    descr = OptionDescription("unicode1_master_slaves_requires", "Master slaves with Unicode slave 3 hidden when Unicode slave 2 is test", [descr])
    return descr
