#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""Un agent de listing (pour les tests)
"""

import os

from agent import Agent

class ListAgent(Agent):
    """Liste un répertoire courant
    """
    def __init__(self,repertoire_listing= "./"):
        self.repertoire = repertoire_listing
        self.name="ls"
        self.description="""Listing des fichiers d'un répertoire"""
        Agent.__init__(self)
        # écriture dans les fichiers
        self.write_html()
        self.write_xml()

    HTML = """
<div class="titlediv">
<h1 class="newstitle">
Listing du répertoire des scripts perso
</h1>
<a name="%s"/>
</div>
<div class="bodydiv">
Listing du répertoire : <br/>
%s
</div>
"""
    def _ls(self):
        """Récupère la sortie de ls
        """
        sortie = os.popen("ls %s" % self.repertoire)
        resultat = sortie.readlines()
        sortie.close()
        return resultat
        
    def _dump_xml(self):
        """
        Formatage xml du résultat
        """
        liste_resultat = self._ls()
        l = ["""  <ul>"""]
        for elt in liste_resultat:
            l.append("""    <li>%s</li>""" % elt.rstrip())

        l.append("""  </ul>""")
        return "\n".join(l)

    def _dump_html(self):
        """Formatage html du résultat 
        """
        return self.HTML % (self.name, self._dump_xml())
    
if __name__ == "__main__":
    ListAgent()
