# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir pour la surveillance d'expiration des certificats
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import HTMLData, TableData
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import status_to_img
from pyeole.diagnose import CertValidator


class LocalCert(Agent):
    def __init__(self, name, cert_files, **params):
        Agent.__init__(self, name, **params)
        self.status = status.OK()
        self.table = TableData([
            ('path', "Chemin du certificat", {'align': 'left'}, None),
            ('expire', "Validité", {'align': 'left'}, None),
            ('usage', "Impact", {'align': 'left'}, None),
            ('status', "État", {'align':'center'}, status_to_img),
            ])
        self.cert_files = cert_files
        title = HTMLData("<h3>Surveillance des certificats</h3>")
        self.data = [title, self.table]

    def measure(self):
        self.status = status.OK()
        new_measure = []
        for cert_file, cert_datas in self.cert_files.items():
            cert = CertValidator(cert_file, chain=cert_datas['chain'], ca=cert_datas['ca'])
            res = cert.test_cert()
            if not res['valid'][0]:
                self.status = status.Error()
                status_ = "Off"
                valid = res['valid'][1]
            elif res['expired'][0] != 'OK':
                if res['expired'][0] == 'ERROR' and self.status < status.Error():
                    self.status = status.Error()
                elif self.status < status.Warn():  # WARNING
                    self.status = status.Warn()
                status_ = "Off"
                valid = res['expired'][1]
            else:
                # Certificate OK
                status_ = "On"
                valid = res['expired'][1]
            new_measure.append({'path': cert_file,
                                'expire': valid,
                                'usage': ', '.join(cert_datas.get('usage', [])),
                                'status': status_,
                                })

        return new_measure

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value

    def check_status(self):
        return self.status
