#!/usr/bin/env python3
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# parse_logs.py
#
# script de mise à jour de la table last_log_serveur depuis log_serveur
#
###########################################################################

import os,sys
import psycopg2 as PgSQL
from zephir.backend.config import DB_NAME, DB_USER, DB_PASSWD

cx = PgSQL.connect(database=DB_NAME,user=DB_USER,password=DB_PASSWD)
cu = cx.cursor()

cu.execute("""select * from last_log_serveur limit 1""")
test = cu.fetchall()
cu.execute("""select * from log_serveur limit 1""")
test2 = cu.fetchall()
if test == [] and test2 != []:
    print("\nOptimisation de la table des logs, veuillez patienter ...")
    # La table des logs réduits vient d'être créée
    # on la remplit à partir de la table principale
    print(" - Purge des logs de surveillance")
    # purge des logs de surveillance et des logs rvp
    cu.execute("""delete from log_serveur where type in ('SURVEILLANCE','RVP')""")
    cx.commit()
    print(" - Remplissage de la table des logs réduits")
    cu.execute("""select id_serveur, type from log_serveur group by id_serveur, type""")
    logs=cu.fetchall()
    for log in logs:
        if log[1] != 'SURVEILLANCE':
            # on lit le dernier log de chaque type dans la table log_serveur
            cu.execute("""select * from log_serveur where id_serveur = %s and type = '%s' order by date desc, id desc limit 1""" % (log[0],log[1]))
            res = cu.fetchall()[0]
            # et on l'insère dans last_log_serveur
            try:
                query = """insert into last_log_serveur (id_serveur,date,type,message,etat) values (%s,'%s','%s','%s',%s)""" % (res[1],str(res[2]),res[3].replace("'","''"),res[4].replace("'","''"),res[5])
                cu.execute(query)
            except Exception as e :
                print("erreur  : %s" % str(e))
                print("données : ", res)
                cx.rollback()
                sys.exit(1)
    cx.commit()
    print(" - récupération de l'espace disque et optimisation des requêtes")
    os.system('su - postgres -c "vacuumdb --analyze zephir" &> /dev/null')
    print("Mise à jour des logs terminée")
