/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_ACCELERATION_STRUCTURE_H
#define VN_PROTOCOL_RENDERER_ACCELERATION_STRUCTURE_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#if !defined(__clang__) && defined(__GNUC__) && __GNUC__ >= 12
#pragma GCC diagnostic ignored "-Wdangling-pointer"
#endif
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/*
 * These structs/unions/commands are not included
 *
 *   vkCopyAccelerationStructureToMemoryKHR
 *   vkCopyMemoryToAccelerationStructureKHR
 *   vkBuildAccelerationStructuresKHR
 */

/* struct VkAccelerationStructureVersionInfoKHR chain */

static inline void *
vn_decode_VkAccelerationStructureVersionInfoKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkAccelerationStructureVersionInfoKHR_self_temp(struct vn_cs_decoder *dec, VkAccelerationStructureVersionInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, 2*VK_UUID_SIZE);
        val->pVersionData = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pVersionData), array_size);
        if (!val->pVersionData) return;
        vn_decode_uint8_t_array(dec, (uint8_t *)val->pVersionData, array_size);
    } else {
        vn_decode_array_size(dec, 2*VK_UUID_SIZE);
        val->pVersionData = NULL;
    }
}

static inline void
vn_decode_VkAccelerationStructureVersionInfoKHR_temp(struct vn_cs_decoder *dec, VkAccelerationStructureVersionInfoKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkAccelerationStructureVersionInfoKHR_pnext_temp(dec);
    vn_decode_VkAccelerationStructureVersionInfoKHR_self_temp(dec, val);
}

static inline void
vn_replace_VkAccelerationStructureVersionInfoKHR_handle_self(VkAccelerationStructureVersionInfoKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->pVersionData */
}

static inline void
vn_replace_VkAccelerationStructureVersionInfoKHR_handle(VkAccelerationStructureVersionInfoKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR:
            vn_replace_VkAccelerationStructureVersionInfoKHR_handle_self((VkAccelerationStructureVersionInfoKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkAccelerationStructureCreateInfoKHR chain */

static inline void *
vn_decode_VkAccelerationStructureCreateInfoKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkAccelerationStructureCreateInfoKHR_self_temp(struct vn_cs_decoder *dec, VkAccelerationStructureCreateInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->createFlags);
    vn_decode_VkBuffer_lookup(dec, &val->buffer);
    vn_decode_VkDeviceSize(dec, &val->offset);
    vn_decode_VkDeviceSize(dec, &val->size);
    vn_decode_VkAccelerationStructureTypeKHR(dec, &val->type);
    vn_decode_VkDeviceAddress(dec, &val->deviceAddress);
}

static inline void
vn_decode_VkAccelerationStructureCreateInfoKHR_temp(struct vn_cs_decoder *dec, VkAccelerationStructureCreateInfoKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkAccelerationStructureCreateInfoKHR_pnext_temp(dec);
    vn_decode_VkAccelerationStructureCreateInfoKHR_self_temp(dec, val);
}

static inline void
vn_replace_VkAccelerationStructureCreateInfoKHR_handle_self(VkAccelerationStructureCreateInfoKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->createFlags */
    vn_replace_VkBuffer_handle(&val->buffer);
    /* skip val->offset */
    /* skip val->size */
    /* skip val->type */
    /* skip val->deviceAddress */
}

static inline void
vn_replace_VkAccelerationStructureCreateInfoKHR_handle(VkAccelerationStructureCreateInfoKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR:
            vn_replace_VkAccelerationStructureCreateInfoKHR_handle_self((VkAccelerationStructureCreateInfoKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkAccelerationStructureDeviceAddressInfoKHR chain */

static inline void *
vn_decode_VkAccelerationStructureDeviceAddressInfoKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkAccelerationStructureDeviceAddressInfoKHR_self_temp(struct vn_cs_decoder *dec, VkAccelerationStructureDeviceAddressInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkAccelerationStructureKHR_lookup(dec, &val->accelerationStructure);
}

static inline void
vn_decode_VkAccelerationStructureDeviceAddressInfoKHR_temp(struct vn_cs_decoder *dec, VkAccelerationStructureDeviceAddressInfoKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkAccelerationStructureDeviceAddressInfoKHR_pnext_temp(dec);
    vn_decode_VkAccelerationStructureDeviceAddressInfoKHR_self_temp(dec, val);
}

static inline void
vn_replace_VkAccelerationStructureDeviceAddressInfoKHR_handle_self(VkAccelerationStructureDeviceAddressInfoKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkAccelerationStructureKHR_handle(&val->accelerationStructure);
}

static inline void
vn_replace_VkAccelerationStructureDeviceAddressInfoKHR_handle(VkAccelerationStructureDeviceAddressInfoKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR:
            vn_replace_VkAccelerationStructureDeviceAddressInfoKHR_handle_self((VkAccelerationStructureDeviceAddressInfoKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkAccelerationStructureBuildSizesInfoKHR chain */

static inline void
vn_encode_VkAccelerationStructureBuildSizesInfoKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkAccelerationStructureBuildSizesInfoKHR_self(struct vn_cs_encoder *enc, const VkAccelerationStructureBuildSizesInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceSize(enc, &val->accelerationStructureSize);
    vn_encode_VkDeviceSize(enc, &val->updateScratchSize);
    vn_encode_VkDeviceSize(enc, &val->buildScratchSize);
}

static inline void
vn_encode_VkAccelerationStructureBuildSizesInfoKHR(struct vn_cs_encoder *enc, const VkAccelerationStructureBuildSizesInfoKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR });
    vn_encode_VkAccelerationStructureBuildSizesInfoKHR_pnext(enc, val->pNext);
    vn_encode_VkAccelerationStructureBuildSizesInfoKHR_self(enc, val);
}

static inline void *
vn_decode_VkAccelerationStructureBuildSizesInfoKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkAccelerationStructureBuildSizesInfoKHR_self_partial_temp(struct vn_cs_decoder *dec, VkAccelerationStructureBuildSizesInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->accelerationStructureSize */
    /* skip val->updateScratchSize */
    /* skip val->buildScratchSize */
}

static inline void
vn_decode_VkAccelerationStructureBuildSizesInfoKHR_partial_temp(struct vn_cs_decoder *dec, VkAccelerationStructureBuildSizesInfoKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkAccelerationStructureBuildSizesInfoKHR_pnext_partial_temp(dec);
    vn_decode_VkAccelerationStructureBuildSizesInfoKHR_self_partial_temp(dec, val);
}

static inline void vn_decode_vkDestroyAccelerationStructureKHR_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDestroyAccelerationStructureKHR *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkAccelerationStructureKHR_lookup(dec, &args->accelerationStructure);
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
}

static inline void vn_replace_vkDestroyAccelerationStructureKHR_args_handle(struct vn_command_vkDestroyAccelerationStructureKHR *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkAccelerationStructureKHR_handle(&args->accelerationStructure);
    /* skip args->pAllocator */
}

static inline void vn_encode_vkDestroyAccelerationStructureKHR_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDestroyAccelerationStructureKHR *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDestroyAccelerationStructureKHR_EXT});

    /* skip args->device */
    /* skip args->accelerationStructure */
    /* skip args->pAllocator */
}

static inline void vn_decode_vkCopyAccelerationStructureKHR_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCopyAccelerationStructureKHR *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkDeferredOperationKHR_lookup(dec, &args->deferredOperation);
    if (vn_decode_simple_pointer(dec)) {
        args->pInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pInfo));
        if (!args->pInfo) return;
        vn_decode_VkCopyAccelerationStructureInfoKHR_temp(dec, (VkCopyAccelerationStructureInfoKHR *)args->pInfo);
    } else {
        args->pInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCopyAccelerationStructureKHR_args_handle(struct vn_command_vkCopyAccelerationStructureKHR *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkDeferredOperationKHR_handle(&args->deferredOperation);
    if (args->pInfo)
        vn_replace_VkCopyAccelerationStructureInfoKHR_handle((VkCopyAccelerationStructureInfoKHR *)args->pInfo);
}

static inline void vn_encode_vkCopyAccelerationStructureKHR_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCopyAccelerationStructureKHR *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCopyAccelerationStructureKHR_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->deferredOperation */
    /* skip args->pInfo */
}

static inline void vn_decode_vkWriteAccelerationStructuresPropertiesKHR_args_temp(struct vn_cs_decoder *dec, struct vn_cs_encoder *enc, struct vn_command_vkWriteAccelerationStructuresPropertiesKHR *args)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWriteAccelerationStructuresPropertiesKHR_EXT;
    size_t offset = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    offset += vn_sizeof_VkResult(&ret);
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->accelerationStructureCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->accelerationStructureCount);
        args->pAccelerationStructures = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pAccelerationStructures), iter_count);
        if (!args->pAccelerationStructures) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkAccelerationStructureKHR_lookup(dec, &((VkAccelerationStructureKHR *)args->pAccelerationStructures)[i]);
    } else {
        vn_decode_array_size(dec, args->accelerationStructureCount);
        args->pAccelerationStructures = NULL;
    }
    vn_decode_VkQueryType(dec, &args->queryType);
    vn_decode_size_t(dec, &args->dataSize);
    if (vn_peek_array_size(dec)) {
        offset += vn_sizeof_array_size(args->dataSize);
        const size_t array_size = vn_decode_array_size(dec, args->dataSize);
        args->pData = vn_cs_encoder_get_blob_storage(enc, offset, array_size);
        if (!args->pData) return;
        offset += vn_sizeof_blob_array(args->pData, array_size);
    } else {
        vn_decode_array_size(dec, args->dataSize);
        args->pData = NULL;
    }
    vn_decode_size_t(dec, &args->stride);
}

static inline void vn_replace_vkWriteAccelerationStructuresPropertiesKHR_args_handle(struct vn_command_vkWriteAccelerationStructuresPropertiesKHR *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->accelerationStructureCount */
    if (args->pAccelerationStructures) {
       for (uint32_t i = 0; i < args->accelerationStructureCount; i++)
            vn_replace_VkAccelerationStructureKHR_handle(&((VkAccelerationStructureKHR *)args->pAccelerationStructures)[i]);
    }
    /* skip args->queryType */
    /* skip args->dataSize */
    /* skip args->pData */
    /* skip args->stride */
}

static inline void vn_encode_vkWriteAccelerationStructuresPropertiesKHR_reply(struct vn_cs_encoder *enc, const struct vn_command_vkWriteAccelerationStructuresPropertiesKHR *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkWriteAccelerationStructuresPropertiesKHR_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->accelerationStructureCount */
    /* skip args->pAccelerationStructures */
    /* skip args->queryType */
    /* skip args->dataSize */
    if (args->pData) {
        vn_encode_array_size(enc, args->dataSize);
        vn_encode_blob_array(enc, args->pData, args->dataSize);
    } else {
        vn_encode_array_size(enc, 0);
    }
    /* skip args->stride */
}

static inline void vn_decode_vkGetDeviceAccelerationStructureCompatibilityKHR_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetDeviceAccelerationStructureCompatibilityKHR *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pVersionInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pVersionInfo));
        if (!args->pVersionInfo) return;
        vn_decode_VkAccelerationStructureVersionInfoKHR_temp(dec, (VkAccelerationStructureVersionInfoKHR *)args->pVersionInfo);
    } else {
        args->pVersionInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pCompatibility = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCompatibility));
        if (!args->pCompatibility) return;
    } else {
        args->pCompatibility = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetDeviceAccelerationStructureCompatibilityKHR_args_handle(struct vn_command_vkGetDeviceAccelerationStructureCompatibilityKHR *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pVersionInfo)
        vn_replace_VkAccelerationStructureVersionInfoKHR_handle((VkAccelerationStructureVersionInfoKHR *)args->pVersionInfo);
    /* skip args->pCompatibility */
}

static inline void vn_encode_vkGetDeviceAccelerationStructureCompatibilityKHR_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetDeviceAccelerationStructureCompatibilityKHR *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetDeviceAccelerationStructureCompatibilityKHR_EXT});

    /* skip args->device */
    /* skip args->pVersionInfo */
    if (vn_encode_simple_pointer(enc, args->pCompatibility))
        vn_encode_VkAccelerationStructureCompatibilityKHR(enc, args->pCompatibility);
}

static inline void vn_decode_vkCreateAccelerationStructureKHR_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateAccelerationStructureKHR *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfo));
        if (!args->pCreateInfo) return;
        vn_decode_VkAccelerationStructureCreateInfoKHR_temp(dec, (VkAccelerationStructureCreateInfoKHR *)args->pCreateInfo);
    } else {
        args->pCreateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pAccelerationStructure = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pAccelerationStructure));
        if (!args->pAccelerationStructure) return;
        vn_decode_VkAccelerationStructureKHR(dec, args->pAccelerationStructure);
    } else {
        args->pAccelerationStructure = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCreateAccelerationStructureKHR_args_handle(struct vn_command_vkCreateAccelerationStructureKHR *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pCreateInfo)
        vn_replace_VkAccelerationStructureCreateInfoKHR_handle((VkAccelerationStructureCreateInfoKHR *)args->pCreateInfo);
    /* skip args->pAllocator */
    /* skip args->pAccelerationStructure */
}

static inline void vn_encode_vkCreateAccelerationStructureKHR_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateAccelerationStructureKHR *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateAccelerationStructureKHR_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pCreateInfo */
    /* skip args->pAllocator */
    if (vn_encode_simple_pointer(enc, args->pAccelerationStructure))
        vn_encode_VkAccelerationStructureKHR(enc, args->pAccelerationStructure);
}

static inline void vn_decode_vkGetAccelerationStructureDeviceAddressKHR_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetAccelerationStructureDeviceAddressKHR *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pInfo));
        if (!args->pInfo) return;
        vn_decode_VkAccelerationStructureDeviceAddressInfoKHR_temp(dec, (VkAccelerationStructureDeviceAddressInfoKHR *)args->pInfo);
    } else {
        args->pInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetAccelerationStructureDeviceAddressKHR_args_handle(struct vn_command_vkGetAccelerationStructureDeviceAddressKHR *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pInfo)
        vn_replace_VkAccelerationStructureDeviceAddressInfoKHR_handle((VkAccelerationStructureDeviceAddressInfoKHR *)args->pInfo);
}

static inline void vn_encode_vkGetAccelerationStructureDeviceAddressKHR_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetAccelerationStructureDeviceAddressKHR *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetAccelerationStructureDeviceAddressKHR_EXT});

    vn_encode_VkDeviceAddress(enc, &args->ret);
    /* skip args->device */
    /* skip args->pInfo */
}

static inline void vn_decode_vkGetAccelerationStructureBuildSizesKHR_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetAccelerationStructureBuildSizesKHR *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkAccelerationStructureBuildTypeKHR(dec, &args->buildType);
    if (vn_decode_simple_pointer(dec)) {
        args->pBuildInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBuildInfo));
        if (!args->pBuildInfo) return;
        vn_decode_VkAccelerationStructureBuildGeometryInfoKHR_temp(dec, (VkAccelerationStructureBuildGeometryInfoKHR *)args->pBuildInfo);
    } else {
        args->pBuildInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, (args->pBuildInfo ? args->pBuildInfo->geometryCount : 0));
        args->pMaxPrimitiveCounts = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pMaxPrimitiveCounts), array_size);
        if (!args->pMaxPrimitiveCounts) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)args->pMaxPrimitiveCounts, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pMaxPrimitiveCounts = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pSizeInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSizeInfo));
        if (!args->pSizeInfo) return;
        vn_decode_VkAccelerationStructureBuildSizesInfoKHR_partial_temp(dec, args->pSizeInfo);
    } else {
        args->pSizeInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetAccelerationStructureBuildSizesKHR_args_handle(struct vn_command_vkGetAccelerationStructureBuildSizesKHR *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->buildType */
    if (args->pBuildInfo)
        vn_replace_VkAccelerationStructureBuildGeometryInfoKHR_handle((VkAccelerationStructureBuildGeometryInfoKHR *)args->pBuildInfo);
    /* skip args->pMaxPrimitiveCounts */
    /* skip args->pSizeInfo */
}

static inline void vn_encode_vkGetAccelerationStructureBuildSizesKHR_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetAccelerationStructureBuildSizesKHR *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetAccelerationStructureBuildSizesKHR_EXT});

    /* skip args->device */
    /* skip args->buildType */
    /* skip args->pBuildInfo */
    /* skip args->pMaxPrimitiveCounts */
    if (vn_encode_simple_pointer(enc, args->pSizeInfo))
        vn_encode_VkAccelerationStructureBuildSizesInfoKHR(enc, args->pSizeInfo);
}

static inline void vn_dispatch_vkDestroyAccelerationStructureKHR(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDestroyAccelerationStructureKHR args;

    if (!ctx->dispatch_vkDestroyAccelerationStructureKHR) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDestroyAccelerationStructureKHR_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDestroyAccelerationStructureKHR(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkDestroyAccelerationStructureKHR_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCopyAccelerationStructureKHR(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCopyAccelerationStructureKHR args;

    if (!ctx->dispatch_vkCopyAccelerationStructureKHR) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCopyAccelerationStructureKHR_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCopyAccelerationStructureKHR(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCopyAccelerationStructureKHR returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkCopyAccelerationStructureKHR_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkWriteAccelerationStructuresPropertiesKHR(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkWriteAccelerationStructuresPropertiesKHR args;

    if (!ctx->dispatch_vkWriteAccelerationStructuresPropertiesKHR) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) {
        if (!vn_cs_encoder_acquire(ctx->encoder))
           return;
    }

    vn_decode_vkWriteAccelerationStructuresPropertiesKHR_args_temp(ctx->decoder, ctx->encoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkWriteAccelerationStructuresPropertiesKHR(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkWriteAccelerationStructuresPropertiesKHR returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        vn_encode_vkWriteAccelerationStructuresPropertiesKHR_reply(ctx->encoder, &args);
        vn_cs_encoder_release(ctx->encoder);
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetDeviceAccelerationStructureCompatibilityKHR(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetDeviceAccelerationStructureCompatibilityKHR args;

    if (!ctx->dispatch_vkGetDeviceAccelerationStructureCompatibilityKHR) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetDeviceAccelerationStructureCompatibilityKHR_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetDeviceAccelerationStructureCompatibilityKHR(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetDeviceAccelerationStructureCompatibilityKHR_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCreateAccelerationStructureKHR(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateAccelerationStructureKHR args;

    if (!ctx->dispatch_vkCreateAccelerationStructureKHR) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateAccelerationStructureKHR_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateAccelerationStructureKHR(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCreateAccelerationStructureKHR returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkCreateAccelerationStructureKHR_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetAccelerationStructureDeviceAddressKHR(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetAccelerationStructureDeviceAddressKHR args;

    if (!ctx->dispatch_vkGetAccelerationStructureDeviceAddressKHR) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetAccelerationStructureDeviceAddressKHR_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetAccelerationStructureDeviceAddressKHR(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetAccelerationStructureDeviceAddressKHR_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetAccelerationStructureBuildSizesKHR(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetAccelerationStructureBuildSizesKHR args;

    if (!ctx->dispatch_vkGetAccelerationStructureBuildSizesKHR) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetAccelerationStructureBuildSizesKHR_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetAccelerationStructureBuildSizesKHR(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetAccelerationStructureBuildSizesKHR_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#pragma GCC diagnostic pop

#endif /* VN_PROTOCOL_RENDERER_ACCELERATION_STRUCTURE_H */
