/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2022 Google LLC
 * Copyright 2022 Collabora Ltd.
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_UTIL_H
#define VN_PROTOCOL_RENDERER_UTIL_H

#include "vn_protocol_renderer_info.h"

struct vn_global_proc_table {
   PFN_vkCreateInstance CreateInstance;
   PFN_vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties;
   PFN_vkEnumerateInstanceLayerProperties EnumerateInstanceLayerProperties;
   PFN_vkEnumerateInstanceVersion EnumerateInstanceVersion;
};

struct vn_instance_proc_table {
   PFN_vkDestroyInstance DestroyInstance;
   PFN_vkEnumeratePhysicalDeviceGroups EnumeratePhysicalDeviceGroups;
   PFN_vkEnumeratePhysicalDevices EnumeratePhysicalDevices;
};

struct vn_physical_device_proc_table {
   PFN_vkCreateDevice CreateDevice;
   PFN_vkEnumerateDeviceExtensionProperties EnumerateDeviceExtensionProperties;
   PFN_vkEnumerateDeviceLayerProperties EnumerateDeviceLayerProperties;
   PFN_vkGetDeviceProcAddr GetDeviceProcAddr;
   PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR GetPhysicalDeviceCalibrateableTimeDomainsKHR;
   PFN_vkGetPhysicalDeviceExternalBufferProperties GetPhysicalDeviceExternalBufferProperties;
   PFN_vkGetPhysicalDeviceExternalFenceProperties GetPhysicalDeviceExternalFenceProperties;
   PFN_vkGetPhysicalDeviceExternalSemaphoreProperties GetPhysicalDeviceExternalSemaphoreProperties;
   PFN_vkGetPhysicalDeviceFeatures GetPhysicalDeviceFeatures;
   PFN_vkGetPhysicalDeviceFeatures2 GetPhysicalDeviceFeatures2;
   PFN_vkGetPhysicalDeviceFormatProperties GetPhysicalDeviceFormatProperties;
   PFN_vkGetPhysicalDeviceFormatProperties2 GetPhysicalDeviceFormatProperties2;
   PFN_vkGetPhysicalDeviceFragmentShadingRatesKHR GetPhysicalDeviceFragmentShadingRatesKHR;
   PFN_vkGetPhysicalDeviceImageFormatProperties GetPhysicalDeviceImageFormatProperties;
   PFN_vkGetPhysicalDeviceImageFormatProperties2 GetPhysicalDeviceImageFormatProperties2;
   PFN_vkGetPhysicalDeviceMemoryProperties GetPhysicalDeviceMemoryProperties;
   PFN_vkGetPhysicalDeviceMemoryProperties2 GetPhysicalDeviceMemoryProperties2;
   PFN_vkGetPhysicalDeviceMultisamplePropertiesEXT GetPhysicalDeviceMultisamplePropertiesEXT;
   PFN_vkGetPhysicalDeviceProperties GetPhysicalDeviceProperties;
   PFN_vkGetPhysicalDeviceProperties2 GetPhysicalDeviceProperties2;
   PFN_vkGetPhysicalDeviceQueueFamilyProperties GetPhysicalDeviceQueueFamilyProperties;
   PFN_vkGetPhysicalDeviceQueueFamilyProperties2 GetPhysicalDeviceQueueFamilyProperties2;
   PFN_vkGetPhysicalDeviceSparseImageFormatProperties GetPhysicalDeviceSparseImageFormatProperties;
   PFN_vkGetPhysicalDeviceSparseImageFormatProperties2 GetPhysicalDeviceSparseImageFormatProperties2;
   PFN_vkGetPhysicalDeviceToolProperties GetPhysicalDeviceToolProperties;
};

struct vn_device_proc_table {
   PFN_vkAllocateCommandBuffers AllocateCommandBuffers;
   PFN_vkAllocateDescriptorSets AllocateDescriptorSets;
   PFN_vkAllocateMemory AllocateMemory;
   PFN_vkBeginCommandBuffer BeginCommandBuffer;
   PFN_vkBindBufferMemory BindBufferMemory;
   PFN_vkBindBufferMemory2 BindBufferMemory2;
   PFN_vkBindImageMemory BindImageMemory;
   PFN_vkBindImageMemory2 BindImageMemory2;
   PFN_vkBuildAccelerationStructuresKHR BuildAccelerationStructuresKHR;
   PFN_vkCmdBeginConditionalRenderingEXT CmdBeginConditionalRenderingEXT;
   PFN_vkCmdBeginQuery CmdBeginQuery;
   PFN_vkCmdBeginQueryIndexedEXT CmdBeginQueryIndexedEXT;
   PFN_vkCmdBeginRenderPass CmdBeginRenderPass;
   PFN_vkCmdBeginRenderPass2 CmdBeginRenderPass2;
   PFN_vkCmdBeginRendering CmdBeginRendering;
   PFN_vkCmdBeginTransformFeedbackEXT CmdBeginTransformFeedbackEXT;
   PFN_vkCmdBindDescriptorSets CmdBindDescriptorSets;
   PFN_vkCmdBindDescriptorSets2 CmdBindDescriptorSets2;
   PFN_vkCmdBindIndexBuffer CmdBindIndexBuffer;
   PFN_vkCmdBindIndexBuffer2 CmdBindIndexBuffer2;
   PFN_vkCmdBindPipeline CmdBindPipeline;
   PFN_vkCmdBindTransformFeedbackBuffersEXT CmdBindTransformFeedbackBuffersEXT;
   PFN_vkCmdBindVertexBuffers CmdBindVertexBuffers;
   PFN_vkCmdBindVertexBuffers2 CmdBindVertexBuffers2;
   PFN_vkCmdBlitImage CmdBlitImage;
   PFN_vkCmdBlitImage2 CmdBlitImage2;
   PFN_vkCmdBuildAccelerationStructuresIndirectKHR CmdBuildAccelerationStructuresIndirectKHR;
   PFN_vkCmdBuildAccelerationStructuresKHR CmdBuildAccelerationStructuresKHR;
   PFN_vkCmdClearAttachments CmdClearAttachments;
   PFN_vkCmdClearColorImage CmdClearColorImage;
   PFN_vkCmdClearDepthStencilImage CmdClearDepthStencilImage;
   PFN_vkCmdCopyAccelerationStructureKHR CmdCopyAccelerationStructureKHR;
   PFN_vkCmdCopyAccelerationStructureToMemoryKHR CmdCopyAccelerationStructureToMemoryKHR;
   PFN_vkCmdCopyBuffer CmdCopyBuffer;
   PFN_vkCmdCopyBuffer2 CmdCopyBuffer2;
   PFN_vkCmdCopyBufferToImage CmdCopyBufferToImage;
   PFN_vkCmdCopyBufferToImage2 CmdCopyBufferToImage2;
   PFN_vkCmdCopyImage CmdCopyImage;
   PFN_vkCmdCopyImage2 CmdCopyImage2;
   PFN_vkCmdCopyImageToBuffer CmdCopyImageToBuffer;
   PFN_vkCmdCopyImageToBuffer2 CmdCopyImageToBuffer2;
   PFN_vkCmdCopyMemoryToAccelerationStructureKHR CmdCopyMemoryToAccelerationStructureKHR;
   PFN_vkCmdCopyQueryPoolResults CmdCopyQueryPoolResults;
   PFN_vkCmdDispatch CmdDispatch;
   PFN_vkCmdDispatchBase CmdDispatchBase;
   PFN_vkCmdDispatchIndirect CmdDispatchIndirect;
   PFN_vkCmdDraw CmdDraw;
   PFN_vkCmdDrawIndexed CmdDrawIndexed;
   PFN_vkCmdDrawIndexedIndirect CmdDrawIndexedIndirect;
   PFN_vkCmdDrawIndexedIndirectCount CmdDrawIndexedIndirectCount;
   PFN_vkCmdDrawIndirect CmdDrawIndirect;
   PFN_vkCmdDrawIndirectByteCountEXT CmdDrawIndirectByteCountEXT;
   PFN_vkCmdDrawIndirectCount CmdDrawIndirectCount;
   PFN_vkCmdDrawMultiEXT CmdDrawMultiEXT;
   PFN_vkCmdDrawMultiIndexedEXT CmdDrawMultiIndexedEXT;
   PFN_vkCmdEndConditionalRenderingEXT CmdEndConditionalRenderingEXT;
   PFN_vkCmdEndQuery CmdEndQuery;
   PFN_vkCmdEndQueryIndexedEXT CmdEndQueryIndexedEXT;
   PFN_vkCmdEndRenderPass CmdEndRenderPass;
   PFN_vkCmdEndRenderPass2 CmdEndRenderPass2;
   PFN_vkCmdEndRendering CmdEndRendering;
   PFN_vkCmdEndTransformFeedbackEXT CmdEndTransformFeedbackEXT;
   PFN_vkCmdExecuteCommands CmdExecuteCommands;
   PFN_vkCmdFillBuffer CmdFillBuffer;
   PFN_vkCmdNextSubpass CmdNextSubpass;
   PFN_vkCmdNextSubpass2 CmdNextSubpass2;
   PFN_vkCmdPipelineBarrier CmdPipelineBarrier;
   PFN_vkCmdPipelineBarrier2 CmdPipelineBarrier2;
   PFN_vkCmdPushConstants CmdPushConstants;
   PFN_vkCmdPushConstants2 CmdPushConstants2;
   PFN_vkCmdPushDescriptorSet CmdPushDescriptorSet;
   PFN_vkCmdPushDescriptorSet2 CmdPushDescriptorSet2;
   PFN_vkCmdPushDescriptorSetWithTemplate CmdPushDescriptorSetWithTemplate;
   PFN_vkCmdPushDescriptorSetWithTemplate2 CmdPushDescriptorSetWithTemplate2;
   PFN_vkCmdResetEvent CmdResetEvent;
   PFN_vkCmdResetEvent2 CmdResetEvent2;
   PFN_vkCmdResetQueryPool CmdResetQueryPool;
   PFN_vkCmdResolveImage CmdResolveImage;
   PFN_vkCmdResolveImage2 CmdResolveImage2;
   PFN_vkCmdSetAlphaToCoverageEnableEXT CmdSetAlphaToCoverageEnableEXT;
   PFN_vkCmdSetAlphaToOneEnableEXT CmdSetAlphaToOneEnableEXT;
   PFN_vkCmdSetAttachmentFeedbackLoopEnableEXT CmdSetAttachmentFeedbackLoopEnableEXT;
   PFN_vkCmdSetBlendConstants CmdSetBlendConstants;
   PFN_vkCmdSetColorBlendAdvancedEXT CmdSetColorBlendAdvancedEXT;
   PFN_vkCmdSetColorBlendEnableEXT CmdSetColorBlendEnableEXT;
   PFN_vkCmdSetColorBlendEquationEXT CmdSetColorBlendEquationEXT;
   PFN_vkCmdSetColorWriteEnableEXT CmdSetColorWriteEnableEXT;
   PFN_vkCmdSetColorWriteMaskEXT CmdSetColorWriteMaskEXT;
   PFN_vkCmdSetConservativeRasterizationModeEXT CmdSetConservativeRasterizationModeEXT;
   PFN_vkCmdSetCullMode CmdSetCullMode;
   PFN_vkCmdSetDepthBias CmdSetDepthBias;
   PFN_vkCmdSetDepthBias2EXT CmdSetDepthBias2EXT;
   PFN_vkCmdSetDepthBiasEnable CmdSetDepthBiasEnable;
   PFN_vkCmdSetDepthBounds CmdSetDepthBounds;
   PFN_vkCmdSetDepthBoundsTestEnable CmdSetDepthBoundsTestEnable;
   PFN_vkCmdSetDepthClampEnableEXT CmdSetDepthClampEnableEXT;
   PFN_vkCmdSetDepthClampRangeEXT CmdSetDepthClampRangeEXT;
   PFN_vkCmdSetDepthClipEnableEXT CmdSetDepthClipEnableEXT;
   PFN_vkCmdSetDepthClipNegativeOneToOneEXT CmdSetDepthClipNegativeOneToOneEXT;
   PFN_vkCmdSetDepthCompareOp CmdSetDepthCompareOp;
   PFN_vkCmdSetDepthTestEnable CmdSetDepthTestEnable;
   PFN_vkCmdSetDepthWriteEnable CmdSetDepthWriteEnable;
   PFN_vkCmdSetDeviceMask CmdSetDeviceMask;
   PFN_vkCmdSetEvent CmdSetEvent;
   PFN_vkCmdSetEvent2 CmdSetEvent2;
   PFN_vkCmdSetExtraPrimitiveOverestimationSizeEXT CmdSetExtraPrimitiveOverestimationSizeEXT;
   PFN_vkCmdSetFragmentShadingRateKHR CmdSetFragmentShadingRateKHR;
   PFN_vkCmdSetFrontFace CmdSetFrontFace;
   PFN_vkCmdSetLineRasterizationModeEXT CmdSetLineRasterizationModeEXT;
   PFN_vkCmdSetLineStipple CmdSetLineStipple;
   PFN_vkCmdSetLineStippleEnableEXT CmdSetLineStippleEnableEXT;
   PFN_vkCmdSetLineWidth CmdSetLineWidth;
   PFN_vkCmdSetLogicOpEXT CmdSetLogicOpEXT;
   PFN_vkCmdSetLogicOpEnableEXT CmdSetLogicOpEnableEXT;
   PFN_vkCmdSetPatchControlPointsEXT CmdSetPatchControlPointsEXT;
   PFN_vkCmdSetPolygonModeEXT CmdSetPolygonModeEXT;
   PFN_vkCmdSetPrimitiveRestartEnable CmdSetPrimitiveRestartEnable;
   PFN_vkCmdSetPrimitiveTopology CmdSetPrimitiveTopology;
   PFN_vkCmdSetProvokingVertexModeEXT CmdSetProvokingVertexModeEXT;
   PFN_vkCmdSetRasterizationSamplesEXT CmdSetRasterizationSamplesEXT;
   PFN_vkCmdSetRasterizationStreamEXT CmdSetRasterizationStreamEXT;
   PFN_vkCmdSetRasterizerDiscardEnable CmdSetRasterizerDiscardEnable;
   PFN_vkCmdSetRayTracingPipelineStackSizeKHR CmdSetRayTracingPipelineStackSizeKHR;
   PFN_vkCmdSetRenderingAttachmentLocations CmdSetRenderingAttachmentLocations;
   PFN_vkCmdSetRenderingInputAttachmentIndices CmdSetRenderingInputAttachmentIndices;
   PFN_vkCmdSetSampleLocationsEXT CmdSetSampleLocationsEXT;
   PFN_vkCmdSetSampleLocationsEnableEXT CmdSetSampleLocationsEnableEXT;
   PFN_vkCmdSetSampleMaskEXT CmdSetSampleMaskEXT;
   PFN_vkCmdSetScissor CmdSetScissor;
   PFN_vkCmdSetScissorWithCount CmdSetScissorWithCount;
   PFN_vkCmdSetStencilCompareMask CmdSetStencilCompareMask;
   PFN_vkCmdSetStencilOp CmdSetStencilOp;
   PFN_vkCmdSetStencilReference CmdSetStencilReference;
   PFN_vkCmdSetStencilTestEnable CmdSetStencilTestEnable;
   PFN_vkCmdSetStencilWriteMask CmdSetStencilWriteMask;
   PFN_vkCmdSetTessellationDomainOriginEXT CmdSetTessellationDomainOriginEXT;
   PFN_vkCmdSetVertexInputEXT CmdSetVertexInputEXT;
   PFN_vkCmdSetViewport CmdSetViewport;
   PFN_vkCmdSetViewportWithCount CmdSetViewportWithCount;
   PFN_vkCmdTraceRaysIndirect2KHR CmdTraceRaysIndirect2KHR;
   PFN_vkCmdTraceRaysIndirectKHR CmdTraceRaysIndirectKHR;
   PFN_vkCmdTraceRaysKHR CmdTraceRaysKHR;
   PFN_vkCmdUpdateBuffer CmdUpdateBuffer;
   PFN_vkCmdWaitEvents CmdWaitEvents;
   PFN_vkCmdWaitEvents2 CmdWaitEvents2;
   PFN_vkCmdWriteAccelerationStructuresPropertiesKHR CmdWriteAccelerationStructuresPropertiesKHR;
   PFN_vkCmdWriteTimestamp CmdWriteTimestamp;
   PFN_vkCmdWriteTimestamp2 CmdWriteTimestamp2;
   PFN_vkCopyAccelerationStructureKHR CopyAccelerationStructureKHR;
   PFN_vkCopyAccelerationStructureToMemoryKHR CopyAccelerationStructureToMemoryKHR;
   PFN_vkCopyImageToImage CopyImageToImage;
   PFN_vkCopyImageToMemory CopyImageToMemory;
   PFN_vkCopyMemoryToAccelerationStructureKHR CopyMemoryToAccelerationStructureKHR;
   PFN_vkCopyMemoryToImage CopyMemoryToImage;
   PFN_vkCreateAccelerationStructureKHR CreateAccelerationStructureKHR;
   PFN_vkCreateBuffer CreateBuffer;
   PFN_vkCreateBufferView CreateBufferView;
   PFN_vkCreateCommandPool CreateCommandPool;
   PFN_vkCreateComputePipelines CreateComputePipelines;
   PFN_vkCreateDeferredOperationKHR CreateDeferredOperationKHR;
   PFN_vkCreateDescriptorPool CreateDescriptorPool;
   PFN_vkCreateDescriptorSetLayout CreateDescriptorSetLayout;
   PFN_vkCreateDescriptorUpdateTemplate CreateDescriptorUpdateTemplate;
   PFN_vkCreateEvent CreateEvent;
   PFN_vkCreateFence CreateFence;
   PFN_vkCreateFramebuffer CreateFramebuffer;
   PFN_vkCreateGraphicsPipelines CreateGraphicsPipelines;
   PFN_vkCreateImage CreateImage;
   PFN_vkCreateImageView CreateImageView;
   PFN_vkCreatePipelineCache CreatePipelineCache;
   PFN_vkCreatePipelineLayout CreatePipelineLayout;
   PFN_vkCreatePrivateDataSlot CreatePrivateDataSlot;
   PFN_vkCreateQueryPool CreateQueryPool;
   PFN_vkCreateRayTracingPipelinesKHR CreateRayTracingPipelinesKHR;
   PFN_vkCreateRenderPass CreateRenderPass;
   PFN_vkCreateRenderPass2 CreateRenderPass2;
   PFN_vkCreateSampler CreateSampler;
   PFN_vkCreateSamplerYcbcrConversion CreateSamplerYcbcrConversion;
   PFN_vkCreateSemaphore CreateSemaphore;
   PFN_vkCreateShaderModule CreateShaderModule;
   PFN_vkDeferredOperationJoinKHR DeferredOperationJoinKHR;
   PFN_vkDestroyAccelerationStructureKHR DestroyAccelerationStructureKHR;
   PFN_vkDestroyBuffer DestroyBuffer;
   PFN_vkDestroyBufferView DestroyBufferView;
   PFN_vkDestroyCommandPool DestroyCommandPool;
   PFN_vkDestroyDeferredOperationKHR DestroyDeferredOperationKHR;
   PFN_vkDestroyDescriptorPool DestroyDescriptorPool;
   PFN_vkDestroyDescriptorSetLayout DestroyDescriptorSetLayout;
   PFN_vkDestroyDescriptorUpdateTemplate DestroyDescriptorUpdateTemplate;
   PFN_vkDestroyDevice DestroyDevice;
   PFN_vkDestroyEvent DestroyEvent;
   PFN_vkDestroyFence DestroyFence;
   PFN_vkDestroyFramebuffer DestroyFramebuffer;
   PFN_vkDestroyImage DestroyImage;
   PFN_vkDestroyImageView DestroyImageView;
   PFN_vkDestroyPipeline DestroyPipeline;
   PFN_vkDestroyPipelineCache DestroyPipelineCache;
   PFN_vkDestroyPipelineLayout DestroyPipelineLayout;
   PFN_vkDestroyPrivateDataSlot DestroyPrivateDataSlot;
   PFN_vkDestroyQueryPool DestroyQueryPool;
   PFN_vkDestroyRenderPass DestroyRenderPass;
   PFN_vkDestroySampler DestroySampler;
   PFN_vkDestroySamplerYcbcrConversion DestroySamplerYcbcrConversion;
   PFN_vkDestroySemaphore DestroySemaphore;
   PFN_vkDestroyShaderModule DestroyShaderModule;
   PFN_vkDeviceWaitIdle DeviceWaitIdle;
   PFN_vkEndCommandBuffer EndCommandBuffer;
   PFN_vkFlushMappedMemoryRanges FlushMappedMemoryRanges;
   PFN_vkFreeCommandBuffers FreeCommandBuffers;
   PFN_vkFreeDescriptorSets FreeDescriptorSets;
   PFN_vkFreeMemory FreeMemory;
   PFN_vkGetAccelerationStructureBuildSizesKHR GetAccelerationStructureBuildSizesKHR;
   PFN_vkGetAccelerationStructureDeviceAddressKHR GetAccelerationStructureDeviceAddressKHR;
   PFN_vkGetBufferDeviceAddress GetBufferDeviceAddress;
   PFN_vkGetBufferMemoryRequirements GetBufferMemoryRequirements;
   PFN_vkGetBufferMemoryRequirements2 GetBufferMemoryRequirements2;
   PFN_vkGetBufferOpaqueCaptureAddress GetBufferOpaqueCaptureAddress;
   PFN_vkGetCalibratedTimestampsKHR GetCalibratedTimestampsKHR;
   PFN_vkGetDeferredOperationMaxConcurrencyKHR GetDeferredOperationMaxConcurrencyKHR;
   PFN_vkGetDeferredOperationResultKHR GetDeferredOperationResultKHR;
   PFN_vkGetDescriptorSetLayoutSupport GetDescriptorSetLayoutSupport;
   PFN_vkGetDeviceAccelerationStructureCompatibilityKHR GetDeviceAccelerationStructureCompatibilityKHR;
   PFN_vkGetDeviceBufferMemoryRequirements GetDeviceBufferMemoryRequirements;
   PFN_vkGetDeviceGroupPeerMemoryFeatures GetDeviceGroupPeerMemoryFeatures;
   PFN_vkGetDeviceImageMemoryRequirements GetDeviceImageMemoryRequirements;
   PFN_vkGetDeviceImageSparseMemoryRequirements GetDeviceImageSparseMemoryRequirements;
   PFN_vkGetDeviceImageSubresourceLayout GetDeviceImageSubresourceLayout;
   PFN_vkGetDeviceMemoryCommitment GetDeviceMemoryCommitment;
   PFN_vkGetDeviceMemoryOpaqueCaptureAddress GetDeviceMemoryOpaqueCaptureAddress;
   PFN_vkGetDeviceQueue GetDeviceQueue;
   PFN_vkGetDeviceQueue2 GetDeviceQueue2;
   PFN_vkGetEventStatus GetEventStatus;
   PFN_vkGetFenceFdKHR GetFenceFdKHR;
   PFN_vkGetFenceStatus GetFenceStatus;
   PFN_vkGetImageDrmFormatModifierPropertiesEXT GetImageDrmFormatModifierPropertiesEXT;
   PFN_vkGetImageMemoryRequirements GetImageMemoryRequirements;
   PFN_vkGetImageMemoryRequirements2 GetImageMemoryRequirements2;
   PFN_vkGetImageSparseMemoryRequirements GetImageSparseMemoryRequirements;
   PFN_vkGetImageSparseMemoryRequirements2 GetImageSparseMemoryRequirements2;
   PFN_vkGetImageSubresourceLayout GetImageSubresourceLayout;
   PFN_vkGetImageSubresourceLayout2 GetImageSubresourceLayout2;
   PFN_vkGetMemoryFdKHR GetMemoryFdKHR;
   PFN_vkGetMemoryFdPropertiesKHR GetMemoryFdPropertiesKHR;
   PFN_vkGetPipelineCacheData GetPipelineCacheData;
   PFN_vkGetPrivateData GetPrivateData;
   PFN_vkGetQueryPoolResults GetQueryPoolResults;
   PFN_vkGetRayTracingCaptureReplayShaderGroupHandlesKHR GetRayTracingCaptureReplayShaderGroupHandlesKHR;
   PFN_vkGetRayTracingShaderGroupHandlesKHR GetRayTracingShaderGroupHandlesKHR;
   PFN_vkGetRayTracingShaderGroupStackSizeKHR GetRayTracingShaderGroupStackSizeKHR;
   PFN_vkGetRenderAreaGranularity GetRenderAreaGranularity;
   PFN_vkGetRenderingAreaGranularity GetRenderingAreaGranularity;
   PFN_vkGetSemaphoreCounterValue GetSemaphoreCounterValue;
   PFN_vkGetSemaphoreFdKHR GetSemaphoreFdKHR;
   PFN_vkImportFenceFdKHR ImportFenceFdKHR;
   PFN_vkImportSemaphoreFdKHR ImportSemaphoreFdKHR;
   PFN_vkInvalidateMappedMemoryRanges InvalidateMappedMemoryRanges;
   PFN_vkMapMemory MapMemory;
   PFN_vkMapMemory2 MapMemory2;
   PFN_vkMergePipelineCaches MergePipelineCaches;
   PFN_vkQueueBindSparse QueueBindSparse;
   PFN_vkQueueSubmit QueueSubmit;
   PFN_vkQueueSubmit2 QueueSubmit2;
   PFN_vkQueueWaitIdle QueueWaitIdle;
   PFN_vkResetCommandBuffer ResetCommandBuffer;
   PFN_vkResetCommandPool ResetCommandPool;
   PFN_vkResetDescriptorPool ResetDescriptorPool;
   PFN_vkResetEvent ResetEvent;
   PFN_vkResetFences ResetFences;
   PFN_vkResetQueryPool ResetQueryPool;
   PFN_vkSetEvent SetEvent;
   PFN_vkSetPrivateData SetPrivateData;
   PFN_vkSignalSemaphore SignalSemaphore;
   PFN_vkTransitionImageLayout TransitionImageLayout;
   PFN_vkTrimCommandPool TrimCommandPool;
   PFN_vkUnmapMemory UnmapMemory;
   PFN_vkUnmapMemory2 UnmapMemory2;
   PFN_vkUpdateDescriptorSetWithTemplate UpdateDescriptorSetWithTemplate;
   PFN_vkUpdateDescriptorSets UpdateDescriptorSets;
   PFN_vkWaitForFences WaitForFences;
   PFN_vkWaitSemaphores WaitSemaphores;
   PFN_vkWriteAccelerationStructuresPropertiesKHR WriteAccelerationStructuresPropertiesKHR;
};

static inline void
vn_util_init_global_proc_table(PFN_vkGetInstanceProcAddr get_proc_addr,
                               struct vn_global_proc_table *proc_table)
{
#define VN_GIPA(cmd) (PFN_ ## cmd)get_proc_addr(VK_NULL_HANDLE, #cmd)
   proc_table->CreateInstance = VN_GIPA(vkCreateInstance);
   proc_table->EnumerateInstanceExtensionProperties = VN_GIPA(vkEnumerateInstanceExtensionProperties);
   proc_table->EnumerateInstanceLayerProperties = VN_GIPA(vkEnumerateInstanceLayerProperties);
   proc_table->EnumerateInstanceVersion = VN_GIPA(vkEnumerateInstanceVersion);
#undef VN_GIPA
}

static inline void
vn_util_init_instance_proc_table(VkInstance instance,
                                 PFN_vkGetInstanceProcAddr get_proc_addr,
                                 struct vn_instance_proc_table *proc_table)
{
#define VN_GIPA(instance, cmd) (PFN_ ## cmd)get_proc_addr(instance, #cmd)
   proc_table->DestroyInstance = VN_GIPA(instance, vkDestroyInstance);
   proc_table->EnumeratePhysicalDeviceGroups = VN_GIPA(instance, vkEnumeratePhysicalDeviceGroups);
   if (!proc_table->EnumeratePhysicalDeviceGroups)
      proc_table->EnumeratePhysicalDeviceGroups = VN_GIPA(instance, vkEnumeratePhysicalDeviceGroupsKHR);
   proc_table->EnumeratePhysicalDevices = VN_GIPA(instance, vkEnumeratePhysicalDevices);
#undef VN_GIPA
}

static inline void
vn_util_init_physical_device_proc_table(VkInstance instance,
                                        PFN_vkGetInstanceProcAddr get_proc_addr,
                                        struct vn_physical_device_proc_table *proc_table)
{
#define VN_GIPA(instance, cmd) (PFN_ ## cmd)get_proc_addr(instance, #cmd)
   proc_table->CreateDevice = VN_GIPA(instance, vkCreateDevice);
   proc_table->EnumerateDeviceExtensionProperties = VN_GIPA(instance, vkEnumerateDeviceExtensionProperties);
   proc_table->EnumerateDeviceLayerProperties = VN_GIPA(instance, vkEnumerateDeviceLayerProperties);
   proc_table->GetDeviceProcAddr = VN_GIPA(instance, vkGetDeviceProcAddr);
   proc_table->GetPhysicalDeviceCalibrateableTimeDomainsKHR = VN_GIPA(instance, vkGetPhysicalDeviceCalibrateableTimeDomainsKHR);
   if (!proc_table->GetPhysicalDeviceCalibrateableTimeDomainsKHR)
      proc_table->GetPhysicalDeviceCalibrateableTimeDomainsKHR = VN_GIPA(instance, vkGetPhysicalDeviceCalibrateableTimeDomainsEXT);
   proc_table->GetPhysicalDeviceExternalBufferProperties = VN_GIPA(instance, vkGetPhysicalDeviceExternalBufferProperties);
   if (!proc_table->GetPhysicalDeviceExternalBufferProperties)
      proc_table->GetPhysicalDeviceExternalBufferProperties = VN_GIPA(instance, vkGetPhysicalDeviceExternalBufferPropertiesKHR);
   proc_table->GetPhysicalDeviceExternalFenceProperties = VN_GIPA(instance, vkGetPhysicalDeviceExternalFenceProperties);
   if (!proc_table->GetPhysicalDeviceExternalFenceProperties)
      proc_table->GetPhysicalDeviceExternalFenceProperties = VN_GIPA(instance, vkGetPhysicalDeviceExternalFencePropertiesKHR);
   proc_table->GetPhysicalDeviceExternalSemaphoreProperties = VN_GIPA(instance, vkGetPhysicalDeviceExternalSemaphoreProperties);
   if (!proc_table->GetPhysicalDeviceExternalSemaphoreProperties)
      proc_table->GetPhysicalDeviceExternalSemaphoreProperties = VN_GIPA(instance, vkGetPhysicalDeviceExternalSemaphorePropertiesKHR);
   proc_table->GetPhysicalDeviceFeatures = VN_GIPA(instance, vkGetPhysicalDeviceFeatures);
   proc_table->GetPhysicalDeviceFeatures2 = VN_GIPA(instance, vkGetPhysicalDeviceFeatures2);
   if (!proc_table->GetPhysicalDeviceFeatures2)
      proc_table->GetPhysicalDeviceFeatures2 = VN_GIPA(instance, vkGetPhysicalDeviceFeatures2KHR);
   proc_table->GetPhysicalDeviceFormatProperties = VN_GIPA(instance, vkGetPhysicalDeviceFormatProperties);
   proc_table->GetPhysicalDeviceFormatProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceFormatProperties2);
   if (!proc_table->GetPhysicalDeviceFormatProperties2)
      proc_table->GetPhysicalDeviceFormatProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceFormatProperties2KHR);
   proc_table->GetPhysicalDeviceFragmentShadingRatesKHR = VN_GIPA(instance, vkGetPhysicalDeviceFragmentShadingRatesKHR);
   proc_table->GetPhysicalDeviceImageFormatProperties = VN_GIPA(instance, vkGetPhysicalDeviceImageFormatProperties);
   proc_table->GetPhysicalDeviceImageFormatProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceImageFormatProperties2);
   if (!proc_table->GetPhysicalDeviceImageFormatProperties2)
      proc_table->GetPhysicalDeviceImageFormatProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceImageFormatProperties2KHR);
   proc_table->GetPhysicalDeviceMemoryProperties = VN_GIPA(instance, vkGetPhysicalDeviceMemoryProperties);
   proc_table->GetPhysicalDeviceMemoryProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceMemoryProperties2);
   if (!proc_table->GetPhysicalDeviceMemoryProperties2)
      proc_table->GetPhysicalDeviceMemoryProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceMemoryProperties2KHR);
   proc_table->GetPhysicalDeviceMultisamplePropertiesEXT = VN_GIPA(instance, vkGetPhysicalDeviceMultisamplePropertiesEXT);
   proc_table->GetPhysicalDeviceProperties = VN_GIPA(instance, vkGetPhysicalDeviceProperties);
   proc_table->GetPhysicalDeviceProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceProperties2);
   if (!proc_table->GetPhysicalDeviceProperties2)
      proc_table->GetPhysicalDeviceProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceProperties2KHR);
   proc_table->GetPhysicalDeviceQueueFamilyProperties = VN_GIPA(instance, vkGetPhysicalDeviceQueueFamilyProperties);
   proc_table->GetPhysicalDeviceQueueFamilyProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceQueueFamilyProperties2);
   if (!proc_table->GetPhysicalDeviceQueueFamilyProperties2)
      proc_table->GetPhysicalDeviceQueueFamilyProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceQueueFamilyProperties2KHR);
   proc_table->GetPhysicalDeviceSparseImageFormatProperties = VN_GIPA(instance, vkGetPhysicalDeviceSparseImageFormatProperties);
   proc_table->GetPhysicalDeviceSparseImageFormatProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceSparseImageFormatProperties2);
   if (!proc_table->GetPhysicalDeviceSparseImageFormatProperties2)
      proc_table->GetPhysicalDeviceSparseImageFormatProperties2 = VN_GIPA(instance, vkGetPhysicalDeviceSparseImageFormatProperties2KHR);
   proc_table->GetPhysicalDeviceToolProperties = VN_GIPA(instance, vkGetPhysicalDeviceToolProperties);
   if (!proc_table->GetPhysicalDeviceToolProperties)
      proc_table->GetPhysicalDeviceToolProperties = VN_GIPA(instance, vkGetPhysicalDeviceToolPropertiesEXT);
#undef VN_GIPA
}


static inline void
vn_util_init_device_proc_table(VkDevice dev,
                               PFN_vkGetDeviceProcAddr get_proc_addr,
                               uint32_t api_version,
                               const struct vn_info_extension_table *ext_table,
                               struct vn_device_proc_table *proc_table)
{
#define VN_GDPA(dev, cmd) (PFN_ ## cmd)get_proc_addr(dev, #cmd)
   proc_table->AllocateCommandBuffers = VN_GDPA(dev, vkAllocateCommandBuffers);
   proc_table->AllocateDescriptorSets = VN_GDPA(dev, vkAllocateDescriptorSets);
   proc_table->AllocateMemory = VN_GDPA(dev, vkAllocateMemory);
   proc_table->BeginCommandBuffer = VN_GDPA(dev, vkBeginCommandBuffer);
   proc_table->BindBufferMemory = VN_GDPA(dev, vkBindBufferMemory);
   proc_table->BindBufferMemory2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkBindBufferMemory2) :
      ext_table->KHR_bind_memory2 ? VN_GDPA(dev, vkBindBufferMemory2KHR) :
      NULL;
   proc_table->BindImageMemory = VN_GDPA(dev, vkBindImageMemory);
   proc_table->BindImageMemory2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkBindImageMemory2) :
      ext_table->KHR_bind_memory2 ? VN_GDPA(dev, vkBindImageMemory2KHR) :
      NULL;
   proc_table->BuildAccelerationStructuresKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkBuildAccelerationStructuresKHR) :
      NULL;
   proc_table->CmdBeginConditionalRenderingEXT =
      ext_table->EXT_conditional_rendering ? VN_GDPA(dev, vkCmdBeginConditionalRenderingEXT) :
      NULL;
   proc_table->CmdBeginQuery = VN_GDPA(dev, vkCmdBeginQuery);
   proc_table->CmdBeginQueryIndexedEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdBeginQueryIndexedEXT) :
      NULL;
   proc_table->CmdBeginRenderPass = VN_GDPA(dev, vkCmdBeginRenderPass);
   proc_table->CmdBeginRenderPass2 =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCmdBeginRenderPass2) :
      ext_table->KHR_create_renderpass2 ? VN_GDPA(dev, vkCmdBeginRenderPass2KHR) :
      NULL;
   proc_table->CmdBeginRendering =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdBeginRendering) :
      ext_table->KHR_dynamic_rendering ? VN_GDPA(dev, vkCmdBeginRenderingKHR) :
      NULL;
   proc_table->CmdBeginTransformFeedbackEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdBeginTransformFeedbackEXT) :
      NULL;
   proc_table->CmdBindDescriptorSets = VN_GDPA(dev, vkCmdBindDescriptorSets);
   proc_table->CmdBindDescriptorSets2 =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCmdBindDescriptorSets2) :
      ext_table->KHR_maintenance6 ? VN_GDPA(dev, vkCmdBindDescriptorSets2KHR) :
      NULL;
   proc_table->CmdBindIndexBuffer = VN_GDPA(dev, vkCmdBindIndexBuffer);
   proc_table->CmdBindIndexBuffer2 =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCmdBindIndexBuffer2) :
      ext_table->KHR_maintenance5 ? VN_GDPA(dev, vkCmdBindIndexBuffer2KHR) :
      NULL;
   proc_table->CmdBindPipeline = VN_GDPA(dev, vkCmdBindPipeline);
   proc_table->CmdBindTransformFeedbackBuffersEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdBindTransformFeedbackBuffersEXT) :
      NULL;
   proc_table->CmdBindVertexBuffers = VN_GDPA(dev, vkCmdBindVertexBuffers);
   proc_table->CmdBindVertexBuffers2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdBindVertexBuffers2) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdBindVertexBuffers2EXT) :
      NULL;
   proc_table->CmdBlitImage = VN_GDPA(dev, vkCmdBlitImage);
   proc_table->CmdBlitImage2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdBlitImage2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdBlitImage2KHR) :
      NULL;
   proc_table->CmdBuildAccelerationStructuresIndirectKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkCmdBuildAccelerationStructuresIndirectKHR) :
      NULL;
   proc_table->CmdBuildAccelerationStructuresKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkCmdBuildAccelerationStructuresKHR) :
      NULL;
   proc_table->CmdClearAttachments = VN_GDPA(dev, vkCmdClearAttachments);
   proc_table->CmdClearColorImage = VN_GDPA(dev, vkCmdClearColorImage);
   proc_table->CmdClearDepthStencilImage = VN_GDPA(dev, vkCmdClearDepthStencilImage);
   proc_table->CmdCopyAccelerationStructureKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkCmdCopyAccelerationStructureKHR) :
      NULL;
   proc_table->CmdCopyAccelerationStructureToMemoryKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkCmdCopyAccelerationStructureToMemoryKHR) :
      NULL;
   proc_table->CmdCopyBuffer = VN_GDPA(dev, vkCmdCopyBuffer);
   proc_table->CmdCopyBuffer2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdCopyBuffer2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdCopyBuffer2KHR) :
      NULL;
   proc_table->CmdCopyBufferToImage = VN_GDPA(dev, vkCmdCopyBufferToImage);
   proc_table->CmdCopyBufferToImage2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdCopyBufferToImage2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdCopyBufferToImage2KHR) :
      NULL;
   proc_table->CmdCopyImage = VN_GDPA(dev, vkCmdCopyImage);
   proc_table->CmdCopyImage2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdCopyImage2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdCopyImage2KHR) :
      NULL;
   proc_table->CmdCopyImageToBuffer = VN_GDPA(dev, vkCmdCopyImageToBuffer);
   proc_table->CmdCopyImageToBuffer2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdCopyImageToBuffer2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdCopyImageToBuffer2KHR) :
      NULL;
   proc_table->CmdCopyMemoryToAccelerationStructureKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkCmdCopyMemoryToAccelerationStructureKHR) :
      NULL;
   proc_table->CmdCopyQueryPoolResults = VN_GDPA(dev, vkCmdCopyQueryPoolResults);
   proc_table->CmdDispatch = VN_GDPA(dev, vkCmdDispatch);
   proc_table->CmdDispatchBase =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkCmdDispatchBase) :
      ext_table->KHR_device_group ? VN_GDPA(dev, vkCmdDispatchBaseKHR) :
      NULL;
   proc_table->CmdDispatchIndirect = VN_GDPA(dev, vkCmdDispatchIndirect);
   proc_table->CmdDraw = VN_GDPA(dev, vkCmdDraw);
   proc_table->CmdDrawIndexed = VN_GDPA(dev, vkCmdDrawIndexed);
   proc_table->CmdDrawIndexedIndirect = VN_GDPA(dev, vkCmdDrawIndexedIndirect);
   proc_table->CmdDrawIndexedIndirectCount =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCmdDrawIndexedIndirectCount) :
      ext_table->KHR_draw_indirect_count ? VN_GDPA(dev, vkCmdDrawIndexedIndirectCountKHR) :
      NULL;
   proc_table->CmdDrawIndirect = VN_GDPA(dev, vkCmdDrawIndirect);
   proc_table->CmdDrawIndirectByteCountEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdDrawIndirectByteCountEXT) :
      NULL;
   proc_table->CmdDrawIndirectCount =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCmdDrawIndirectCount) :
      ext_table->KHR_draw_indirect_count ? VN_GDPA(dev, vkCmdDrawIndirectCountKHR) :
      NULL;
   proc_table->CmdDrawMultiEXT =
      ext_table->EXT_multi_draw ? VN_GDPA(dev, vkCmdDrawMultiEXT) :
      NULL;
   proc_table->CmdDrawMultiIndexedEXT =
      ext_table->EXT_multi_draw ? VN_GDPA(dev, vkCmdDrawMultiIndexedEXT) :
      NULL;
   proc_table->CmdEndConditionalRenderingEXT =
      ext_table->EXT_conditional_rendering ? VN_GDPA(dev, vkCmdEndConditionalRenderingEXT) :
      NULL;
   proc_table->CmdEndQuery = VN_GDPA(dev, vkCmdEndQuery);
   proc_table->CmdEndQueryIndexedEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdEndQueryIndexedEXT) :
      NULL;
   proc_table->CmdEndRenderPass = VN_GDPA(dev, vkCmdEndRenderPass);
   proc_table->CmdEndRenderPass2 =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCmdEndRenderPass2) :
      ext_table->KHR_create_renderpass2 ? VN_GDPA(dev, vkCmdEndRenderPass2KHR) :
      NULL;
   proc_table->CmdEndRendering =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdEndRendering) :
      ext_table->KHR_dynamic_rendering ? VN_GDPA(dev, vkCmdEndRenderingKHR) :
      NULL;
   proc_table->CmdEndTransformFeedbackEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdEndTransformFeedbackEXT) :
      NULL;
   proc_table->CmdExecuteCommands = VN_GDPA(dev, vkCmdExecuteCommands);
   proc_table->CmdFillBuffer = VN_GDPA(dev, vkCmdFillBuffer);
   proc_table->CmdNextSubpass = VN_GDPA(dev, vkCmdNextSubpass);
   proc_table->CmdNextSubpass2 =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCmdNextSubpass2) :
      ext_table->KHR_create_renderpass2 ? VN_GDPA(dev, vkCmdNextSubpass2KHR) :
      NULL;
   proc_table->CmdPipelineBarrier = VN_GDPA(dev, vkCmdPipelineBarrier);
   proc_table->CmdPipelineBarrier2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdPipelineBarrier2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkCmdPipelineBarrier2KHR) :
      NULL;
   proc_table->CmdPushConstants = VN_GDPA(dev, vkCmdPushConstants);
   proc_table->CmdPushConstants2 =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCmdPushConstants2) :
      ext_table->KHR_maintenance6 ? VN_GDPA(dev, vkCmdPushConstants2KHR) :
      NULL;
   proc_table->CmdPushDescriptorSet =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCmdPushDescriptorSet) :
      ext_table->KHR_push_descriptor ? VN_GDPA(dev, vkCmdPushDescriptorSetKHR) :
      NULL;
   proc_table->CmdPushDescriptorSet2 =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCmdPushDescriptorSet2) :
      ext_table->KHR_maintenance6 ? VN_GDPA(dev, vkCmdPushDescriptorSet2KHR) :
      NULL;
   proc_table->CmdPushDescriptorSetWithTemplate =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCmdPushDescriptorSetWithTemplate) :
      ext_table->KHR_push_descriptor ? VN_GDPA(dev, vkCmdPushDescriptorSetWithTemplateKHR) :
      ext_table->KHR_descriptor_update_template ? VN_GDPA(dev, vkCmdPushDescriptorSetWithTemplateKHR) :
      NULL;
   proc_table->CmdPushDescriptorSetWithTemplate2 =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCmdPushDescriptorSetWithTemplate2) :
      ext_table->KHR_maintenance6 ? VN_GDPA(dev, vkCmdPushDescriptorSetWithTemplate2KHR) :
      NULL;
   proc_table->CmdResetEvent = VN_GDPA(dev, vkCmdResetEvent);
   proc_table->CmdResetEvent2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdResetEvent2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkCmdResetEvent2KHR) :
      NULL;
   proc_table->CmdResetQueryPool = VN_GDPA(dev, vkCmdResetQueryPool);
   proc_table->CmdResolveImage = VN_GDPA(dev, vkCmdResolveImage);
   proc_table->CmdResolveImage2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdResolveImage2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdResolveImage2KHR) :
      NULL;
   proc_table->CmdSetAlphaToCoverageEnableEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetAlphaToCoverageEnableEXT) :
      NULL;
   proc_table->CmdSetAlphaToOneEnableEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetAlphaToOneEnableEXT) :
      NULL;
   proc_table->CmdSetAttachmentFeedbackLoopEnableEXT =
      ext_table->EXT_attachment_feedback_loop_dynamic_state ? VN_GDPA(dev, vkCmdSetAttachmentFeedbackLoopEnableEXT) :
      NULL;
   proc_table->CmdSetBlendConstants = VN_GDPA(dev, vkCmdSetBlendConstants);
   proc_table->CmdSetColorBlendAdvancedEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetColorBlendAdvancedEXT) :
      NULL;
   proc_table->CmdSetColorBlendEnableEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetColorBlendEnableEXT) :
      NULL;
   proc_table->CmdSetColorBlendEquationEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetColorBlendEquationEXT) :
      NULL;
   proc_table->CmdSetColorWriteEnableEXT =
      ext_table->EXT_color_write_enable ? VN_GDPA(dev, vkCmdSetColorWriteEnableEXT) :
      NULL;
   proc_table->CmdSetColorWriteMaskEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetColorWriteMaskEXT) :
      NULL;
   proc_table->CmdSetConservativeRasterizationModeEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetConservativeRasterizationModeEXT) :
      NULL;
   proc_table->CmdSetCullMode =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetCullMode) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetCullModeEXT) :
      NULL;
   proc_table->CmdSetDepthBias = VN_GDPA(dev, vkCmdSetDepthBias);
   proc_table->CmdSetDepthBias2EXT =
      ext_table->EXT_depth_bias_control ? VN_GDPA(dev, vkCmdSetDepthBias2EXT) :
      NULL;
   proc_table->CmdSetDepthBiasEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetDepthBiasEnable) :
      ext_table->EXT_extended_dynamic_state2 ? VN_GDPA(dev, vkCmdSetDepthBiasEnableEXT) :
      NULL;
   proc_table->CmdSetDepthBounds = VN_GDPA(dev, vkCmdSetDepthBounds);
   proc_table->CmdSetDepthBoundsTestEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetDepthBoundsTestEnable) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetDepthBoundsTestEnableEXT) :
      NULL;
   proc_table->CmdSetDepthClampEnableEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetDepthClampEnableEXT) :
      NULL;
   proc_table->CmdSetDepthClampRangeEXT =
      ext_table->EXT_depth_clamp_control ? VN_GDPA(dev, vkCmdSetDepthClampRangeEXT) :
      NULL;
   proc_table->CmdSetDepthClipEnableEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetDepthClipEnableEXT) :
      NULL;
   proc_table->CmdSetDepthClipNegativeOneToOneEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetDepthClipNegativeOneToOneEXT) :
      NULL;
   proc_table->CmdSetDepthCompareOp =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetDepthCompareOp) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetDepthCompareOpEXT) :
      NULL;
   proc_table->CmdSetDepthTestEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetDepthTestEnable) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetDepthTestEnableEXT) :
      NULL;
   proc_table->CmdSetDepthWriteEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetDepthWriteEnable) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetDepthWriteEnableEXT) :
      NULL;
   proc_table->CmdSetDeviceMask =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkCmdSetDeviceMask) :
      ext_table->KHR_device_group ? VN_GDPA(dev, vkCmdSetDeviceMaskKHR) :
      NULL;
   proc_table->CmdSetEvent = VN_GDPA(dev, vkCmdSetEvent);
   proc_table->CmdSetEvent2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetEvent2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkCmdSetEvent2KHR) :
      NULL;
   proc_table->CmdSetExtraPrimitiveOverestimationSizeEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetExtraPrimitiveOverestimationSizeEXT) :
      NULL;
   proc_table->CmdSetFragmentShadingRateKHR =
      ext_table->KHR_fragment_shading_rate ? VN_GDPA(dev, vkCmdSetFragmentShadingRateKHR) :
      NULL;
   proc_table->CmdSetFrontFace =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetFrontFace) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetFrontFaceEXT) :
      NULL;
   proc_table->CmdSetLineRasterizationModeEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetLineRasterizationModeEXT) :
      NULL;
   proc_table->CmdSetLineStipple =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCmdSetLineStipple) :
      ext_table->EXT_line_rasterization ? VN_GDPA(dev, vkCmdSetLineStippleEXT) :
      ext_table->KHR_line_rasterization ? VN_GDPA(dev, vkCmdSetLineStippleKHR) :
      NULL;
   proc_table->CmdSetLineStippleEnableEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetLineStippleEnableEXT) :
      NULL;
   proc_table->CmdSetLineWidth = VN_GDPA(dev, vkCmdSetLineWidth);
   proc_table->CmdSetLogicOpEXT =
      ext_table->EXT_extended_dynamic_state2 ? VN_GDPA(dev, vkCmdSetLogicOpEXT) :
      NULL;
   proc_table->CmdSetLogicOpEnableEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetLogicOpEnableEXT) :
      NULL;
   proc_table->CmdSetPatchControlPointsEXT =
      ext_table->EXT_extended_dynamic_state2 ? VN_GDPA(dev, vkCmdSetPatchControlPointsEXT) :
      NULL;
   proc_table->CmdSetPolygonModeEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetPolygonModeEXT) :
      NULL;
   proc_table->CmdSetPrimitiveRestartEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetPrimitiveRestartEnable) :
      ext_table->EXT_extended_dynamic_state2 ? VN_GDPA(dev, vkCmdSetPrimitiveRestartEnableEXT) :
      NULL;
   proc_table->CmdSetPrimitiveTopology =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetPrimitiveTopology) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetPrimitiveTopologyEXT) :
      NULL;
   proc_table->CmdSetProvokingVertexModeEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetProvokingVertexModeEXT) :
      NULL;
   proc_table->CmdSetRasterizationSamplesEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetRasterizationSamplesEXT) :
      NULL;
   proc_table->CmdSetRasterizationStreamEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetRasterizationStreamEXT) :
      NULL;
   proc_table->CmdSetRasterizerDiscardEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetRasterizerDiscardEnable) :
      ext_table->EXT_extended_dynamic_state2 ? VN_GDPA(dev, vkCmdSetRasterizerDiscardEnableEXT) :
      NULL;
   proc_table->CmdSetRayTracingPipelineStackSizeKHR =
      ext_table->KHR_ray_tracing_pipeline ? VN_GDPA(dev, vkCmdSetRayTracingPipelineStackSizeKHR) :
      NULL;
   proc_table->CmdSetRenderingAttachmentLocations =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCmdSetRenderingAttachmentLocations) :
      ext_table->KHR_dynamic_rendering_local_read ? VN_GDPA(dev, vkCmdSetRenderingAttachmentLocationsKHR) :
      NULL;
   proc_table->CmdSetRenderingInputAttachmentIndices =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCmdSetRenderingInputAttachmentIndices) :
      ext_table->KHR_dynamic_rendering_local_read ? VN_GDPA(dev, vkCmdSetRenderingInputAttachmentIndicesKHR) :
      NULL;
   proc_table->CmdSetSampleLocationsEXT =
      ext_table->EXT_sample_locations ? VN_GDPA(dev, vkCmdSetSampleLocationsEXT) :
      NULL;
   proc_table->CmdSetSampleLocationsEnableEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetSampleLocationsEnableEXT) :
      NULL;
   proc_table->CmdSetSampleMaskEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetSampleMaskEXT) :
      NULL;
   proc_table->CmdSetScissor = VN_GDPA(dev, vkCmdSetScissor);
   proc_table->CmdSetScissorWithCount =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetScissorWithCount) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetScissorWithCountEXT) :
      NULL;
   proc_table->CmdSetStencilCompareMask = VN_GDPA(dev, vkCmdSetStencilCompareMask);
   proc_table->CmdSetStencilOp =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetStencilOp) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetStencilOpEXT) :
      NULL;
   proc_table->CmdSetStencilReference = VN_GDPA(dev, vkCmdSetStencilReference);
   proc_table->CmdSetStencilTestEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetStencilTestEnable) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetStencilTestEnableEXT) :
      NULL;
   proc_table->CmdSetStencilWriteMask = VN_GDPA(dev, vkCmdSetStencilWriteMask);
   proc_table->CmdSetTessellationDomainOriginEXT =
      ext_table->EXT_extended_dynamic_state3 ? VN_GDPA(dev, vkCmdSetTessellationDomainOriginEXT) :
      NULL;
   proc_table->CmdSetVertexInputEXT =
      ext_table->EXT_vertex_input_dynamic_state ? VN_GDPA(dev, vkCmdSetVertexInputEXT) :
      NULL;
   proc_table->CmdSetViewport = VN_GDPA(dev, vkCmdSetViewport);
   proc_table->CmdSetViewportWithCount =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetViewportWithCount) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetViewportWithCountEXT) :
      NULL;
   proc_table->CmdTraceRaysIndirect2KHR =
      ext_table->KHR_ray_tracing_maintenance1 ? VN_GDPA(dev, vkCmdTraceRaysIndirect2KHR) :
      NULL;
   proc_table->CmdTraceRaysIndirectKHR =
      ext_table->KHR_ray_tracing_pipeline ? VN_GDPA(dev, vkCmdTraceRaysIndirectKHR) :
      NULL;
   proc_table->CmdTraceRaysKHR =
      ext_table->KHR_ray_tracing_pipeline ? VN_GDPA(dev, vkCmdTraceRaysKHR) :
      NULL;
   proc_table->CmdUpdateBuffer = VN_GDPA(dev, vkCmdUpdateBuffer);
   proc_table->CmdWaitEvents = VN_GDPA(dev, vkCmdWaitEvents);
   proc_table->CmdWaitEvents2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdWaitEvents2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkCmdWaitEvents2KHR) :
      NULL;
   proc_table->CmdWriteAccelerationStructuresPropertiesKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkCmdWriteAccelerationStructuresPropertiesKHR) :
      NULL;
   proc_table->CmdWriteTimestamp = VN_GDPA(dev, vkCmdWriteTimestamp);
   proc_table->CmdWriteTimestamp2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdWriteTimestamp2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkCmdWriteTimestamp2KHR) :
      NULL;
   proc_table->CopyAccelerationStructureKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkCopyAccelerationStructureKHR) :
      NULL;
   proc_table->CopyAccelerationStructureToMemoryKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkCopyAccelerationStructureToMemoryKHR) :
      NULL;
   proc_table->CopyImageToImage =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCopyImageToImage) :
      ext_table->EXT_host_image_copy ? VN_GDPA(dev, vkCopyImageToImageEXT) :
      NULL;
   proc_table->CopyImageToMemory =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCopyImageToMemory) :
      ext_table->EXT_host_image_copy ? VN_GDPA(dev, vkCopyImageToMemoryEXT) :
      NULL;
   proc_table->CopyMemoryToAccelerationStructureKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkCopyMemoryToAccelerationStructureKHR) :
      NULL;
   proc_table->CopyMemoryToImage =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkCopyMemoryToImage) :
      ext_table->EXT_host_image_copy ? VN_GDPA(dev, vkCopyMemoryToImageEXT) :
      NULL;
   proc_table->CreateAccelerationStructureKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkCreateAccelerationStructureKHR) :
      NULL;
   proc_table->CreateBuffer = VN_GDPA(dev, vkCreateBuffer);
   proc_table->CreateBufferView = VN_GDPA(dev, vkCreateBufferView);
   proc_table->CreateCommandPool = VN_GDPA(dev, vkCreateCommandPool);
   proc_table->CreateComputePipelines = VN_GDPA(dev, vkCreateComputePipelines);
   proc_table->CreateDeferredOperationKHR =
      ext_table->KHR_deferred_host_operations ? VN_GDPA(dev, vkCreateDeferredOperationKHR) :
      NULL;
   proc_table->CreateDescriptorPool = VN_GDPA(dev, vkCreateDescriptorPool);
   proc_table->CreateDescriptorSetLayout = VN_GDPA(dev, vkCreateDescriptorSetLayout);
   proc_table->CreateDescriptorUpdateTemplate =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkCreateDescriptorUpdateTemplate) :
      ext_table->KHR_descriptor_update_template ? VN_GDPA(dev, vkCreateDescriptorUpdateTemplateKHR) :
      NULL;
   proc_table->CreateEvent = VN_GDPA(dev, vkCreateEvent);
   proc_table->CreateFence = VN_GDPA(dev, vkCreateFence);
   proc_table->CreateFramebuffer = VN_GDPA(dev, vkCreateFramebuffer);
   proc_table->CreateGraphicsPipelines = VN_GDPA(dev, vkCreateGraphicsPipelines);
   proc_table->CreateImage = VN_GDPA(dev, vkCreateImage);
   proc_table->CreateImageView = VN_GDPA(dev, vkCreateImageView);
   proc_table->CreatePipelineCache = VN_GDPA(dev, vkCreatePipelineCache);
   proc_table->CreatePipelineLayout = VN_GDPA(dev, vkCreatePipelineLayout);
   proc_table->CreatePrivateDataSlot =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCreatePrivateDataSlot) :
      ext_table->EXT_private_data ? VN_GDPA(dev, vkCreatePrivateDataSlotEXT) :
      NULL;
   proc_table->CreateQueryPool = VN_GDPA(dev, vkCreateQueryPool);
   proc_table->CreateRayTracingPipelinesKHR =
      ext_table->KHR_ray_tracing_pipeline ? VN_GDPA(dev, vkCreateRayTracingPipelinesKHR) :
      NULL;
   proc_table->CreateRenderPass = VN_GDPA(dev, vkCreateRenderPass);
   proc_table->CreateRenderPass2 =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCreateRenderPass2) :
      ext_table->KHR_create_renderpass2 ? VN_GDPA(dev, vkCreateRenderPass2KHR) :
      NULL;
   proc_table->CreateSampler = VN_GDPA(dev, vkCreateSampler);
   proc_table->CreateSamplerYcbcrConversion =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkCreateSamplerYcbcrConversion) :
      ext_table->KHR_sampler_ycbcr_conversion ? VN_GDPA(dev, vkCreateSamplerYcbcrConversionKHR) :
      NULL;
   proc_table->CreateSemaphore = VN_GDPA(dev, vkCreateSemaphore);
   proc_table->CreateShaderModule = VN_GDPA(dev, vkCreateShaderModule);
   proc_table->DeferredOperationJoinKHR =
      ext_table->KHR_deferred_host_operations ? VN_GDPA(dev, vkDeferredOperationJoinKHR) :
      NULL;
   proc_table->DestroyAccelerationStructureKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkDestroyAccelerationStructureKHR) :
      NULL;
   proc_table->DestroyBuffer = VN_GDPA(dev, vkDestroyBuffer);
   proc_table->DestroyBufferView = VN_GDPA(dev, vkDestroyBufferView);
   proc_table->DestroyCommandPool = VN_GDPA(dev, vkDestroyCommandPool);
   proc_table->DestroyDeferredOperationKHR =
      ext_table->KHR_deferred_host_operations ? VN_GDPA(dev, vkDestroyDeferredOperationKHR) :
      NULL;
   proc_table->DestroyDescriptorPool = VN_GDPA(dev, vkDestroyDescriptorPool);
   proc_table->DestroyDescriptorSetLayout = VN_GDPA(dev, vkDestroyDescriptorSetLayout);
   proc_table->DestroyDescriptorUpdateTemplate =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkDestroyDescriptorUpdateTemplate) :
      ext_table->KHR_descriptor_update_template ? VN_GDPA(dev, vkDestroyDescriptorUpdateTemplateKHR) :
      NULL;
   proc_table->DestroyDevice = VN_GDPA(dev, vkDestroyDevice);
   proc_table->DestroyEvent = VN_GDPA(dev, vkDestroyEvent);
   proc_table->DestroyFence = VN_GDPA(dev, vkDestroyFence);
   proc_table->DestroyFramebuffer = VN_GDPA(dev, vkDestroyFramebuffer);
   proc_table->DestroyImage = VN_GDPA(dev, vkDestroyImage);
   proc_table->DestroyImageView = VN_GDPA(dev, vkDestroyImageView);
   proc_table->DestroyPipeline = VN_GDPA(dev, vkDestroyPipeline);
   proc_table->DestroyPipelineCache = VN_GDPA(dev, vkDestroyPipelineCache);
   proc_table->DestroyPipelineLayout = VN_GDPA(dev, vkDestroyPipelineLayout);
   proc_table->DestroyPrivateDataSlot =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkDestroyPrivateDataSlot) :
      ext_table->EXT_private_data ? VN_GDPA(dev, vkDestroyPrivateDataSlotEXT) :
      NULL;
   proc_table->DestroyQueryPool = VN_GDPA(dev, vkDestroyQueryPool);
   proc_table->DestroyRenderPass = VN_GDPA(dev, vkDestroyRenderPass);
   proc_table->DestroySampler = VN_GDPA(dev, vkDestroySampler);
   proc_table->DestroySamplerYcbcrConversion =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkDestroySamplerYcbcrConversion) :
      ext_table->KHR_sampler_ycbcr_conversion ? VN_GDPA(dev, vkDestroySamplerYcbcrConversionKHR) :
      NULL;
   proc_table->DestroySemaphore = VN_GDPA(dev, vkDestroySemaphore);
   proc_table->DestroyShaderModule = VN_GDPA(dev, vkDestroyShaderModule);
   proc_table->DeviceWaitIdle = VN_GDPA(dev, vkDeviceWaitIdle);
   proc_table->EndCommandBuffer = VN_GDPA(dev, vkEndCommandBuffer);
   proc_table->FlushMappedMemoryRanges = VN_GDPA(dev, vkFlushMappedMemoryRanges);
   proc_table->FreeCommandBuffers = VN_GDPA(dev, vkFreeCommandBuffers);
   proc_table->FreeDescriptorSets = VN_GDPA(dev, vkFreeDescriptorSets);
   proc_table->FreeMemory = VN_GDPA(dev, vkFreeMemory);
   proc_table->GetAccelerationStructureBuildSizesKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkGetAccelerationStructureBuildSizesKHR) :
      NULL;
   proc_table->GetAccelerationStructureDeviceAddressKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkGetAccelerationStructureDeviceAddressKHR) :
      NULL;
   proc_table->GetBufferDeviceAddress =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkGetBufferDeviceAddress) :
      ext_table->EXT_buffer_device_address ? VN_GDPA(dev, vkGetBufferDeviceAddressEXT) :
      ext_table->KHR_buffer_device_address ? VN_GDPA(dev, vkGetBufferDeviceAddressKHR) :
      NULL;
   proc_table->GetBufferMemoryRequirements = VN_GDPA(dev, vkGetBufferMemoryRequirements);
   proc_table->GetBufferMemoryRequirements2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetBufferMemoryRequirements2) :
      ext_table->KHR_get_memory_requirements2 ? VN_GDPA(dev, vkGetBufferMemoryRequirements2KHR) :
      NULL;
   proc_table->GetBufferOpaqueCaptureAddress =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkGetBufferOpaqueCaptureAddress) :
      ext_table->KHR_buffer_device_address ? VN_GDPA(dev, vkGetBufferOpaqueCaptureAddressKHR) :
      NULL;
   proc_table->GetCalibratedTimestampsKHR =
      ext_table->EXT_calibrated_timestamps ? VN_GDPA(dev, vkGetCalibratedTimestampsEXT) :
      ext_table->KHR_calibrated_timestamps ? VN_GDPA(dev, vkGetCalibratedTimestampsKHR) :
      NULL;
   proc_table->GetDeferredOperationMaxConcurrencyKHR =
      ext_table->KHR_deferred_host_operations ? VN_GDPA(dev, vkGetDeferredOperationMaxConcurrencyKHR) :
      NULL;
   proc_table->GetDeferredOperationResultKHR =
      ext_table->KHR_deferred_host_operations ? VN_GDPA(dev, vkGetDeferredOperationResultKHR) :
      NULL;
   proc_table->GetDescriptorSetLayoutSupport =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetDescriptorSetLayoutSupport) :
      ext_table->KHR_maintenance3 ? VN_GDPA(dev, vkGetDescriptorSetLayoutSupportKHR) :
      NULL;
   proc_table->GetDeviceAccelerationStructureCompatibilityKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkGetDeviceAccelerationStructureCompatibilityKHR) :
      NULL;
   proc_table->GetDeviceBufferMemoryRequirements =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkGetDeviceBufferMemoryRequirements) :
      ext_table->KHR_maintenance4 ? VN_GDPA(dev, vkGetDeviceBufferMemoryRequirementsKHR) :
      NULL;
   proc_table->GetDeviceGroupPeerMemoryFeatures =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetDeviceGroupPeerMemoryFeatures) :
      ext_table->KHR_device_group ? VN_GDPA(dev, vkGetDeviceGroupPeerMemoryFeaturesKHR) :
      NULL;
   proc_table->GetDeviceImageMemoryRequirements =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkGetDeviceImageMemoryRequirements) :
      ext_table->KHR_maintenance4 ? VN_GDPA(dev, vkGetDeviceImageMemoryRequirementsKHR) :
      NULL;
   proc_table->GetDeviceImageSparseMemoryRequirements =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkGetDeviceImageSparseMemoryRequirements) :
      ext_table->KHR_maintenance4 ? VN_GDPA(dev, vkGetDeviceImageSparseMemoryRequirementsKHR) :
      NULL;
   proc_table->GetDeviceImageSubresourceLayout =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkGetDeviceImageSubresourceLayout) :
      ext_table->KHR_maintenance5 ? VN_GDPA(dev, vkGetDeviceImageSubresourceLayoutKHR) :
      NULL;
   proc_table->GetDeviceMemoryCommitment = VN_GDPA(dev, vkGetDeviceMemoryCommitment);
   proc_table->GetDeviceMemoryOpaqueCaptureAddress =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkGetDeviceMemoryOpaqueCaptureAddress) :
      ext_table->KHR_buffer_device_address ? VN_GDPA(dev, vkGetDeviceMemoryOpaqueCaptureAddressKHR) :
      NULL;
   proc_table->GetDeviceQueue = VN_GDPA(dev, vkGetDeviceQueue);
   proc_table->GetDeviceQueue2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetDeviceQueue2) :
      NULL;
   proc_table->GetEventStatus = VN_GDPA(dev, vkGetEventStatus);
   proc_table->GetFenceFdKHR =
      ext_table->KHR_external_fence_fd ? VN_GDPA(dev, vkGetFenceFdKHR) :
      NULL;
   proc_table->GetFenceStatus = VN_GDPA(dev, vkGetFenceStatus);
   proc_table->GetImageDrmFormatModifierPropertiesEXT =
      ext_table->EXT_image_drm_format_modifier ? VN_GDPA(dev, vkGetImageDrmFormatModifierPropertiesEXT) :
      NULL;
   proc_table->GetImageMemoryRequirements = VN_GDPA(dev, vkGetImageMemoryRequirements);
   proc_table->GetImageMemoryRequirements2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetImageMemoryRequirements2) :
      ext_table->KHR_get_memory_requirements2 ? VN_GDPA(dev, vkGetImageMemoryRequirements2KHR) :
      NULL;
   proc_table->GetImageSparseMemoryRequirements = VN_GDPA(dev, vkGetImageSparseMemoryRequirements);
   proc_table->GetImageSparseMemoryRequirements2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetImageSparseMemoryRequirements2) :
      ext_table->KHR_get_memory_requirements2 ? VN_GDPA(dev, vkGetImageSparseMemoryRequirements2KHR) :
      NULL;
   proc_table->GetImageSubresourceLayout = VN_GDPA(dev, vkGetImageSubresourceLayout);
   proc_table->GetImageSubresourceLayout2 =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkGetImageSubresourceLayout2) :
      ext_table->EXT_host_image_copy ? VN_GDPA(dev, vkGetImageSubresourceLayout2EXT) :
      ext_table->KHR_maintenance5 ? VN_GDPA(dev, vkGetImageSubresourceLayout2KHR) :
      NULL;
   proc_table->GetMemoryFdKHR =
      ext_table->KHR_external_memory_fd ? VN_GDPA(dev, vkGetMemoryFdKHR) :
      NULL;
   proc_table->GetMemoryFdPropertiesKHR =
      ext_table->KHR_external_memory_fd ? VN_GDPA(dev, vkGetMemoryFdPropertiesKHR) :
      NULL;
   proc_table->GetPipelineCacheData = VN_GDPA(dev, vkGetPipelineCacheData);
   proc_table->GetPrivateData =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkGetPrivateData) :
      ext_table->EXT_private_data ? VN_GDPA(dev, vkGetPrivateDataEXT) :
      NULL;
   proc_table->GetQueryPoolResults = VN_GDPA(dev, vkGetQueryPoolResults);
   proc_table->GetRayTracingCaptureReplayShaderGroupHandlesKHR =
      ext_table->KHR_ray_tracing_pipeline ? VN_GDPA(dev, vkGetRayTracingCaptureReplayShaderGroupHandlesKHR) :
      NULL;
   proc_table->GetRayTracingShaderGroupHandlesKHR =
      ext_table->KHR_ray_tracing_pipeline ? VN_GDPA(dev, vkGetRayTracingShaderGroupHandlesKHR) :
      NULL;
   proc_table->GetRayTracingShaderGroupStackSizeKHR =
      ext_table->KHR_ray_tracing_pipeline ? VN_GDPA(dev, vkGetRayTracingShaderGroupStackSizeKHR) :
      NULL;
   proc_table->GetRenderAreaGranularity = VN_GDPA(dev, vkGetRenderAreaGranularity);
   proc_table->GetRenderingAreaGranularity =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkGetRenderingAreaGranularity) :
      ext_table->KHR_maintenance5 ? VN_GDPA(dev, vkGetRenderingAreaGranularityKHR) :
      NULL;
   proc_table->GetSemaphoreCounterValue =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkGetSemaphoreCounterValue) :
      ext_table->KHR_timeline_semaphore ? VN_GDPA(dev, vkGetSemaphoreCounterValueKHR) :
      NULL;
   proc_table->GetSemaphoreFdKHR =
      ext_table->KHR_external_semaphore_fd ? VN_GDPA(dev, vkGetSemaphoreFdKHR) :
      NULL;
   proc_table->ImportFenceFdKHR =
      ext_table->KHR_external_fence_fd ? VN_GDPA(dev, vkImportFenceFdKHR) :
      NULL;
   proc_table->ImportSemaphoreFdKHR =
      ext_table->KHR_external_semaphore_fd ? VN_GDPA(dev, vkImportSemaphoreFdKHR) :
      NULL;
   proc_table->InvalidateMappedMemoryRanges = VN_GDPA(dev, vkInvalidateMappedMemoryRanges);
   proc_table->MapMemory = VN_GDPA(dev, vkMapMemory);
   proc_table->MapMemory2 =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkMapMemory2) :
      ext_table->KHR_map_memory2 ? VN_GDPA(dev, vkMapMemory2KHR) :
      NULL;
   proc_table->MergePipelineCaches = VN_GDPA(dev, vkMergePipelineCaches);
   proc_table->QueueBindSparse = VN_GDPA(dev, vkQueueBindSparse);
   proc_table->QueueSubmit = VN_GDPA(dev, vkQueueSubmit);
   proc_table->QueueSubmit2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkQueueSubmit2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkQueueSubmit2KHR) :
      NULL;
   proc_table->QueueWaitIdle = VN_GDPA(dev, vkQueueWaitIdle);
   proc_table->ResetCommandBuffer = VN_GDPA(dev, vkResetCommandBuffer);
   proc_table->ResetCommandPool = VN_GDPA(dev, vkResetCommandPool);
   proc_table->ResetDescriptorPool = VN_GDPA(dev, vkResetDescriptorPool);
   proc_table->ResetEvent = VN_GDPA(dev, vkResetEvent);
   proc_table->ResetFences = VN_GDPA(dev, vkResetFences);
   proc_table->ResetQueryPool =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkResetQueryPool) :
      ext_table->EXT_host_query_reset ? VN_GDPA(dev, vkResetQueryPoolEXT) :
      NULL;
   proc_table->SetEvent = VN_GDPA(dev, vkSetEvent);
   proc_table->SetPrivateData =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkSetPrivateData) :
      ext_table->EXT_private_data ? VN_GDPA(dev, vkSetPrivateDataEXT) :
      NULL;
   proc_table->SignalSemaphore =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkSignalSemaphore) :
      ext_table->KHR_timeline_semaphore ? VN_GDPA(dev, vkSignalSemaphoreKHR) :
      NULL;
   proc_table->TransitionImageLayout =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkTransitionImageLayout) :
      ext_table->EXT_host_image_copy ? VN_GDPA(dev, vkTransitionImageLayoutEXT) :
      NULL;
   proc_table->TrimCommandPool =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkTrimCommandPool) :
      ext_table->KHR_maintenance1 ? VN_GDPA(dev, vkTrimCommandPoolKHR) :
      NULL;
   proc_table->UnmapMemory = VN_GDPA(dev, vkUnmapMemory);
   proc_table->UnmapMemory2 =
      api_version >= VK_API_VERSION_1_4 ? VN_GDPA(dev, vkUnmapMemory2) :
      ext_table->KHR_map_memory2 ? VN_GDPA(dev, vkUnmapMemory2KHR) :
      NULL;
   proc_table->UpdateDescriptorSetWithTemplate =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkUpdateDescriptorSetWithTemplate) :
      ext_table->KHR_descriptor_update_template ? VN_GDPA(dev, vkUpdateDescriptorSetWithTemplateKHR) :
      NULL;
   proc_table->UpdateDescriptorSets = VN_GDPA(dev, vkUpdateDescriptorSets);
   proc_table->WaitForFences = VN_GDPA(dev, vkWaitForFences);
   proc_table->WaitSemaphores =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkWaitSemaphores) :
      ext_table->KHR_timeline_semaphore ? VN_GDPA(dev, vkWaitSemaphoresKHR) :
      NULL;
   proc_table->WriteAccelerationStructuresPropertiesKHR =
      ext_table->KHR_acceleration_structure ? VN_GDPA(dev, vkWriteAccelerationStructuresPropertiesKHR) :
      NULL;
#undef VN_GDPA
}

#endif /* VN_PROTOCOL_RENDERER_UTIL_H */
