/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "mo" locale.
 */
public class LocalizedNamesImpl_mo extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BY",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "CV",
        "EA",
        "CL",
        "CN",
        "TD",
        "CY",
        "CI",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CR",
        "HR",
        "CU",
        "DK",
        "DG",
        "DJ",
        "DM",
        "EC",
        "EG",
        "CH",
        "SV",
        "AE",
        "ER",
        "EE",
        "ET",
        "FJ",
        "PH",
        "FI",
        "FR",
        "FX",
        "GA",
        "GM",
        "GE",
        "GS",
        "DE",
        "GH",
        "GI",
        "GR",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "HT",
        "HN",
        "HK",
        "IN",
        "ID",
        "AC",
        "BV",
        "CX",
        "CP",
        "HM",
        "IM",
        "AX",
        "IC",
        "KY",
        "CC",
        "CK",
        "FK",
        "FO",
        "MP",
        "MH",
        "UM",
        "NF",
        "SB",
        "TC",
        "VG",
        "VI",
        "JO",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "KG",
        "KZ",
        "KE",
        "KI",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "GB",
        "MA",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MC",
        "MN",
        "MS",
        "MZ",
        "ME",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "QO",
        "NL",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PR",
        "PT",
        "QA",
        "CZ",
        "CF",
        "CD",
        "DO",
        "MD",
        "RE",
        "RO",
        "RU",
        "RW",
        "EH",
        "WS",
        "AS",
        "SM",
        "ST",
        "SN",
        "RS",
        "CS",
        "SC",
        "SH",
        "LC",
        "BL",
        "KN",
        "MF",
        "PM",
        "VC",
        "SL",
        "SG",
        "SY",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "US",
        "SD",
        "SE",
        "SR",
        "SJ",
        "SZ",
        "TJ",
        "TW",
        "TZ",
        "TF",
        "IO",
        "PS",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UA",
        "UG",
        "HU",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Lume");
    namesMap.put("003", "America de Nord");
    namesMap.put("005", "America de Sud");
    namesMap.put("011", "Africa Occidentală");
    namesMap.put("013", "America Centrală");
    namesMap.put("014", "Africa Orientală");
    namesMap.put("015", "Africa Septentrională");
    namesMap.put("017", "Africa Centrală");
    namesMap.put("018", "Africa Meridională");
    namesMap.put("019", "Americi");
    namesMap.put("021", "America Septentrională");
    namesMap.put("029", "Caraibe");
    namesMap.put("030", "Asia Orientală");
    namesMap.put("034", "Asia Meridională");
    namesMap.put("035", "Asia de Sud-Est");
    namesMap.put("039", "Europa Meridională");
    namesMap.put("053", "Australia și Noua Zeelandă");
    namesMap.put("054", "Melanezia");
    namesMap.put("057", "Regiunea Micronezia");
    namesMap.put("061", "Polinezia");
    namesMap.put("062", "Asia Centrală de Sud");
    namesMap.put("143", "Asia Centrală");
    namesMap.put("145", "Asia Occidentală");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa Orientală");
    namesMap.put("154", "Europa Septentrională");
    namesMap.put("155", "Europa Occidentală");
    namesMap.put("172", "Comunitatea Statelor Independente");
    namesMap.put("419", "America Latină și Caraibe");
    namesMap.put("830", "Insulele Anglo-Normande");
    namesMap.put("AC", "Insula Ascension");
    namesMap.put("AE", "Emiratele Arabe Unite");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua și Barbuda");
    namesMap.put("AN", "Antilele Olandeze");
    namesMap.put("AS", "Samoa Americană");
    namesMap.put("AX", "Insulele Aland");
    namesMap.put("AZ", "Azerbaidjan");
    namesMap.put("BA", "Bosnia și Herțegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BL", "Sfântul Bartolomeu");
    namesMap.put("BR", "Brazilia");
    namesMap.put("BV", "Insula Bouvet");
    namesMap.put("BY", "Bielorusia");
    namesMap.put("CC", "Insulele Cocos");
    namesMap.put("CD", "Republica Democrată Congo");
    namesMap.put("CF", "Republica Centrafricană");
    namesMap.put("CG", "Congo");
    namesMap.put("CH", "Eleveția");
    namesMap.put("CI", "Coasta de Fildeș");
    namesMap.put("CK", "Insulele Cook");
    namesMap.put("CM", "Camerun");
    namesMap.put("CO", "Columbia");
    namesMap.put("CP", "Insula Clipperton");
    namesMap.put("CS", "Serbia și Muntenegru");
    namesMap.put("CV", "Capul Verde");
    namesMap.put("CX", "Insula Christmas");
    namesMap.put("CY", "Cipru");
    namesMap.put("CZ", "Republica Cehă");
    namesMap.put("DE", "Germania");
    namesMap.put("DK", "Danemarca");
    namesMap.put("DO", "Republica Dominicană");
    namesMap.put("EA", "Ceuta şi Melilla");
    namesMap.put("EG", "Egipt");
    namesMap.put("EH", "Sahara Occidentală");
    namesMap.put("ER", "Eritreea");
    namesMap.put("ES", "Spania");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Uniunea Europeană");
    namesMap.put("FI", "Finlanda");
    namesMap.put("FK", "Insulele Falkland");
    namesMap.put("FM", "Micronezia");
    namesMap.put("FO", "Insulele Feroe");
    namesMap.put("FR", "Franța");
    namesMap.put("FX", "Franța metropolitană");
    namesMap.put("GB", "Marea Britanie");
    namesMap.put("GF", "Guyana Franceză");
    namesMap.put("GL", "Groenlanda");
    namesMap.put("GN", "Guineea");
    namesMap.put("GP", "Guadelupa");
    namesMap.put("GQ", "Guineea Ecuatorială");
    namesMap.put("GR", "Grecia");
    namesMap.put("GS", "Georgia de Sud şi Insulele Sandwich de Sud");
    namesMap.put("GW", "Guineea-Bissau");
    namesMap.put("HM", "Insula Heard și Insulele McDonald");
    namesMap.put("HR", "Croația");
    namesMap.put("HU", "Ungaria");
    namesMap.put("IC", "Insulele Canare");
    namesMap.put("ID", "Indonezia");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Insula Man");
    namesMap.put("IO", "Teritoriul Britanic din Oceanul Indian");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islanda");
    namesMap.put("IT", "Italia");
    namesMap.put("JO", "Iordania");
    namesMap.put("JP", "Japonia");
    namesMap.put("KG", "Kârgâzstan");
    namesMap.put("KH", "Cambodgia");
    namesMap.put("KM", "Comore");
    namesMap.put("KN", "Sfântul Kitts și Nevis");
    namesMap.put("KP", "Coreea de Nord");
    namesMap.put("KR", "Coreea de Sud");
    namesMap.put("KW", "Kuweit");
    namesMap.put("KY", "Insulele Cayman");
    namesMap.put("KZ", "Kazahstan");
    namesMap.put("LB", "Liban");
    namesMap.put("LC", "Sfânta Lucia");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("LV", "Letonia");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Maroc");
    namesMap.put("MD", "Republica Moldova");
    namesMap.put("ME", "Muntenegru");
    namesMap.put("MF", "Sfântul Martin");
    namesMap.put("MH", "Insulele Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MO", "Macao");
    namesMap.put("MP", "Insulele Mariane de Nord");
    namesMap.put("MQ", "Martinica");
    namesMap.put("MV", "Maldive");
    namesMap.put("MX", "Mexic");
    namesMap.put("MY", "Malaezia");
    namesMap.put("MZ", "Mozambic");
    namesMap.put("NC", "Noua Caledonie");
    namesMap.put("NF", "Insulele Norfolk");
    namesMap.put("NL", "Olanda");
    namesMap.put("NO", "Norvegia");
    namesMap.put("NZ", "Noua Zeelandă");
    namesMap.put("PF", "Polinezia Franceză");
    namesMap.put("PG", "Papua Noua Guinee");
    namesMap.put("PH", "Filipine");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "Sfântul Pierre și Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Porto Rico");
    namesMap.put("PS", "Teritoriul Palestinian");
    namesMap.put("PT", "Portugalia");
    namesMap.put("QO", "Oceania Periferică");
    namesMap.put("RE", "Reunion");
    namesMap.put("RO", "România");
    namesMap.put("RU", "Rusia");
    namesMap.put("SA", "Arabia Saudită");
    namesMap.put("SB", "Insulele Solomon");
    namesMap.put("SE", "Suedia");
    namesMap.put("SH", "Sfânta Elena");
    namesMap.put("SJ", "Svalbard și Jan Mayen");
    namesMap.put("SK", "Slovacia");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sao Tome și Principe");
    namesMap.put("SY", "Siria");
    namesMap.put("TC", "Insulele Turks și Caicos");
    namesMap.put("TD", "Ciad");
    namesMap.put("TF", "Teritoriile Australe și Antarctice Franceze");
    namesMap.put("TH", "Thailanda");
    namesMap.put("TJ", "Tadjikistan");
    namesMap.put("TL", "Timorul de Est");
    namesMap.put("TR", "Turcia");
    namesMap.put("TT", "Trinidad-Tobago");
    namesMap.put("UA", "Ucraina");
    namesMap.put("UM", "Insulele Minore Îndepărtate ale Statelor Unite ale Americii");
    namesMap.put("US", "Statele Unite ale Americii");
    namesMap.put("VA", "Vatican");
    namesMap.put("VC", "Sfântul Vincent și Grenadine");
    namesMap.put("VG", "Insulele Virgine Britanice");
    namesMap.put("VI", "Insulele Virgine S.U.A.");
    namesMap.put("WF", "Wallis și Futuna");
    namesMap.put("ZA", "Africa de Sud");
    namesMap.put("ZZ", "Regiune necunoscută sau nevalidă");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Lume",
        "003": "America de Nord",
        "005": "America de Sud",
        "011": "Africa Occidentală",
        "013": "America Centrală",
        "014": "Africa Orientală",
        "015": "Africa Septentrională",
        "017": "Africa Centrală",
        "018": "Africa Meridională",
        "019": "Americi",
        "021": "America Septentrională",
        "029": "Caraibe",
        "030": "Asia Orientală",
        "034": "Asia Meridională",
        "035": "Asia de Sud-Est",
        "039": "Europa Meridională",
        "053": "Australia și Noua Zeelandă",
        "054": "Melanezia",
        "057": "Regiunea Micronezia",
        "061": "Polinezia",
        "062": "Asia Centrală de Sud",
        "143": "Asia Centrală",
        "145": "Asia Occidentală",
        "150": "Europa",
        "151": "Europa Orientală",
        "154": "Europa Septentrională",
        "155": "Europa Occidentală",
        "172": "Comunitatea Statelor Independente",
        "419": "America Latină și Caraibe",
        "830": "Insulele Anglo-Normande",
        "AC": "Insula Ascension",
        "AE": "Emiratele Arabe Unite",
        "AF": "Afganistan",
        "AG": "Antigua și Barbuda",
        "AN": "Antilele Olandeze",
        "AS": "Samoa Americană",
        "AX": "Insulele Aland",
        "AZ": "Azerbaidjan",
        "BA": "Bosnia și Herțegovina",
        "BE": "Belgia",
        "BL": "Sfântul Bartolomeu",
        "BR": "Brazilia",
        "BV": "Insula Bouvet",
        "BY": "Bielorusia",
        "CC": "Insulele Cocos",
        "CD": "Republica Democrată Congo",
        "CF": "Republica Centrafricană",
        "CG": "Congo",
        "CH": "Eleveția",
        "CI": "Coasta de Fildeș",
        "CK": "Insulele Cook",
        "CM": "Camerun",
        "CO": "Columbia",
        "CP": "Insula Clipperton",
        "CS": "Serbia și Muntenegru",
        "CV": "Capul Verde",
        "CX": "Insula Christmas",
        "CY": "Cipru",
        "CZ": "Republica Cehă",
        "DE": "Germania",
        "DK": "Danemarca",
        "DO": "Republica Dominicană",
        "EA": "Ceuta şi Melilla",
        "EG": "Egipt",
        "EH": "Sahara Occidentală",
        "ER": "Eritreea",
        "ES": "Spania",
        "ET": "Etiopia",
        "EU": "Uniunea Europeană",
        "FI": "Finlanda",
        "FK": "Insulele Falkland",
        "FM": "Micronezia",
        "FO": "Insulele Feroe",
        "FR": "Franța",
        "FX": "Franța metropolitană",
        "GB": "Marea Britanie",
        "GF": "Guyana Franceză",
        "GL": "Groenlanda",
        "GN": "Guineea",
        "GP": "Guadelupa",
        "GQ": "Guineea Ecuatorială",
        "GR": "Grecia",
        "GS": "Georgia de Sud şi Insulele Sandwich de Sud",
        "GW": "Guineea-Bissau",
        "HM": "Insula Heard și Insulele McDonald",
        "HR": "Croația",
        "HU": "Ungaria",
        "IC": "Insulele Canare",
        "ID": "Indonezia",
        "IE": "Irlanda",
        "IM": "Insula Man",
        "IO": "Teritoriul Britanic din Oceanul Indian",
        "IQ": "Irak",
        "IS": "Islanda",
        "IT": "Italia",
        "JO": "Iordania",
        "JP": "Japonia",
        "KG": "Kârgâzstan",
        "KH": "Cambodgia",
        "KM": "Comore",
        "KN": "Sfântul Kitts și Nevis",
        "KP": "Coreea de Nord",
        "KR": "Coreea de Sud",
        "KW": "Kuweit",
        "KY": "Insulele Cayman",
        "KZ": "Kazahstan",
        "LB": "Liban",
        "LC": "Sfânta Lucia",
        "LT": "Lituania",
        "LU": "Luxemburg",
        "LV": "Letonia",
        "LY": "Libia",
        "MA": "Maroc",
        "MD": "Republica Moldova",
        "ME": "Muntenegru",
        "MF": "Sfântul Martin",
        "MH": "Insulele Marshall",
        "MK": "Macedonia",
        "MM": "Myanmar",
        "MO": "Macao",
        "MP": "Insulele Mariane de Nord",
        "MQ": "Martinica",
        "MV": "Maldive",
        "MX": "Mexic",
        "MY": "Malaezia",
        "MZ": "Mozambic",
        "NC": "Noua Caledonie",
        "NF": "Insulele Norfolk",
        "NL": "Olanda",
        "NO": "Norvegia",
        "NZ": "Noua Zeelandă",
        "PF": "Polinezia Franceză",
        "PG": "Papua Noua Guinee",
        "PH": "Filipine",
        "PL": "Polonia",
        "PM": "Sfântul Pierre și Miquelon",
        "PN": "Pitcairn",
        "PR": "Porto Rico",
        "PS": "Teritoriul Palestinian",
        "PT": "Portugalia",
        "QO": "Oceania Periferică",
        "RE": "Reunion",
        "RO": "România",
        "RU": "Rusia",
        "SA": "Arabia Saudită",
        "SB": "Insulele Solomon",
        "SE": "Suedia",
        "SH": "Sfânta Elena",
        "SJ": "Svalbard și Jan Mayen",
        "SK": "Slovacia",
        "SR": "Surinam",
        "ST": "Sao Tome și Principe",
        "SY": "Siria",
        "TC": "Insulele Turks și Caicos",
        "TD": "Ciad",
        "TF": "Teritoriile Australe și Antarctice Franceze",
        "TH": "Thailanda",
        "TJ": "Tadjikistan",
        "TL": "Timorul de Est",
        "TR": "Turcia",
        "TT": "Trinidad-Tobago",
        "UA": "Ucraina",
        "UM": "Insulele Minore Îndepărtate ale Statelor Unite ale Americii",
        "US": "Statele Unite ale Americii",
        "VA": "Vatican",
        "VC": "Sfântul Vincent și Grenadine",
        "VG": "Insulele Virgine Britanice",
        "VI": "Insulele Virgine S.U.A.",
        "WF": "Wallis și Futuna",
        "ZA": "Africa de Sud",
        "ZZ": "Regiune necunoscută sau nevalidă"
    };
  }-*/;
}
