/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: LONGMULU.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): longmulu
su(bsystem): longmath
ty(pe): A
sh(ort description): Multiply a 32bit number with an unsigned 16bit integer
lo(ng description): 
pr(erequistes): 
va(lue): none; \tok{num := num * (unsigned)n}
re(lated to): longmul longmuli
se(condary subsystems): portable
in(itialized by): 
wa(rning): 
bu(gs): 
co(mpilers): A function for non-32bit-aware compilers, a macro otherwise.

*/

#include "initsupl.loc"

#ifdef _MICROC_

#include "suppl.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: LONGMULU.C 2.6 1999/12/13 02:23:24 ska Exp ska $";
#endif

void longmulu(dword *num, unsigned n)
{	dword tmp;

	assert(num);

	longsetu(tmp, n);
	longmul(num, tmp);
}
#endif
