/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.fest.util.ArrayFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    private static final ArrayFormatter formatter = new ArrayFormatter();

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] array(T ... values) {
        return values;
    }

    public static String format(Object array) {
        return formatter.format(array);
    }

    public static <T> T[] nonNullElements(T[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<T> nonNullElements = new ArrayList<T>();
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (o != null) {
                nonNullElements.add(o);
            }
            ++n2;
        }
        int elementCount = nonNullElements.size();
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), elementCount);
        System.arraycopy(nonNullElements.toArray(), 0, newArray, 0, elementCount);
        return newArray;
    }

    public static <T> boolean hasOnlyNullElements(T[] array) {
        if (array == null) {
            throw new NullPointerException("The array to check should not be null");
        }
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (o != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private Arrays() {
    }
}

