#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Star Wars: Galactic Battlegrounds
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251114.8

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='star-wars-galactic-battlegrounds'
GAME_NAME='Star Wars: Galactic Battlegrounds'

ARCHIVE_BASE_EN_0_NAME='setup_sw_galactic_battlegrounds_saga_2.0.0.4.exe'
ARCHIVE_BASE_EN_0_MD5='6af25835c5f240914cb04f7b4f741813'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_SIZE='819518'
ARCHIVE_BASE_EN_0_VERSION='1.1-gog2.0.0.4'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/star_wars_galactic_battlegrounds_saga'

ARCHIVE_BASE_FR_0_NAME='setup_sw_galactic_battlegrounds_saga_french_2.0.0.4.exe'
ARCHIVE_BASE_FR_0_MD5='b30458033e825ad252e2d5b3dc8a7845'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_SIZE='807572'
ARCHIVE_BASE_FR_0_VERSION='1.1-gog2.0.0.4'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/star_wars_galactic_battlegrounds_saga'

CONTENT_PATH_DEFAULT='app/game'
## The game crashes on launch if the following libraries are missing.
CONTENT_LIBS_L10N_LIBS_FILES='
language.dll
language_x1.dll'
CONTENT_GAME_BIN_FILES='
battlegrounds.exe
battlegrounds_x1.exe'
CONTENT_GAME_L10N_FILES='
history
taunt
sound/campaign
sound/scenario
data/list.crx
data/list_x1.crx
data/genie.dat
data/genie_x1.dat
data/sounds.drs
data/sounds_x1.drs'
CONTENT_GAME_DATA_FILES='
ai
extras
music
random
savegame
sound
data/load
data/shadow.col
data/blendomatic.dat
data/blkedge.dat
data/filtermaps.dat
data/lightmaps.dat
data/loqmaps.dat
data/patternmasks.dat
data/stemplet.dat
data/tileedge.dat
data/view_icm.dat
data/graphics.drs
data/graphics_x1.drs
data/interfac.drs
data/interfac_x1.drs
data/terrain.drs
data/terrain_x1.drs
xlogo1.avi
xintro.avi'
## gamedata_x1.drs differs between French and English localisations, but it does not seem to be an significative difference.
## gamedata.drs is identical in both localisations, as expected.
CONTENT_GAME0_DATA_FILES='
data/gamedata.drs
data/gamedata_x1.drs'
## campaign/media/1c2s6_end.mm differs between French and English localisations, but it does not seem to be an significative difference.
CONTENT_GAME1_DATA_FILES='
campaign'
CONTENT_DOC_DATA_PATH='app'
CONTENT_DOC_DATA_FILES='
*.pdf'

USER_PERSISTENT_DIRECTORIES='
ai
campaign
random
savegame
scenario'
USER_PERSISTENT_FILES='
data/*.dat
player.nf*'

## Work around CD check.
WINE_REGISTRY_INIT='
[HKEY_LOCAL_MACHINE\Software\LucasArts Entertainment Company LLC\Star Wars Galactic Battlegrounds\1.0]

"CDPath"="C:"'
## Loss of focus leads to rendering problems, making the game menu unusable.
## (WINE 10.0)
WINE_VIRTUAL_DESKTOP='1280x1024'

APP_MAIN_EXE='battlegrounds.exe'
## Play the introduction videos on launch.
APP_MAIN_PRERUN='
# Play the introduction videos on launch.
mpv --fs --no-osc xlogo1.avi xintro.avi
'

APP_ADDON_ID="${GAME_ID}-clone-wars"
APP_ADDON_NAME="$GAME_NAME - Clone Wars"
APP_ADDON_EXE='battlegrounds_x1.exe'
## Play the introduction videos on launch.
APP_ADDON_PRERUN="$APP_MAIN_PRERUN"

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_L10N_LIBS
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'
PKG_BIN_DEPENDENCIES_COMMANDS='
mpv'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
PKG_L10N_DESCRIPTION_EN='English localisation'
PKG_L10N_DESCRIPTION_FR='French localisation'
PKG_L10N_DEPENDENCIES_SIBLINGS='
PKG_L10N_LIBS'

PKG_L10N_LIBS_ID_EN="${PKG_L10N_ID_EN}-libs"
PKG_L10N_LIBS_ID_FR="${PKG_L10N_ID_FR}-libs"
PKG_L10N_LIBS_PROVIDES="
${PKG_L10N_BASE_ID}-libs"
PKG_L10N_LIBS_ARCH='32'
PKG_L10N_LIBS_DESCRIPTION_EN="$PKG_L10N_DESCRIPTION_EN - libraries"
PKG_L10N_LIBS_DESCRIPTION_FR="$PKG_L10N_DESCRIPTION_FR - libraries"
## Prevent a fallback on PKG_L10N_DEPENDENCIES_SIBLINGS.
PKG_L10N_LIBS_DEPENDENCIES_SIBLINGS=' '

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Install shipped libraries.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	ln --force --symbolic $(path_libraries)/* "\${PATH_PREFIX}"
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
