// Authors:
//   Rafael Mizrahi   <rafim@mainsoft.com>
//   Erez Lotan       <erezl@mainsoft.com>
//   Oren Gurfinkel   <oreng@mainsoft.com>
//   Ofer Borstein
// 
// Copyright (c) 2004 Mainsoft Co.
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

//------------------------------------------------------------------------------
// <autogenerated>
//     This code was generated by a tool.
//     Runtime Version: 1.1.4322.573
//
//     Changes to this file may cause incorrect behavior and will be lost if 
//     the code is regenerated.
// </autogenerated>
//------------------------------------------------------------------------------

namespace GHTUtils {
    using System;
    using System.Data;
    using System.Xml;
    using System.Runtime.Serialization;
    
    
    [Serializable()]
    [System.ComponentModel.DesignerCategoryAttribute("code")]
    [System.Diagnostics.DebuggerStepThrough()]
    [System.ComponentModel.ToolboxItem(true)]
    public class GHTTestSuiteResult : DataSet {
        
        private TestSuiteResultsDataTable tableTestSuiteResults;
        
        private TestSuiteInfoDataTable tableTestSuiteInfo;
        
        public GHTTestSuiteResult() {
            this.InitClass();
            System.ComponentModel.CollectionChangeEventHandler schemaChangedHandler = new System.ComponentModel.CollectionChangeEventHandler(this.SchemaChanged);
            this.Tables.CollectionChanged += schemaChangedHandler;
            this.Relations.CollectionChanged += schemaChangedHandler;
        }
        
        protected GHTTestSuiteResult(SerializationInfo info, StreamingContext context) {
            string strSchema = ((string)(info.GetValue("XmlSchema", typeof(string))));
            if ((strSchema != null)) {
                DataSet ds = new DataSet();
                ds.ReadXmlSchema(new XmlTextReader(new System.IO.StringReader(strSchema)));
                if ((ds.Tables["TestSuiteResults"] != null)) {
                    this.Tables.Add(new TestSuiteResultsDataTable(ds.Tables["TestSuiteResults"]));
                }
                if ((ds.Tables["TestSuiteInfo"] != null)) {
                    this.Tables.Add(new TestSuiteInfoDataTable(ds.Tables["TestSuiteInfo"]));
                }
                this.DataSetName = ds.DataSetName;
                this.Prefix = ds.Prefix;
                this.Namespace = ds.Namespace;
                this.Locale = ds.Locale;
                this.CaseSensitive = ds.CaseSensitive;
                this.EnforceConstraints = ds.EnforceConstraints;
                this.Merge(ds, false, System.Data.MissingSchemaAction.Add);
                this.InitVars();
            }
            else {
                this.InitClass();
            }
            this.GetSerializationData(info, context);
            System.ComponentModel.CollectionChangeEventHandler schemaChangedHandler = new System.ComponentModel.CollectionChangeEventHandler(this.SchemaChanged);
            this.Tables.CollectionChanged += schemaChangedHandler;
            this.Relations.CollectionChanged += schemaChangedHandler;
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibilityAttribute(System.ComponentModel.DesignerSerializationVisibility.Content)]
        public TestSuiteResultsDataTable TestSuiteResults {
            get {
                return this.tableTestSuiteResults;
            }
        }
        
        [System.ComponentModel.Browsable(false)]
        [System.ComponentModel.DesignerSerializationVisibilityAttribute(System.ComponentModel.DesignerSerializationVisibility.Content)]
        public TestSuiteInfoDataTable TestSuiteInfo {
            get {
                return this.tableTestSuiteInfo;
            }
        }
        
        public override DataSet Clone() {
            GHTTestSuiteResult cln = ((GHTTestSuiteResult)(base.Clone()));
            cln.InitVars();
            return cln;
        }
        
        protected override bool ShouldSerializeTables() {
            return false;
        }
        
        protected override bool ShouldSerializeRelations() {
            return false;
        }
        
        protected override void ReadXmlSerializable(XmlReader reader) {
            this.Reset();
            DataSet ds = new DataSet();
            ds.ReadXml(reader);
            if ((ds.Tables["TestSuiteResults"] != null)) {
                this.Tables.Add(new TestSuiteResultsDataTable(ds.Tables["TestSuiteResults"]));
            }
            if ((ds.Tables["TestSuiteInfo"] != null)) {
                this.Tables.Add(new TestSuiteInfoDataTable(ds.Tables["TestSuiteInfo"]));
            }
            this.DataSetName = ds.DataSetName;
            this.Prefix = ds.Prefix;
            this.Namespace = ds.Namespace;
            this.Locale = ds.Locale;
            this.CaseSensitive = ds.CaseSensitive;
            this.EnforceConstraints = ds.EnforceConstraints;
            this.Merge(ds, false, System.Data.MissingSchemaAction.Add);
            this.InitVars();
        }
        
        protected override System.Xml.Schema.XmlSchema GetSchemaSerializable() {
            System.IO.MemoryStream stream = new System.IO.MemoryStream();
            this.WriteXmlSchema(new XmlTextWriter(stream, null));
            stream.Position = 0;
            return System.Xml.Schema.XmlSchema.Read(new XmlTextReader(stream), null);
        }
        
        internal void InitVars() {
            this.tableTestSuiteResults = ((TestSuiteResultsDataTable)(this.Tables["TestSuiteResults"]));
            if ((this.tableTestSuiteResults != null)) {
                this.tableTestSuiteResults.InitVars();
            }
            this.tableTestSuiteInfo = ((TestSuiteInfoDataTable)(this.Tables["TestSuiteInfo"]));
            if ((this.tableTestSuiteInfo != null)) {
                this.tableTestSuiteInfo.InitVars();
            }
        }
        
        private void InitClass() {
            this.DataSetName = "GHTTestSuiteResult";
            this.Prefix = "";
            this.Namespace = "http://www.mainsoft.com/GH/GHT/XMLSerializationTS/Result";
            this.Locale = new System.Globalization.CultureInfo("en-US");
            this.CaseSensitive = false;
            this.EnforceConstraints = true;
            this.tableTestSuiteResults = new TestSuiteResultsDataTable();
            this.Tables.Add(this.tableTestSuiteResults);
            this.tableTestSuiteInfo = new TestSuiteInfoDataTable();
            this.Tables.Add(this.tableTestSuiteInfo);
        }
        
        private bool ShouldSerializeTestSuiteResults() {
            return false;
        }
        
        private bool ShouldSerializeTestSuiteInfo() {
            return false;
        }
        
        private void SchemaChanged(object sender, System.ComponentModel.CollectionChangeEventArgs e) {
            if ((e.Action == System.ComponentModel.CollectionChangeAction.Remove)) {
                this.InitVars();
            }
        }
        
        public delegate void TestSuiteResultsRowChangeEventHandler(object sender, TestSuiteResultsRowChangeEvent e);
        
        public delegate void TestSuiteInfoRowChangeEventHandler(object sender, TestSuiteInfoRowChangeEvent e);
        
        [System.Diagnostics.DebuggerStepThrough()]
        public class TestSuiteResultsDataTable : DataTable, System.Collections.IEnumerable {
            
            private DataColumn columnTestId;
            
            private DataColumn columnDescription;
            
            private DataColumn columnStatus;
            
            private DataColumn columnComment;
            
            private DataColumn columnStatusUrl;
            
            private DataColumn columnNetStatus;
            
            private DataColumn columnNetStatusUrl;
            
            private DataColumn columnNetMsg;
            
            private DataColumn columnNetExType;
            
            private DataColumn columnNetStack;
            
            private DataColumn columnNetInnerExType;
            
            private DataColumn columnNetInnerMsg;
            
            private DataColumn columnNetInnerstack;
            
            private DataColumn columnNetTestPhase;
            
            private DataColumn columnGHStatus;
            
            private DataColumn columnGHStatusUrl;
            
            private DataColumn columnGHExType;
            
            private DataColumn columnGHMsg;
            
            private DataColumn columnGHStack;
            
            private DataColumn columnGHInnerExType;
            
            private DataColumn columnGHInnerMsg;
            
            private DataColumn columnGHInnerStack;
            
            private DataColumn columnGHTestPhase;
            
            private DataColumn columnUserField1;
            
            private DataColumn columnUserField2;
            
            private DataColumn columnUserField3;
            
            internal TestSuiteResultsDataTable() : 
                    base("TestSuiteResults") {
                this.InitClass();
            }
            
            internal TestSuiteResultsDataTable(DataTable table) : 
                    base(table.TableName) {
                if ((table.CaseSensitive != table.DataSet.CaseSensitive)) {
                    this.CaseSensitive = table.CaseSensitive;
                }
                if ((table.Locale.ToString() != table.DataSet.Locale.ToString())) {
                    this.Locale = table.Locale;
                }
                if ((table.Namespace != table.DataSet.Namespace)) {
                    this.Namespace = table.Namespace;
                }
                this.Prefix = table.Prefix;
                this.MinimumCapacity = table.MinimumCapacity;
                this.DisplayExpression = table.DisplayExpression;
            }
            
            [System.ComponentModel.Browsable(false)]
            public int Count {
                get {
                    return this.Rows.Count;
                }
            }
            
            internal DataColumn TestIdColumn {
                get {
                    return this.columnTestId;
                }
            }
            
            internal DataColumn DescriptionColumn {
                get {
                    return this.columnDescription;
                }
            }
            
            internal DataColumn StatusColumn {
                get {
                    return this.columnStatus;
                }
            }
            
            internal DataColumn CommentColumn {
                get {
                    return this.columnComment;
                }
            }
            
            internal DataColumn StatusUrlColumn {
                get {
                    return this.columnStatusUrl;
                }
            }
            
            internal DataColumn NetStatusColumn {
                get {
                    return this.columnNetStatus;
                }
            }
            
            internal DataColumn NetStatusUrlColumn {
                get {
                    return this.columnNetStatusUrl;
                }
            }
            
            internal DataColumn NetMsgColumn {
                get {
                    return this.columnNetMsg;
                }
            }
            
            internal DataColumn NetExTypeColumn {
                get {
                    return this.columnNetExType;
                }
            }
            
            internal DataColumn NetStackColumn {
                get {
                    return this.columnNetStack;
                }
            }
            
            internal DataColumn NetInnerExTypeColumn {
                get {
                    return this.columnNetInnerExType;
                }
            }
            
            internal DataColumn NetInnerMsgColumn {
                get {
                    return this.columnNetInnerMsg;
                }
            }
            
            internal DataColumn NetInnerstackColumn {
                get {
                    return this.columnNetInnerstack;
                }
            }
            
            internal DataColumn NetTestPhaseColumn {
                get {
                    return this.columnNetTestPhase;
                }
            }
            
            internal DataColumn GHStatusColumn {
                get {
                    return this.columnGHStatus;
                }
            }
            
            internal DataColumn GHStatusUrlColumn {
                get {
                    return this.columnGHStatusUrl;
                }
            }
            
            internal DataColumn GHExTypeColumn {
                get {
                    return this.columnGHExType;
                }
            }
            
            internal DataColumn GHMsgColumn {
                get {
                    return this.columnGHMsg;
                }
            }
            
            internal DataColumn GHStackColumn {
                get {
                    return this.columnGHStack;
                }
            }
            
            internal DataColumn GHInnerExTypeColumn {
                get {
                    return this.columnGHInnerExType;
                }
            }
            
            internal DataColumn GHInnerMsgColumn {
                get {
                    return this.columnGHInnerMsg;
                }
            }
            
            internal DataColumn GHInnerStackColumn {
                get {
                    return this.columnGHInnerStack;
                }
            }
            
            internal DataColumn GHTestPhaseColumn {
                get {
                    return this.columnGHTestPhase;
                }
            }
            
            internal DataColumn UserField1Column {
                get {
                    return this.columnUserField1;
                }
            }
            
            internal DataColumn UserField2Column {
                get {
                    return this.columnUserField2;
                }
            }
            
            internal DataColumn UserField3Column {
                get {
                    return this.columnUserField3;
                }
            }
            
            public TestSuiteResultsRow this[int index] {
                get {
                    return ((TestSuiteResultsRow)(this.Rows[index]));
                }
            }
            
            public event TestSuiteResultsRowChangeEventHandler TestSuiteResultsRowChanged;
            
            public event TestSuiteResultsRowChangeEventHandler TestSuiteResultsRowChanging;
            
            public event TestSuiteResultsRowChangeEventHandler TestSuiteResultsRowDeleted;
            
            public event TestSuiteResultsRowChangeEventHandler TestSuiteResultsRowDeleting;
            
            public void AddTestSuiteResultsRow(TestSuiteResultsRow row) {
                this.Rows.Add(row);
            }
            
            public TestSuiteResultsRow AddTestSuiteResultsRow(
                        string TestId, 
                        string Description, 
                        string Status, 
                        string Comment, 
                        string StatusUrl, 
                        string NetStatus, 
                        string NetStatusUrl, 
                        string NetMsg, 
                        string NetExType, 
                        string NetStack, 
                        string NetInnerExType, 
                        string NetInnerMsg, 
                        string NetInnerstack, 
                        string NetTestPhase, 
                        string GHStatus, 
                        string GHStatusUrl, 
                        string GHExType, 
                        string GHMsg, 
                        string GHStack, 
                        string GHInnerExType, 
                        string GHInnerMsg, 
                        string GHInnerStack, 
                        string GHTestPhase, 
                        string UserField1, 
                        string UserField2, 
                        string UserField3) {
                TestSuiteResultsRow rowTestSuiteResultsRow = ((TestSuiteResultsRow)(this.NewRow()));
                rowTestSuiteResultsRow.ItemArray = new object[] {
                        TestId,
                        Description,
                        Status,
                        Comment,
                        StatusUrl,
                        NetStatus,
                        NetStatusUrl,
                        NetMsg,
                        NetExType,
                        NetStack,
                        NetInnerExType,
                        NetInnerMsg,
                        NetInnerstack,
                        NetTestPhase,
                        GHStatus,
                        GHStatusUrl,
                        GHExType,
                        GHMsg,
                        GHStack,
                        GHInnerExType,
                        GHInnerMsg,
                        GHInnerStack,
                        GHTestPhase,
                        UserField1,
                        UserField2,
                        UserField3};
                this.Rows.Add(rowTestSuiteResultsRow);
                return rowTestSuiteResultsRow;
            }
            
            public System.Collections.IEnumerator GetEnumerator() {
                return this.Rows.GetEnumerator();
            }
            
            public override DataTable Clone() {
                TestSuiteResultsDataTable cln = ((TestSuiteResultsDataTable)(base.Clone()));
                cln.InitVars();
                return cln;
            }
            
            protected override DataTable CreateInstance() {
                return new TestSuiteResultsDataTable();
            }
            
            internal void InitVars() {
                this.columnTestId = this.Columns["TestId"];
                this.columnDescription = this.Columns["Description"];
                this.columnStatus = this.Columns["Status"];
                this.columnComment = this.Columns["Comment"];
                this.columnStatusUrl = this.Columns["StatusUrl"];
                this.columnNetStatus = this.Columns["NetStatus"];
                this.columnNetStatusUrl = this.Columns["NetStatusUrl"];
                this.columnNetMsg = this.Columns["NetMsg"];
                this.columnNetExType = this.Columns["NetExType"];
                this.columnNetStack = this.Columns["NetStack"];
                this.columnNetInnerExType = this.Columns["NetInnerExType"];
                this.columnNetInnerMsg = this.Columns["NetInnerMsg"];
                this.columnNetInnerstack = this.Columns["NetInnerstack"];
                this.columnNetTestPhase = this.Columns["NetTestPhase"];
                this.columnGHStatus = this.Columns["GHStatus"];
                this.columnGHStatusUrl = this.Columns["GHStatusUrl"];
                this.columnGHExType = this.Columns["GHExType"];
                this.columnGHMsg = this.Columns["GHMsg"];
                this.columnGHStack = this.Columns["GHStack"];
                this.columnGHInnerExType = this.Columns["GHInnerExType"];
                this.columnGHInnerMsg = this.Columns["GHInnerMsg"];
                this.columnGHInnerStack = this.Columns["GHInnerStack"];
                this.columnGHTestPhase = this.Columns["GHTestPhase"];
                this.columnUserField1 = this.Columns["UserField1"];
                this.columnUserField2 = this.Columns["UserField2"];
                this.columnUserField3 = this.Columns["UserField3"];
            }
            
            private void InitClass() {
                this.columnTestId = new DataColumn("TestId", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnTestId);
                this.columnDescription = new DataColumn("Description", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnDescription);
                this.columnStatus = new DataColumn("Status", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnStatus);
                this.columnComment = new DataColumn("Comment", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnComment);
                this.columnStatusUrl = new DataColumn("StatusUrl", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnStatusUrl);
                this.columnNetStatus = new DataColumn("NetStatus", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnNetStatus);
                this.columnNetStatusUrl = new DataColumn("NetStatusUrl", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnNetStatusUrl);
                this.columnNetMsg = new DataColumn("NetMsg", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnNetMsg);
                this.columnNetExType = new DataColumn("NetExType", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnNetExType);
                this.columnNetStack = new DataColumn("NetStack", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnNetStack);
                this.columnNetInnerExType = new DataColumn("NetInnerExType", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnNetInnerExType);
                this.columnNetInnerMsg = new DataColumn("NetInnerMsg", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnNetInnerMsg);
                this.columnNetInnerstack = new DataColumn("NetInnerstack", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnNetInnerstack);
                this.columnNetTestPhase = new DataColumn("NetTestPhase", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnNetTestPhase);
                this.columnGHStatus = new DataColumn("GHStatus", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnGHStatus);
                this.columnGHStatusUrl = new DataColumn("GHStatusUrl", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnGHStatusUrl);
                this.columnGHExType = new DataColumn("GHExType", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnGHExType);
                this.columnGHMsg = new DataColumn("GHMsg", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnGHMsg);
                this.columnGHStack = new DataColumn("GHStack", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnGHStack);
                this.columnGHInnerExType = new DataColumn("GHInnerExType", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnGHInnerExType);
                this.columnGHInnerMsg = new DataColumn("GHInnerMsg", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnGHInnerMsg);
                this.columnGHInnerStack = new DataColumn("GHInnerStack", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnGHInnerStack);
                this.columnGHTestPhase = new DataColumn("GHTestPhase", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnGHTestPhase);
                this.columnUserField1 = new DataColumn("UserField1", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnUserField1);
                this.columnUserField2 = new DataColumn("UserField2", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnUserField2);
                this.columnUserField3 = new DataColumn("UserField3", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnUserField3);
                this.columnTestId.AllowDBNull = false;
                this.columnStatus.AllowDBNull = false;
            }
            
            public TestSuiteResultsRow NewTestSuiteResultsRow() {
                return ((TestSuiteResultsRow)(this.NewRow()));
            }
            
            protected override DataRow NewRowFromBuilder(DataRowBuilder builder) {
                return new TestSuiteResultsRow(builder);
            }
            
            protected override System.Type GetRowType() {
                return typeof(TestSuiteResultsRow);
            }
            
            protected override void OnRowChanged(DataRowChangeEventArgs e) {
                base.OnRowChanged(e);
                if ((this.TestSuiteResultsRowChanged != null)) {
                    this.TestSuiteResultsRowChanged(this, new TestSuiteResultsRowChangeEvent(((TestSuiteResultsRow)(e.Row)), e.Action));
                }
            }
            
            protected override void OnRowChanging(DataRowChangeEventArgs e) {
                base.OnRowChanging(e);
                if ((this.TestSuiteResultsRowChanging != null)) {
                    this.TestSuiteResultsRowChanging(this, new TestSuiteResultsRowChangeEvent(((TestSuiteResultsRow)(e.Row)), e.Action));
                }
            }
            
            protected override void OnRowDeleted(DataRowChangeEventArgs e) {
                base.OnRowDeleted(e);
                if ((this.TestSuiteResultsRowDeleted != null)) {
                    this.TestSuiteResultsRowDeleted(this, new TestSuiteResultsRowChangeEvent(((TestSuiteResultsRow)(e.Row)), e.Action));
                }
            }
            
            protected override void OnRowDeleting(DataRowChangeEventArgs e) {
                base.OnRowDeleting(e);
                if ((this.TestSuiteResultsRowDeleting != null)) {
                    this.TestSuiteResultsRowDeleting(this, new TestSuiteResultsRowChangeEvent(((TestSuiteResultsRow)(e.Row)), e.Action));
                }
            }
            
            public void RemoveTestSuiteResultsRow(TestSuiteResultsRow row) {
                this.Rows.Remove(row);
            }
        }
        
        [System.Diagnostics.DebuggerStepThrough()]
        public class TestSuiteResultsRow : DataRow {
            
            private TestSuiteResultsDataTable tableTestSuiteResults;
            
            internal TestSuiteResultsRow(DataRowBuilder rb) : 
                    base(rb) {
                this.tableTestSuiteResults = ((TestSuiteResultsDataTable)(this.Table));
            }
            
            public string TestId {
                get {
                    return ((string)(this[this.tableTestSuiteResults.TestIdColumn]));
                }
                set {
                    this[this.tableTestSuiteResults.TestIdColumn] = value;
                }
            }
            
            public string Description {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.DescriptionColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.DescriptionColumn] = value;
                }
            }
            
            public string Status {
                get {
                    return ((string)(this[this.tableTestSuiteResults.StatusColumn]));
                }
                set {
                    this[this.tableTestSuiteResults.StatusColumn] = value;
                }
            }
            
            public string Comment {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.CommentColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.CommentColumn] = value;
                }
            }
            
            public string StatusUrl {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.StatusUrlColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.StatusUrlColumn] = value;
                }
            }
            
            public string NetStatus {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.NetStatusColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.NetStatusColumn] = value;
                }
            }
            
            public string NetStatusUrl {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.NetStatusUrlColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.NetStatusUrlColumn] = value;
                }
            }
            
            public string NetMsg {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.NetMsgColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.NetMsgColumn] = value;
                }
            }
            
            public string NetExType {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.NetExTypeColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.NetExTypeColumn] = value;
                }
            }
            
            public string NetStack {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.NetStackColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.NetStackColumn] = value;
                }
            }
            
            public string NetInnerExType {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.NetInnerExTypeColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.NetInnerExTypeColumn] = value;
                }
            }
            
            public string NetInnerMsg {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.NetInnerMsgColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.NetInnerMsgColumn] = value;
                }
            }
            
            public string NetInnerstack {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.NetInnerstackColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.NetInnerstackColumn] = value;
                }
            }
            
            public string NetTestPhase {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.NetTestPhaseColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.NetTestPhaseColumn] = value;
                }
            }
            
            public string GHStatus {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.GHStatusColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.GHStatusColumn] = value;
                }
            }
            
            public string GHStatusUrl {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.GHStatusUrlColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.GHStatusUrlColumn] = value;
                }
            }
            
            public string GHExType {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.GHExTypeColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.GHExTypeColumn] = value;
                }
            }
            
            public string GHMsg {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.GHMsgColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.GHMsgColumn] = value;
                }
            }
            
            public string GHStack {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.GHStackColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.GHStackColumn] = value;
                }
            }
            
            public string GHInnerExType {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.GHInnerExTypeColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.GHInnerExTypeColumn] = value;
                }
            }
            
            public string GHInnerMsg {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.GHInnerMsgColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.GHInnerMsgColumn] = value;
                }
            }
            
            public string GHInnerStack {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.GHInnerStackColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.GHInnerStackColumn] = value;
                }
            }
            
            public string GHTestPhase {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.GHTestPhaseColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.GHTestPhaseColumn] = value;
                }
            }
            
            public string UserField1 {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.UserField1Column]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.UserField1Column] = value;
                }
            }
            
            public string UserField2 {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.UserField2Column]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.UserField2Column] = value;
                }
            }
            
            public string UserField3 {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteResults.UserField3Column]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteResults.UserField3Column] = value;
                }
            }
            
            public bool IsDescriptionNull() {
                return this.IsNull(this.tableTestSuiteResults.DescriptionColumn);
            }
            
            public void SetDescriptionNull() {
                this[this.tableTestSuiteResults.DescriptionColumn] = System.Convert.DBNull;
            }
            
            public bool IsCommentNull() {
                return this.IsNull(this.tableTestSuiteResults.CommentColumn);
            }
            
            public void SetCommentNull() {
                this[this.tableTestSuiteResults.CommentColumn] = System.Convert.DBNull;
            }
            
            public bool IsStatusUrlNull() {
                return this.IsNull(this.tableTestSuiteResults.StatusUrlColumn);
            }
            
            public void SetStatusUrlNull() {
                this[this.tableTestSuiteResults.StatusUrlColumn] = System.Convert.DBNull;
            }
            
            public bool IsNetStatusNull() {
                return this.IsNull(this.tableTestSuiteResults.NetStatusColumn);
            }
            
            public void SetNetStatusNull() {
                this[this.tableTestSuiteResults.NetStatusColumn] = System.Convert.DBNull;
            }
            
            public bool IsNetStatusUrlNull() {
                return this.IsNull(this.tableTestSuiteResults.NetStatusUrlColumn);
            }
            
            public void SetNetStatusUrlNull() {
                this[this.tableTestSuiteResults.NetStatusUrlColumn] = System.Convert.DBNull;
            }
            
            public bool IsNetMsgNull() {
                return this.IsNull(this.tableTestSuiteResults.NetMsgColumn);
            }
            
            public void SetNetMsgNull() {
                this[this.tableTestSuiteResults.NetMsgColumn] = System.Convert.DBNull;
            }
            
            public bool IsNetExTypeNull() {
                return this.IsNull(this.tableTestSuiteResults.NetExTypeColumn);
            }
            
            public void SetNetExTypeNull() {
                this[this.tableTestSuiteResults.NetExTypeColumn] = System.Convert.DBNull;
            }
            
            public bool IsNetStackNull() {
                return this.IsNull(this.tableTestSuiteResults.NetStackColumn);
            }
            
            public void SetNetStackNull() {
                this[this.tableTestSuiteResults.NetStackColumn] = System.Convert.DBNull;
            }
            
            public bool IsNetInnerExTypeNull() {
                return this.IsNull(this.tableTestSuiteResults.NetInnerExTypeColumn);
            }
            
            public void SetNetInnerExTypeNull() {
                this[this.tableTestSuiteResults.NetInnerExTypeColumn] = System.Convert.DBNull;
            }
            
            public bool IsNetInnerMsgNull() {
                return this.IsNull(this.tableTestSuiteResults.NetInnerMsgColumn);
            }
            
            public void SetNetInnerMsgNull() {
                this[this.tableTestSuiteResults.NetInnerMsgColumn] = System.Convert.DBNull;
            }
            
            public bool IsNetInnerstackNull() {
                return this.IsNull(this.tableTestSuiteResults.NetInnerstackColumn);
            }
            
            public void SetNetInnerstackNull() {
                this[this.tableTestSuiteResults.NetInnerstackColumn] = System.Convert.DBNull;
            }
            
            public bool IsNetTestPhaseNull() {
                return this.IsNull(this.tableTestSuiteResults.NetTestPhaseColumn);
            }
            
            public void SetNetTestPhaseNull() {
                this[this.tableTestSuiteResults.NetTestPhaseColumn] = System.Convert.DBNull;
            }
            
            public bool IsGHStatusNull() {
                return this.IsNull(this.tableTestSuiteResults.GHStatusColumn);
            }
            
            public void SetGHStatusNull() {
                this[this.tableTestSuiteResults.GHStatusColumn] = System.Convert.DBNull;
            }
            
            public bool IsGHStatusUrlNull() {
                return this.IsNull(this.tableTestSuiteResults.GHStatusUrlColumn);
            }
            
            public void SetGHStatusUrlNull() {
                this[this.tableTestSuiteResults.GHStatusUrlColumn] = System.Convert.DBNull;
            }
            
            public bool IsGHExTypeNull() {
                return this.IsNull(this.tableTestSuiteResults.GHExTypeColumn);
            }
            
            public void SetGHExTypeNull() {
                this[this.tableTestSuiteResults.GHExTypeColumn] = System.Convert.DBNull;
            }
            
            public bool IsGHMsgNull() {
                return this.IsNull(this.tableTestSuiteResults.GHMsgColumn);
            }
            
            public void SetGHMsgNull() {
                this[this.tableTestSuiteResults.GHMsgColumn] = System.Convert.DBNull;
            }
            
            public bool IsGHStackNull() {
                return this.IsNull(this.tableTestSuiteResults.GHStackColumn);
            }
            
            public void SetGHStackNull() {
                this[this.tableTestSuiteResults.GHStackColumn] = System.Convert.DBNull;
            }
            
            public bool IsGHInnerExTypeNull() {
                return this.IsNull(this.tableTestSuiteResults.GHInnerExTypeColumn);
            }
            
            public void SetGHInnerExTypeNull() {
                this[this.tableTestSuiteResults.GHInnerExTypeColumn] = System.Convert.DBNull;
            }
            
            public bool IsGHInnerMsgNull() {
                return this.IsNull(this.tableTestSuiteResults.GHInnerMsgColumn);
            }
            
            public void SetGHInnerMsgNull() {
                this[this.tableTestSuiteResults.GHInnerMsgColumn] = System.Convert.DBNull;
            }
            
            public bool IsGHInnerStackNull() {
                return this.IsNull(this.tableTestSuiteResults.GHInnerStackColumn);
            }
            
            public void SetGHInnerStackNull() {
                this[this.tableTestSuiteResults.GHInnerStackColumn] = System.Convert.DBNull;
            }
            
            public bool IsGHTestPhaseNull() {
                return this.IsNull(this.tableTestSuiteResults.GHTestPhaseColumn);
            }
            
            public void SetGHTestPhaseNull() {
                this[this.tableTestSuiteResults.GHTestPhaseColumn] = System.Convert.DBNull;
            }
            
            public bool IsUserField1Null() {
                return this.IsNull(this.tableTestSuiteResults.UserField1Column);
            }
            
            public void SetUserField1Null() {
                this[this.tableTestSuiteResults.UserField1Column] = System.Convert.DBNull;
            }
            
            public bool IsUserField2Null() {
                return this.IsNull(this.tableTestSuiteResults.UserField2Column);
            }
            
            public void SetUserField2Null() {
                this[this.tableTestSuiteResults.UserField2Column] = System.Convert.DBNull;
            }
            
            public bool IsUserField3Null() {
                return this.IsNull(this.tableTestSuiteResults.UserField3Column);
            }
            
            public void SetUserField3Null() {
                this[this.tableTestSuiteResults.UserField3Column] = System.Convert.DBNull;
            }
        }
        
        [System.Diagnostics.DebuggerStepThrough()]
        public class TestSuiteResultsRowChangeEvent : EventArgs {
            
            private TestSuiteResultsRow eventRow;
            
            private DataRowAction eventAction;
            
            public TestSuiteResultsRowChangeEvent(TestSuiteResultsRow row, DataRowAction action) {
                this.eventRow = row;
                this.eventAction = action;
            }
            
            public TestSuiteResultsRow Row {
                get {
                    return this.eventRow;
                }
            }
            
            public DataRowAction Action {
                get {
                    return this.eventAction;
                }
            }
        }
        
        [System.Diagnostics.DebuggerStepThrough()]
        public class TestSuiteInfoDataTable : DataTable, System.Collections.IEnumerable {
            
            private DataColumn columnName;
            
            private DataColumn columnBuild;
            
            private DataColumn columnDescription;
            
            private DataColumn columnRunDate;
            
            private DataColumn columnRunBy;
            
            private DataColumn columnIsComparative;
            
            private DataColumn columnFileName;
            
            internal TestSuiteInfoDataTable() : 
                    base("TestSuiteInfo") {
                this.InitClass();
            }
            
            internal TestSuiteInfoDataTable(DataTable table) : 
                    base(table.TableName) {
                if ((table.CaseSensitive != table.DataSet.CaseSensitive)) {
                    this.CaseSensitive = table.CaseSensitive;
                }
                if ((table.Locale.ToString() != table.DataSet.Locale.ToString())) {
                    this.Locale = table.Locale;
                }
                if ((table.Namespace != table.DataSet.Namespace)) {
                    this.Namespace = table.Namespace;
                }
                this.Prefix = table.Prefix;
                this.MinimumCapacity = table.MinimumCapacity;
                this.DisplayExpression = table.DisplayExpression;
            }
            
            [System.ComponentModel.Browsable(false)]
            public int Count {
                get {
                    return this.Rows.Count;
                }
            }
            
            internal DataColumn NameColumn {
                get {
                    return this.columnName;
                }
            }
            
            internal DataColumn BuildColumn {
                get {
                    return this.columnBuild;
                }
            }
            
            internal DataColumn DescriptionColumn {
                get {
                    return this.columnDescription;
                }
            }
            
            internal DataColumn RunDateColumn {
                get {
                    return this.columnRunDate;
                }
            }
            
            internal DataColumn RunByColumn {
                get {
                    return this.columnRunBy;
                }
            }
            
            internal DataColumn IsComparativeColumn {
                get {
                    return this.columnIsComparative;
                }
            }
            
            internal DataColumn FileNameColumn {
                get {
                    return this.columnFileName;
                }
            }
            
            public TestSuiteInfoRow this[int index] {
                get {
                    return ((TestSuiteInfoRow)(this.Rows[index]));
                }
            }
            
            public event TestSuiteInfoRowChangeEventHandler TestSuiteInfoRowChanged;
            
            public event TestSuiteInfoRowChangeEventHandler TestSuiteInfoRowChanging;
            
            public event TestSuiteInfoRowChangeEventHandler TestSuiteInfoRowDeleted;
            
            public event TestSuiteInfoRowChangeEventHandler TestSuiteInfoRowDeleting;
            
            public void AddTestSuiteInfoRow(TestSuiteInfoRow row) {
                this.Rows.Add(row);
            }
            
            public TestSuiteInfoRow AddTestSuiteInfoRow(string Name, string Build, string Description, string RunDate, string RunBy, bool IsComparative, string FileName) {
                TestSuiteInfoRow rowTestSuiteInfoRow = ((TestSuiteInfoRow)(this.NewRow()));
                rowTestSuiteInfoRow.ItemArray = new object[] {
                        Name,
                        Build,
                        Description,
                        RunDate,
                        RunBy,
                        IsComparative,
                        FileName};
                this.Rows.Add(rowTestSuiteInfoRow);
                return rowTestSuiteInfoRow;
            }
            
            public System.Collections.IEnumerator GetEnumerator() {
                return this.Rows.GetEnumerator();
            }
            
            public override DataTable Clone() {
                TestSuiteInfoDataTable cln = ((TestSuiteInfoDataTable)(base.Clone()));
                cln.InitVars();
                return cln;
            }
            
            protected override DataTable CreateInstance() {
                return new TestSuiteInfoDataTable();
            }
            
            internal void InitVars() {
                this.columnName = this.Columns["Name"];
                this.columnBuild = this.Columns["Build"];
                this.columnDescription = this.Columns["Description"];
                this.columnRunDate = this.Columns["RunDate"];
                this.columnRunBy = this.Columns["RunBy"];
                this.columnIsComparative = this.Columns["IsComparative"];
                this.columnFileName = this.Columns["FileName"];
            }
            
            private void InitClass() {
                this.columnName = new DataColumn("Name", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnName);
                this.columnBuild = new DataColumn("Build", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnBuild);
                this.columnDescription = new DataColumn("Description", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnDescription);
                this.columnRunDate = new DataColumn("RunDate", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnRunDate);
                this.columnRunBy = new DataColumn("RunBy", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnRunBy);
                this.columnIsComparative = new DataColumn("IsComparative", typeof(bool), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnIsComparative);
                this.columnFileName = new DataColumn("FileName", typeof(string), null, System.Data.MappingType.Element);
                this.Columns.Add(this.columnFileName);
            }
            
            public TestSuiteInfoRow NewTestSuiteInfoRow() {
                return ((TestSuiteInfoRow)(this.NewRow()));
            }
            
            protected override DataRow NewRowFromBuilder(DataRowBuilder builder) {
                return new TestSuiteInfoRow(builder);
            }
            
            protected override System.Type GetRowType() {
                return typeof(TestSuiteInfoRow);
            }
            
            protected override void OnRowChanged(DataRowChangeEventArgs e) {
                base.OnRowChanged(e);
                if ((this.TestSuiteInfoRowChanged != null)) {
                    this.TestSuiteInfoRowChanged(this, new TestSuiteInfoRowChangeEvent(((TestSuiteInfoRow)(e.Row)), e.Action));
                }
            }
            
            protected override void OnRowChanging(DataRowChangeEventArgs e) {
                base.OnRowChanging(e);
                if ((this.TestSuiteInfoRowChanging != null)) {
                    this.TestSuiteInfoRowChanging(this, new TestSuiteInfoRowChangeEvent(((TestSuiteInfoRow)(e.Row)), e.Action));
                }
            }
            
            protected override void OnRowDeleted(DataRowChangeEventArgs e) {
                base.OnRowDeleted(e);
                if ((this.TestSuiteInfoRowDeleted != null)) {
                    this.TestSuiteInfoRowDeleted(this, new TestSuiteInfoRowChangeEvent(((TestSuiteInfoRow)(e.Row)), e.Action));
                }
            }
            
            protected override void OnRowDeleting(DataRowChangeEventArgs e) {
                base.OnRowDeleting(e);
                if ((this.TestSuiteInfoRowDeleting != null)) {
                    this.TestSuiteInfoRowDeleting(this, new TestSuiteInfoRowChangeEvent(((TestSuiteInfoRow)(e.Row)), e.Action));
                }
            }
            
            public void RemoveTestSuiteInfoRow(TestSuiteInfoRow row) {
                this.Rows.Remove(row);
            }
        }
        
        [System.Diagnostics.DebuggerStepThrough()]
        public class TestSuiteInfoRow : DataRow {
            
            private TestSuiteInfoDataTable tableTestSuiteInfo;
            
            internal TestSuiteInfoRow(DataRowBuilder rb) : 
                    base(rb) {
                this.tableTestSuiteInfo = ((TestSuiteInfoDataTable)(this.Table));
            }
            
            public string Name {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteInfo.NameColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteInfo.NameColumn] = value;
                }
            }
            
            public string Build {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteInfo.BuildColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteInfo.BuildColumn] = value;
                }
            }
            
            public string Description {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteInfo.DescriptionColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteInfo.DescriptionColumn] = value;
                }
            }
            
            public string RunDate {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteInfo.RunDateColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteInfo.RunDateColumn] = value;
                }
            }
            
            public string RunBy {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteInfo.RunByColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteInfo.RunByColumn] = value;
                }
            }
            
            public bool IsComparative {
                get {
                    try {
                        return ((bool)(this[this.tableTestSuiteInfo.IsComparativeColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteInfo.IsComparativeColumn] = value;
                }
            }
            
            public string FileName {
                get {
                    try {
                        return ((string)(this[this.tableTestSuiteInfo.FileNameColumn]));
                    }
                    catch (InvalidCastException e) {
                        throw new StrongTypingException("Cannot get value because it is DBNull.", e);
                    }
                }
                set {
                    this[this.tableTestSuiteInfo.FileNameColumn] = value;
                }
            }
            
            public bool IsNameNull() {
                return this.IsNull(this.tableTestSuiteInfo.NameColumn);
            }
            
            public void SetNameNull() {
                this[this.tableTestSuiteInfo.NameColumn] = System.Convert.DBNull;
            }
            
            public bool IsBuildNull() {
                return this.IsNull(this.tableTestSuiteInfo.BuildColumn);
            }
            
            public void SetBuildNull() {
                this[this.tableTestSuiteInfo.BuildColumn] = System.Convert.DBNull;
            }
            
            public bool IsDescriptionNull() {
                return this.IsNull(this.tableTestSuiteInfo.DescriptionColumn);
            }
            
            public void SetDescriptionNull() {
                this[this.tableTestSuiteInfo.DescriptionColumn] = System.Convert.DBNull;
            }
            
            public bool IsRunDateNull() {
                return this.IsNull(this.tableTestSuiteInfo.RunDateColumn);
            }
            
            public void SetRunDateNull() {
                this[this.tableTestSuiteInfo.RunDateColumn] = System.Convert.DBNull;
            }
            
            public bool IsRunByNull() {
                return this.IsNull(this.tableTestSuiteInfo.RunByColumn);
            }
            
            public void SetRunByNull() {
                this[this.tableTestSuiteInfo.RunByColumn] = System.Convert.DBNull;
            }
            
            public bool IsIsComparativeNull() {
                return this.IsNull(this.tableTestSuiteInfo.IsComparativeColumn);
            }
            
            public void SetIsComparativeNull() {
                this[this.tableTestSuiteInfo.IsComparativeColumn] = System.Convert.DBNull;
            }
            
            public bool IsFileNameNull() {
                return this.IsNull(this.tableTestSuiteInfo.FileNameColumn);
            }
            
            public void SetFileNameNull() {
                this[this.tableTestSuiteInfo.FileNameColumn] = System.Convert.DBNull;
            }
        }
        
        [System.Diagnostics.DebuggerStepThrough()]
        public class TestSuiteInfoRowChangeEvent : EventArgs {
            
            private TestSuiteInfoRow eventRow;
            
            private DataRowAction eventAction;
            
            public TestSuiteInfoRowChangeEvent(TestSuiteInfoRow row, DataRowAction action) {
                this.eventRow = row;
                this.eventAction = action;
            }
            
            public TestSuiteInfoRow Row {
                get {
                    return this.eventRow;
                }
            }
            
            public DataRowAction Action {
                get {
                    return this.eventAction;
                }
            }
        }
    }
}
