Subroutine ener(ameam,energy,pos,npart,vel,masse,ndim,cell,nvec,reall,options,rcut,nimage)

  !Calcule l'energie
  !variables
  !ameam: parametres du modele meam
  !energy: energie
  !eneropt: modele de calcul de l'energie
  !npart: nombre de particules
  !ndim: dimension de l'espace
  !pos(npart,ndim):position des particules
  !cell(nvec,ndim): cellule de simulation
  !nvec: nombre de vecteurs de la cellule
  !reall: cote cellule de simulaion
  !input
  USE types_def
  IMPLICIT NONE
  TYPE(options_type) :: options
  integer :: ndim,npart,nvec,nimage
  double precision :: ameam(2),pos(npart,ndim),vel(npart,ndim),cell(nvec,ndim)
  double precision :: reall,masse,rcut
  !output
  double precision :: energy
  !local variables
  integer :: ipart,idim
  double precision :: velsq,enerkin,enerpott

  enerkin=0.d0
  do ipart=1,npart
     velsq=0.d0
     do idim=1,ndim
        velsq=velsq+vel(ipart,idim)**2
     enddo
     enerkin=enerkin+.5d0*masse*velsq
  enddo
  call enerpot(ameam,enerpott,options%eneropt,pos,npart,ndim,cell,nvec,reall,rcut,nimage)
  energy=enerkin*reall**2+enerpott
  print*,energy,enerkin,enerpott
  ! stop
  return
end subroutine ener


