!{\src2tex{textfont=tt}}
!!****f* ABINIT/transfunc
!! NAME
!! transfunc 
!! 
!! FUNCTION
!! Transform phi, tphi and tproj thanks to sss=<chi(i)|chi(j)> (see uspp code)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ,MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS 
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %lmax= Maximum value of l
!!    %orbitals(basis_size)= Quantum number l for each basis function
!!    %wav_meshsz=Mesh size for partial waves and projectors inherited from uspp
!!  usdata
!!    %sss(basis_size,basis_size)=<chi(i)|chi(j)> from uspp code
!!  un_log= Unit number for log file (comments)
!!
!! SIDE EFFECTS
!!  pawps
!!    %phi(wav_meshsz,basis_size)= atomic partial waves
!!    %tphi(wav_meshsz,basis_size)= atomic pseudo partial waves
!!    %tproj(wav_meshsz,basis_size)= projectors on partial waves
!!  
!! PARENTS
!!      uspp2abinit
!!
!! NOTES
!!  Inherited from routine "qdiag" in uspp code
!!
!! SOURCE

 subroutine transfunc(pawps,pshead,usdata,un_log)

 use defs_basis
 use defs_pawps

 implicit none
 
!Arguments ---------------------------------------------
 integer :: un_log
!These types are defined in defs_pawps
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead
 type(usdata_type)   :: usdata

!Local variables ---------------------------------------
 integer :: ia,ib,ll,meshsz,nn,ns
 real(dp) :: det
 real(dp) :: nn1(4),nn2(4)
 real(dp), allocatable :: beta(:,:),psi(:,:), phi(:,:),sssm1(:,:)
                          
!-------------------------------------------------------

!Compute number of projector per angular momentum
 nn1=0;nn2(1)=1
 do ib=1,pshead%basis_size
  nn1(pshead%orbitals(ib)+1)=nn1(pshead%orbitals(ib)+1)+1
 enddo
 do ll=1,pshead%lmax
  nn2(ll+1)=nn2(ll)+nn1(ll)
 enddo

!Init. temporary arrays
 meshsz=pshead%wav_meshsz
 allocate(beta(meshsz,pshead%basis_size))
 allocate(phi (meshsz,pshead%basis_size))
 allocate(psi (meshsz,pshead%basis_size))
 allocate (sssm1(pshead%basis_size,pshead%basis_size))
 beta=zero;phi=zero;psi=zero;sssm1=zero

!Loop on angular momenta
 do ll=0,pshead%lmax
  nn=nn1(ll+1);ns=nn2(ll+1)

  if (nn>0) then
   if(nn==1) then
    sssm1(ns,ns)=1.d0/usdata%sss(ns,ns)
   elseif (nn==2) then
    det=usdata%sss(ns,ns)*usdata%sss(ns+1,ns+1)&
&      -usdata%sss(ns,ns+1)*usdata%sss(ns+1,ns)
    sssm1(ns,ns)=usdata%sss(ns+1,ns+1) /det
    sssm1(ns+1,ns)=-usdata%sss(ns+1,ns)/det
    sssm1(ns,ns+1)=-usdata%sss(ns,ns+1)/det
    sssm1(ns+1,ns+1)=usdata%sss(ns,ns) /det
   else
    write(un_log,'(/,a)') '> USpp->Abinit translator ERROR (transfunc):'
    write(un_log,'(a)')   '    No more than 2 projectors per l !'
    stop 'Program stopped before end'
   endif
   do ia=1,nn
    do ib=1,nn
     beta(1:meshsz,ns+ia-1)=&
&           beta(1:meshsz,ns+ia-1)+usdata%sss(ns+ib-1,ns+ia-1)&
&          *pawps%tproj(1:meshsz,ns+ib-1)
     psi(1:meshsz,ns+ia-1)=&
&           psi(1:meshsz,ns+ia-1)+sssm1(ns+ia-1,ns+ib-1)&
&          *pawps%phi(1:meshsz,ns+ib-1)
     phi(1:meshsz,ns+ia-1)=&
&           phi(1:meshsz,ns+ia-1)+sssm1(ns+ia-1,ns+ib-1)&
&          *pawps%tphi(1:meshsz,ns+ib-1)
    enddo
   enddo
  endif         
 enddo

 pawps%phi  =psi
 pawps%tphi =phi
 pawps%tproj=beta

 deallocate(beta,phi,psi,sssm1)

 end subroutine
!!***
