/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:25:13 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.variant.BCFReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class BCFReader_ESTest extends BCFReader_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.bci");
      byte[] byteArray0 = new byte[1];
      FileSystemHandling.shouldThrowIOException(evoSuiteFile0);
      FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader("");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader("");
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader("httpft:p^");
        fail("Expecting exception: MalformedURLException");
      
      } catch(Throwable e) {
         //
         // unknown protocol: httpft
         //
         verifyException("java.net.URL", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader("ftp:gw$aRKzJFodD8u-pR");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.net.URL", e);
      }
  }
}
