/* Generated By:JavaCC: Do not edit this line. OpeningHoursParser.java */
package ch.poole.openinghoursparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Collections;
import java.util.Locale;
import java.io.ByteArrayInputStream;
import java.io.IOException;

import ch.poole.openinghoursparser.Util;

import static ch.poole.openinghoursparser.I18n.tr;

public class OpeningHoursParser implements OpeningHoursParserConstants {
  static int TWELVEHOURS = 12*60;

  boolean strict = false;
  boolean strictTime = false;
  enum AMPM { AM, PM };
  boolean monthOnly = false;
  List < ParseException > exceptions = new ArrayList < ParseException > ();

  /**
   * Get the output of the parser
   *
   * @param strict if true the parser will run in strict mode
   * @return a List of Rule elements
   * @throws OpeningHoursParseException on parse errors
   */
  public List < Rule > rules(boolean strict) throws OpeningHoursParseException
  {
    return rules(strict, true);
  }

  /**
   * Get the output of the parser
   *
   * @param strict if true the parser will run in strict mode
   * @param strictTime if false and strict is true, earlier than the start time endings will be fixed up silently
   * @return a List of Rule elements
   * @throws OpeningHoursParseException on parse errors
   */
  public List < Rule > rules(boolean strict, boolean strictTime) throws OpeningHoursParseException
  {
    try
    {
      List < Rule > r = rules0(strict, strictTime);
      if (exceptions.size() > 1)
      {
        throw new OpeningHoursParseException(exceptions);
      }
      else if (exceptions.size() == 1)
      {
        ParseException t = exceptions.get(0);
        if (t instanceof OpeningHoursParseException)
        {
          throw (OpeningHoursParseException) t;
        }
        throw new OpeningHoursParseException(t);
      }
      return r;
    }
    catch (ParseException pex)
    { // signature requires this
      throw (OpeningHoursParseException) pex;
    }
  }

  void error_skip(ParseException e) throws ParseException {
  exceptions.add(e);
  Token t;
  do {
    t = getNextToken();
  } while (t.kind != SEMICOLON && t.kind != COMMA && t.kind != FALLBACKSEPERATOR && t.kind != WS && t.kind != HYPHEN && t.kind != EOF);
  }

  boolean precedingWs(Token t) throws ParseException {
  return t.specialToken != null && t.specialToken.kind == WS;
  }

/**
 * match a number between 1 and 5
 */
  final public Token one2five() throws ParseException {
  Token n = null;
    if (getToken(1).kind == NUMBER && Util.between(getToken(1).image, 1, 5)) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    n = jj_consume_token(NUMBER);
    {if (true) return n;}
    throw new Error("Missing return statement in function");
  }

/**
 * match a positive number larger than 1
 */
  final public Token number() throws ParseException {
  Token n = null;
    if (getToken(1).kind == NUMBER && Util.equalsOrMore(getToken(1).image, 1)) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    n = jj_consume_token(NUMBER);
    {if (true) return n;}
    throw new Error("Missing return statement in function");
  }

/**
 * Match a comment.
 */
  final public String comment() throws ParseException {
  StringBuilder builder = new StringBuilder();
    jj_consume_token(QUOTE);
    label_1:
    while (true) {
      if (jj_2_1(5)) {
        ;
      } else {
        break label_1;
      }
      getChar(builder);
    }
    jj_consume_token(ENDQUOTE);
    {if (true) return builder.toString();}
    throw new Error("Missing return statement in function");
  }

/**
 * Match char inside quoted string.
 */
  final public void getChar(StringBuilder builder) throws ParseException {
  Token t;
    t = jj_consume_token(CHAR);
    if (t.image.length() < 2)
    {
      // CHAR
      builder.append(t.image.charAt(0));
    }
  }

/**
 * returns a number Token if between 0 and 24
 * uses semantic lookahead
 */
  final public Token hours() throws ParseException {
  Token h = null;
    if (getToken(1).kind == NUMBER && Util.between(getToken(1).image, 0, 24)) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    h = jj_consume_token(NUMBER);
    {if (true) return h;}
    throw new Error("Missing return statement in function");
  }

/**
 * returns a number Token if between 0 and 59 and starts with a suitable delimiter
 * uses semantic lookahead
 */
  final public Token minutes() throws ParseException {
  Token delimiter = null;
  Token m = null;
    if (jj_2_2(5)) {
      delimiter = jj_consume_token(COLON);
    } else if (jj_2_3(5)) {
      delimiter = jj_consume_token(STOP);
    } else if (jj_2_4(5)) {
      delimiter = jj_consume_token(H);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (getToken(1).kind == NUMBER && Util.between(getToken(1).image, 0, 59) && (getToken(1).image.length() >= 2 || "0".equals(getToken(1).image))) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    m = jj_consume_token(NUMBER);
    if (strict && (m.image.length() !=  2 || delimiter.kind != COLON || precedingWs(m) || precedingWs(delimiter))) {
      ParseException pex = new OpeningHoursParseException(tr("invalid_minutes"), token.next);
      pex.currentToken = token;
      {if (true) throw pex;}
    }
    {if (true) return m;}
    throw new Error("Missing return statement in function");
  }

/**
 * returns the total number of minutes for a time of the form hh:00 or just hh
 *
 * AM/PM handling, see http://www.npl.co.uk/reference/faqs/is-midnight-12-am-or-12-pm-faq-time for why this is a mess
 * 12:01pm to 12:59pm is 12:01 to 12:59
 * 13:00pm and later is considered to be mistyped and in the 24:00 system
 * 12:00 pm is 12:00
 * 12:01am to 12:59am is 00:01 to 00:59
 * 12:00am is 00:00
 * 13:00am and later is considered to be mistyped and in the 24:00 system 
 */
  final public int time() throws ParseException {
  Token h = null;
  Token m = null;
  int result = 0;
  AMPM ampm = null;
    h = hours();
    if (jj_2_5(2147483647) && (h!=null)) {
      m = minutes();
    } else {
      ;
    }
    if (jj_2_6(5)) {
      ampm = ampm();
    } else {
      ;
    }
    if (strict && m == null) {
        ParseException pex = new OpeningHoursParseException(tr("hours_without_minutes"));
            pex.currentToken = token;
        {if (true) throw pex;}
    }
    if (m != null) {
      result = Integer.parseInt(m.image);
    }
    result = result + Integer.parseInt(h.image) * 60;
    if (ampm == AMPM.PM && result < TWELVEHOURS) { // only use add 12h if the time is less than 12 h
      result = result + TWELVEHOURS;               // 12:01 pm to 12:59 pm are already correct 24h times
    } else if (ampm == AMPM.AM && result >= TWELVEHOURS && result < TWELVEHOURS + 60) {
          result = result - TWELVEHOURS;               // 12:00am to 12:59am are clearly early morning
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public AMPM ampm() throws ParseException {
  String result = null;
  Token ampm = null;
    if (jj_2_7(5)) {
      ampm = jj_consume_token(AM);
    } else if (jj_2_8(5)) {
      ampm = jj_consume_token(PM);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
          if (ampm != null) {
            if (strict) {
          ParseException pex = new OpeningHoursParseException(tr("found", ampm.image), token.next);
              pex.currentToken = token;
          {if (true) throw pex;}
        }
        {if (true) return ampm.kind == AM ? AMPM.AM : AMPM.PM;}
      }
      {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * returns the total number of minutes for a time of the form hh:00 or just hh with hh up to 48 
 */
  final public int extendedtime() throws ParseException {
  Token h = null;
  Token m = null;
  int result = 0;
  AMPM ampm = null;
    if (getToken(1).kind == NUMBER && Util.between(getToken(1).image, 0, 48)) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    h = jj_consume_token(NUMBER);
    if (jj_2_9(2147483647) && (h!=null)) {
      m = minutes();
    } else {
      ;
    }
    if (jj_2_10(5)) {
      ampm = ampm();
    } else {
      ;
    }
    if (strict && m == null) {
        ParseException pex = new OpeningHoursParseException(tr("hours_without_minutes"));
        pex.currentToken = token;
        {if (true) throw pex;}
    }
    if (m != null) {
      result = Integer.parseInt(m.image);
    }
    result = result + Integer.parseInt(h.image) * 60;
    if (ampm == AMPM.PM && result < TWELVEHOURS) {
      result = result + TWELVEHOURS;
    } else if (ampm == AMPM.AM && result >= TWELVEHOURS && result < TWELVEHOURS + 60) {
          result = result - TWELVEHOURS;
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public VariableTime variabletime() throws ParseException {
  Token event = null;
  Token sign = null;
  int offset = 0;
  VariableTime vt = new VariableTime();
    if (jj_2_13(5)) {
      event = jj_consume_token(EVENTS);
    vt.setEvent(event.image);
    {if (true) return vt;}
    } else if (jj_2_14(5)) {
      jj_consume_token(32);
      event = jj_consume_token(EVENTS);
      if (jj_2_11(5)) {
        sign = jj_consume_token(PLUS);
      } else if (jj_2_12(5)) {
        sign = jj_consume_token(HYPHEN);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      offset = time();
      jj_consume_token(33);
      vt.setEvent(event.image);
      vt.offset = (sign.image.equals("-") ? - 1 : 1) * offset;
    {if (true) return vt;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int interval() throws ParseException {
  Token number = null;
  Token hours = null;
  int interval = 0;
    jj_consume_token(SLASH);
    if (jj_2_15(2147483647)) {
      hours = hours();
      number = minutes();
        interval = Integer.parseInt(hours.image) * 60 + Integer.parseInt(number.image);
    } else if (jj_2_16(5)) {
      number = number();
        interval = Integer.parseInt(number.image);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return interval;}
    throw new Error("Missing return statement in function");
  }

  final public TimeSpan timespan() throws ParseException {
  int start = 0;
  int end =-1;
  Token startplus = null;
  Token endplus = null;
  Token to = null;
  VariableTime startVT = null;
  VariableTime endVT = null;
  TimeSpan ts = new TimeSpan();
  int inter = 0;
    if (jj_2_17(5)) {
      start = time();
        ts.start = start;
    } else if (jj_2_18(5)) {
      startVT = variabletime();
        ts.startEvent = startVT;
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_28(5)) {
      if (jj_2_26(5)) {
        startplus = jj_consume_token(PLUS);
      } else if (jj_2_27(5)) {
        if (jj_2_19(5)) {
          jj_consume_token(HYPHEN);
        } else if (jj_2_20(5)) {
          to = jj_consume_token(TO);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        if (jj_2_21(5)) {
          end = extendedtime();
            if (end < start) {
              if (!strict || !strictTime)
              {
                // non-strict, add 24h
                end = end + 24*60;
              } else {
                ParseException pex = new OpeningHoursParseException(tr("earlier_than_time"), token.next);
                            pex.currentToken = token;
                {if (true) throw pex;}
              }
            }
            ts.end = end;
        } else if (jj_2_22(5)) {
          endVT = variabletime();
            ts.endEvent = endVT;
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
          if (strict && to != null) {
            {if (true) throw new OpeningHoursParseException(tr("to_instead_of_dash"), token.next);}
          }
        if (jj_2_25(5)) {
          if (jj_2_23(5)) {
            endplus = jj_consume_token(PLUS);
          } else if (jj_2_24(5)) {
            inter = interval();
              ts.interval = inter;
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
      ts.openEnded = startplus != null || endplus != null;
      {if (true) return ts;}
    throw new Error("Missing return statement in function");
  }

  final public List < TimeSpan > time_selector() throws ParseException {
  TimeSpan ts, ts1;
  List < TimeSpan > result = new ArrayList < TimeSpan > ();
    ts = timespan();
    label_2:
    while (true) {
      if (jj_2_29(5)) {
        ;
      } else {
        break label_2;
      }
      jj_consume_token(COMMA);
      ts1 = timespan();
        result.add(0, ts1);
    }
    result.add(ts);
    Collections.reverse(result);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String weekday() throws ParseException {
  Token w = null;
    if (jj_2_32(5)) {
      w = jj_consume_token(WEEKDAY);
    {if (true) return w.image;}
    } else if (jj_2_33(5)) {
      if (jj_2_30(5)) {
        w = jj_consume_token(WEEKDAY3);
      } else if (jj_2_31(5)) {
        w = jj_consume_token(WEEKDAYDE);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (strict) {
        String msg = w.kind == OpeningHoursParserConstants.WEEKDAY3 ? tr("invalid_week_day_three") : tr("invalid_week_day_german");
        ParseException e = new OpeningHoursParseException(msg, token.next);
                e.currentToken = token;
        {if (true) throw e;}
      }
      {if (true) return w.image;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Mo-
// Mo-Fr
// Mo[1]
// Mo[1,3,5]
  final public WeekDayRange weekday_range() throws ParseException {
  String startDay = null;
  String endDay = null;
  Nth nth = null;
  Nth nth1 = null;
  Token m = null;
  Token n = null;
  Token to = null;
  WeekDayRange wdr = new WeekDayRange();
    startDay = weekday();
    if (jj_2_42(5)) {
      if (jj_2_40(5)) {
        if (jj_2_34(5)) {
          jj_consume_token(HYPHEN);
        } else if (jj_2_35(5)) {
          to = jj_consume_token(TO);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        endDay = weekday();
          if (strict && to != null) {
            {if (true) throw new OpeningHoursParseException(tr("to_instead_of_dash"), token.next);}
          }
          wdr.setEndDay(endDay);
      } else if (jj_2_41(5)) {
        jj_consume_token(BRACKET_LEFT);
        nth = nth();
        label_3:
        while (true) {
          if (jj_2_36(5)) {
            ;
          } else {
            break label_3;
          }
          jj_consume_token(COMMA);
          nth1 = nth();
            wdr.add(nth1);
        }
          wdr.add(nth);
          Collections.reverse(wdr.getNths());
        jj_consume_token(BRACKET_RIGHT);
        if (jj_2_39(5)) {
          if (jj_2_37(5)) {
            m = jj_consume_token(HYPHEN);
          } else if (jj_2_38(5)) {
            jj_consume_token(PLUS);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          n = number();
          jj_consume_token(DAYS);
          wdr.offset = Integer.parseInt(n.image);
          if (m != null)
          {
            wdr.offset = wdr.offset * - 1;
          }
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    wdr.setStartDay(startDay);
    {if (true) return wdr;}
    throw new Error("Missing return statement in function");
  }

  final public Nth nth() throws ParseException {
  Nth n = new Nth();
  Token t1 = null;
  Token t2 = null;
  Token sign = null;
  Token sign2 = null;
    if (jj_2_44(5)) {
      if (jj_2_43(5)) {
        sign = jj_consume_token(HYPHEN);
      } else {
        ;
      }
      t1 = one2five();
      n.startNth = Integer.parseInt(t1.image);
      if (sign != null) {
        n.startNth = n.startNth * -1;
      }
    } else {
      ;
    }
    if (jj_2_46(5)) {
      jj_consume_token(HYPHEN);
      if (jj_2_45(5)) {
        sign2 = jj_consume_token(HYPHEN);
      } else {
        ;
      }
      t2 = one2five();
      n.endNth = Integer.parseInt(t2.image);
      if (sign2 != null) {
        n.endNth = n.endNth * -1;
      }
    } else {
      ;
    }
    {if (true) return n;}
    throw new Error("Missing return statement in function");
  }

  final public List < WeekDayRange > weekday_selector() throws ParseException {
  WeekDayRange wdr, wdr1;
  List < WeekDayRange > result = new ArrayList < WeekDayRange > ();
    wdr = weekday_range();
    label_4:
    while (true) {
      if (jj_2_47(5)) {
        ;
      } else {
        break label_4;
      }
      jj_consume_token(COMMA);
      wdr1 = weekday_range();
      result.add(0, wdr1);
    }
    result.add(wdr);
    Collections.reverse(result);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public Holiday holiday() throws ParseException {
  Token h = null;
  Token n = null;
  Token m = null;
  Holiday result = new Holiday();
    h = jj_consume_token(HOLIDAYS);
    if (jj_2_50(5)) {
      if (jj_2_48(5)) {
        m = jj_consume_token(HYPHEN);
      } else if (jj_2_49(5)) {
        jj_consume_token(PLUS);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      n = number();
      jj_consume_token(DAYS);
      result.offset = Integer.parseInt(n.image);
      if (m != null)
      {
        result.offset = result.offset * - 1;
      }
    } else {
      ;
    }
    result.type = Holiday.Type.valueOf(h.image.toUpperCase(Locale.US)); // the enum values are in upper case
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public List < Holiday > holiday_sequence() throws ParseException {
  Holiday h = null;
  Holiday h1 = null;
  List < Holiday > result = new ArrayList < Holiday > ();
    h = holiday();
    label_5:
    while (true) {
      if (jj_2_51(5)) {
        ;
      } else {
        break label_5;
      }
      jj_consume_token(COMMA);
      h1 = holiday();
      result.add(0, h1);
    }
    result.add(h);
    Collections.reverse(result);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String month() throws ParseException {
  Token m = null;
    m = jj_consume_token(MONTH);
    {if (true) return m.image;}
    throw new Error("Missing return statement in function");
  }

  final public DateRange date_range() throws ParseException {
  DateRange mdr = new DateRange();
  DateWithOffset startDate = null;
  DateWithOffset endDate = null;
  Token plus = null;
  Token to = null;
    startDate = datewithoffset(false);
    if (strict && startDate.getVarDate()==null && startDate.getMonth()==null) {
      {if (true) throw new OpeningHoursParseException(tr("missing_month"), token.next);}
    }
    mdr.startDate = startDate;
    startDate.openEnded = plus != null;
    if (jj_2_57(5)) {
      if (jj_2_55(5)) {
        if (jj_2_52(5)) {
          jj_consume_token(HYPHEN);
        } else if (jj_2_53(5)) {
          to = jj_consume_token(TO);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        endDate = datewithoffset(startDate.undefinedDay());
        if (strict && to != null) {
          {if (true) throw new OpeningHoursParseException(tr("to_instead_of_dash"), token != null ? token.next : null);}
        }
        if ((startDate.undefinedDay() && !endDate.undefinedDay()) || (!startDate.undefinedDay() && endDate.undefinedDay())) {
          if (strict) {
            {if (true) throw new OpeningHoursParseException(tr("missing_day_in_range", startDate.toString(), endDate.toString()), token != null ? token.next : null);}
          } else {
            // fix this
            if (startDate.undefinedDay()) {
              startDate.setDay(1);
            } else {
              endDate.setDay(Month.lastDay(endDate.getYear(), endDate.getMonth()));
            }
          }
        }
        mdr.endDate = endDate;
        if (jj_2_54(5)) {
          mdr.interval = interval();
          if (startDate.day != DateWithOffset.UNDEFINED_MONTH_DAY || endDate.day != DateWithOffset.UNDEFINED_MONTH_DAY || startDate.varDate!=null || endDate.varDate!=null) {
                {if (true) throw new OpeningHoursParseException(tr("interval_not_allowed_here"), token != null ? token.next : null);}
          }
        } else {
          ;
        }
      } else if (jj_2_56(5)) {
        jj_consume_token(PLUS);
      startDate.openEnded = true;
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    {if (true) return mdr;}
    throw new Error("Missing return statement in function");
  }

  final public int daynum() throws ParseException {
  Token n = null;
    if (getToken(1).kind == NUMBER && Util.between(getToken(1).image, 1, 31) && !(getToken(2).kind == COLON && getToken(3).kind == NUMBER && getToken(4).kind != COLON)) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    n = jj_consume_token(NUMBER);
    {if (true) return Integer.parseInt(n.image);}
    throw new Error("Missing return statement in function");
  }

  final public int year() throws ParseException {
  Token n = null;
    if (getToken(1).kind == NUMBER && Util.equalsOrMore(getToken(1).image, 1900)) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    n = jj_consume_token(NUMBER);
    {if (true) return Integer.parseInt(n.image);}
    throw new Error("Missing return statement in function");
  }

  final public DateWithOffset datewithoffset(boolean mo) throws ParseException {
  DateWithOffset dwo = new DateWithOffset();
  int y = 0;
  Token m = null;
  Token d = null;
  Token h = null;
  Token n = null;
  Token v = null;
  Token minus = null;
  Token num = null;
  Token wd = null;
  Token nth = null;
  String nthWd = null;
  Token sign = null;
  monthOnly = mo;
    if (jj_2_58(5)) {
      y = year();
      dwo.year = y;
    } else {
      ;
    }
    if (jj_2_71(5)) {
      if (jj_2_63(5)) {
        if (jj_2_61(2147483647) && (!monthOnly && (getToken(1).kind == NUMBER && (getToken(2).kind != COLON ||  getToken(2).kind != STOP || getToken(2).kind != H))
                          || ( getToken(1).kind == MONTH && getToken(2).kind == NUMBER && (getToken(3).kind != COLON ||  getToken(3).kind != STOP || getToken(3).kind != H)))) {
          if (jj_2_59(5)) {
            m = jj_consume_token(MONTH);
                dwo.setMonth(m.image);
          } else {
            ;
          }
          dwo.day = daynum();
        } else if (jj_2_62(11) && (!monthOnly && ((getToken( getToken(4).kind == HYPHEN ? 9 : 8).kind == DAYS && getToken( getToken(4).kind == HYPHEN ? 10 : 9).kind != COMMA)
                                  || (getToken( getToken(4).kind == HYPHEN ? 9 : 8).kind != DAYS && getToken( getToken(4).kind == HYPHEN ? 7 : 6).kind != COMMA)
                                  || (getToken( getToken(4).kind == HYPHEN ? 9 : 8).kind == DAYS && getToken( getToken(4).kind == HYPHEN ? 10 : 9).kind == COMMA && getToken( getToken(4).kind == HYPHEN ? 11 : 10).kind != WEEKDAY)
                                  || (getToken( getToken(4).kind == HYPHEN ? 9 : 8).kind != DAYS && getToken( getToken(4).kind == HYPHEN ? 7 : 6).kind == COMMA && getToken( getToken(4).kind == HYPHEN ? 8 : 7).kind != WEEKDAY)))) {
          m = jj_consume_token(MONTH);
              dwo.setMonth(m.image);
          nthWd = weekday();
          jj_consume_token(BRACKET_LEFT);
          if (jj_2_60(5)) {
            sign = jj_consume_token(HYPHEN);
          } else {
            ;
          }
          nth = one2five();
          jj_consume_token(BRACKET_RIGHT);
            dwo.nthWeekDay = WeekDay.getValue(nthWd);
            dwo.nth = Integer.parseInt(nth.image);
            if (sign != null) {
              dwo.nth = dwo.nth * -1;
            }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else if (jj_2_64(5)) {
        v = jj_consume_token(VARDATE);
            dwo.setVarDate(v.image);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_67(5)) {
        if (jj_2_65(5)) {
          minus = jj_consume_token(HYPHEN);
        } else if (jj_2_66(5)) {
          jj_consume_token(PLUS);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        wd = jj_consume_token(WEEKDAY);
          dwo.weekDayOffsetPositive = minus == null;
          dwo.setWeekDayOffset(wd.image);
      } else {
        ;
      }
      if (jj_2_70(5)) {
        if (jj_2_68(5)) {
          minus = jj_consume_token(HYPHEN);
        } else if (jj_2_69(5)) {
          jj_consume_token(PLUS);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        num = number();
        jj_consume_token(DAYS);
          dwo.dayOffset = Integer.parseInt(num.image) * (minus != null ? - 1 : 1);
      } else {
        ;
      }
    } else if (jj_2_72(5)) {
      m = jj_consume_token(MONTH);
        dwo.setMonth(m.image);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return dwo;}
    throw new Error("Missing return statement in function");
  }

  final public List < DateRange > date_selector() throws ParseException {
  DateRange mdr, mdr1;
  Month lastMonth = null;
  List < DateRange > result = new ArrayList < DateRange > ();
    if ((getToken(1).kind == NUMBER && (getToken(2).kind == MONTH || getToken(2).kind == VARDATE))
            || getToken(1).kind == MONTH || getToken(1).kind == VARDATE) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    mdr = date_range();
    label_6:
    while (true) {
      if (jj_2_73(5)) {
        ;
      } else {
        break label_6;
      }
      jj_consume_token(COMMA);
      mdr1 = date_range();
        DateWithOffset dwo = mdr1.getStartDate();
        // if the month is missing in the start date patch it up here
        // in strict mode we will never get to this point
        if (dwo.getVarDate() == null)
        {
          if (dwo.getMonth() == null)
          {
            if (strict) {
              {if (true) throw new OpeningHoursParseException(tr("missing_month_start"), token.next);}
            }
            if (lastMonth == null)
            {
              DateWithOffset first = mdr.getStartDate();
              lastMonth = first.getMonth();
              if (lastMonth == null)
              {
                // fail, can't fudge the month
                {if (true) throw new OpeningHoursParseException(tr("missing_month_start"), token.next);}
              }
            }
            dwo.setMonth(lastMonth);
          }
          else if (dwo.getMonth() != null)
          {
            lastMonth = dwo.getMonth();
          }
        }
        result.add(0, mdr1);
    }
      result.add(mdr);
      Collections.reverse(result);
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public int weeknum() throws ParseException {
  Token n = null;
    if (getToken(1).kind == NUMBER && Util.between(getToken(1).image, 1, 54)) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    n = jj_consume_token(NUMBER);
    {if (true) return Integer.parseInt(n.image);}
    throw new Error("Missing return statement in function");
  }

  final public WeekRange week_range() throws ParseException {
  WeekRange wr = new WeekRange();
  Token w = null;
  Token w1 = null;
  Token to = null;
    wr.startWeek = weeknum();
    if (jj_2_77(5)) {
      if (jj_2_74(5)) {
        jj_consume_token(HYPHEN);
      } else if (jj_2_75(5)) {
        to = jj_consume_token(TO);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      wr.endWeek = weeknum();
      if (strict && to != null) {
        {if (true) throw new OpeningHoursParseException(tr("to_instead_of_dash"), token.next);}
      }
      if (jj_2_76(5)) {
        wr.interval = interval();
      } else {
        ;
      }
    } else {
      ;
    }
    {if (true) return wr;}
    throw new Error("Missing return statement in function");
  }

  final public List < WeekRange > week_selector() throws ParseException {
  WeekRange wr, wr1;
  List < WeekRange > result = new ArrayList < WeekRange > ();
    jj_consume_token(WEEK);
    wr = week_range();
    label_7:
    while (true) {
      if (jj_2_78(5)) {
        ;
      } else {
        break label_7;
      }
      jj_consume_token(COMMA);
      wr1 = week_range();
      result.add(0, wr1);
    }
    result.add(wr);
    Collections.reverse(result);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public YearRange year_range() throws ParseException {
  YearRange yr = new YearRange();
  Token y = null;
  Token y1 = null;
  Token to = null;
    yr.startYear = year();
    if (jj_2_84(5)) {
      if (jj_2_82(5)) {
        if (jj_2_79(5)) {
          jj_consume_token(HYPHEN);
        } else if (jj_2_80(5)) {
          to = jj_consume_token(TO);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        yr.endYear = year();
        if (strict && to != null) {
          {if (true) throw new OpeningHoursParseException(tr("to_instead_of_dash"), token.next);}
        }
        if (jj_2_81(5)) {
          yr.interval = interval();
        } else {
          ;
        }
      } else if (jj_2_83(5)) {
        jj_consume_token(PLUS);
      yr.openEnded = true;
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    {if (true) return yr;}
    throw new Error("Missing return statement in function");
  }

  final public List < YearRange > year_selector() throws ParseException {
  YearRange yr, yr1;
  List < YearRange > result = new ArrayList < YearRange > ();
    if (getToken(2).kind != MONTH  && getToken(2).kind != VARDATE) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    yr = year_range();
    label_8:
    while (true) {
      if (jj_2_85(5)) {
        ;
      } else {
        break label_8;
      }
      jj_consume_token(COMMA);
      yr1 = year_range();
      result.add(0, yr1);
    }
    result.add(yr);
    Collections.reverse(result);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public RuleModifier rule_modifier() throws ParseException {
  RuleModifier rm = new RuleModifier();
  Token m = null;
  String c = null;
    if (jj_2_86(5)) {
      m = jj_consume_token(MODIFIER);
      rm.setModifier(m.image);
    } else {
      ;
    }
    if (jj_2_87(5)) {
      c = comment();
      rm.comment = c;
    } else {
      ;
    }
    if (rm.modifier == null && rm.comment == null) {
      {if (true) return null;}
    }
    {if (true) return rm;}
    throw new Error("Missing return statement in function");
  }

  final public Rule rule() throws ParseException {
  Rule r = null;
  String comment = null;
  boolean always = false;
  List < YearRange > ys = null;
  List < WeekRange > ws = null;
  List < DateRange > ms = null;
  List < Holiday > hs = null;
  List < WeekDayRange > ds = null;
  List < WeekDayRange > ds2 = null;
  List < TimeSpan > ts = null;
  RuleModifier rm = null;
  boolean colonForClarification = false;
    if (jj_2_92(2147483647)) {
      comment = comment();
      jj_consume_token(COLON);
    } else {
      if (jj_2_88(5)) {
        ys = year_selector();
      } else {
        ;
      }
      if (jj_2_89(5)) {
        ws = week_selector();
      } else {
        ;
      }
      if (jj_2_90(5)) {
        ms = date_selector();
      } else {
        ;
      }
      if (jj_2_91(5)) {
        jj_consume_token(COLON);
              colonForClarification = true;
      } else {
        ;
      }
    }
    if (jj_2_101(5)) {
      jj_consume_token(ALWAYS);
        if (strict && (ys != null || ws != null || ms != null))
        {
          ParseException e = new OpeningHoursParseException(tr("24_7_with_other_selectors"));
          e.currentToken = token;
          {if (true) throw e;}
        }
        else
        {
          if (ys != null || ws != null || ms != null) {
            // correct to proper syntax
            ts = new ArrayList < TimeSpan > ();
            TimeSpan t = new TimeSpan();
            t.start = 0;
            t.end = 1440;
            ts.add(t);
          }
          else
          {
                always = true;
         }
        }
    } else {
      if (jj_2_98(2147483647)) {
        ds = weekday_selector();
        jj_consume_token(COMMA);
        hs = holiday_sequence();
        if (jj_2_93(5)) {
          jj_consume_token(COMMA);
          ds2 = weekday_selector();
        } else {
          ;
        }
          if (ds2 != null) {
            if (strict)
            {
              ParseException e = new OpeningHoursParseException(tr("holiday_in_weekday_range"), token.next);
              e.currentToken = token;
              {if (true) throw e;}
            }
            ds.addAll(ds2);
          }
          for (Holiday h:hs) {
            h.setAfterWeekDays(true);
          }
      } else {
        if (jj_2_94(5)) {
          hs = holiday_sequence();
        } else {
          ;
        }
        if (jj_2_97(5)) {
          if (jj_2_95(5)) {
            jj_consume_token(COMMA);
            ds = weekday_selector();
          } else if (jj_2_96(5)) {
            ds = weekday_selector();
              if (hs != null) {
                for (Holiday h:hs) {
                  h.setUseAsWeekDay(false);
                }
              }
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          ;
        }
      }
      if (jj_2_99(5)) {
        jj_consume_token(COLON);
      } else {
        ;
      }
      if (jj_2_100(5)) {
        ts = time_selector();
      } else {
        ;
      }
    }
    rm = rule_modifier();
    r = new Rule();
    r.comment = comment;
    r.twentyfourseven = always;
    r.years = ys;
    r.weeks = ws;
    r.dates = ms;
    r.holidays = hs;
    r.days = ds;
    r.times = ts;
    r.modifier = rm;
    r.colonForClarification = colonForClarification;
    {if (true) return r;}
    throw new Error("Missing return statement in function");
  }

  final private List < Rule > rules0(boolean strict, boolean strictTime) throws ParseException {
  this.strict = strict;
  this.strictTime = strictTime;
  List < Rule > result = new ArrayList < Rule > ();
  Rule r = null;
  Rule r1 = null;
    try {
      r = rule();
    } catch (ParseException e) {
    error_skip(e);
    {if (true) return rules0(strict, strictTime);}
    }
    try {
      label_9:
      while (true) {
        if (jj_2_102(5)) {
          ;
        } else {
          break label_9;
        }
        if (jj_2_103(5)) {
          jj_consume_token(COMMA);
          r1 = rule();
            r1.additive = true;
            r1.fallBack = false;
            result.add(0, r1);
        } else if (jj_2_104(5)) {
          jj_consume_token(SEMICOLON);
          r1 = rule();
            r1.additive = false;
            r1.fallBack = false;
            result.add(0, r1);
        } else if (jj_2_105(5)) {
          jj_consume_token(FALLBACKSEPERATOR);
          r1 = rule();
            r1.additive = false;
            r1.fallBack = true;
            result.add(0, r1);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(0);
    } catch (ParseException e) {
    error_skip(e);
    {if (true) return rules0(strict, strictTime);}
    }
    r.additive = false;
    r.fallBack = false;
    result.add(r);
    Collections.reverse(result);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_86(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_87(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_88(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_89(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_90(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_91(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_92(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_93(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_94(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_95(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_96(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_97(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_98(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_99(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_100(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_101(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_102(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_103(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_104(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_105(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  private boolean jj_3_38() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_11() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) return true;
    }
    }
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == NUMBER && Util.between(getToken(1).image, 0, 59) && (getToken(1).image.length() >= 2 || "0".equals(getToken(1).image));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_43()) return true;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3_37() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3_39() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) return true;
    }
    if (jj_3R_15()) return true;
    if (jj_scan_token(DAYS)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    return false;
  }

  private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) return true;
    }
    if (jj_3R_15()) return true;
    if (jj_scan_token(DAYS)) return true;
    return false;
  }

  private boolean jj_3_36() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_14() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == NUMBER && Util.between(getToken(1).image, 0, 24);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_45()) return true;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3_35() {
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    return false;
  }

  private boolean jj_3_73() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3_105() {
    if (jj_scan_token(FALLBACKSEPERATOR)) return true;
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_scan_token(BRACKET_LEFT)) return true;
    if (jj_3R_20()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_36()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(BRACKET_RIGHT)) return true;
    xsp = jj_scanpos;
    if (jj_3_39()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_38() {
    jj_lookingAhead = true;
    jj_semLA = (getToken(1).kind == NUMBER && (getToken(2).kind == MONTH || getToken(2).kind == VARDATE))
        || getToken(1).kind == MONTH || getToken(1).kind == VARDATE;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_55()) return true;
    if (jj_3R_31()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_73()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_34() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3_104() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_10() {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  private boolean jj_3_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3_41()) return true;
    }
    return false;
  }

  private boolean jj_3_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3_35()) return true;
    }
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3_103() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_21()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_42()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_102() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_103()) {
    jj_scanpos = xsp;
    if (jj_3_104()) {
    jj_scanpos = xsp;
    if (jj_3_105()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_72() {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3_31() {
    if (jj_scan_token(WEEKDAYDE)) return true;
    return false;
  }

  private boolean jj_3_69() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3_68() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(QUOTE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_1()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDQUOTE)) return true;
    return false;
  }

  private boolean jj_3R_46() {
    return false;
  }

  private boolean jj_3_70() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3_69()) return true;
    }
    if (jj_3R_15()) return true;
    if (jj_scan_token(DAYS)) return true;
    return false;
  }

  private boolean jj_3_66() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3_65() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3R_15() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == NUMBER && Util.equalsOrMore(getToken(1).image, 1);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_46()) return true;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3_67() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) {
    jj_scanpos = xsp;
    if (jj_3_66()) return true;
    }
    if (jj_scan_token(WEEKDAY)) return true;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_scan_token(WEEKDAY3)) return true;
    return false;
  }

  private boolean jj_3R_50() {
    return false;
  }

  private boolean jj_3_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3_31()) return true;
    }
    return false;
  }

  private boolean jj_3_64() {
    if (jj_scan_token(VARDATE)) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_scan_token(WEEKDAY)) return true;
    return false;
  }

  private boolean jj_3R_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3_33()) return true;
    }
    return false;
  }

  private boolean jj_3R_22() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == NUMBER && Util.between(getToken(1).image, 1, 5);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_50()) return true;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3_60() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3_62() {
    if (jj_scan_token(MONTH)) return true;
    if (jj_3R_21()) return true;
    if (jj_scan_token(BRACKET_LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(6)) jj_scanpos = xsp;
    if (jj_3R_22()) return true;
    if (jj_scan_token(BRACKET_RIGHT)) return true;
    xsp = jj_scanpos;
    if (jj_3R_28()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_100() {
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3_99() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_96() {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_scan_token(MONTH)) return true;
    if (jj_3R_21()) return true;
    if (jj_scan_token(BRACKET_LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) jj_scanpos = xsp;
    if (jj_3R_22()) return true;
    if (jj_scan_token(BRACKET_RIGHT)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_3R_19()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_29()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_95() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3_97() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_95()) {
    jj_scanpos = xsp;
    if (jj_3_96()) return true;
    }
    return false;
  }

  private boolean jj_3_94() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(24)) jj_scanpos = xsp;
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3_59() {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_94()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_97()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_24() {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3_24()) return true;
    }
    return false;
  }

  private boolean jj_3R_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_59()) jj_scanpos = xsp;
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3_63() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = !monthOnly && (getToken(1).kind == NUMBER && (getToken(2).kind != COLON ||  getToken(2).kind != STOP || getToken(2).kind != H))
                  || ( getToken(1).kind == MONTH && getToken(2).kind == NUMBER && (getToken(3).kind != COLON ||  getToken(3).kind != STOP || getToken(3).kind != H));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_29()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !monthOnly && ((getToken( getToken(4).kind == HYPHEN ? 9 : 8).kind == DAYS && getToken( getToken(4).kind == HYPHEN ? 10 : 9).kind != COMMA)
                          || (getToken( getToken(4).kind == HYPHEN ? 9 : 8).kind != DAYS && getToken( getToken(4).kind == HYPHEN ? 7 : 6).kind != COMMA)
                          || (getToken( getToken(4).kind == HYPHEN ? 9 : 8).kind == DAYS && getToken( getToken(4).kind == HYPHEN ? 10 : 9).kind == COMMA && getToken( getToken(4).kind == HYPHEN ? 11 : 10).kind != WEEKDAY)
                          || (getToken( getToken(4).kind == HYPHEN ? 9 : 8).kind != DAYS && getToken( getToken(4).kind == HYPHEN ? 7 : 6).kind == COMMA && getToken( getToken(4).kind == HYPHEN ? 8 : 7).kind != WEEKDAY));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_30()) return true;
    }
    return false;
  }

  private boolean jj_3_71() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3_64()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_67()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_70()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_93() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3_98() {
    if (jj_3R_39()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3_58() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_58()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_71()) {
    jj_scanpos = xsp;
    if (jj_3_72()) return true;
    }
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_3R_39()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_40()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_93()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_99()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_100()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_21() {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3R_51() {
    return false;
  }

  private boolean jj_3_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3_20()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_25()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_26() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) return true;
    }
    return false;
  }

  private boolean jj_3_18() {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_26() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == NUMBER && Util.equalsOrMore(getToken(1).image, 1900);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_51()) return true;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    return false;
  }

  private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_28()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_101() {
    if (jj_scan_token(ALWAYS)) return true;
    return false;
  }

  private boolean jj_3_91() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3_90() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_27() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == NUMBER && Util.between(getToken(1).image, 1, 31) && !(getToken(2).kind == COLON && getToken(3).kind == NUMBER && getToken(4).kind != COLON);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_52()) return true;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3_89() {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3_88() {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3_92() {
    if (jj_3R_35()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_88()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_89()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_90()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_91()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_56() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_14()) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_3R_35()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3_54() {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_101()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    }
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_3R_14()) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_scan_token(SLASH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3_16()) return true;
    }
    return false;
  }

  private boolean jj_3_53() {
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3_52() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3_56()) return true;
    }
    return false;
  }

  private boolean jj_3_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3_53()) return true;
    }
    if (jj_3R_25()) return true;
    xsp = jj_scanpos;
    if (jj_3_54()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_87() {
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_scan_token(32)) return true;
    if (jj_scan_token(EVENTS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) return true;
    }
    if (jj_3R_13()) return true;
    if (jj_scan_token(33)) return true;
    return false;
  }

  private boolean jj_3_86() {
    if (jj_scan_token(MODIFIER)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_87()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_3R_25()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_57()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_scan_token(EVENTS)) return true;
    return false;
  }

  private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) return true;
    }
    return false;
  }

  private boolean jj_3R_54() {
    return false;
  }

  private boolean jj_3_85() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_36() {
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind != MONTH  && getToken(2).kind != VARDATE;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_54()) return true;
    if (jj_3R_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_85()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_47() {
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_12()) return true;
    return false;
  }

  private boolean jj_3_51() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_3R_24()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_51()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_80() {
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3_81() {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3_83() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_17() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == NUMBER && Util.between(getToken(1).image, 0, 48);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_47()) return true;
    if (jj_scan_token(NUMBER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_48()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_79() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3_49() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3_82() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_79()) {
    jj_scanpos = xsp;
    if (jj_3_80()) return true;
    }
    if (jj_3R_26()) return true;
    xsp = jj_scanpos;
    if (jj_3_81()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3_83()) return true;
    }
    return false;
  }

  private boolean jj_3_48() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_26()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_84()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) return true;
    }
    if (jj_3R_15()) return true;
    if (jj_scan_token(DAYS)) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_scan_token(HOLIDAYS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_50()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_scan_token(PM)) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(AM)) return true;
    return false;
  }

  private boolean jj_3R_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3_8()) return true;
    }
    return false;
  }

  private boolean jj_3_78() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_scan_token(WEEK)) return true;
    if (jj_3R_33()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_78()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_47() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(H)) return true;
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_3R_23()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_47()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_75() {
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3_76() {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_12()) return true;
    return false;
  }

  private boolean jj_3_45() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3_74() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_3_75()) return true;
    }
    if (jj_3R_32()) return true;
    xsp = jj_scanpos;
    if (jj_3_76()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_13() {
    if (jj_3R_14()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_46() {
    if (jj_scan_token(HYPHEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_45()) jj_scanpos = xsp;
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_3R_32()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_77()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_scan_token(STOP)) return true;
    return false;
  }

  private boolean jj_3R_53() {
    return false;
  }

  private boolean jj_3_43() {
    if (jj_scan_token(HYPHEN)) return true;
    return false;
  }

  private boolean jj_3_44() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_43()) jj_scanpos = xsp;
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_44()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_32() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == NUMBER && Util.between(getToken(1).image, 1, 54);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_53()) return true;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_43() {
    return false;
  }

  /** Generated Token Manager. */
  public OpeningHoursParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[105];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public OpeningHoursParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public OpeningHoursParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new OpeningHoursParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public OpeningHoursParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new OpeningHoursParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public OpeningHoursParser(OpeningHoursParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(OpeningHoursParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[35];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 35; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 105; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
