/*
  Copyright © 2010 Harald Sitter <apachelogger@ubuntu.com>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2 of
  the License or (at your option) version 3 or any later version
  accepted by the membership of KDE e.V. (or its successor approved
  by the membership of KDE e.V.), which shall act as a proxy
  defined in Section 14 of version 3 of the license.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ENGINEPROBE_H
#define ENGINEPROBE_H

#include <QtGui/QWidget>

class EngineProbe : public QWidget
{
    Q_OBJECT
public:
    /**
     * Constructor
     *
     * @param paren Parent of the Probe.
     */
    EngineProbe(QWidget *parent = 0);

protected:
    /**
     * Overload function for QWidget::paintEvent(). This does not do any special
     * painting but is the actual heart of the probe. It creates a QPainter and
     * then tries to get the underlying QPaintEngine's type.
     *
     * If a type was obtainable this function emits the engineType() signal.
     *
     * Please also note that the widget will be actually painted (e.g. shown)
     * until you delete it or call hide().
     *
     * @param event QPaintEvent as posted by show() or hide() for example.
     */
    virtual void paintEvent(QPaintEvent *event);

signals:
    /**
     * This signal is emitted when the default engine type is found.
     *
     * @param type QPaintEngine::Type enumeration value.
     */
    void engineType(int type);

private:
    /**
     * Whether this EngineProbe already probed the type (i.e. whether engineType()
     * was emitted).
     *
     * This is used to prevent duplicated signal emission.
     */
    bool probed;
};

#endif // ENGINEPROBE_H
