/*
 *  xtiffio.h -- Public interface to Extended TIFF tags
 *
 *    This is a template for defining a client module
 *    which supports tag extensions to the standard libtiff
 *    set. Only portions of the code marked "XXX" need to
 *    be changed to support your tag set.
 *
 *    written by: Niles D. Ritter
 */

#ifndef __xtiffio_h
#define __xtiffio_h

#include "tiffio.h"

/* 
 *  KDC specific tags
 */

#define TIFFTAG_KDC_33423 33423 /*(0x828f) ASCII (2) 6<Full\0\0>*/
#define TIFFTAG_KDC_33424 33424 /*(0x8290) LONG (4) 1<1002>*/
#define TIFFTAG_KDC_33434 33434 /*(0x829a) RATIONAL (5) 1<0.01069>*/
#define TIFFTAG_KDC_33437 33437 /*(0x829d) RATIONAL (5) 1<2.5>*/
#define TIFFTAG_KDC_34850 34850 /*(0x8822) SHORT (3) 1<2>*/
#define TIFFTAG_KDC_34859 34859 /*(0x882b) SHORT (3) 1<0>*/
#define TIFFTAG_KDC_DATETIME 36867 /*(0x9003) ASCII (2) 20<1994:03:25 00:00:25\0>*/
#define TIFFTAG_KDC_37382 37382 /*(0x9206) RATIONAL (5) 1<0.7>*/
#define TIFFTAG_KDC_37385 37385 /*(0x9209) SHORT (3) 1<31>*/
#define TIFFTAG_KDC_37386 37386 /*(0x920a) RATIONAL (5) 1<100>*/
#define TIFFTAG_KDC_37393 37393 /*(0x9211) SHORT (3) 1<1>*/
#define TIFFTAG_KDC_37398 37398 /*(0x9216) BYTE (1) 4<00 00 00 0x1>*/
#define TIFFTAG_KDC_37399 37399 /*(0x9217) SHORT (3) 1<2>*/
#define TIFFTAG_KDC_33421 33421 /*(0x828d) SHORT (3) 2<2 2>*/
#define TIFFTAG_KDC_33422 33422 /*(0x828e) BYTE (1) 4<0x1 0x2 00 0x1>*/
#define TIFFTAG_KDC_37122 37122 /*(0x9102) RATIONAL (5) 1<0.75>*/
#define TIFFTAG_KDC_37400 37400 /*(0x9218) SRATIONAL (10) 12<0 -2.02926 1.04202 -0.824892 0 -1.4279 5.95526 -0.572662 0 -0.4228*/

/* 
 *  XXX Define Printing method flags. These
 *  flags may be passed in to TIFFPrintDirectory() to
 *  indicate that those particular field values should
 *  be printed out in full, rather than just an indicator
 *  of whether they are present or not.
 */
/*#define	TIFFPRINT_MYMULTIDOUBLES	0x80000000*/

/**********************************************************************
 *    Nothing below this line should need to be changed by the user.
 **********************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

extern TIFF* XTIFFOpen(const char* name, const char* mode);
extern TIFF* XTIFFFdOpen(int fd, const char* name, const char* mode);
extern void  XTIFFClose(TIFF *tif);

#if defined(__cplusplus)
}
#endif

#endif /* __xtiffio_h */

