
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStyledItemDelegate.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QStyledItemDelegate>
#include <QAbstractItemModel>
#include <QAbstractItemView>
#include <QChildEvent>
#include <QEvent>
#include <QFontMetrics>
#include <QHelpEvent>
#include <QItemEditorFactory>
#include <QLocale>
#include <QModelIndex>
#include <QObject>
#include <QPainter>
#include <QSize>
#include <QStyleOptionViewItem>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStyledItemDelegate

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QStyledItemDelegate::staticMetaObject);
}


// QWidget *QStyledItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_createEditor_c6860 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_f_createEditor_c6860 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QStyledItemDelegate *)cls)->createEditor (arg1, arg2, arg3));
}


// QString QStyledItemDelegate::displayText(const QVariant &value, const QLocale &locale)


static void _init_f_displayText_c3997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("locale");
  decl->add_arg<const QLocale & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_displayText_c3997 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = gsi::arg_reader<const QVariant & >() (args, heap);
  const QLocale &arg2 = gsi::arg_reader<const QLocale & >() (args, heap);
  ret.write<QString > ((QString)((QStyledItemDelegate *)cls)->displayText (arg1, arg2));
}


// QItemEditorFactory *QStyledItemDelegate::itemEditorFactory()


static void _init_f_itemEditorFactory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QItemEditorFactory * > ();
}

static void _call_f_itemEditorFactory_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QItemEditorFactory * > ((QItemEditorFactory *)((QStyledItemDelegate *)cls)->itemEditorFactory ());
}


// void QStyledItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_paint_c6971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_c6971 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate *)cls)->paint (arg1, arg2, arg3);
}


// void QStyledItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)


static void _init_f_setEditorData_c3602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEditorData_c3602 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate *)cls)->setEditorData (arg1, arg2);
}


// void QStyledItemDelegate::setItemEditorFactory(QItemEditorFactory *factory)


static void _init_f_setItemEditorFactory_2445 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factory");
  decl->add_arg<QItemEditorFactory * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemEditorFactory_2445 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QItemEditorFactory *arg1 = gsi::arg_reader<QItemEditorFactory * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate *)cls)->setItemEditorFactory (arg1);
}


// void QStyledItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)


static void _init_f_setModelData_c5913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setModelData_c5913 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QAbstractItemModel *arg2 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate *)cls)->setModelData (arg1, arg2, arg3);
}


// QSize QStyledItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_sizeHint_c5653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c5653 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStyleOptionViewItem &arg1 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QSize > ((QSize)((QStyledItemDelegate *)cls)->sizeHint (arg1, arg2));
}


// void QStyledItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_updateEditorGeometry_c6860 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_updateEditorGeometry_c6860 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate *)cls)->updateEditorGeometry (arg1, arg2, arg3);
}


// static QString QStyledItemDelegate::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QStyledItemDelegate::tr (arg1, arg2));
}


// static QString QStyledItemDelegate::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QStyledItemDelegate::tr (arg1, arg2, arg3));
}


// static QString QStyledItemDelegate::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QStyledItemDelegate::trUtf8 (arg1, arg2));
}


// static QString QStyledItemDelegate::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QStyledItemDelegate::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QStyledItemDelegate () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("createEditor", "@brief Method QWidget *QStyledItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::createEditor", true, &_init_f_createEditor_c6860, &_call_f_createEditor_c6860);
  methods += new qt_gsi::GenericMethod ("displayText", "@brief Method QString QStyledItemDelegate::displayText(const QVariant &value, const QLocale &locale)\n", true, &_init_f_displayText_c3997, &_call_f_displayText_c3997);
  methods += new qt_gsi::GenericMethod (":itemEditorFactory", "@brief Method QItemEditorFactory *QStyledItemDelegate::itemEditorFactory()\n", true, &_init_f_itemEditorFactory_c0, &_call_f_itemEditorFactory_c0);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Method void QStyledItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::paint", true, &_init_f_paint_c6971, &_call_f_paint_c6971);
  methods += new qt_gsi::GenericMethod ("setEditorData", "@brief Method void QStyledItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::setEditorData", true, &_init_f_setEditorData_c3602, &_call_f_setEditorData_c3602);
  methods += new qt_gsi::GenericMethod ("setItemEditorFactory|itemEditorFactory=", "@brief Method void QStyledItemDelegate::setItemEditorFactory(QItemEditorFactory *factory)\n", false, &_init_f_setItemEditorFactory_2445, &_call_f_setItemEditorFactory_2445);
  methods += new qt_gsi::GenericMethod ("setModelData", "@brief Method void QStyledItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::setModelData", true, &_init_f_setModelData_c5913, &_call_f_setModelData_c5913);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QStyledItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::sizeHint", true, &_init_f_sizeHint_c5653, &_call_f_sizeHint_c5653);
  methods += new qt_gsi::GenericMethod ("updateEditorGeometry", "@brief Method void QStyledItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::updateEditorGeometry", true, &_init_f_updateEditorGeometry_c6860, &_call_f_updateEditorGeometry_c6860);
  methods += gsi::qt_signal<QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > ("closeEditor(QWidget *, QAbstractItemDelegate::EndEditHint)", "closeEditor", gsi::arg("editor"), gsi::arg("hint"), "@brief Signal declaration for QStyledItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QWidget * > ("commitData(QWidget *)", "commitData", gsi::arg("editor"), "@brief Signal declaration for QStyledItemDelegate::commitData(QWidget *editor)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QStyledItemDelegate::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("sizeHintChanged(const QModelIndex &)", "sizeHintChanged", gsi::arg("arg1"), "@brief Signal declaration for QStyledItemDelegate::sizeHintChanged(const QModelIndex &)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStyledItemDelegate::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStyledItemDelegate::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStyledItemDelegate::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStyledItemDelegate::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractItemDelegate> &qtdecl_QAbstractItemDelegate ();

qt_gsi::QtNativeClass<QStyledItemDelegate> decl_QStyledItemDelegate (qtdecl_QAbstractItemDelegate (), "QtGui", "QStyledItemDelegate_Native",
  methods_QStyledItemDelegate (),
  "@hide\n@alias QStyledItemDelegate");

GSI_QTGUI_PUBLIC gsi::Class<QStyledItemDelegate> &qtdecl_QStyledItemDelegate () { return decl_QStyledItemDelegate; }

}


class QStyledItemDelegate_Adaptor : public QStyledItemDelegate, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStyledItemDelegate_Adaptor();

  //  [adaptor ctor] QStyledItemDelegate::QStyledItemDelegate(QObject *parent)
  QStyledItemDelegate_Adaptor() : QStyledItemDelegate()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStyledItemDelegate::QStyledItemDelegate(QObject *parent)
  QStyledItemDelegate_Adaptor(QObject *parent) : QStyledItemDelegate(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QStyledItemDelegate::receivers(const char *signal)
  int fp_QStyledItemDelegate_receivers_c1731 (const char *signal) const {
    return QStyledItemDelegate::receivers(signal);
  }

  //  [expose] QObject *QStyledItemDelegate::sender()
  QObject * fp_QStyledItemDelegate_sender_c0 () const {
    return QStyledItemDelegate::sender();
  }

  //  [adaptor impl] QWidget *QStyledItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)
  QWidget * cbs_createEditor_c6860_0(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    return QStyledItemDelegate::createEditor(parent, option, index);
  }

  virtual QWidget * createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_createEditor_c6860_0.can_issue()) {
      return cb_createEditor_c6860_0.issue<QStyledItemDelegate_Adaptor, QWidget *, QWidget *, const QStyleOptionViewItem &, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_createEditor_c6860_0, parent, option, index);
    } else {
      return QStyledItemDelegate::createEditor(parent, option, index);
    }
  }

  //  [adaptor impl] QString QStyledItemDelegate::displayText(const QVariant &value, const QLocale &locale)
  QString cbs_displayText_c3997_0(const QVariant &value, const QLocale &locale) const
  {
    return QStyledItemDelegate::displayText(value, locale);
  }

  virtual QString displayText(const QVariant &value, const QLocale &locale) const
  {
    if (cb_displayText_c3997_0.can_issue()) {
      return cb_displayText_c3997_0.issue<QStyledItemDelegate_Adaptor, QString, const QVariant &, const QLocale &>(&QStyledItemDelegate_Adaptor::cbs_displayText_c3997_0, value, locale);
    } else {
      return QStyledItemDelegate::displayText(value, locale);
    }
  }

  //  [adaptor impl] bool QStyledItemDelegate::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QStyledItemDelegate::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QStyledItemDelegate_Adaptor, bool, QEvent *>(&QStyledItemDelegate_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QStyledItemDelegate::event(arg1);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)
  void cbs_paint_c6971_0(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    QStyledItemDelegate::paint(painter, option, index);
  }

  virtual void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_paint_c6971_0.can_issue()) {
      cb_paint_c6971_0.issue<QStyledItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_paint_c6971_0, painter, option, index);
    } else {
      QStyledItemDelegate::paint(painter, option, index);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)
  void cbs_setEditorData_c3602_0(QWidget *editor, const QModelIndex &index) const
  {
    QStyledItemDelegate::setEditorData(editor, index);
  }

  virtual void setEditorData(QWidget *editor, const QModelIndex &index) const
  {
    if (cb_setEditorData_c3602_0.can_issue()) {
      cb_setEditorData_c3602_0.issue<QStyledItemDelegate_Adaptor, QWidget *, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_setEditorData_c3602_0, editor, index);
    } else {
      QStyledItemDelegate::setEditorData(editor, index);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)
  void cbs_setModelData_c5913_0(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
  {
    QStyledItemDelegate::setModelData(editor, model, index);
  }

  virtual void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
  {
    if (cb_setModelData_c5913_0.can_issue()) {
      cb_setModelData_c5913_0.issue<QStyledItemDelegate_Adaptor, QWidget *, QAbstractItemModel *, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_setModelData_c5913_0, editor, model, index);
    } else {
      QStyledItemDelegate::setModelData(editor, model, index);
    }
  }

  //  [adaptor impl] QSize QStyledItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)
  QSize cbs_sizeHint_c5653_0(const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    return QStyledItemDelegate::sizeHint(option, index);
  }

  virtual QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_sizeHint_c5653_0.can_issue()) {
      return cb_sizeHint_c5653_0.issue<QStyledItemDelegate_Adaptor, QSize, const QStyleOptionViewItem &, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_sizeHint_c5653_0, option, index);
    } else {
      return QStyledItemDelegate::sizeHint(option, index);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)
  void cbs_updateEditorGeometry_c6860_0(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    QStyledItemDelegate::updateEditorGeometry(editor, option, index);
  }

  virtual void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_updateEditorGeometry_c6860_0.can_issue()) {
      cb_updateEditorGeometry_c6860_0.issue<QStyledItemDelegate_Adaptor, QWidget *, const QStyleOptionViewItem &, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_updateEditorGeometry_c6860_0, editor, option, index);
    } else {
      QStyledItemDelegate::updateEditorGeometry(editor, option, index);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QStyledItemDelegate::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QStyledItemDelegate_Adaptor, QChildEvent *>(&QStyledItemDelegate_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QStyledItemDelegate::childEvent(arg1);
    }
  }

  //  [emitter impl] void QStyledItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void emitter_QStyledItemDelegate_closeEditor_4926(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    emit QStyledItemDelegate::closeEditor(editor, hint);
  }

  //  [emitter impl] void QStyledItemDelegate::commitData(QWidget *editor)
  void emitter_QStyledItemDelegate_commitData_1315(QWidget *editor)
  {
    emit QStyledItemDelegate::commitData(editor);
  }

  //  [adaptor impl] void QStyledItemDelegate::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QStyledItemDelegate::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QStyledItemDelegate_Adaptor, QEvent *>(&QStyledItemDelegate_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QStyledItemDelegate::customEvent(arg1);
    }
  }

  //  [emitter impl] void QStyledItemDelegate::destroyed(QObject *)
  void emitter_QStyledItemDelegate_destroyed_1302(QObject *arg1)
  {
    emit QStyledItemDelegate::destroyed(arg1);
  }

  //  [adaptor impl] void QStyledItemDelegate::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QStyledItemDelegate::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QStyledItemDelegate_Adaptor, const char *>(&QStyledItemDelegate_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QStyledItemDelegate::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QStyledItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  bool cbs_editorEvent_9073_0(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    return QStyledItemDelegate::editorEvent(event, model, option, index);
  }

  virtual bool editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    if (cb_editorEvent_9073_0.can_issue()) {
      return cb_editorEvent_9073_0.issue<QStyledItemDelegate_Adaptor, bool, QEvent *, QAbstractItemModel *, const QStyleOptionViewItem &, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_editorEvent_9073_0, event, model, option, index);
    } else {
      return QStyledItemDelegate::editorEvent(event, model, option, index);
    }
  }

  //  [adaptor impl] bool QStyledItemDelegate::eventFilter(QObject *object, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *object, QEvent *event)
  {
    return QStyledItemDelegate::eventFilter(object, event);
  }

  virtual bool eventFilter(QObject *object, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QStyledItemDelegate_Adaptor, bool, QObject *, QEvent *>(&QStyledItemDelegate_Adaptor::cbs_eventFilter_2411_0, object, event);
    } else {
      return QStyledItemDelegate::eventFilter(object, event);
    }
  }

  //  [adaptor impl] void QStyledItemDelegate::initStyleOption(QStyleOptionViewItem *option, const QModelIndex &index)
  void cbs_initStyleOption_c4962_0(QStyleOptionViewItem *option, const QModelIndex &index) const
  {
    QStyledItemDelegate::initStyleOption(option, index);
  }

  virtual void initStyleOption(QStyleOptionViewItem *option, const QModelIndex &index) const
  {
    if (cb_initStyleOption_c4962_0.can_issue()) {
      cb_initStyleOption_c4962_0.issue<QStyledItemDelegate_Adaptor, QStyleOptionViewItem *, const QModelIndex &>(&QStyledItemDelegate_Adaptor::cbs_initStyleOption_c4962_0, option, index);
    } else {
      QStyledItemDelegate::initStyleOption(option, index);
    }
  }

  //  [emitter impl] void QStyledItemDelegate::sizeHintChanged(const QModelIndex &)
  void emitter_QStyledItemDelegate_sizeHintChanged_2395(const QModelIndex &arg1)
  {
    emit QStyledItemDelegate::sizeHintChanged(arg1);
  }

  //  [adaptor impl] void QStyledItemDelegate::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QStyledItemDelegate::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QStyledItemDelegate_Adaptor, QTimerEvent *>(&QStyledItemDelegate_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QStyledItemDelegate::timerEvent(arg1);
    }
  }

  gsi::Callback cb_createEditor_c6860_0;
  gsi::Callback cb_displayText_c3997_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_paint_c6971_0;
  gsi::Callback cb_setEditorData_c3602_0;
  gsi::Callback cb_setModelData_c5913_0;
  gsi::Callback cb_sizeHint_c5653_0;
  gsi::Callback cb_updateEditorGeometry_c6860_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_editorEvent_9073_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_initStyleOption_c4962_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QStyledItemDelegate_Adaptor::~QStyledItemDelegate_Adaptor() { }

//  Constructor QStyledItemDelegate::QStyledItemDelegate(QObject *parent) (adaptor class)

static void _init_ctor_QStyledItemDelegate_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QStyledItemDelegate_Adaptor> ();
}

static void _call_ctor_QStyledItemDelegate_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QStyledItemDelegate_Adaptor *> (new QStyledItemDelegate_Adaptor (arg1));
}


// void QStyledItemDelegate::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QStyledItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_emitter_closeEditor_4926 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemDelegate::NoHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_closeEditor_4926 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemDelegate::EndEditHint>(heap, QAbstractItemDelegate::NoHint), heap);
  ((QStyledItemDelegate_Adaptor *)cls)->emitter_QStyledItemDelegate_closeEditor_4926 (arg1, arg2);
}


// emitter void QStyledItemDelegate::commitData(QWidget *editor)

static void _init_emitter_commitData_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_commitData_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  ((QStyledItemDelegate_Adaptor *)cls)->emitter_QStyledItemDelegate_commitData_1315 (arg1);
}


// QWidget *QStyledItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_createEditor_c6860_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_cbs_createEditor_c6860_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QWidget * > ((QWidget *)((QStyledItemDelegate_Adaptor *)cls)->cbs_createEditor_c6860_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_createEditor_c6860_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_createEditor_c6860_0 = cb;
}


// void QStyledItemDelegate::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QStyledItemDelegate::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QStyledItemDelegate_Adaptor *)cls)->emitter_QStyledItemDelegate_destroyed_1302 (arg1);
}


// void QStyledItemDelegate::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// QString QStyledItemDelegate::displayText(const QVariant &value, const QLocale &locale)

static void _init_cbs_displayText_c3997_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("locale");
  decl->add_arg<const QLocale & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_cbs_displayText_c3997_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = args.read<const QVariant & > (heap);
  const QLocale &arg2 = args.read<const QLocale & > (heap);
  ret.write<QString > ((QString)((QStyledItemDelegate_Adaptor *)cls)->cbs_displayText_c3997_0 (arg1, arg2));
}

static void _set_callback_cbs_displayText_c3997_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_displayText_c3997_0 = cb;
}


// bool QStyledItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_editorEvent_9073_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("index");
  decl->add_arg<const QModelIndex & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_editorEvent_9073_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > (heap);
  const QStyleOptionViewItem &arg3 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QStyledItemDelegate_Adaptor *)cls)->cbs_editorEvent_9073_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_editorEvent_9073_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_editorEvent_9073_0 = cb;
}


// bool QStyledItemDelegate::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QStyledItemDelegate_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QStyledItemDelegate::eventFilter(QObject *object, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QStyledItemDelegate_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QStyledItemDelegate::initStyleOption(QStyleOptionViewItem *option, const QModelIndex &index)

static void _init_cbs_initStyleOption_c4962_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionViewItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c4962_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionViewItem *arg1 = args.read<QStyleOptionViewItem * > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_initStyleOption_c4962_0 (arg1, arg2);
}

static void _set_callback_cbs_initStyleOption_c4962_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_initStyleOption_c4962_0 = cb;
}


// void QStyledItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_paint_c6971_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_c6971_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_paint_c6971_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_c6971_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_paint_c6971_0 = cb;
}


// exposed int QStyledItemDelegate::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QStyledItemDelegate_Adaptor *)cls)->fp_QStyledItemDelegate_receivers_c1731 (arg1));
}


// exposed QObject *QStyledItemDelegate::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QStyledItemDelegate_Adaptor *)cls)->fp_QStyledItemDelegate_sender_c0 ());
}


// void QStyledItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)

static void _init_cbs_setEditorData_c3602_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setEditorData_c3602_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_setEditorData_c3602_0 (arg1, arg2);
}

static void _set_callback_cbs_setEditorData_c3602_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_setEditorData_c3602_0 = cb;
}


// void QStyledItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)

static void _init_cbs_setModelData_c5913_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_setModelData_c5913_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_setModelData_c5913_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_setModelData_c5913_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_setModelData_c5913_0 = cb;
}


// QSize QStyledItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_sizeHint_c5653_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c5653_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QStyledItemDelegate_Adaptor *)cls)->cbs_sizeHint_c5653_0 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c5653_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_sizeHint_c5653_0 = cb;
}


// emitter void QStyledItemDelegate::sizeHintChanged(const QModelIndex &)

static void _init_emitter_sizeHintChanged_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_sizeHintChanged_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QStyledItemDelegate_Adaptor *)cls)->emitter_QStyledItemDelegate_sizeHintChanged_2395 (arg1);
}


// void QStyledItemDelegate::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QStyledItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_updateEditorGeometry_c6860_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometry_c6860_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStyledItemDelegate_Adaptor *)cls)->cbs_updateEditorGeometry_c6860_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_updateEditorGeometry_c6860_0 (void *cls, const gsi::Callback &cb)
{
  ((QStyledItemDelegate_Adaptor *)cls)->cb_updateEditorGeometry_c6860_0 = cb;
}


namespace gsi
{

gsi::Class<QStyledItemDelegate> &qtdecl_QStyledItemDelegate ();

static gsi::Methods methods_QStyledItemDelegate_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStyledItemDelegate::QStyledItemDelegate(QObject *parent)\nThis method creates an object of class QStyledItemDelegate.", &_init_ctor_QStyledItemDelegate_Adaptor_1302, &_call_ctor_QStyledItemDelegate_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QStyledItemDelegate::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_closeEditor", "@brief Emitter for signal void QStyledItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nCall this method to emit this signal.", false, &_init_emitter_closeEditor_4926, &_call_emitter_closeEditor_4926);
  methods += new qt_gsi::GenericMethod ("emit_commitData", "@brief Emitter for signal void QStyledItemDelegate::commitData(QWidget *editor)\nCall this method to emit this signal.", false, &_init_emitter_commitData_1315, &_call_emitter_commitData_1315);
  methods += new qt_gsi::GenericMethod ("createEditor", "@brief Virtual method QWidget *QStyledItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_createEditor_c6860_0, &_call_cbs_createEditor_c6860_0);
  methods += new qt_gsi::GenericMethod ("createEditor", "@hide", true, &_init_cbs_createEditor_c6860_0, &_call_cbs_createEditor_c6860_0, &_set_callback_cbs_createEditor_c6860_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QStyledItemDelegate::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QStyledItemDelegate::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QStyledItemDelegate::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("displayText", "@brief Virtual method QString QStyledItemDelegate::displayText(const QVariant &value, const QLocale &locale)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_displayText_c3997_0, &_call_cbs_displayText_c3997_0);
  methods += new qt_gsi::GenericMethod ("displayText", "@hide", true, &_init_cbs_displayText_c3997_0, &_call_cbs_displayText_c3997_0, &_set_callback_cbs_displayText_c3997_0);
  methods += new qt_gsi::GenericMethod ("*editorEvent", "@brief Virtual method bool QStyledItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorEvent_9073_0, &_call_cbs_editorEvent_9073_0);
  methods += new qt_gsi::GenericMethod ("*editorEvent", "@hide", false, &_init_cbs_editorEvent_9073_0, &_call_cbs_editorEvent_9073_0, &_set_callback_cbs_editorEvent_9073_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QStyledItemDelegate::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QStyledItemDelegate::eventFilter(QObject *object, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QStyledItemDelegate::initStyleOption(QStyleOptionViewItem *option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c4962_0, &_call_cbs_initStyleOption_c4962_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c4962_0, &_call_cbs_initStyleOption_c4962_0, &_set_callback_cbs_initStyleOption_c4962_0);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QStyledItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paint_c6971_0, &_call_cbs_paint_c6971_0);
  methods += new qt_gsi::GenericMethod ("paint", "@hide", true, &_init_cbs_paint_c6971_0, &_call_cbs_paint_c6971_0, &_set_callback_cbs_paint_c6971_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QStyledItemDelegate::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QStyledItemDelegate::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setEditorData", "@brief Virtual method void QStyledItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_setEditorData_c3602_0, &_call_cbs_setEditorData_c3602_0);
  methods += new qt_gsi::GenericMethod ("setEditorData", "@hide", true, &_init_cbs_setEditorData_c3602_0, &_call_cbs_setEditorData_c3602_0, &_set_callback_cbs_setEditorData_c3602_0);
  methods += new qt_gsi::GenericMethod ("setModelData", "@brief Virtual method void QStyledItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_setModelData_c5913_0, &_call_cbs_setModelData_c5913_0);
  methods += new qt_gsi::GenericMethod ("setModelData", "@hide", true, &_init_cbs_setModelData_c5913_0, &_call_cbs_setModelData_c5913_0, &_set_callback_cbs_setModelData_c5913_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QStyledItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c5653_0, &_call_cbs_sizeHint_c5653_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c5653_0, &_call_cbs_sizeHint_c5653_0, &_set_callback_cbs_sizeHint_c5653_0);
  methods += new qt_gsi::GenericMethod ("emit_sizeHintChanged", "@brief Emitter for signal void QStyledItemDelegate::sizeHintChanged(const QModelIndex &)\nCall this method to emit this signal.", false, &_init_emitter_sizeHintChanged_2395, &_call_emitter_sizeHintChanged_2395);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QStyledItemDelegate::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("updateEditorGeometry", "@brief Virtual method void QStyledItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_updateEditorGeometry_c6860_0, &_call_cbs_updateEditorGeometry_c6860_0);
  methods += new qt_gsi::GenericMethod ("updateEditorGeometry", "@hide", true, &_init_cbs_updateEditorGeometry_c6860_0, &_call_cbs_updateEditorGeometry_c6860_0, &_set_callback_cbs_updateEditorGeometry_c6860_0);
  return methods;
}

gsi::Class<QStyledItemDelegate_Adaptor> decl_QStyledItemDelegate_Adaptor (qtdecl_QStyledItemDelegate (), "QtGui", "QStyledItemDelegate",
  methods_QStyledItemDelegate_Adaptor (),
  "@qt\n@brief Binding of QStyledItemDelegate");

}

