
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDomNode.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QDomNode>
#include <QDomAttr>
#include <QDomCDATASection>
#include <QDomCharacterData>
#include <QDomComment>
#include <QDomDocument>
#include <QDomDocumentFragment>
#include <QDomDocumentType>
#include <QDomElement>
#include <QDomEntity>
#include <QDomEntityReference>
#include <QDomNamedNodeMap>
#include <QDomNodeList>
#include <QDomNotation>
#include <QDomProcessingInstruction>
#include <QDomText>
#include <QTextStream>
#include "gsiQt.h"
#include "gsiQtXmlCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDomNode

//  Constructor QDomNode::QDomNode()


static void _init_ctor_QDomNode_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QDomNode> ();
}

static void _call_ctor_QDomNode_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomNode *> (new QDomNode ());
}


//  Constructor QDomNode::QDomNode(const QDomNode &)


static void _init_ctor_QDomNode_2072 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return_new<QDomNode> ();
}

static void _call_ctor_QDomNode_2072 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDomNode &arg1 = gsi::arg_reader<const QDomNode & >() (args, heap);
  ret.write<QDomNode *> (new QDomNode (arg1));
}


// QDomNode QDomNode::appendChild(const QDomNode &newChild)


static void _init_f_appendChild_2072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newChild");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return<QDomNode > ();
}

static void _call_f_appendChild_2072 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDomNode &arg1 = gsi::arg_reader<const QDomNode & >() (args, heap);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->appendChild (arg1));
}


// QDomNamedNodeMap QDomNode::attributes()


static void _init_f_attributes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNamedNodeMap > ();
}

static void _call_f_attributes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomNamedNodeMap > ((QDomNamedNodeMap)((QDomNode *)cls)->attributes ());
}


// QDomNodeList QDomNode::childNodes()


static void _init_f_childNodes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNodeList > ();
}

static void _call_f_childNodes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomNodeList > ((QDomNodeList)((QDomNode *)cls)->childNodes ());
}


// void QDomNode::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDomNode *)cls)->clear ();
}


// QDomNode QDomNode::cloneNode(bool deep)


static void _init_f_cloneNode_c864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("deep", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<QDomNode > ();
}

static void _call_f_cloneNode_c864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->cloneNode (arg1));
}


// int QDomNode::columnNumber()


static void _init_f_columnNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columnNumber_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDomNode *)cls)->columnNumber ());
}


// QDomNode QDomNode::firstChild()


static void _init_f_firstChild_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNode > ();
}

static void _call_f_firstChild_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->firstChild ());
}


// QDomElement QDomNode::firstChildElement(const QString &tagName)


static void _init_f_firstChildElement_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tagName", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDomElement > ();
}

static void _call_f_firstChildElement_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QDomElement > ((QDomElement)((QDomNode *)cls)->firstChildElement (arg1));
}


// bool QDomNode::hasAttributes()


static void _init_f_hasAttributes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAttributes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->hasAttributes ());
}


// bool QDomNode::hasChildNodes()


static void _init_f_hasChildNodes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasChildNodes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->hasChildNodes ());
}


// QDomNode QDomNode::insertAfter(const QDomNode &newChild, const QDomNode &refChild)


static void _init_f_insertAfter_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newChild");
  decl->add_arg<const QDomNode & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("refChild");
  decl->add_arg<const QDomNode & > (argspec_1);
  decl->set_return<QDomNode > ();
}

static void _call_f_insertAfter_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDomNode &arg1 = gsi::arg_reader<const QDomNode & >() (args, heap);
  const QDomNode &arg2 = gsi::arg_reader<const QDomNode & >() (args, heap);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->insertAfter (arg1, arg2));
}


// QDomNode QDomNode::insertBefore(const QDomNode &newChild, const QDomNode &refChild)


static void _init_f_insertBefore_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newChild");
  decl->add_arg<const QDomNode & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("refChild");
  decl->add_arg<const QDomNode & > (argspec_1);
  decl->set_return<QDomNode > ();
}

static void _call_f_insertBefore_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDomNode &arg1 = gsi::arg_reader<const QDomNode & >() (args, heap);
  const QDomNode &arg2 = gsi::arg_reader<const QDomNode & >() (args, heap);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->insertBefore (arg1, arg2));
}


// bool QDomNode::isAttr()


static void _init_f_isAttr_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAttr_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isAttr ());
}


// bool QDomNode::isCDATASection()


static void _init_f_isCDATASection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCDATASection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isCDATASection ());
}


// bool QDomNode::isCharacterData()


static void _init_f_isCharacterData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCharacterData_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isCharacterData ());
}


// bool QDomNode::isComment()


static void _init_f_isComment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isComment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isComment ());
}


// bool QDomNode::isDocument()


static void _init_f_isDocument_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDocument_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isDocument ());
}


// bool QDomNode::isDocumentFragment()


static void _init_f_isDocumentFragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDocumentFragment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isDocumentFragment ());
}


// bool QDomNode::isDocumentType()


static void _init_f_isDocumentType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDocumentType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isDocumentType ());
}


// bool QDomNode::isElement()


static void _init_f_isElement_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isElement_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isElement ());
}


// bool QDomNode::isEntity()


static void _init_f_isEntity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEntity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isEntity ());
}


// bool QDomNode::isEntityReference()


static void _init_f_isEntityReference_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEntityReference_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isEntityReference ());
}


// bool QDomNode::isNotation()


static void _init_f_isNotation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNotation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isNotation ());
}


// bool QDomNode::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isNull ());
}


// bool QDomNode::isProcessingInstruction()


static void _init_f_isProcessingInstruction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isProcessingInstruction_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isProcessingInstruction ());
}


// bool QDomNode::isSupported(const QString &feature, const QString &version)


static void _init_f_isSupported_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("feature");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("version");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isSupported_c3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QDomNode *)cls)->isSupported (arg1, arg2));
}


// bool QDomNode::isText()


static void _init_f_isText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDomNode *)cls)->isText ());
}


// QDomNode QDomNode::lastChild()


static void _init_f_lastChild_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNode > ();
}

static void _call_f_lastChild_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->lastChild ());
}


// QDomElement QDomNode::lastChildElement(const QString &tagName)


static void _init_f_lastChildElement_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tagName", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDomElement > ();
}

static void _call_f_lastChildElement_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QDomElement > ((QDomElement)((QDomNode *)cls)->lastChildElement (arg1));
}


// int QDomNode::lineNumber()


static void _init_f_lineNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_lineNumber_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDomNode *)cls)->lineNumber ());
}


// QString QDomNode::localName()


static void _init_f_localName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_localName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDomNode *)cls)->localName ());
}


// QDomNode QDomNode::namedItem(const QString &name)


static void _init_f_namedItem_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDomNode > ();
}

static void _call_f_namedItem_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->namedItem (arg1));
}


// QString QDomNode::namespaceURI()


static void _init_f_namespaceURI_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_namespaceURI_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDomNode *)cls)->namespaceURI ());
}


// QDomNode QDomNode::nextSibling()


static void _init_f_nextSibling_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNode > ();
}

static void _call_f_nextSibling_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->nextSibling ());
}


// QDomElement QDomNode::nextSiblingElement(const QString &taName)


static void _init_f_nextSiblingElement_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("taName", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDomElement > ();
}

static void _call_f_nextSiblingElement_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QDomElement > ((QDomElement)((QDomNode *)cls)->nextSiblingElement (arg1));
}


// QString QDomNode::nodeName()


static void _init_f_nodeName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_nodeName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDomNode *)cls)->nodeName ());
}


// QDomNode::NodeType QDomNode::nodeType()


static void _init_f_nodeType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDomNode::NodeType>::target_type > ();
}

static void _call_f_nodeType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QDomNode::NodeType>::target_type > ((qt_gsi::Converter<QDomNode::NodeType>::target_type)qt_gsi::CppToQtAdaptor<QDomNode::NodeType>(((QDomNode *)cls)->nodeType ()));
}


// QString QDomNode::nodeValue()


static void _init_f_nodeValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_nodeValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDomNode *)cls)->nodeValue ());
}


// void QDomNode::normalize()


static void _init_f_normalize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_normalize_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDomNode *)cls)->normalize ();
}


// bool QDomNode::operator!=(const QDomNode &)


static void _init_f_operator_excl__eq__c2072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2072 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDomNode &arg1 = gsi::arg_reader<const QDomNode & >() (args, heap);
  ret.write<bool > ((bool)((QDomNode *)cls)->operator!= (arg1));
}


// QDomNode &QDomNode::operator=(const QDomNode &)


static void _init_f_operator_eq__2072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return<QDomNode & > ();
}

static void _call_f_operator_eq__2072 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDomNode &arg1 = gsi::arg_reader<const QDomNode & >() (args, heap);
  ret.write<QDomNode & > ((QDomNode &)((QDomNode *)cls)->operator= (arg1));
}


// bool QDomNode::operator==(const QDomNode &)


static void _init_f_operator_eq__eq__c2072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2072 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDomNode &arg1 = gsi::arg_reader<const QDomNode & >() (args, heap);
  ret.write<bool > ((bool)((QDomNode *)cls)->operator== (arg1));
}


// QDomDocument QDomNode::ownerDocument()


static void _init_f_ownerDocument_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomDocument > ();
}

static void _call_f_ownerDocument_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomDocument > ((QDomDocument)((QDomNode *)cls)->ownerDocument ());
}


// QDomNode QDomNode::parentNode()


static void _init_f_parentNode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNode > ();
}

static void _call_f_parentNode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->parentNode ());
}


// QString QDomNode::prefix()


static void _init_f_prefix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_prefix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDomNode *)cls)->prefix ());
}


// QDomNode QDomNode::previousSibling()


static void _init_f_previousSibling_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNode > ();
}

static void _call_f_previousSibling_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->previousSibling ());
}


// QDomElement QDomNode::previousSiblingElement(const QString &tagName)


static void _init_f_previousSiblingElement_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tagName", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDomElement > ();
}

static void _call_f_previousSiblingElement_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QDomElement > ((QDomElement)((QDomNode *)cls)->previousSiblingElement (arg1));
}


// QDomNode QDomNode::removeChild(const QDomNode &oldChild)


static void _init_f_removeChild_2072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldChild");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return<QDomNode > ();
}

static void _call_f_removeChild_2072 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDomNode &arg1 = gsi::arg_reader<const QDomNode & >() (args, heap);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->removeChild (arg1));
}


// QDomNode QDomNode::replaceChild(const QDomNode &newChild, const QDomNode &oldChild)


static void _init_f_replaceChild_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newChild");
  decl->add_arg<const QDomNode & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldChild");
  decl->add_arg<const QDomNode & > (argspec_1);
  decl->set_return<QDomNode > ();
}

static void _call_f_replaceChild_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDomNode &arg1 = gsi::arg_reader<const QDomNode & >() (args, heap);
  const QDomNode &arg2 = gsi::arg_reader<const QDomNode & >() (args, heap);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->replaceChild (arg1, arg2));
}


// void QDomNode::save(QTextStream &, int, QDomNode::EncodingPolicy)


static void _init_f_save_c5033 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTextStream & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("arg3", true, "QDomNode::EncodingFromDocument");
  decl->add_arg<const qt_gsi::Converter<QDomNode::EncodingPolicy>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_save_c5033 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextStream &arg1 = gsi::arg_reader<QTextStream & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QDomNode::EncodingPolicy>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QDomNode::EncodingPolicy>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QDomNode::EncodingPolicy>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QDomNode::EncodingPolicy>(heap, QDomNode::EncodingFromDocument), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDomNode *)cls)->save (arg1, arg2, qt_gsi::QtToCppAdaptor<QDomNode::EncodingPolicy>(arg3).cref());
}


// void QDomNode::setNodeValue(const QString &)


static void _init_f_setNodeValue_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNodeValue_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDomNode *)cls)->setNodeValue (arg1);
}


// void QDomNode::setPrefix(const QString &pre)


static void _init_f_setPrefix_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pre");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPrefix_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDomNode *)cls)->setPrefix (arg1);
}


// QDomAttr QDomNode::toAttr()


static void _init_f_toAttr_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomAttr > ();
}

static void _call_f_toAttr_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomAttr > ((QDomAttr)((QDomNode *)cls)->toAttr ());
}


// QDomCDATASection QDomNode::toCDATASection()


static void _init_f_toCDATASection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomCDATASection > ();
}

static void _call_f_toCDATASection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomCDATASection > ((QDomCDATASection)((QDomNode *)cls)->toCDATASection ());
}


// QDomCharacterData QDomNode::toCharacterData()


static void _init_f_toCharacterData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomCharacterData > ();
}

static void _call_f_toCharacterData_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomCharacterData > ((QDomCharacterData)((QDomNode *)cls)->toCharacterData ());
}


// QDomComment QDomNode::toComment()


static void _init_f_toComment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomComment > ();
}

static void _call_f_toComment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomComment > ((QDomComment)((QDomNode *)cls)->toComment ());
}


// QDomDocument QDomNode::toDocument()


static void _init_f_toDocument_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomDocument > ();
}

static void _call_f_toDocument_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomDocument > ((QDomDocument)((QDomNode *)cls)->toDocument ());
}


// QDomDocumentFragment QDomNode::toDocumentFragment()


static void _init_f_toDocumentFragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomDocumentFragment > ();
}

static void _call_f_toDocumentFragment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomDocumentFragment > ((QDomDocumentFragment)((QDomNode *)cls)->toDocumentFragment ());
}


// QDomDocumentType QDomNode::toDocumentType()


static void _init_f_toDocumentType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomDocumentType > ();
}

static void _call_f_toDocumentType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomDocumentType > ((QDomDocumentType)((QDomNode *)cls)->toDocumentType ());
}


// QDomElement QDomNode::toElement()


static void _init_f_toElement_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomElement > ();
}

static void _call_f_toElement_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomElement > ((QDomElement)((QDomNode *)cls)->toElement ());
}


// QDomEntity QDomNode::toEntity()


static void _init_f_toEntity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomEntity > ();
}

static void _call_f_toEntity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomEntity > ((QDomEntity)((QDomNode *)cls)->toEntity ());
}


// QDomEntityReference QDomNode::toEntityReference()


static void _init_f_toEntityReference_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomEntityReference > ();
}

static void _call_f_toEntityReference_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomEntityReference > ((QDomEntityReference)((QDomNode *)cls)->toEntityReference ());
}


// QDomNotation QDomNode::toNotation()


static void _init_f_toNotation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNotation > ();
}

static void _call_f_toNotation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomNotation > ((QDomNotation)((QDomNode *)cls)->toNotation ());
}


// QDomProcessingInstruction QDomNode::toProcessingInstruction()


static void _init_f_toProcessingInstruction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomProcessingInstruction > ();
}

static void _call_f_toProcessingInstruction_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomProcessingInstruction > ((QDomProcessingInstruction)((QDomNode *)cls)->toProcessingInstruction ());
}


// QDomText QDomNode::toText()


static void _init_f_toText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomText > ();
}

static void _call_f_toText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDomText > ((QDomText)((QDomNode *)cls)->toText ());
}



namespace gsi
{

static gsi::Methods methods_QDomNode () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDomNode::QDomNode()\nThis method creates an object of class QDomNode.", &_init_ctor_QDomNode_0, &_call_ctor_QDomNode_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDomNode::QDomNode(const QDomNode &)\nThis method creates an object of class QDomNode.", &_init_ctor_QDomNode_2072, &_call_ctor_QDomNode_2072);
  methods += new qt_gsi::GenericMethod ("appendChild", "@brief Method QDomNode QDomNode::appendChild(const QDomNode &newChild)\n", false, &_init_f_appendChild_2072, &_call_f_appendChild_2072);
  methods += new qt_gsi::GenericMethod ("attributes", "@brief Method QDomNamedNodeMap QDomNode::attributes()\n", true, &_init_f_attributes_c0, &_call_f_attributes_c0);
  methods += new qt_gsi::GenericMethod ("childNodes", "@brief Method QDomNodeList QDomNode::childNodes()\n", true, &_init_f_childNodes_c0, &_call_f_childNodes_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QDomNode::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("cloneNode", "@brief Method QDomNode QDomNode::cloneNode(bool deep)\n", true, &_init_f_cloneNode_c864, &_call_f_cloneNode_c864);
  methods += new qt_gsi::GenericMethod ("columnNumber", "@brief Method int QDomNode::columnNumber()\n", true, &_init_f_columnNumber_c0, &_call_f_columnNumber_c0);
  methods += new qt_gsi::GenericMethod ("firstChild", "@brief Method QDomNode QDomNode::firstChild()\n", true, &_init_f_firstChild_c0, &_call_f_firstChild_c0);
  methods += new qt_gsi::GenericMethod ("firstChildElement", "@brief Method QDomElement QDomNode::firstChildElement(const QString &tagName)\n", true, &_init_f_firstChildElement_c2025, &_call_f_firstChildElement_c2025);
  methods += new qt_gsi::GenericMethod ("hasAttributes", "@brief Method bool QDomNode::hasAttributes()\n", true, &_init_f_hasAttributes_c0, &_call_f_hasAttributes_c0);
  methods += new qt_gsi::GenericMethod ("hasChildNodes", "@brief Method bool QDomNode::hasChildNodes()\n", true, &_init_f_hasChildNodes_c0, &_call_f_hasChildNodes_c0);
  methods += new qt_gsi::GenericMethod ("insertAfter", "@brief Method QDomNode QDomNode::insertAfter(const QDomNode &newChild, const QDomNode &refChild)\n", false, &_init_f_insertAfter_4036, &_call_f_insertAfter_4036);
  methods += new qt_gsi::GenericMethod ("insertBefore", "@brief Method QDomNode QDomNode::insertBefore(const QDomNode &newChild, const QDomNode &refChild)\n", false, &_init_f_insertBefore_4036, &_call_f_insertBefore_4036);
  methods += new qt_gsi::GenericMethod ("isAttr?", "@brief Method bool QDomNode::isAttr()\n", true, &_init_f_isAttr_c0, &_call_f_isAttr_c0);
  methods += new qt_gsi::GenericMethod ("isCDATASection?", "@brief Method bool QDomNode::isCDATASection()\n", true, &_init_f_isCDATASection_c0, &_call_f_isCDATASection_c0);
  methods += new qt_gsi::GenericMethod ("isCharacterData?", "@brief Method bool QDomNode::isCharacterData()\n", true, &_init_f_isCharacterData_c0, &_call_f_isCharacterData_c0);
  methods += new qt_gsi::GenericMethod ("isComment?", "@brief Method bool QDomNode::isComment()\n", true, &_init_f_isComment_c0, &_call_f_isComment_c0);
  methods += new qt_gsi::GenericMethod ("isDocument?", "@brief Method bool QDomNode::isDocument()\n", true, &_init_f_isDocument_c0, &_call_f_isDocument_c0);
  methods += new qt_gsi::GenericMethod ("isDocumentFragment?", "@brief Method bool QDomNode::isDocumentFragment()\n", true, &_init_f_isDocumentFragment_c0, &_call_f_isDocumentFragment_c0);
  methods += new qt_gsi::GenericMethod ("isDocumentType?", "@brief Method bool QDomNode::isDocumentType()\n", true, &_init_f_isDocumentType_c0, &_call_f_isDocumentType_c0);
  methods += new qt_gsi::GenericMethod ("isElement?", "@brief Method bool QDomNode::isElement()\n", true, &_init_f_isElement_c0, &_call_f_isElement_c0);
  methods += new qt_gsi::GenericMethod ("isEntity?", "@brief Method bool QDomNode::isEntity()\n", true, &_init_f_isEntity_c0, &_call_f_isEntity_c0);
  methods += new qt_gsi::GenericMethod ("isEntityReference?", "@brief Method bool QDomNode::isEntityReference()\n", true, &_init_f_isEntityReference_c0, &_call_f_isEntityReference_c0);
  methods += new qt_gsi::GenericMethod ("isNotation?", "@brief Method bool QDomNode::isNotation()\n", true, &_init_f_isNotation_c0, &_call_f_isNotation_c0);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QDomNode::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("isProcessingInstruction?", "@brief Method bool QDomNode::isProcessingInstruction()\n", true, &_init_f_isProcessingInstruction_c0, &_call_f_isProcessingInstruction_c0);
  methods += new qt_gsi::GenericMethod ("isSupported?", "@brief Method bool QDomNode::isSupported(const QString &feature, const QString &version)\n", true, &_init_f_isSupported_c3942, &_call_f_isSupported_c3942);
  methods += new qt_gsi::GenericMethod ("isText?", "@brief Method bool QDomNode::isText()\n", true, &_init_f_isText_c0, &_call_f_isText_c0);
  methods += new qt_gsi::GenericMethod ("lastChild", "@brief Method QDomNode QDomNode::lastChild()\n", true, &_init_f_lastChild_c0, &_call_f_lastChild_c0);
  methods += new qt_gsi::GenericMethod ("lastChildElement", "@brief Method QDomElement QDomNode::lastChildElement(const QString &tagName)\n", true, &_init_f_lastChildElement_c2025, &_call_f_lastChildElement_c2025);
  methods += new qt_gsi::GenericMethod ("lineNumber", "@brief Method int QDomNode::lineNumber()\n", true, &_init_f_lineNumber_c0, &_call_f_lineNumber_c0);
  methods += new qt_gsi::GenericMethod ("localName", "@brief Method QString QDomNode::localName()\n", true, &_init_f_localName_c0, &_call_f_localName_c0);
  methods += new qt_gsi::GenericMethod ("namedItem", "@brief Method QDomNode QDomNode::namedItem(const QString &name)\n", true, &_init_f_namedItem_c2025, &_call_f_namedItem_c2025);
  methods += new qt_gsi::GenericMethod ("namespaceURI", "@brief Method QString QDomNode::namespaceURI()\n", true, &_init_f_namespaceURI_c0, &_call_f_namespaceURI_c0);
  methods += new qt_gsi::GenericMethod ("nextSibling", "@brief Method QDomNode QDomNode::nextSibling()\n", true, &_init_f_nextSibling_c0, &_call_f_nextSibling_c0);
  methods += new qt_gsi::GenericMethod ("nextSiblingElement", "@brief Method QDomElement QDomNode::nextSiblingElement(const QString &taName)\n", true, &_init_f_nextSiblingElement_c2025, &_call_f_nextSiblingElement_c2025);
  methods += new qt_gsi::GenericMethod ("nodeName", "@brief Method QString QDomNode::nodeName()\n", true, &_init_f_nodeName_c0, &_call_f_nodeName_c0);
  methods += new qt_gsi::GenericMethod ("nodeType", "@brief Method QDomNode::NodeType QDomNode::nodeType()\n", true, &_init_f_nodeType_c0, &_call_f_nodeType_c0);
  methods += new qt_gsi::GenericMethod (":nodeValue", "@brief Method QString QDomNode::nodeValue()\n", true, &_init_f_nodeValue_c0, &_call_f_nodeValue_c0);
  methods += new qt_gsi::GenericMethod ("normalize", "@brief Method void QDomNode::normalize()\n", false, &_init_f_normalize_0, &_call_f_normalize_0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QDomNode::operator!=(const QDomNode &)\n", true, &_init_f_operator_excl__eq__c2072, &_call_f_operator_excl__eq__c2072);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QDomNode &QDomNode::operator=(const QDomNode &)\n", false, &_init_f_operator_eq__2072, &_call_f_operator_eq__2072);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QDomNode::operator==(const QDomNode &)\n", true, &_init_f_operator_eq__eq__c2072, &_call_f_operator_eq__eq__c2072);
  methods += new qt_gsi::GenericMethod ("ownerDocument", "@brief Method QDomDocument QDomNode::ownerDocument()\n", true, &_init_f_ownerDocument_c0, &_call_f_ownerDocument_c0);
  methods += new qt_gsi::GenericMethod ("parentNode", "@brief Method QDomNode QDomNode::parentNode()\n", true, &_init_f_parentNode_c0, &_call_f_parentNode_c0);
  methods += new qt_gsi::GenericMethod (":prefix", "@brief Method QString QDomNode::prefix()\n", true, &_init_f_prefix_c0, &_call_f_prefix_c0);
  methods += new qt_gsi::GenericMethod ("previousSibling", "@brief Method QDomNode QDomNode::previousSibling()\n", true, &_init_f_previousSibling_c0, &_call_f_previousSibling_c0);
  methods += new qt_gsi::GenericMethod ("previousSiblingElement", "@brief Method QDomElement QDomNode::previousSiblingElement(const QString &tagName)\n", true, &_init_f_previousSiblingElement_c2025, &_call_f_previousSiblingElement_c2025);
  methods += new qt_gsi::GenericMethod ("removeChild", "@brief Method QDomNode QDomNode::removeChild(const QDomNode &oldChild)\n", false, &_init_f_removeChild_2072, &_call_f_removeChild_2072);
  methods += new qt_gsi::GenericMethod ("replaceChild", "@brief Method QDomNode QDomNode::replaceChild(const QDomNode &newChild, const QDomNode &oldChild)\n", false, &_init_f_replaceChild_4036, &_call_f_replaceChild_4036);
  methods += new qt_gsi::GenericMethod ("save", "@brief Method void QDomNode::save(QTextStream &, int, QDomNode::EncodingPolicy)\n", true, &_init_f_save_c5033, &_call_f_save_c5033);
  methods += new qt_gsi::GenericMethod ("setNodeValue|nodeValue=", "@brief Method void QDomNode::setNodeValue(const QString &)\n", false, &_init_f_setNodeValue_2025, &_call_f_setNodeValue_2025);
  methods += new qt_gsi::GenericMethod ("setPrefix|prefix=", "@brief Method void QDomNode::setPrefix(const QString &pre)\n", false, &_init_f_setPrefix_2025, &_call_f_setPrefix_2025);
  methods += new qt_gsi::GenericMethod ("toAttr", "@brief Method QDomAttr QDomNode::toAttr()\n", true, &_init_f_toAttr_c0, &_call_f_toAttr_c0);
  methods += new qt_gsi::GenericMethod ("toCDATASection", "@brief Method QDomCDATASection QDomNode::toCDATASection()\n", true, &_init_f_toCDATASection_c0, &_call_f_toCDATASection_c0);
  methods += new qt_gsi::GenericMethod ("toCharacterData", "@brief Method QDomCharacterData QDomNode::toCharacterData()\n", true, &_init_f_toCharacterData_c0, &_call_f_toCharacterData_c0);
  methods += new qt_gsi::GenericMethod ("toComment", "@brief Method QDomComment QDomNode::toComment()\n", true, &_init_f_toComment_c0, &_call_f_toComment_c0);
  methods += new qt_gsi::GenericMethod ("toDocument", "@brief Method QDomDocument QDomNode::toDocument()\n", true, &_init_f_toDocument_c0, &_call_f_toDocument_c0);
  methods += new qt_gsi::GenericMethod ("toDocumentFragment", "@brief Method QDomDocumentFragment QDomNode::toDocumentFragment()\n", true, &_init_f_toDocumentFragment_c0, &_call_f_toDocumentFragment_c0);
  methods += new qt_gsi::GenericMethod ("toDocumentType", "@brief Method QDomDocumentType QDomNode::toDocumentType()\n", true, &_init_f_toDocumentType_c0, &_call_f_toDocumentType_c0);
  methods += new qt_gsi::GenericMethod ("toElement", "@brief Method QDomElement QDomNode::toElement()\n", true, &_init_f_toElement_c0, &_call_f_toElement_c0);
  methods += new qt_gsi::GenericMethod ("toEntity", "@brief Method QDomEntity QDomNode::toEntity()\n", true, &_init_f_toEntity_c0, &_call_f_toEntity_c0);
  methods += new qt_gsi::GenericMethod ("toEntityReference", "@brief Method QDomEntityReference QDomNode::toEntityReference()\n", true, &_init_f_toEntityReference_c0, &_call_f_toEntityReference_c0);
  methods += new qt_gsi::GenericMethod ("toNotation", "@brief Method QDomNotation QDomNode::toNotation()\n", true, &_init_f_toNotation_c0, &_call_f_toNotation_c0);
  methods += new qt_gsi::GenericMethod ("toProcessingInstruction", "@brief Method QDomProcessingInstruction QDomNode::toProcessingInstruction()\n", true, &_init_f_toProcessingInstruction_c0, &_call_f_toProcessingInstruction_c0);
  methods += new qt_gsi::GenericMethod ("toText", "@brief Method QDomText QDomNode::toText()\n", true, &_init_f_toText_c0, &_call_f_toText_c0);
  return methods;
}

gsi::Class<QDomNode> decl_QDomNode ("QtXml", "QDomNode",
  methods_QDomNode (),
  "@qt\n@brief Binding of QDomNode");


GSI_QTXML_PUBLIC gsi::Class<QDomNode> &qtdecl_QDomNode () { return decl_QDomNode; }

}


//  Implementation of the enum wrapper class for QDomNode::EncodingPolicy
namespace qt_gsi
{

static gsi::Enum<QDomNode::EncodingPolicy> decl_QDomNode_EncodingPolicy_Enum ("QtXml", "QDomNode_EncodingPolicy",
    gsi::enum_const ("EncodingFromDocument", QDomNode::EncodingFromDocument, "@brief Enum constant QDomNode::EncodingFromDocument") +
    gsi::enum_const ("EncodingFromTextStream", QDomNode::EncodingFromTextStream, "@brief Enum constant QDomNode::EncodingFromTextStream"),
  "@qt\n@brief This class represents the QDomNode::EncodingPolicy enum");

static gsi::QFlagsClass<QDomNode::EncodingPolicy > decl_QDomNode_EncodingPolicy_Enums ("QtXml", "QDomNode_QFlags_EncodingPolicy",
  "@qt\n@brief This class represents the QFlags<QDomNode::EncodingPolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QDomNode> inject_QDomNode_EncodingPolicy_Enum_in_parent (decl_QDomNode_EncodingPolicy_Enum.defs ());
static gsi::ClassExt<QDomNode> decl_QDomNode_EncodingPolicy_Enum_as_child (decl_QDomNode_EncodingPolicy_Enum, "EncodingPolicy");
static gsi::ClassExt<QDomNode> decl_QDomNode_EncodingPolicy_Enums_as_child (decl_QDomNode_EncodingPolicy_Enums, "QFlags_EncodingPolicy");

}


//  Implementation of the enum wrapper class for QDomNode::NodeType
namespace qt_gsi
{

static gsi::Enum<QDomNode::NodeType> decl_QDomNode_NodeType_Enum ("QtXml", "QDomNode_NodeType",
    gsi::enum_const ("ElementNode", QDomNode::ElementNode, "@brief Enum constant QDomNode::ElementNode") +
    gsi::enum_const ("AttributeNode", QDomNode::AttributeNode, "@brief Enum constant QDomNode::AttributeNode") +
    gsi::enum_const ("TextNode", QDomNode::TextNode, "@brief Enum constant QDomNode::TextNode") +
    gsi::enum_const ("CDATASectionNode", QDomNode::CDATASectionNode, "@brief Enum constant QDomNode::CDATASectionNode") +
    gsi::enum_const ("EntityReferenceNode", QDomNode::EntityReferenceNode, "@brief Enum constant QDomNode::EntityReferenceNode") +
    gsi::enum_const ("EntityNode", QDomNode::EntityNode, "@brief Enum constant QDomNode::EntityNode") +
    gsi::enum_const ("ProcessingInstructionNode", QDomNode::ProcessingInstructionNode, "@brief Enum constant QDomNode::ProcessingInstructionNode") +
    gsi::enum_const ("CommentNode", QDomNode::CommentNode, "@brief Enum constant QDomNode::CommentNode") +
    gsi::enum_const ("DocumentNode", QDomNode::DocumentNode, "@brief Enum constant QDomNode::DocumentNode") +
    gsi::enum_const ("DocumentTypeNode", QDomNode::DocumentTypeNode, "@brief Enum constant QDomNode::DocumentTypeNode") +
    gsi::enum_const ("DocumentFragmentNode", QDomNode::DocumentFragmentNode, "@brief Enum constant QDomNode::DocumentFragmentNode") +
    gsi::enum_const ("NotationNode", QDomNode::NotationNode, "@brief Enum constant QDomNode::NotationNode") +
    gsi::enum_const ("BaseNode", QDomNode::BaseNode, "@brief Enum constant QDomNode::BaseNode") +
    gsi::enum_const ("CharacterDataNode", QDomNode::CharacterDataNode, "@brief Enum constant QDomNode::CharacterDataNode"),
  "@qt\n@brief This class represents the QDomNode::NodeType enum");

static gsi::QFlagsClass<QDomNode::NodeType > decl_QDomNode_NodeType_Enums ("QtXml", "QDomNode_QFlags_NodeType",
  "@qt\n@brief This class represents the QFlags<QDomNode::NodeType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QDomNode> inject_QDomNode_NodeType_Enum_in_parent (decl_QDomNode_NodeType_Enum.defs ());
static gsi::ClassExt<QDomNode> decl_QDomNode_NodeType_Enum_as_child (decl_QDomNode_NodeType_Enum, "NodeType");
static gsi::ClassExt<QDomNode> decl_QDomNode_NodeType_Enums_as_child (decl_QDomNode_NodeType_Enums, "QFlags_NodeType");

}

