/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.codegen.flags;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/writeFlags")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class WriteFlagsTestGenerated extends AbstractWriteFlagsTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInWriteFlags() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("compiler/testData/writeFlags/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCallableReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/writeFlags/callableReference/visibility")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Visibility extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInVisibility() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/callableReference/visibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("functionReference.kt")
            public void testFunctionReference() throws Exception {
                runTest("compiler/testData/writeFlags/callableReference/visibility/functionReference.kt");
            }

            @TestMetadata("functionReferenceInInlineFunction.kt")
            public void testFunctionReferenceInInlineFunction() throws Exception {
                runTest("compiler/testData/writeFlags/callableReference/visibility/functionReferenceInInlineFunction.kt");
            }

            @TestMetadata("propertyReference.kt")
            public void testPropertyReference() throws Exception {
                runTest("compiler/testData/writeFlags/callableReference/visibility/propertyReference.kt");
            }

            @TestMetadata("propertyReferenceInInlineFunction.kt")
            public void testPropertyReferenceInInlineFunction() throws Exception {
                runTest("compiler/testData/writeFlags/callableReference/visibility/propertyReferenceInInlineFunction.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/writeFlags/class")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Class extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/class"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/writeFlags/class/accessFlags")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AccessFlags extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAccessFlags() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/class/accessFlags"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("defaultImpls.kt")
            public void testDefaultImpls() throws Exception {
                runTest("compiler/testData/writeFlags/class/accessFlags/defaultImpls.kt");
            }

            @TestMetadata("innerSealed.kt")
            public void testInnerSealed() throws Exception {
                runTest("compiler/testData/writeFlags/class/accessFlags/innerSealed.kt");
            }

            @TestMetadata("mappingWhen.kt")
            public void testMappingWhen() throws Exception {
                runTest("compiler/testData/writeFlags/class/accessFlags/mappingWhen.kt");
            }

            @TestMetadata("objectLiteral.kt")
            public void testObjectLiteral() throws Exception {
                runTest("compiler/testData/writeFlags/class/accessFlags/objectLiteral.kt");
            }

            @TestMetadata("publicFinalClass.kt")
            public void testPublicFinalClass() throws Exception {
                runTest("compiler/testData/writeFlags/class/accessFlags/publicFinalClass.kt");
            }

            @TestMetadata("publicFinalInnerClass.kt")
            public void testPublicFinalInnerClass() throws Exception {
                runTest("compiler/testData/writeFlags/class/accessFlags/publicFinalInnerClass.kt");
            }

            @TestMetadata("publicInnerInterface.kt")
            public void testPublicInnerInterface() throws Exception {
                runTest("compiler/testData/writeFlags/class/accessFlags/publicInnerInterface.kt");
            }

            @TestMetadata("publicInterface.kt")
            public void testPublicInterface() throws Exception {
                runTest("compiler/testData/writeFlags/class/accessFlags/publicInterface.kt");
            }

            @TestMetadata("simpleFilePackageFacade.kt")
            public void testSimpleFilePackageFacade() throws Exception {
                runTest("compiler/testData/writeFlags/class/accessFlags/simpleFilePackageFacade.kt");
            }
        }

        @TestMetadata("compiler/testData/writeFlags/class/deprecatedFlag")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DeprecatedFlag extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDeprecatedFlag() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/class/deprecatedFlag"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("class.kt")
            public void testClass() throws Exception {
                runTest("compiler/testData/writeFlags/class/deprecatedFlag/class.kt");
            }

            @TestMetadata("classObject.kt")
            public void testClassObject() throws Exception {
                runTest("compiler/testData/writeFlags/class/deprecatedFlag/classObject.kt");
            }

            @TestMetadata("enumClass.kt")
            public void testEnumClass() throws Exception {
                runTest("compiler/testData/writeFlags/class/deprecatedFlag/enumClass.kt");
            }

            @TestMetadata("innerClass.kt")
            public void testInnerClass() throws Exception {
                runTest("compiler/testData/writeFlags/class/deprecatedFlag/innerClass.kt");
            }

            @TestMetadata("trait.kt")
            public void testTrait() throws Exception {
                runTest("compiler/testData/writeFlags/class/deprecatedFlag/trait.kt");
            }
        }

        @TestMetadata("compiler/testData/writeFlags/class/visibility")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Visibility extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInVisibility() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/class/visibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/writeFlags/class/visibility/internal")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Internal extends AbstractWriteFlagsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInternal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/class/visibility/internal"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("class.kt")
                public void testClass() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/internal/class.kt");
                }

                @TestMetadata("enum.kt")
                public void testEnum() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/internal/enum.kt");
                }

                @TestMetadata("innerClass.kt")
                public void testInnerClass() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/internal/innerClass.kt");
                }

                @TestMetadata("innerEnum.kt")
                public void testInnerEnum() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/internal/innerEnum.kt");
                }

                @TestMetadata("innerObject.kt")
                public void testInnerObject() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/internal/innerObject.kt");
                }

                @TestMetadata("innerTrait.kt")
                public void testInnerTrait() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/internal/innerTrait.kt");
                }

                @TestMetadata("object.kt")
                public void testObject() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/internal/object.kt");
                }

                @TestMetadata("trait.kt")
                public void testTrait() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/internal/trait.kt");
                }
            }

            @TestMetadata("compiler/testData/writeFlags/class/visibility/packageprivate")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Packageprivate extends AbstractWriteFlagsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPackageprivate() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/class/visibility/packageprivate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("enumEntry.kt")
                public void testEnumEntry() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/packageprivate/enumEntry.kt");
                }
            }

            @TestMetadata("compiler/testData/writeFlags/class/visibility/private")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Private extends AbstractWriteFlagsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPrivate() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/class/visibility/private"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("class.kt")
                public void testClass() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/private/class.kt");
                }

                @TestMetadata("enum.kt")
                public void testEnum() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/private/enum.kt");
                }

                @TestMetadata("innerClass.kt")
                public void testInnerClass() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/private/innerClass.kt");
                }

                @TestMetadata("innerEnum.kt")
                public void testInnerEnum() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/private/innerEnum.kt");
                }

                @TestMetadata("innerObject.kt")
                public void testInnerObject() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/private/innerObject.kt");
                }

                @TestMetadata("innerTrait.kt")
                public void testInnerTrait() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/private/innerTrait.kt");
                }

                @TestMetadata("object.kt")
                public void testObject() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/private/object.kt");
                }

                @TestMetadata("trait.kt")
                public void testTrait() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/private/trait.kt");
                }
            }

            @TestMetadata("compiler/testData/writeFlags/class/visibility/public")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Public extends AbstractWriteFlagsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPublic() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/class/visibility/public"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("class.kt")
                public void testClass() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/public/class.kt");
                }

                @TestMetadata("enum.kt")
                public void testEnum() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/public/enum.kt");
                }

                @TestMetadata("innerClass.kt")
                public void testInnerClass() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/public/innerClass.kt");
                }

                @TestMetadata("innerEnum.kt")
                public void testInnerEnum() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/public/innerEnum.kt");
                }

                @TestMetadata("innerObject.kt")
                public void testInnerObject() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/public/innerObject.kt");
                }

                @TestMetadata("innerTrait.kt")
                public void testInnerTrait() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/public/innerTrait.kt");
                }

                @TestMetadata("object.kt")
                public void testObject() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/public/object.kt");
                }

                @TestMetadata("trait.kt")
                public void testTrait() throws Exception {
                    runTest("compiler/testData/writeFlags/class/visibility/public/trait.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/writeFlags/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DelegatedProperty extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/writeFlags/delegatedProperty/visibility")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Visibility extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInVisibility() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/delegatedProperty/visibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("privateSet.kt")
            public void testPrivateSet() throws Exception {
                runTest("compiler/testData/writeFlags/delegatedProperty/visibility/privateSet.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/writeFlags/function")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Function extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/function"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/writeFlags/function/classObjectPrivate")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassObjectPrivate extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassObjectPrivate() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/function/classObjectPrivate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("privateFun.kt")
            public void testPrivateFun() throws Exception {
                runTest("compiler/testData/writeFlags/function/classObjectPrivate/privateFun.kt");
            }

            @TestMetadata("privateVal.kt")
            public void testPrivateVal() throws Exception {
                runTest("compiler/testData/writeFlags/function/classObjectPrivate/privateVal.kt");
            }

            @TestMetadata("privateVar.kt")
            public void testPrivateVar() throws Exception {
                runTest("compiler/testData/writeFlags/function/classObjectPrivate/privateVar.kt");
            }
        }

        @TestMetadata("compiler/testData/writeFlags/function/constructors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructors extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConstructors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/function/constructors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classObject.kt")
            public void testClassObject() throws Exception {
                runTest("compiler/testData/writeFlags/function/constructors/classObject.kt");
            }

            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                runTest("compiler/testData/writeFlags/function/constructors/enum.kt");
            }

            @TestMetadata("objectInClass.kt")
            public void testObjectInClass() throws Exception {
                runTest("compiler/testData/writeFlags/function/constructors/objectInClass.kt");
            }

            @TestMetadata("objectLiteral.kt")
            public void testObjectLiteral() throws Exception {
                runTest("compiler/testData/writeFlags/function/constructors/objectLiteral.kt");
            }

            @TestMetadata("topLevelObject.kt")
            public void testTopLevelObject() throws Exception {
                runTest("compiler/testData/writeFlags/function/constructors/topLevelObject.kt");
            }
        }

        @TestMetadata("compiler/testData/writeFlags/function/deprecatedFlag")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DeprecatedFlag extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDeprecatedFlag() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/function/deprecatedFlag"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("emptyGetter.kt")
            public void testEmptyGetter() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/emptyGetter.kt");
            }

            @TestMetadata("emptySetter.kt")
            public void testEmptySetter() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/emptySetter.kt");
            }

            @TestMetadata("extentionFun.kt")
            public void testExtentionFun() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/extentionFun.kt");
            }

            @TestMetadata("funInClass.kt")
            public void testFunInClass() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/funInClass.kt");
            }

            @TestMetadata("funInClassObject.kt")
            public void testFunInClassObject() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/funInClassObject.kt");
            }

            @TestMetadata("getter.kt")
            public void testGetter() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/getter.kt");
            }

            @TestMetadata("getterAnnotationOnProperty.kt")
            public void testGetterAnnotationOnProperty() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/getterAnnotationOnProperty.kt");
            }

            @TestMetadata("getterForPropertyInConstructor.kt")
            public void testGetterForPropertyInConstructor() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/getterForPropertyInConstructor.kt");
            }

            @TestMetadata("setter.kt")
            public void testSetter() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/setter.kt");
            }

            @TestMetadata("setterAnnotationOnProperty.kt")
            public void testSetterAnnotationOnProperty() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/setterAnnotationOnProperty.kt");
            }

            @TestMetadata("setterForPropertyInConstructor.kt")
            public void testSetterForPropertyInConstructor() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/setterForPropertyInConstructor.kt");
            }

            @TestMetadata("topLevelFun.kt")
            public void testTopLevelFun() throws Exception {
                runTest("compiler/testData/writeFlags/function/deprecatedFlag/topLevelFun.kt");
            }
        }

        @TestMetadata("compiler/testData/writeFlags/function/withDefaultArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class WithDefaultArguments extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWithDefaultArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/function/withDefaultArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("funInClass.kt")
            public void testFunInClass() throws Exception {
                runTest("compiler/testData/writeFlags/function/withDefaultArguments/funInClass.kt");
            }

            @TestMetadata("funInClassObject.kt")
            public void testFunInClassObject() throws Exception {
                runTest("compiler/testData/writeFlags/function/withDefaultArguments/funInClassObject.kt");
            }

            @TestMetadata("inlineOnlyFunInClass.kt")
            public void testInlineOnlyFunInClass() throws Exception {
                runTest("compiler/testData/writeFlags/function/withDefaultArguments/inlineOnlyFunInClass.kt");
            }

            @TestMetadata("reifiedFunInClass.kt")
            public void testReifiedFunInClass() throws Exception {
                runTest("compiler/testData/writeFlags/function/withDefaultArguments/reifiedFunInClass.kt");
            }

            @TestMetadata("topLevelFun.kt")
            public void testTopLevelFun() throws Exception {
                runTest("compiler/testData/writeFlags/function/withDefaultArguments/topLevelFun.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/writeFlags/hidden")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Hidden extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInHidden() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/hidden"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("compiler/testData/writeFlags/hidden/function.kt");
        }

        @TestMetadata("propertyGetter.kt")
        public void testPropertyGetter() throws Exception {
            runTest("compiler/testData/writeFlags/hidden/propertyGetter.kt");
        }

        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            runTest("compiler/testData/writeFlags/hidden/propertySetter.kt");
        }
    }

    @TestMetadata("compiler/testData/writeFlags/inline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inline extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/inline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("lostInnerClass.kt")
        public void testLostInnerClass() throws Exception {
            runTest("compiler/testData/writeFlags/inline/lostInnerClass.kt");
        }

        @TestMetadata("lostInnerClass2.kt")
        public void testLostInnerClass2() throws Exception {
            runTest("compiler/testData/writeFlags/inline/lostInnerClass2.kt");
        }

        @TestMetadata("lostInnerClass3.kt")
        public void testLostInnerClass3() throws Exception {
            runTest("compiler/testData/writeFlags/inline/lostInnerClass3.kt");
        }
    }

    @TestMetadata("compiler/testData/writeFlags/innerClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InnerClass extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInnerClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/innerClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/writeFlags/innerClass/visibility")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Visibility extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInVisibility() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/innerClass/visibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("internal.kt")
            public void testInternal() throws Exception {
                runTest("compiler/testData/writeFlags/innerClass/visibility/internal.kt");
            }

            @TestMetadata("internalClassObject.kt")
            public void testInternalClassObject() throws Exception {
                runTest("compiler/testData/writeFlags/innerClass/visibility/internalClassObject.kt");
            }

            @TestMetadata("private.kt")
            public void testPrivate() throws Exception {
                runTest("compiler/testData/writeFlags/innerClass/visibility/private.kt");
            }

            @TestMetadata("privateClassObject.kt")
            public void testPrivateClassObject() throws Exception {
                runTest("compiler/testData/writeFlags/innerClass/visibility/privateClassObject.kt");
            }

            @TestMetadata("public.kt")
            public void testPublic() throws Exception {
                runTest("compiler/testData/writeFlags/innerClass/visibility/public.kt");
            }

            @TestMetadata("publicClassObject.kt")
            public void testPublicClassObject() throws Exception {
                runTest("compiler/testData/writeFlags/innerClass/visibility/publicClassObject.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/writeFlags/jvm8")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Jvm8 extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInJvm8() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/jvm8"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("interfaceMethod.kt")
        public void testInterfaceMethod() throws Exception {
            runTest("compiler/testData/writeFlags/jvm8/interfaceMethod.kt");
        }

        @TestMetadata("interfaceProperty.kt")
        public void testInterfaceProperty() throws Exception {
            runTest("compiler/testData/writeFlags/jvm8/interfaceProperty.kt");
        }

        @TestMetadata("compiler/testData/writeFlags/jvm8/defaults")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Defaults extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDefaults() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/jvm8/defaults"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("defaultMethod.kt")
            public void testDefaultMethod() throws Exception {
                runTest("compiler/testData/writeFlags/jvm8/defaults/defaultMethod.kt");
            }

            @TestMetadata("defaultProperty.kt")
            public void testDefaultProperty() throws Exception {
                runTest("compiler/testData/writeFlags/jvm8/defaults/defaultProperty.kt");
            }

            @TestMetadata("propertyAnnotation.kt")
            public void testPropertyAnnotation() throws Exception {
                runTest("compiler/testData/writeFlags/jvm8/defaults/propertyAnnotation.kt");
            }

            @TestMetadata("compiler/testData/writeFlags/jvm8/defaults/compatibility")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Compatibility extends AbstractWriteFlagsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCompatibility() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/jvm8/defaults/compatibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("propertyAccessors.kt")
                public void testPropertyAccessors() throws Exception {
                    runTest("compiler/testData/writeFlags/jvm8/defaults/compatibility/propertyAccessors.kt");
                }

                @TestMetadata("propertyAnnotation.kt")
                public void testPropertyAnnotation() throws Exception {
                    runTest("compiler/testData/writeFlags/jvm8/defaults/compatibility/propertyAnnotation.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/writeFlags/lambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Lambda extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/lambda"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("lambdaInInlineFunction.kt")
        public void testLambdaInInlineFunction() throws Exception {
            runTest("compiler/testData/writeFlags/lambda/lambdaInInlineFunction.kt");
        }

        @TestMetadata("simpleLambda.kt")
        public void testSimpleLambda() throws Exception {
            runTest("compiler/testData/writeFlags/lambda/simpleLambda.kt");
        }
    }

    @TestMetadata("compiler/testData/writeFlags/lateinit")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Lateinit extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLateinit() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/lateinit"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("lateinitGetter.kt")
        public void testLateinitGetter() throws Exception {
            runTest("compiler/testData/writeFlags/lateinit/lateinitGetter.kt");
        }

        @TestMetadata("lateinitProperty.kt")
        public void testLateinitProperty() throws Exception {
            runTest("compiler/testData/writeFlags/lateinit/lateinitProperty.kt");
        }

        @TestMetadata("lateinitPropertyNoSetter.kt")
        public void testLateinitPropertyNoSetter() throws Exception {
            runTest("compiler/testData/writeFlags/lateinit/lateinitPropertyNoSetter.kt");
        }
    }

    @TestMetadata("compiler/testData/writeFlags/property")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Property extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/writeFlags/property/classObject")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassObject extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassObject() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/property/classObject"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/writeFlags/property/classObject/class")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Class extends AbstractWriteFlagsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/property/classObject/class"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegatedProtectedVar.kt")
                public void testDelegatedProtectedVar() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/delegatedProtectedVar.kt");
                }

                @TestMetadata("delegatedPublicVal.kt")
                public void testDelegatedPublicVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/delegatedPublicVal.kt");
                }

                @TestMetadata("internalVal.kt")
                public void testInternalVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/internalVal.kt");
                }

                @TestMetadata("internalVar.kt")
                public void testInternalVar() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/internalVar.kt");
                }

                @TestMetadata("internalVarPrivateSet.kt")
                public void testInternalVarPrivateSet() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/internalVarPrivateSet.kt");
                }

                @TestMetadata("noBackingField.kt")
                public void testNoBackingField() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/noBackingField.kt");
                }

                @TestMetadata("privateVal.kt")
                public void testPrivateVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/privateVal.kt");
                }

                @TestMetadata("privateVar.kt")
                public void testPrivateVar() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/privateVar.kt");
                }

                @TestMetadata("protectedVal.kt")
                public void testProtectedVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/protectedVal.kt");
                }

                @TestMetadata("protectedVarPrivateSet.kt")
                public void testProtectedVarPrivateSet() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/protectedVarPrivateSet.kt");
                }

                @TestMetadata("publicVal.kt")
                public void testPublicVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/publicVal.kt");
                }

                @TestMetadata("publicValNonDefault.kt")
                public void testPublicValNonDefault() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/publicValNonDefault.kt");
                }

                @TestMetadata("publicVar.kt")
                public void testPublicVar() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/publicVar.kt");
                }

                @TestMetadata("publicVarNonDefault.kt")
                public void testPublicVarNonDefault() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/publicVarNonDefault.kt");
                }

                @TestMetadata("publicVarPrivateSet.kt")
                public void testPublicVarPrivateSet() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/publicVarPrivateSet.kt");
                }

                @TestMetadata("publicVarProtectedSet.kt")
                public void testPublicVarProtectedSet() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/publicVarProtectedSet.kt");
                }

                @TestMetadata("publicVarPublicSet.kt")
                public void testPublicVarPublicSet() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/class/publicVarPublicSet.kt");
                }
            }

            @TestMetadata("compiler/testData/writeFlags/property/classObject/rename")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Rename extends AbstractWriteFlagsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInRename() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/property/classObject/rename"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("constructorAndClassObject.kt")
                public void testConstructorAndClassObject() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/rename/constructorAndClassObject.kt");
                }

                @TestMetadata("delegatedAndDelegated.kt")
                public void testDelegatedAndDelegated() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/rename/delegatedAndDelegated.kt");
                }

                @TestMetadata("delegatedAndProperty.kt")
                public void testDelegatedAndProperty() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/rename/delegatedAndProperty.kt");
                }

                @TestMetadata("propertyAndProperty.kt")
                public void testPropertyAndProperty() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/rename/propertyAndProperty.kt");
                }
            }

            @TestMetadata("compiler/testData/writeFlags/property/classObject/trait")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Trait extends AbstractWriteFlagsTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTrait() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/property/classObject/trait"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegatedProtectedVar.kt")
                public void testDelegatedProtectedVar() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/delegatedProtectedVar.kt");
                }

                @TestMetadata("delegatedPublicVal.kt")
                public void testDelegatedPublicVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/delegatedPublicVal.kt");
                }

                @TestMetadata("internalConstVal.kt")
                public void testInternalConstVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/internalConstVal.kt");
                }

                @TestMetadata("internalVal.kt")
                public void testInternalVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/internalVal.kt");
                }

                @TestMetadata("internalVar.kt")
                public void testInternalVar() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/internalVar.kt");
                }

                @TestMetadata("internalVarPrivateSet.kt")
                public void testInternalVarPrivateSet() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/internalVarPrivateSet.kt");
                }

                @TestMetadata("noBackingField.kt")
                public void testNoBackingField() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/noBackingField.kt");
                }

                @TestMetadata("privateVal.kt")
                public void testPrivateVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/privateVal.kt");
                }

                @TestMetadata("privateVar.kt")
                public void testPrivateVar() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/privateVar.kt");
                }

                @TestMetadata("protectedConstVal.kt")
                public void testProtectedConstVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/protectedConstVal.kt");
                }

                @TestMetadata("protectedVal.kt")
                public void testProtectedVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/protectedVal.kt");
                }

                @TestMetadata("protectedVarPrivateSet.kt")
                public void testProtectedVarPrivateSet() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/protectedVarPrivateSet.kt");
                }

                @TestMetadata("publicConstVal.kt")
                public void testPublicConstVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/publicConstVal.kt");
                }

                @TestMetadata("publicVal.kt")
                public void testPublicVal() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/publicVal.kt");
                }

                @TestMetadata("publicValNonDefault.kt")
                public void testPublicValNonDefault() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/publicValNonDefault.kt");
                }

                @TestMetadata("publicVar.kt")
                public void testPublicVar() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/publicVar.kt");
                }

                @TestMetadata("publicVarNonDefault.kt")
                public void testPublicVarNonDefault() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/publicVarNonDefault.kt");
                }

                @TestMetadata("publicVarPrivateSet.kt")
                public void testPublicVarPrivateSet() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/publicVarPrivateSet.kt");
                }

                @TestMetadata("publicVarProtectedSet.kt")
                public void testPublicVarProtectedSet() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/publicVarProtectedSet.kt");
                }

                @TestMetadata("publicVarPublicSet.kt")
                public void testPublicVarPublicSet() throws Exception {
                    runTest("compiler/testData/writeFlags/property/classObject/trait/publicVarPublicSet.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/writeFlags/property/deprecatedFlag")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DeprecatedFlag extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDeprecatedFlag() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/property/deprecatedFlag"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("propertyInClass.kt")
            public void testPropertyInClass() throws Exception {
                runTest("compiler/testData/writeFlags/property/deprecatedFlag/propertyInClass.kt");
            }

            @TestMetadata("topLevelProperty.kt")
            public void testTopLevelProperty() throws Exception {
                runTest("compiler/testData/writeFlags/property/deprecatedFlag/topLevelProperty.kt");
            }
        }

        @TestMetadata("compiler/testData/writeFlags/property/syntheticAnnotationsMethod")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SyntheticAnnotationsMethod extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSyntheticAnnotationsMethod() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/property/syntheticAnnotationsMethod"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("privateProperty.kt")
            public void testPrivateProperty() throws Exception {
                runTest("compiler/testData/writeFlags/property/syntheticAnnotationsMethod/privateProperty.kt");
            }

            @TestMetadata("protectedProperty.kt")
            public void testProtectedProperty() throws Exception {
                runTest("compiler/testData/writeFlags/property/syntheticAnnotationsMethod/protectedProperty.kt");
            }

            @TestMetadata("publicProperty.kt")
            public void testPublicProperty() throws Exception {
                runTest("compiler/testData/writeFlags/property/syntheticAnnotationsMethod/publicProperty.kt");
            }
        }

        @TestMetadata("compiler/testData/writeFlags/property/visibility")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Visibility extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInVisibility() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/property/visibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("internal.kt")
            public void testInternal() throws Exception {
                runTest("compiler/testData/writeFlags/property/visibility/internal.kt");
            }

            @TestMetadata("private.kt")
            public void testPrivate() throws Exception {
                runTest("compiler/testData/writeFlags/property/visibility/private.kt");
            }

            @TestMetadata("public.kt")
            public void testPublic() throws Exception {
                runTest("compiler/testData/writeFlags/property/visibility/public.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/writeFlags/typealias")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Typealias extends AbstractWriteFlagsTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTypealias() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/typealias"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/writeFlags/typealias/syntheticAnnotationsMethod")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SyntheticAnnotationsMethod extends AbstractWriteFlagsTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSyntheticAnnotationsMethod() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/writeFlags/typealias/syntheticAnnotationsMethod"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("privateTypealias.kt")
            public void testPrivateTypealias() throws Exception {
                runTest("compiler/testData/writeFlags/typealias/syntheticAnnotationsMethod/privateTypealias.kt");
            }

            @TestMetadata("publicTypealias.kt")
            public void testPublicTypealias() throws Exception {
                runTest("compiler/testData/writeFlags/typealias/syntheticAnnotationsMethod/publicTypealias.kt");
            }
        }
    }
}
