/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.findUsages;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class FindUsagesTestGenerated extends AbstractFindUsagesTest {
    @TestMetadata("idea/testData/findUsages/kotlin")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Kotlin extends AbstractFindUsagesTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInKotlin() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/findUsages/kotlin/companionObject")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompanionObject extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCompanionObject() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/companionObject"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("inContainingClass.0.kt")
            public void testInContainingClass() throws Exception {
                runTest("idea/testData/findUsages/kotlin/companionObject/inContainingClass.0.kt");
            }

            @TestMetadata("javaUsage.0.kt")
            public void testJavaUsage() throws Exception {
                runTest("idea/testData/findUsages/kotlin/companionObject/javaUsage.0.kt");
            }

            @TestMetadata("named.0.kt")
            public void testNamed() throws Exception {
                runTest("idea/testData/findUsages/kotlin/companionObject/named.0.kt");
            }

            @TestMetadata("simple.0.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/findUsages/kotlin/companionObject/simple.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/conventions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Conventions extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConventions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/conventions"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compareTo.0.kt")
            public void testCompareTo() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/compareTo.0.kt");
            }

            @TestMetadata("contains.0.kt")
            public void testContains() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/contains.0.kt");
            }

            @TestMetadata("equals.0.kt")
            public void testEquals() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/equals.0.kt");
            }

            @TestMetadata("equalsNotAny.0.kt")
            public void testEqualsNotAny() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/equalsNotAny.0.kt");
            }

            @TestMetadata("forIteration.0.kt")
            public void testForIteration() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/forIteration.0.kt");
            }

            @TestMetadata("get.0.kt")
            public void testGet() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/get.0.kt");
            }

            @TestMetadata("getAsPropertyDelegate.0.kt")
            public void testGetAsPropertyDelegate() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/getAsPropertyDelegate.0.kt");
            }

            @TestMetadata("inc.0.kt")
            public void testInc() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/inc.0.kt");
            }

            @TestMetadata("invoke.0.kt")
            public void testInvoke() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/invoke.0.kt");
            }

            @TestMetadata("invokeExtension.0.kt")
            public void testInvokeExtension() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/invokeExtension.0.kt");
            }

            @TestMetadata("invokeWithVarArg.0.kt")
            public void testInvokeWithVarArg() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/invokeWithVarArg.0.kt");
            }

            @TestMetadata("plus.0.kt")
            public void testPlus() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/plus.0.kt");
            }

            @TestMetadata("plusAssign.0.kt")
            public void testPlusAssign() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/plusAssign.0.kt");
            }

            @TestMetadata("set.0.kt")
            public void testSet() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/set.0.kt");
            }

            @TestMetadata("setAsPropertyDelegate.0.kt")
            public void testSetAsPropertyDelegate() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/setAsPropertyDelegate.0.kt");
            }

            @TestMetadata("severalOperators.0.kt")
            public void testSeveralOperators() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/severalOperators.0.kt");
            }

            @TestMetadata("unaryMinus.0.kt")
            public void testUnaryMinus() throws Exception {
                runTest("idea/testData/findUsages/kotlin/conventions/unaryMinus.0.kt");
            }

            @TestMetadata("idea/testData/findUsages/kotlin/conventions/components")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Components extends AbstractFindUsagesTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInComponents() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/conventions/components"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("callableReferences.0.kt")
                public void testCallableReferences() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/callableReferences.0.kt");
                }

                @TestMetadata("companionObjectAccess.0.kt")
                public void testCompanionObjectAccess() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/companionObjectAccess.0.kt");
                }

                @TestMetadata("componentFunForGenericType1.0.kt")
                public void testComponentFunForGenericType1() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/componentFunForGenericType1.0.kt");
                }

                @TestMetadata("componentFunForGenericType2.0.kt")
                public void testComponentFunForGenericType2() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/componentFunForGenericType2.0.kt");
                }

                @TestMetadata("dataClass.0.kt")
                public void testDataClass() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/dataClass.0.kt");
                }

                @TestMetadata("dataClassComponentByRef.0.kt")
                public void testDataClassComponentByRef() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/dataClassComponentByRef.0.kt");
                }

                @TestMetadata("dataClassFromStdlib.0.kt")
                public void testDataClassFromStdlib() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/dataClassFromStdlib.0.kt");
                }

                @TestMetadata("dataClassInsideDataClass.0.kt")
                public void testDataClassInsideDataClass() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/dataClassInsideDataClass.0.kt");
                }

                @TestMetadata("extensionComponentFun.0.kt")
                public void testExtensionComponentFun() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/extensionComponentFun.0.kt");
                }

                @TestMetadata("for.0.kt")
                public void testFor() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/for.0.kt");
                }

                @TestMetadata("isAndAs.0.kt")
                public void testIsAndAs() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/isAndAs.0.kt");
                }

                @TestMetadata("lambdas.0.kt")
                public void testLambdas() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/lambdas.0.kt");
                }

                @TestMetadata("mayTypeAffectAncestors.0.kt")
                public void testMayTypeAffectAncestors() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/mayTypeAffectAncestors.0.kt");
                }

                @TestMetadata("memberComponentFun.0.kt")
                public void testMemberComponentFun() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/memberComponentFun.0.kt");
                }

                @TestMetadata("operators.0.kt")
                public void testOperators() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/operators.0.kt");
                }

                @TestMetadata("recursiveDataClass1.0.kt")
                public void testRecursiveDataClass1() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/recursiveDataClass1.0.kt");
                }

                @TestMetadata("recursiveDataClass2.0.kt")
                public void testRecursiveDataClass2() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/recursiveDataClass2.0.kt");
                }

                @TestMetadata("SAM.0.kt")
                public void testSAM() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/SAM.0.kt");
                }

                @TestMetadata("when.0.kt")
                public void testWhen() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/conventions/components/when.0.kt");
                }
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findClassUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindClassUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindClassUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findClassUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classUsedInPlainText.0.kt")
            public void testClassUsedInPlainText() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/classUsedInPlainText.0.kt");
            }

            @TestMetadata("classUsedInTextAsRef.0.kt")
            public void testClassUsedInTextAsRef() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/classUsedInTextAsRef.0.kt");
            }

            @TestMetadata("javaClassAllUsages.0.kt")
            public void testJavaClassAllUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaClassAllUsages.0.kt");
            }

            @TestMetadata("javaClassConstructorUsages.0.kt")
            public void testJavaClassConstructorUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaClassConstructorUsages.0.kt");
            }

            @TestMetadata("javaClassFunctionUsages1.0.kt")
            public void testJavaClassFunctionUsages1() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaClassFunctionUsages1.0.kt");
            }

            @TestMetadata("javaClassFunctionUsages2.0.kt")
            public void testJavaClassFunctionUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaClassFunctionUsages2.0.kt");
            }

            @TestMetadata("javaClassNonConstructorUsages.0.kt")
            public void testJavaClassNonConstructorUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaClassNonConstructorUsages.0.kt");
            }

            @TestMetadata("javaClassPropertyUsages1.0.kt")
            public void testJavaClassPropertyUsages1() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaClassPropertyUsages1.0.kt");
            }

            @TestMetadata("javaClassPropertyUsages2.0.kt")
            public void testJavaClassPropertyUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaClassPropertyUsages2.0.kt");
            }

            @TestMetadata("javaClassSecondaryCtrUsages.0.kt")
            public void testJavaClassSecondaryCtrUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaClassSecondaryCtrUsages.0.kt");
            }

            @TestMetadata("javaDerivedClassUsages1.0.kt")
            public void testJavaDerivedClassUsages1() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaDerivedClassUsages1.0.kt");
            }

            @TestMetadata("javaDerivedClassUsages2.0.kt")
            public void testJavaDerivedClassUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaDerivedClassUsages2.0.kt");
            }

            @TestMetadata("javaDerivedInterfaceUsages1.0.kt")
            public void testJavaDerivedInterfaceUsages1() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaDerivedInterfaceUsages1.0.kt");
            }

            @TestMetadata("javaDerivedInterfaceUsages2.0.kt")
            public void testJavaDerivedInterfaceUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/javaDerivedInterfaceUsages2.0.kt");
            }

            @TestMetadata("kotlinClassAllUsages.0.kt")
            public void testKotlinClassAllUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassAllUsages.0.kt");
            }

            @TestMetadata("kotlinClassAllUsages2.0.kt")
            public void testKotlinClassAllUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassAllUsages2.0.kt");
            }

            @TestMetadata("kotlinClassAllUsages3.0.kt")
            public void testKotlinClassAllUsages3() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassAllUsages3.0.kt");
            }

            @TestMetadata("kotlinClassAllUsagesNoImport.0.kt")
            public void testKotlinClassAllUsagesNoImport() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassAllUsagesNoImport.0.kt");
            }

            @TestMetadata("kotlinClassConstructorUsages.0.kt")
            public void testKotlinClassConstructorUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassConstructorUsages.0.kt");
            }

            @TestMetadata("kotlinClassDerivedAnonymousObjects.0.kt")
            public void testKotlinClassDerivedAnonymousObjects() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedAnonymousObjects.0.kt");
            }

            @TestMetadata("kotlinClassDerivedClasses.0.kt")
            public void testKotlinClassDerivedClasses() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedClasses.0.kt");
            }

            @TestMetadata("kotlinClassDerivedInnerClasses.0.kt")
            public void testKotlinClassDerivedInnerClasses() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedInnerClasses.0.kt");
            }

            @TestMetadata("kotlinClassDerivedInnerObjects.0.kt")
            public void testKotlinClassDerivedInnerObjects() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedInnerObjects.0.kt");
            }

            @TestMetadata("kotlinClassDerivedLocalClasses.0.kt")
            public void testKotlinClassDerivedLocalClasses() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedLocalClasses.0.kt");
            }

            @TestMetadata("kotlinClassDerivedLocalObjects.0.kt")
            public void testKotlinClassDerivedLocalObjects() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedLocalObjects.0.kt");
            }

            @TestMetadata("kotlinClassDerivedLocalTraits.0.kt")
            public void testKotlinClassDerivedLocalTraits() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedLocalTraits.0.kt");
            }

            @TestMetadata("kotlinClassDerivedObjects.0.kt")
            public void testKotlinClassDerivedObjects() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedObjects.0.kt");
            }

            @TestMetadata("kotlinClassDerivedTraits.0.kt")
            public void testKotlinClassDerivedTraits() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedTraits.0.kt");
            }

            @TestMetadata("kotlinClassFunctionUsages1.0.kt")
            public void testKotlinClassFunctionUsages1() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassFunctionUsages1.0.kt");
            }

            @TestMetadata("kotlinClassFunctionUsages2.0.kt")
            public void testKotlinClassFunctionUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassFunctionUsages2.0.kt");
            }

            @TestMetadata("kotlinClassNonConstructorUsages.0.kt")
            public void testKotlinClassNonConstructorUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassNonConstructorUsages.0.kt");
            }

            @TestMetadata("kotlinClassPropertyUsages1.0.kt")
            public void testKotlinClassPropertyUsages1() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassPropertyUsages1.0.kt");
            }

            @TestMetadata("kotlinClassPropertyUsages2.0.kt")
            public void testKotlinClassPropertyUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassPropertyUsages2.0.kt");
            }

            @TestMetadata("kotlinClassSecondaryCtorUsages.0.kt")
            public void testKotlinClassSecondaryCtorUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassSecondaryCtorUsages.0.kt");
            }

            @TestMetadata("kotlinDeeplyNestedClassAllUsages.0.kt")
            public void testKotlinDeeplyNestedClassAllUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinDeeplyNestedClassAllUsages.0.kt");
            }

            @TestMetadata("kotlinInnerClassAllUsages.0.kt")
            public void testKotlinInnerClassAllUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinInnerClassAllUsages.0.kt");
            }

            @TestMetadata("kotlinLocalClassDerivedAnonymousObjects.0.kt")
            public void testKotlinLocalClassDerivedAnonymousObjects() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassDerivedAnonymousObjects.0.kt");
            }

            @TestMetadata("kotlinLocalClassDerivedLocalClasses.0.kt")
            public void testKotlinLocalClassDerivedLocalClasses() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassDerivedLocalClasses.0.kt");
            }

            @TestMetadata("kotlinLocalClassDerivedLocalObjects.0.kt")
            public void testKotlinLocalClassDerivedLocalObjects() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassDerivedLocalObjects.0.kt");
            }

            @TestMetadata("kotlinLocalClassDerivedLocalTraits.0.kt")
            public void testKotlinLocalClassDerivedLocalTraits() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassDerivedLocalTraits.0.kt");
            }

            @TestMetadata("kotlinLocalClassUsages1.0.kt")
            public void testKotlinLocalClassUsages1() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassUsages1.0.kt");
            }

            @TestMetadata("kotlinLocalClassUsages2.0.kt")
            public void testKotlinLocalClassUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassUsages2.0.kt");
            }

            @TestMetadata("kotlinNestedClassAllUsages.0.kt")
            public void testKotlinNestedClassAllUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinNestedClassAllUsages.0.kt");
            }

            @TestMetadata("kotlinPrivateClassUsages.0.kt")
            public void testKotlinPrivateClassUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinPrivateClassUsages.0.kt");
            }

            @TestMetadata("kotlinTraitDerivedAnonymousObjects.0.kt")
            public void testKotlinTraitDerivedAnonymousObjects() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedAnonymousObjects.0.kt");
            }

            @TestMetadata("kotlinTraitDerivedClasses.0.kt")
            public void testKotlinTraitDerivedClasses() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedClasses.0.kt");
            }

            @TestMetadata("kotlinTraitDerivedInnerClasses.0.kt")
            public void testKotlinTraitDerivedInnerClasses() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedInnerClasses.0.kt");
            }

            @TestMetadata("kotlinTraitDerivedInnerObjects.0.kt")
            public void testKotlinTraitDerivedInnerObjects() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedInnerObjects.0.kt");
            }

            @TestMetadata("kotlinTraitDerivedLocalClasses.0.kt")
            public void testKotlinTraitDerivedLocalClasses() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedLocalClasses.0.kt");
            }

            @TestMetadata("kotlinTraitDerivedLocalObjects.0.kt")
            public void testKotlinTraitDerivedLocalObjects() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedLocalObjects.0.kt");
            }

            @TestMetadata("kotlinTraitDerivedLocalTraits.0.kt")
            public void testKotlinTraitDerivedLocalTraits() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedLocalTraits.0.kt");
            }

            @TestMetadata("kotlinTraitDerivedObjects.0.kt")
            public void testKotlinTraitDerivedObjects() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedObjects.0.kt");
            }

            @TestMetadata("kotlinTraitDerivedTraits.0.kt")
            public void testKotlinTraitDerivedTraits() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedTraits.0.kt");
            }

            @TestMetadata("localAndNonLocalClass.0.kt")
            public void testLocalAndNonLocalClass() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/localAndNonLocalClass.0.kt");
            }

            @TestMetadata("primaryConstructorWithDefaultParams.0.kt")
            public void testPrimaryConstructorWithDefaultParams() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/primaryConstructorWithDefaultParams.0.kt");
            }

            @TestMetadata("usageInTypeAlias.0.kt")
            public void testUsageInTypeAlias() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findClassUsages/usageInTypeAlias.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findFunctionUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindFunctionUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindFunctionUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findFunctionUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("enumFunctionUsages.0.kt")
            public void testEnumFunctionUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/enumFunctionUsages.0.kt");
            }

            @TestMetadata("functionUsedInPlainText.0.kt")
            public void testFunctionUsedInPlainText() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/functionUsedInPlainText.0.kt");
            }

            @TestMetadata("highlightingOfSuperUsages.0.kt")
            public void testHighlightingOfSuperUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/highlightingOfSuperUsages.0.kt");
            }

            @TestMetadata("javaAndKotlinOverrides.0.kt")
            public void testJavaAndKotlinOverrides() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/javaAndKotlinOverrides.0.kt");
            }

            @TestMetadata("javaMethodUsages.0.kt")
            public void testJavaMethodUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/javaMethodUsages.0.kt");
            }

            @TestMetadata("jvmOverloaded.0.kt")
            public void testJvmOverloaded() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/jvmOverloaded.0.kt");
            }

            @TestMetadata("jvmStaticFun.0.kt")
            public void testJvmStaticFun() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/jvmStaticFun.0.kt");
            }

            @TestMetadata("jvmStaticJvmOverloadsFun.0.kt")
            public void testJvmStaticJvmOverloadsFun() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/jvmStaticJvmOverloadsFun.0.kt");
            }

            @TestMetadata("kotlinInternalMethodUsages.0.kt")
            public void testKotlinInternalMethodUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinInternalMethodUsages.0.kt");
            }

            @TestMetadata("kotlinLocalMethodUsages1.0.kt")
            public void testKotlinLocalMethodUsages1() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinLocalMethodUsages1.0.kt");
            }

            @TestMetadata("kotlinLocalMethodUsages2.0.kt")
            public void testKotlinLocalMethodUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinLocalMethodUsages2.0.kt");
            }

            @TestMetadata("kotlinMethodUsages.0.kt")
            public void testKotlinMethodUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinMethodUsages.0.kt");
            }

            @TestMetadata("kotlinMultiRefInImport.0.kt")
            public void testKotlinMultiRefInImport() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinMultiRefInImport.0.kt");
            }

            @TestMetadata("kotlinNestedClassMethodUsages.0.kt")
            public void testKotlinNestedClassMethodUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinNestedClassMethodUsages.0.kt");
            }

            @TestMetadata("kotlinOverloadAndExtensionUsages.0.kt")
            public void testKotlinOverloadAndExtensionUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinOverloadAndExtensionUsages.0.kt");
            }

            @TestMetadata("kotlinOverloadAndExtensionUsages2.0.kt")
            public void testKotlinOverloadAndExtensionUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinOverloadAndExtensionUsages2.0.kt");
            }

            @TestMetadata("kotlinPrivateMethodUsages.0.kt")
            public void testKotlinPrivateMethodUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinPrivateMethodUsages.0.kt");
            }

            @TestMetadata("kotlinTopLevelMethodUsages.0.kt")
            public void testKotlinTopLevelMethodUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTopLevelMethodUsages.0.kt");
            }

            @TestMetadata("kotlinTopLevelMethodUsagesMultifile.0.kt")
            public void testKotlinTopLevelMethodUsagesMultifile() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTopLevelMethodUsagesMultifile.0.kt");
            }

            @TestMetadata("kotlinTopLevelMethodUsagesNoImport.0.kt")
            public void testKotlinTopLevelMethodUsagesNoImport() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTopLevelMethodUsagesNoImport.0.kt");
            }

            @TestMetadata("kotlinTopLevelMethodUsagesWithRenamedFile.0.kt")
            public void testKotlinTopLevelMethodUsagesWithRenamedFile() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTopLevelMethodUsagesWithRenamedFile.0.kt");
            }

            @TestMetadata("kotlinTraitImplThroughDelegate.0.kt")
            public void testKotlinTraitImplThroughDelegate() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTraitImplThroughDelegate.0.kt");
            }

            @TestMetadata("kotlinTraitNoImplThroughDelegate.0.kt")
            public void testKotlinTraitNoImplThroughDelegate() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTraitNoImplThroughDelegate.0.kt");
            }

            @TestMetadata("labeledReturns.0.kt")
            public void testLabeledReturns() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/labeledReturns.0.kt");
            }

            @TestMetadata("localClassMember.0.kt")
            public void testLocalClassMember() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/localClassMember.0.kt");
            }

            @TestMetadata("objectExpressionDeepMember.0.kt")
            public void testObjectExpressionDeepMember() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/objectExpressionDeepMember.0.kt");
            }

            @TestMetadata("objectExpressionMember.0.kt")
            public void testObjectExpressionMember() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/objectExpressionMember.0.kt");
            }

            @TestMetadata("objectExpressionMember2.0.kt")
            public void testObjectExpressionMember2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/objectExpressionMember2.0.kt");
            }

            @TestMetadata("objectExpressionMemberInClass.0.kt")
            public void testObjectExpressionMemberInClass() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/objectExpressionMemberInClass.0.kt");
            }

            @TestMetadata("synthesizedFunction.0.kt")
            public void testSynthesizedFunction() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/synthesizedFunction.0.kt");
            }

            @TestMetadata("usagesOfBaseForFunction.0.kt")
            public void testUsagesOfBaseForFunction() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findFunctionUsages/usagesOfBaseForFunction.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findJavaPropertyUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindJavaPropertyUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindJavaPropertyUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findJavaPropertyUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaPropertyUsagesK.0.kt")
            public void testJavaPropertyUsagesK() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findJavaPropertyUsages/javaPropertyUsagesK.0.kt");
            }

            @TestMetadata("javaPropertyUsagesKJK.0.kt")
            public void testJavaPropertyUsagesKJK() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findJavaPropertyUsages/javaPropertyUsagesKJK.0.kt");
            }

            @TestMetadata("javaPropertyUsagesKK.0.kt")
            public void testJavaPropertyUsagesKK() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findJavaPropertyUsages/javaPropertyUsagesKK.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findObjectUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindObjectUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindObjectUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findObjectUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaObjectUsages.0.kt")
            public void testJavaObjectUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findObjectUsages/javaObjectUsages.0.kt");
            }

            @TestMetadata("kotlinImportedObjectUsages.0.kt")
            public void testKotlinImportedObjectUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findObjectUsages/kotlinImportedObjectUsages.0.kt");
            }

            @TestMetadata("kotlinLocalObjectUsages1.0.kt")
            public void testKotlinLocalObjectUsages1() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findObjectUsages/kotlinLocalObjectUsages1.0.kt");
            }

            @TestMetadata("kotlinLocalObjectUsages2.0.kt")
            public void testKotlinLocalObjectUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findObjectUsages/kotlinLocalObjectUsages2.0.kt");
            }

            @TestMetadata("kotlinNestedObjectUsages.0.kt")
            public void testKotlinNestedObjectUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findObjectUsages/kotlinNestedObjectUsages.0.kt");
            }

            @TestMetadata("kotlinObjectUsages.0.kt")
            public void testKotlinObjectUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findObjectUsages/kotlinObjectUsages.0.kt");
            }

            @TestMetadata("kotlinPrivateObjectUsages.0.kt")
            public void testKotlinPrivateObjectUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findObjectUsages/kotlinPrivateObjectUsages.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findPackageUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindPackageUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindPackageUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findPackageUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kotlinPackageUsages.0.kt")
            public void testKotlinPackageUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPackageUsages/kotlinPackageUsages.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findParameterUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindParameterUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindParameterUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findParameterUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kotlinAnnotationConstructorParameterUsages.0.kt")
            public void testKotlinAnnotationConstructorParameterUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findParameterUsages/kotlinAnnotationConstructorParameterUsages.0.kt");
            }

            @TestMetadata("kotlinComponentFunctionParameterUsages.0.kt")
            public void testKotlinComponentFunctionParameterUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findParameterUsages/kotlinComponentFunctionParameterUsages.0.kt");
            }

            @TestMetadata("kotlinConstructorParameterUsages.0.kt")
            public void testKotlinConstructorParameterUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findParameterUsages/kotlinConstructorParameterUsages.0.kt");
            }

            @TestMetadata("kotlinDefaultAnnotationParameterUsages.0.kt")
            public void testKotlinDefaultAnnotationParameterUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findParameterUsages/kotlinDefaultAnnotationParameterUsages.0.kt");
            }

            @TestMetadata("kotlinFunctionParameterUsages.0.kt")
            public void testKotlinFunctionParameterUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findParameterUsages/kotlinFunctionParameterUsages.0.kt");
            }

            @TestMetadata("kotlinHighlightParameterUsages.0.kt")
            public void testKotlinHighlightParameterUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findParameterUsages/kotlinHighlightParameterUsages.0.kt");
            }

            @TestMetadata("parameterNameInTextFile.0.kt")
            public void testParameterNameInTextFile() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findParameterUsages/parameterNameInTextFile.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindPrimaryConstructorUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindPrimaryConstructorUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotationEntry.0.kt")
            public void testAnnotationEntry() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/annotationEntry.0.kt");
            }

            @TestMetadata("constructorCall.0.kt")
            public void testConstructorCall() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/constructorCall.0.kt");
            }

            @TestMetadata("jvmOverloaded.0.kt")
            public void testJvmOverloaded() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/jvmOverloaded.0.kt");
            }

            @TestMetadata("missingName.0.kt")
            public void testMissingName() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/missingName.0.kt");
            }

            @TestMetadata("primaryConstructorByRef.0.kt")
            public void testPrimaryConstructorByRef() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/primaryConstructorByRef.0.kt");
            }

            @TestMetadata("primaryConstructorNoKeyword.0.kt")
            public void testPrimaryConstructorNoKeyword() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/primaryConstructorNoKeyword.0.kt");
            }

            @TestMetadata("primaryConstructorWithKeyword.0.kt")
            public void testPrimaryConstructorWithKeyword() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/primaryConstructorWithKeyword.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findPropertyUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindPropertyUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindPropertyUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findPropertyUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("extensionPropertyUsages.0.kt")
            public void testExtensionPropertyUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/extensionPropertyUsages.0.kt");
            }

            @TestMetadata("javaAndKotlinOverrides.0.kt")
            public void testJavaAndKotlinOverrides() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/javaAndKotlinOverrides.0.kt");
            }

            @TestMetadata("javaAndKotlinOverrides2.0.kt")
            public void testJavaAndKotlinOverrides2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/javaAndKotlinOverrides2.0.kt");
            }

            @TestMetadata("javaClassObjectPropertyUsages.0.kt")
            public void testJavaClassObjectPropertyUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/javaClassObjectPropertyUsages.0.kt");
            }

            @TestMetadata("javaPropertyReadUsages.0.kt")
            public void testJavaPropertyReadUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyReadUsages.0.kt");
            }

            @TestMetadata("javaPropertyReadUsages2.0.kt")
            public void testJavaPropertyReadUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyReadUsages2.0.kt");
            }

            @TestMetadata("javaPropertyUsages.0.kt")
            public void testJavaPropertyUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyUsages.0.kt");
            }

            @TestMetadata("javaPropertyUsages2.0.kt")
            public void testJavaPropertyUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyUsages2.0.kt");
            }

            @TestMetadata("javaPropertyWriteUsages.0.kt")
            public void testJavaPropertyWriteUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyWriteUsages.0.kt");
            }

            @TestMetadata("javaPropertyWriteUsages2.0.kt")
            public void testJavaPropertyWriteUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyWriteUsages2.0.kt");
            }

            @TestMetadata("jvmStaticProperty.0.kt")
            public void testJvmStaticProperty() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/jvmStaticProperty.0.kt");
            }

            @TestMetadata("kotlinClassObjectPropertyUsage.0.kt")
            public void testKotlinClassObjectPropertyUsage() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinClassObjectPropertyUsage.0.kt");
            }

            @TestMetadata("kotlinLocalPropertyUsages1.0.kt")
            public void testKotlinLocalPropertyUsages1() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinLocalPropertyUsages1.0.kt");
            }

            @TestMetadata("kotlinLocalPropertyUsages2.0.kt")
            public void testKotlinLocalPropertyUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinLocalPropertyUsages2.0.kt");
            }

            @TestMetadata("kotlinMultiRefInImport.0.kt")
            public void testKotlinMultiRefInImport() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinMultiRefInImport.0.kt");
            }

            @TestMetadata("kotlinNestedClassPropertyUsages.0.kt")
            public void testKotlinNestedClassPropertyUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinNestedClassPropertyUsages.0.kt");
            }

            @TestMetadata("kotlinPrivatePropertyInClassObjectUsages.0.kt")
            public void testKotlinPrivatePropertyInClassObjectUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPrivatePropertyInClassObjectUsages.0.kt");
            }

            @TestMetadata("kotlinPrivatePropertyUsages.0.kt")
            public void testKotlinPrivatePropertyUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPrivatePropertyUsages.0.kt");
            }

            @TestMetadata("kotlinPrivatePropertyUsages2.0.kt")
            public void testKotlinPrivatePropertyUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPrivatePropertyUsages2.0.kt");
            }

            @TestMetadata("kotlinPropertyReadUsages.0.kt")
            public void testKotlinPropertyReadUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyReadUsages.0.kt");
            }

            @TestMetadata("kotlinPropertyReadUsages2.0.kt")
            public void testKotlinPropertyReadUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyReadUsages2.0.kt");
            }

            @TestMetadata("kotlinPropertySameNameAsMethodUsages.0.kt")
            public void testKotlinPropertySameNameAsMethodUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertySameNameAsMethodUsages.0.kt");
            }

            @TestMetadata("kotlinPropertyUsages.0.kt")
            public void testKotlinPropertyUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyUsages.0.kt");
            }

            @TestMetadata("kotlinPropertyUsages2.0.kt")
            public void testKotlinPropertyUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyUsages2.0.kt");
            }

            @TestMetadata("kotlinPropertyWriteUsages.0.kt")
            public void testKotlinPropertyWriteUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyWriteUsages.0.kt");
            }

            @TestMetadata("kotlinPropertyWriteUsages2.0.kt")
            public void testKotlinPropertyWriteUsages2() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyWriteUsages2.0.kt");
            }

            @TestMetadata("kotlinTopLevelPropertyUsages.0.kt")
            public void testKotlinTopLevelPropertyUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinTopLevelPropertyUsages.0.kt");
            }

            @TestMetadata("kt7656.0.kt")
            public void testKt7656() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findPropertyUsages/kt7656.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindSecondaryConstructorUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindSecondaryConstructorUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("constructorCall.0.kt")
            public void testConstructorCall() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages/constructorCall.0.kt");
            }

            @TestMetadata("defaultSecondaryConstructor.0.kt")
            public void testDefaultSecondaryConstructor() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages/defaultSecondaryConstructor.0.kt");
            }

            @TestMetadata("jvmOverloaded.0.kt")
            public void testJvmOverloaded() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages/jvmOverloaded.0.kt");
            }

            @TestMetadata("secondaryConstructor.0.kt")
            public void testSecondaryConstructor() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages/secondaryConstructor.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findTypeAliasUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindTypeAliasUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindTypeAliasUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findTypeAliasUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("objectAlias.0.kt")
            public void testObjectAlias() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findTypeAliasUsages/objectAlias.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findTypeParameterUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindTypeParameterUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindTypeParameterUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findTypeParameterUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kotlinClassTypeParameterUsages.0.kt")
            public void testKotlinClassTypeParameterUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findTypeParameterUsages/kotlinClassTypeParameterUsages.0.kt");
            }

            @TestMetadata("kotlinFunctionTypeParameterUsages.0.kt")
            public void testKotlinFunctionTypeParameterUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findTypeParameterUsages/kotlinFunctionTypeParameterUsages.0.kt");
            }

            @TestMetadata("propertyWithTypeParameter.0.kt")
            public void testPropertyWithTypeParameter() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findTypeParameterUsages/propertyWithTypeParameter.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findWithFilteringImports")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindWithFilteringImports extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindWithFilteringImports() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findWithFilteringImports"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("findWithFilteringImports.0.kt")
            public void testFindWithFilteringImports() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findWithFilteringImports/findWithFilteringImports.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findWithStructuralGrouping")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindWithStructuralGrouping extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindWithStructuralGrouping() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findWithStructuralGrouping"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kotlinClassAllUsages.0.kt")
            public void testKotlinClassAllUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findWithStructuralGrouping/kotlinClassAllUsages.0.kt");
            }

            @TestMetadata("kotlinMethodUsages.0.kt")
            public void testKotlinMethodUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findWithStructuralGrouping/kotlinMethodUsages.0.kt");
            }

            @TestMetadata("kotlinPropertyUsages.0.kt")
            public void testKotlinPropertyUsages() throws Exception {
                runTest("idea/testData/findUsages/kotlin/findWithStructuralGrouping/kotlinPropertyUsages.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/internal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Internal extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInternal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/internal"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/findUsages/kotlin/internal/findFunctionUsages")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FindFunctionUsages extends AbstractFindUsagesTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFindFunctionUsages() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/internal/findFunctionUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("enumFunctionUsages.0.kt")
                public void testEnumFunctionUsages() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findFunctionUsages/enumFunctionUsages.0.kt");
                }

                @TestMetadata("kotlinMethodUsages.0.kt")
                public void testKotlinMethodUsages() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findFunctionUsages/kotlinMethodUsages.0.kt");
                }

                @TestMetadata("kotlinMultiRefInImport.0.kt")
                public void testKotlinMultiRefInImport() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findFunctionUsages/kotlinMultiRefInImport.0.kt");
                }

                @TestMetadata("kotlinOverloadAndExtensionUsages.0.kt")
                public void testKotlinOverloadAndExtensionUsages() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findFunctionUsages/kotlinOverloadAndExtensionUsages.0.kt");
                }

                @TestMetadata("kotlinTopLevelMethodUsages.0.kt")
                public void testKotlinTopLevelMethodUsages() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findFunctionUsages/kotlinTopLevelMethodUsages.0.kt");
                }

                @TestMetadata("kotlinTraitImplThroughDelegate.0.kt")
                public void testKotlinTraitImplThroughDelegate() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findFunctionUsages/kotlinTraitImplThroughDelegate.0.kt");
                }

                @TestMetadata("usagesOfBaseForFunction.0.kt")
                public void testUsagesOfBaseForFunction() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findFunctionUsages/usagesOfBaseForFunction.0.kt");
                }
            }

            @TestMetadata("idea/testData/findUsages/kotlin/internal/findPrimaryConstructorUsages")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FindPrimaryConstructorUsages extends AbstractFindUsagesTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFindPrimaryConstructorUsages() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/internal/findPrimaryConstructorUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("constructorCall.0.kt")
                public void testConstructorCall() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findPrimaryConstructorUsages/constructorCall.0.kt");
                }

                @TestMetadata("primaryConstructorByRef.0.kt")
                public void testPrimaryConstructorByRef() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findPrimaryConstructorUsages/primaryConstructorByRef.0.kt");
                }
            }

            @TestMetadata("idea/testData/findUsages/kotlin/internal/findPropertyUsages")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FindPropertyUsages extends AbstractFindUsagesTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFindPropertyUsages() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/internal/findPropertyUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kotlinClassObjectPropertyUsage.0.kt")
                public void testKotlinClassObjectPropertyUsage() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findPropertyUsages/kotlinClassObjectPropertyUsage.0.kt");
                }

                @TestMetadata("kotlinMultiRefInImport.0.kt")
                public void testKotlinMultiRefInImport() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findPropertyUsages/kotlinMultiRefInImport.0.kt");
                }

                @TestMetadata("kotlinPropertyUsages.0.kt")
                public void testKotlinPropertyUsages() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findPropertyUsages/kotlinPropertyUsages.0.kt");
                }

                @TestMetadata("kotlinTopLevelPropertyUsages.0.kt")
                public void testKotlinTopLevelPropertyUsages() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findPropertyUsages/kotlinTopLevelPropertyUsages.0.kt");
                }
            }

            @TestMetadata("idea/testData/findUsages/kotlin/internal/findSecondaryConstructorUsages")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FindSecondaryConstructorUsages extends AbstractFindUsagesTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFindSecondaryConstructorUsages() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/internal/findSecondaryConstructorUsages"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("constructorCall.0.kt")
                public void testConstructorCall() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findSecondaryConstructorUsages/constructorCall.0.kt");
                }

                @TestMetadata("defaultSecondaryConstructor.0.kt")
                public void testDefaultSecondaryConstructor() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findSecondaryConstructorUsages/defaultSecondaryConstructor.0.kt");
                }

                @TestMetadata("secondaryConstructor.0.kt")
                public void testSecondaryConstructor() throws Exception {
                    runTest("idea/testData/findUsages/kotlin/internal/findSecondaryConstructorUsages/secondaryConstructor.0.kt");
                }
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/propertyFiles")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PropertyFiles extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInPropertyFiles() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/propertyFiles"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("propertyFileUsagesByRef.0.kt")
            public void testPropertyFileUsagesByRef() throws Exception {
                runTest("idea/testData/findUsages/kotlin/propertyFiles/propertyFileUsagesByRef.0.kt");
            }

            @TestMetadata("propertyUsagesByRef.0.kt")
            public void testPropertyUsagesByRef() throws Exception {
                runTest("idea/testData/findUsages/kotlin/propertyFiles/propertyUsagesByRef.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/script")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Script extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInScript() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/script"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("anonymousObject.0.kts")
            public void testAnonymousObject() throws Exception {
                runTest("idea/testData/findUsages/kotlin/script/anonymousObject.0.kts");
            }

            @TestMetadata("anonymousObjectAsInitializer.0.kts")
            public void testAnonymousObjectAsInitializer() throws Exception {
                runTest("idea/testData/findUsages/kotlin/script/anonymousObjectAsInitializer.0.kts");
            }

            @TestMetadata("anonymousObjectInFun.0.kts")
            public void testAnonymousObjectInFun() throws Exception {
                runTest("idea/testData/findUsages/kotlin/script/anonymousObjectInFun.0.kts");
            }

            @TestMetadata("dummy.0.kts")
            public void testDummy() throws Exception {
                runTest("idea/testData/findUsages/kotlin/script/dummy.0.kts");
            }

            @TestMetadata("localClass.0.kts")
            public void testLocalClass() throws Exception {
                runTest("idea/testData/findUsages/kotlin/script/localClass.0.kts");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/unresolvedAnnotation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class UnresolvedAnnotation extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInUnresolvedAnnotation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/unresolvedAnnotation"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("unresolvedAnnotation.0.kt")
            public void testUnresolvedAnnotation() throws Exception {
                runTest("idea/testData/findUsages/kotlin/unresolvedAnnotation/unresolvedAnnotation.0.kt");
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/variable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Variable extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInVariable() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/variable"), Pattern.compile("^(.+)\\.0\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("plusAssignFun.0.kt")
            public void testPlusAssignFun() throws Exception {
                runTest("idea/testData/findUsages/kotlin/variable/plusAssignFun.0.kt");
            }

            @TestMetadata("readAccess.0.kt")
            public void testReadAccess() throws Exception {
                runTest("idea/testData/findUsages/kotlin/variable/readAccess.0.kt");
            }

            @TestMetadata("varInDoWhile.0.kt")
            public void testVarInDoWhile() throws Exception {
                runTest("idea/testData/findUsages/kotlin/variable/varInDoWhile.0.kt");
            }

            @TestMetadata("writeAccess.0.kt")
            public void testWriteAccess() throws Exception {
                runTest("idea/testData/findUsages/kotlin/variable/writeAccess.0.kt");
            }
        }
    }

    @TestMetadata("idea/testData/findUsages/java")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Java extends AbstractFindUsagesTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/findUsages/java/findConstructorUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindConstructorUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindConstructorUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java/findConstructorUsages"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaConstructorInDelegationCall.0.java")
            public void testJavaConstructorInDelegationCall() throws Exception {
                runTest("idea/testData/findUsages/java/findConstructorUsages/javaConstructorInDelegationCall.0.java");
            }

            @TestMetadata("javaDefaultConstructorInDelegationCall.0.java")
            public void testJavaDefaultConstructorInDelegationCall() throws Exception {
                runTest("idea/testData/findUsages/java/findConstructorUsages/javaDefaultConstructorInDelegationCall.0.java");
            }

            @TestMetadata("primaryConstructorByJavaRef.0.java")
            public void testPrimaryConstructorByJavaRef() throws Exception {
                runTest("idea/testData/findUsages/java/findConstructorUsages/primaryConstructorByJavaRef.0.java");
            }

            @TestMetadata("primaryConstructorByJavaSuperRef.0.java")
            public void testPrimaryConstructorByJavaSuperRef() throws Exception {
                runTest("idea/testData/findUsages/java/findConstructorUsages/primaryConstructorByJavaSuperRef.0.java");
            }

            @TestMetadata("secondaryConstructorByJavaNewExpression.0.java")
            public void testSecondaryConstructorByJavaNewExpression() throws Exception {
                runTest("idea/testData/findUsages/java/findConstructorUsages/secondaryConstructorByJavaNewExpression.0.java");
            }

            @TestMetadata("secondaryConstructorByJavaSuperCall.0.java")
            public void testSecondaryConstructorByJavaSuperCall() throws Exception {
                runTest("idea/testData/findUsages/java/findConstructorUsages/secondaryConstructorByJavaSuperCall.0.java");
            }
        }

        @TestMetadata("idea/testData/findUsages/java/findJavaClassUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindJavaClassUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindJavaClassUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java/findJavaClassUsages"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("JKClassAllUsages.0.java")
            public void testJKClassAllUsages() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassAllUsages.0.java");
            }

            @TestMetadata("JKClassDerivedAnonymousObjects.0.java")
            public void testJKClassDerivedAnonymousObjects() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedAnonymousObjects.0.java");
            }

            @TestMetadata("JKClassDerivedClasses.0.java")
            public void testJKClassDerivedClasses() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedClasses.0.java");
            }

            @TestMetadata("JKClassDerivedInnerClasses.0.java")
            public void testJKClassDerivedInnerClasses() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedInnerClasses.0.java");
            }

            @TestMetadata("JKClassDerivedInnerObjects.0.java")
            public void testJKClassDerivedInnerObjects() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedInnerObjects.0.java");
            }

            @TestMetadata("JKClassDerivedLocalClasses.0.java")
            public void testJKClassDerivedLocalClasses() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedLocalClasses.0.java");
            }

            @TestMetadata("JKClassDerivedLocalObjects.0.java")
            public void testJKClassDerivedLocalObjects() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedLocalObjects.0.java");
            }

            @TestMetadata("JKClassDerivedObjects.0.java")
            public void testJKClassDerivedObjects() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedObjects.0.java");
            }

            @TestMetadata("JKClassFieldsUsages.0.java")
            public void testJKClassFieldsUsages() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassFieldsUsages.0.java");
            }

            @TestMetadata("JKClassMethodsUsages.0.java")
            public void testJKClassMethodsUsages() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassMethodsUsages.0.java");
            }

            @TestMetadata("JKClassWithImplicitConstructorAllUsages.0.java")
            public void testJKClassWithImplicitConstructorAllUsages() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKClassWithImplicitConstructorAllUsages.0.java");
            }

            @TestMetadata("JKDerivedInterfaces.0.java")
            public void testJKDerivedInterfaces() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKDerivedInterfaces.0.java");
            }

            @TestMetadata("JKInnerClassAllUsages.0.java")
            public void testJKInnerClassAllUsages() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKInnerClassAllUsages.0.java");
            }

            @TestMetadata("JKInterfaceDerivedAnonymousObjects.0.java")
            public void testJKInterfaceDerivedAnonymousObjects() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedAnonymousObjects.0.java");
            }

            @TestMetadata("JKInterfaceDerivedClasses.0.java")
            public void testJKInterfaceDerivedClasses() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedClasses.0.java");
            }

            @TestMetadata("JKInterfaceDerivedInnerClasses.0.java")
            public void testJKInterfaceDerivedInnerClasses() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedInnerClasses.0.java");
            }

            @TestMetadata("JKInterfaceDerivedInnerObjects.0.java")
            public void testJKInterfaceDerivedInnerObjects() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedInnerObjects.0.java");
            }

            @TestMetadata("JKInterfaceDerivedLocalClasses.0.java")
            public void testJKInterfaceDerivedLocalClasses() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedLocalClasses.0.java");
            }

            @TestMetadata("JKInterfaceDerivedLocalObjects.0.java")
            public void testJKInterfaceDerivedLocalObjects() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedLocalObjects.0.java");
            }

            @TestMetadata("JKInterfaceDerivedLocalTraits.0.java")
            public void testJKInterfaceDerivedLocalTraits() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedLocalTraits.0.java");
            }

            @TestMetadata("JKInterfaceDerivedObjects.0.java")
            public void testJKInterfaceDerivedObjects() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedObjects.0.java");
            }

            @TestMetadata("JKNestedClassAllUsages.0.java")
            public void testJKNestedClassAllUsages() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaClassUsages/JKNestedClassAllUsages.0.java");
            }
        }

        @TestMetadata("idea/testData/findUsages/java/findJavaFieldUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindJavaFieldUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindJavaFieldUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java/findJavaFieldUsages"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("JKFieldUsages.0.java")
            public void testJKFieldUsages() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaFieldUsages/JKFieldUsages.0.java");
            }
        }

        @TestMetadata("idea/testData/findUsages/java/findJavaMethodUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindJavaMethodUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindJavaMethodUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java/findJavaMethodUsages"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ConventionUsages.0.java")
            public void testConventionUsages() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/ConventionUsages.0.java");
            }

            @TestMetadata("defaultJavaAnnotationMethodUsages.0.java")
            public void testDefaultJavaAnnotationMethodUsages() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/defaultJavaAnnotationMethodUsages.0.java");
            }

            @TestMetadata("JKMethodOverrides.0.java")
            public void testJKMethodOverrides() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/JKMethodOverrides.0.java");
            }

            @TestMetadata("JKMethodUsages.0.java")
            public void testJKMethodUsages() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/JKMethodUsages.0.java");
            }

            @TestMetadata("javaComponentFunctions.0.java")
            public void testJavaComponentFunctions() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/javaComponentFunctions.0.java");
            }

            @TestMetadata("javaInvoke.0.java")
            public void testJavaInvoke() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/javaInvoke.0.java");
            }

            @TestMetadata("javaInvokeWithStaticImport.0.java")
            public void testJavaInvokeWithStaticImport() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/javaInvokeWithStaticImport.0.java");
            }

            @TestMetadata("JavaWithGroovyInvoke.0.java")
            public void testJavaWithGroovyInvoke() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/JavaWithGroovyInvoke.0.java");
            }

            @TestMetadata("MismatchedAccessor.0.java")
            public void testMismatchedAccessor() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/MismatchedAccessor.0.java");
            }

            @TestMetadata("OverriddenMethodSyntheticAccessor.0.java")
            public void testOverriddenMethodSyntheticAccessor() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/OverriddenMethodSyntheticAccessor.0.java");
            }

            @TestMetadata("SyntheticProperties.0.java")
            public void testSyntheticProperties() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/SyntheticProperties.0.java");
            }

            @TestMetadata("UnaryNot.0.java")
            public void testUnaryNot() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaMethodUsages/UnaryNot.0.java");
            }
        }

        @TestMetadata("idea/testData/findUsages/java/findJavaPropertyUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindJavaPropertyUsages extends AbstractFindUsagesTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFindJavaPropertyUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java/findJavaPropertyUsages"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaPropertyGetterUsagesKJ.0.java")
            public void testJavaPropertyGetterUsagesKJ() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaPropertyUsages/javaPropertyGetterUsagesKJ.0.java");
            }

            @TestMetadata("javaPropertySetterUsagesKJ.0.java")
            public void testJavaPropertySetterUsagesKJ() throws Exception {
                runTest("idea/testData/findUsages/java/findJavaPropertyUsages/javaPropertySetterUsagesKJ.0.java");
            }
        }
    }

    @TestMetadata("idea/testData/findUsages/propertyFiles")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PropertyFiles extends AbstractFindUsagesTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInPropertyFiles() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/propertyFiles"), Pattern.compile("^(.+)\\.0\\.properties$"), TargetBackend.ANY, true);
        }

        @TestMetadata("propertyFileUsages.0.properties")
        public void testPropertyFileUsages() throws Exception {
            runTest("idea/testData/findUsages/propertyFiles/propertyFileUsages.0.properties");
        }

        @TestMetadata("propertyUsages.0.properties")
        public void testPropertyUsages() throws Exception {
            runTest("idea/testData/findUsages/propertyFiles/propertyUsages.0.properties");
        }
    }
}
