
description = "Kotlin SamWithReceiver Compiler Plugin"

plugins {
    kotlin("jvm")
    id("jps-compatible")
}

dependencies {
    compileOnly(project(":compiler:frontend"))
    compileOnly(project(":compiler:frontend.java"))
    compileOnly(project(":compiler:plugin-api"))
    compileOnly(intellijCoreDep()) { includeJars("intellij-core") }

    testCompile(project(":compiler:backend"))
    testCompile(project(":compiler:cli"))
    testCompile(projectTests(":compiler:tests-common"))
    testCompile(commonDep("junit:junit"))
}

sourceSets {
    "main" { projectDefault() }
    "test" { projectDefault() }
}

publish()

val jar = runtimeJar {}
sourcesJar()
javadocJar()
testsJar {}

dist {
    rename("kotlin-", "")
}

ideaPlugin {
    from(jar)
}

projectTest {
    dependsOn(":kotlin-stdlib:jvm-minimal-for-test:dist")
    workingDir = rootDir
}
