/*
 * @(#)InterruptEUTest.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.junit.v1;

//import net.sourceforge.groboutils.testing.junitlog.v1.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.io.IOException;
import java.lang.reflect.Method;


/**
 * Tests the behavior of the Thread.interrupt() and InterruptedException
 * in threaded and non-threaded environments.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     July 15, 2003
 * @version   $Date: 2004/04/09 19:26:52 $
 */
public class InterruptEUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = InterruptEUTest.class;
    
    public InterruptEUTest( String name )
    {
        super( name );
    }

    


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testNonThreadedInterrupt1()
    {
        Thread.currentThread().interrupt();
        assertTrue(
            "Current thread is interrupted.",
            Thread.interrupted() );
        assertFalse(
            "Interrupt was not cleared",
            Thread.interrupted() );
    }
    
    
    public void testNonThreadedInterrupt2()
    {
        Thread.currentThread().interrupt();
        try
        {
            Thread.sleep(1);
            fail("Did not throw interrupted exception.");
        }
        catch (InterruptedException e)
        {
            assertFalse(
                "Interrupt was not cleared",
                Thread.interrupted() );
        }
    }
    
    
    private static class MyRunner implements Runnable
    {
        boolean doRun = true;
        public void run()
        {
            while (doRun)
            {
                Thread.yield();
            }
        }
    }
    public void testKillThread1() throws Exception
    {
        MyRunner mr = new MyRunner();
        Thread t = new Thread( mr );
        t.setDaemon( true );
        t.start();
        
        try
        {
            t.stop( new RuntimeException( "we stopped!" ) );
            Thread.sleep( 100 );
            assertFalse( "Did not kill the thread",
                t.isAlive() );
        }
        finally
        {
            mr.doRun = false;
        }
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

