/*
 * @(#)JavaMakerIUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1.javamaker;

import java.io.File;
import java.io.Writer;
import java.io.StringWriter;
import java.io.IOException;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the JavaMaker class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     Jan 6, 2002
 * @version   $Date: 2003/02/10 22:52:34 $
 */
public class JavaMakerIUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = JavaMakerIUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public JavaMakerIUTest( String name )
    {
        super( name );
    }



    //-------------------------------------------------------------------------
    // Tests
    
    public void testInstantiation()
            throws IOException
    {
        try
        {
            new JavaMaker( (File)null, null, null );
            fail( "Should throw IAE" );
        }
        catch (IllegalArgumentException iae)
        {
            // do nothing
        }
        try
        {
            new JavaMaker( (Writer)null, null, null );
            fail( "Should throw IAE" );
        }
        catch (IllegalArgumentException iae)
        {
            // do nothing
        }
        File f = new File("a");
        try
        {
            new JavaMaker( f, "b", "c" );
        }
        finally
        {
            if (f.exists())
            {
                f.delete();
            }
        }
    }
    
    
    public void testCreatesFile()
            throws IOException
    {
        File f = File.createTempFile( "Script", ".java" );
        try
        {
            if (f.exists())
            {
                f.delete();
            }
            assertTrue(
                "Generated a temporary file.  It should not already exist.",
                !f.exists() );
            
            JavaMaker jsm = new JavaMaker( f, "a", "b" );
            
            jsm.start();
            jsm.end();
            
            assertTrue(
                "ScriptMaker should have created temp file.",
                f.exists() );
        }
        finally
        {
            if (f.exists())
            {
                f.delete();
            }
        }
    }
    
    
    public void testCreatesString()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        jsm.start();
        jsm.end();
        
        String output = sw.toString();
        assertTrue(
            "ScriptMaker should have created a non-empty string.",
            output.length() > 0 );
    }
    
    
    public void testIllegalOrderEnd()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        try
        {
            jsm.end();
            fail( "end should have thrown an IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // should have generated this exception
        }
    }


    public void testIllegalOrderDelay()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        try
        {
            jsm.generateDelay( 10 );
            fail( "generateDelay should have thrown an IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // should have generated this exception
        }
    }


    public void testIllegalOrderWheel()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        try
        {
            jsm.generateMoveMouseWheel( 10 );
            fail( "generateMoveMouseWheel should have thrown an IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // should have generated this exception
        }
    }


    public void testIllegalOrderMove()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        try
        {
            jsm.generateMoveMouse( 10, 10 );
            fail( "generateMoveMouse should have thrown an IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // should have generated this exception
        }
    }


    public void testIllegalOrderMPress()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        try
        {
            jsm.generatePressMouse( 10 );
            fail( "generatePressMouse should have thrown an IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // should have generated this exception
        }
    }


    public void testIllegalOrderMRelease()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        try
        {
            jsm.generateReleaseMouse( 10 );
            fail( "generateReleaseMouse should have thrown an IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // should have generated this exception
        }
    }


    public void testIllegalOrderKPress()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        try
        {
            jsm.generatePressKey( 10 );
            fail( "generatePressKey should have thrown an IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // should have generated this exception
        }
    }


    public void testIllegalOrderKRelease()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        try
        {
            jsm.generateReleaseKey( 10 );
            fail( "generateReleaseKey should have thrown an IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // should have generated this exception
        }
    }


    public void testIllegalOrderScreen()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        try
        {
            jsm.generateScreenCapture( null, 10, 10, 10, 10 );
            fail( "generateScreenCapture should have thrown an IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // should have generated this exception
        }
    }


    public void testIllegalOrderStart()
    {
        StringWriter sw = new StringWriter();
        JavaMaker jsm = new JavaMaker( sw, "a", "b" );
        
        jsm.start();
        try
        {
            jsm.start();
            fail( "start should have thrown an IllegalStateException." );
        }
        catch (IllegalStateException e)
        {
            // should have generated this exception
        }
        finally
        {
            jsm.end();
        }
    }
    
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

