/*
 * StateCategory.java - 0.9.0    01/13/2001 - 16:51:36
 *
 * Copyright (C) 2000,2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.groboclown.util.states.v1;



/**
 * Creates new categories for State collections. Does not save the
 * created state objects. To save time, this creates both
 * States and Transitions, though it should only be used for one or
 * the other.
 *
 * @author Matt Albrecht
 * @version 0.9.0 Alpha
 */
public class StateCategory
{
    //---------------------------------------------------------------------
    // Public Static Fields
     
     
    //---------------------------------------------------------------------
    // Protected Static Fields
     
     
    //---------------------------------------------------------------------
    // Private Static Fields
     
    private final static Object sync = new Object();
    private static int categoryNum = 0;
     
     
    //---------------------------------------------------------------------
    // Public Fields
     
     
    //---------------------------------------------------------------------
    // Protected Fields
     
     
    //---------------------------------------------------------------------
    // Private Fields
     
    private int category;
    private int stateNum = 0;
    private int maxStates;
    private final Object m_sync = new Object();
     
     
     
     
    //---------------------------------------------------------------------
    // Constructors
     
     
    /**
     * Default Constructor
     */
    public StateCategory( int maxStateCount )
    {
        this.maxStates = maxStateCount;
        this.category = getNextCategoryInt();
    }
    
    
    
    
    
    //---------------------------------------------------------------------
    // Public Methods
     
    /**
     * Creates a new unique State instance for this category.
     */
    public State getNextState()
    {
        State s = new State( this.category, getNextStateInt() );
        
        return s;
    }
    
     
    /**
     * Creates a new unique Transition instance for this category.
     */
    public Transition getNextTransition()
    {
        Transition s = new Transition( this.category, getNextStateInt() );
        
        return s;
    }
    
    
    /**
     * Checks if the given state is of this category.
     */
    public boolean isOfCategory( State s )
    {
        return (s.getCategory() == this.category);
    }
    
    
    /**
     * 
     */
    public int getMaximumStateCount()
    {
        return this.maxStates;
    }
    
     
    //---------------------------------------------------------------------
    // Protected Methods
     
     
    //---------------------------------------------------------------------
    // Private Methods
     
    private final int getNextStateInt()
    {
        int val;
        synchronized( this.m_sync )
        {
            val = this.stateNum++;
        }
        if (val >= this.maxStates)
        {
            throw new IllegalStateException("created too many states");
        }
        return val;
    }
     
     
     
    //---------------------------------------------------------------------
    // Private Static Methods
    
    private static final int getNextCategoryInt()
    {
        int val;
        synchronized (sync)
        {
            val = categoryNum++;
        }
        return val;
    }
}
 
