/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.editor.codegen.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.editor.codegen.DelegateMethodGenerator;
import org.openide.explorer.ExplorerManager;
import org.openide.util.NbBundle;

/**
 *
 * @author Jan Lahoda, Dusan Balek
 */
public class DelegatePanel extends javax.swing.JPanel implements PropertyChangeListener {

    private JTextComponent component;
    private ElementHandle<TypeElement> handle;
    private ElementSelectorPanel delegateSelector;
    private ElementSelectorPanel methodSelector;

    /** Creates new form DelegatePanel */
    public DelegatePanel(JTextComponent component, ElementHandle<TypeElement> handle, ElementNode.Description description) {
        this.component = component;
        this.handle = handle;
        initComponents();
        delegateSelector = new ElementSelectorPanel(description, false);
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        delegatePanel.add(delegateSelector, gridBagConstraints);
        delegateSelector.getExplorerManager().addPropertyChangeListener(this);
        
        methodSelector = new ElementSelectorPanel(null, false);
        methodSelector.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        methodPanel.add(methodSelector, gridBagConstraints);
        
        delegateLabel.setText(NbBundle.getMessage(DelegateMethodGenerator.class, "LBL_delegate_field_select")); //NOI18N
        delegateLabel.setLabelFor(delegateSelector);
        methodLabel.setText(NbBundle.getMessage(DelegateMethodGenerator.class, "LBL_delegate_method_select")); //NOI18N
        methodLabel.setLabelFor(methodSelector);
        
        delegateSelector.doInitialExpansion(1);
        jSplitPane1.setDividerLocation(0.5);
	
	this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DelegateMethodGenerator.class, "A11Y_Generate_Delegate"));
    }

    public ElementHandle<? extends Element> getDelegateField() {
        List<ElementHandle<? extends Element>> handles = delegateSelector.getTreeSelectedElements();
        return handles.size() == 1 ? handles.get(0) : null;
    }

    public List<ElementHandle<? extends Element>> getDelegateMethods() {
        return ((ElementSelectorPanel)methodSelector).getSelectedElements();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane1 = new javax.swing.JSplitPane();
        methodPanel = new javax.swing.JPanel();
        methodLabel = new javax.swing.JLabel();
        delegatePanel = new javax.swing.JPanel();
        delegateLabel = new javax.swing.JLabel();

        setFocusable(false);

        jSplitPane1.setBorder(null);
        jSplitPane1.setDividerSize(5);
        jSplitPane1.setResizeWeight(0.5);

        methodPanel.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        methodPanel.add(methodLabel, gridBagConstraints);

        jSplitPane1.setRightComponent(methodPanel);

        delegatePanel.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        delegatePanel.add(delegateLabel, gridBagConstraints);

        jSplitPane1.setLeftComponent(delegatePanel);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 652, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 410, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    public void propertyChange(PropertyChangeEvent evt) {
        if ( ExplorerManager.PROP_SELECTED_NODES.equals(evt.getPropertyName()) ) {
            SwingUtilities.invokeLater(new Runnable() {                 
                public void run() {
                    ElementHandle<? extends VariableElement> fieldHandle = (ElementHandle<? extends VariableElement>) getDelegateField();
                    methodSelector.setRootElement(handle == null || fieldHandle == null ? null : DelegateMethodGenerator.getAvailableMethods(component, handle, fieldHandle), false);
                    methodSelector.doInitialExpansion(-1);            
                }
            });
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JLabel delegateLabel;
    public javax.swing.JPanel delegatePanel;
    public javax.swing.JSplitPane jSplitPane1;
    public javax.swing.JLabel methodLabel;
    public javax.swing.JPanel methodPanel;
    // End of variables declaration//GEN-END:variables
}
