.TH "tcpcryptd" "8" "" "" ""
.SH NAME
.PP
\f[B]tcpcryptd\f[] \- Implement the tcpcrypt protocol by transparently
modifying network I/O
.SH SYNOPSIS
.PP
\f[B]tcpcryptd\f[] [\f[I]options\f[]]
.SH OPTIONS
.PP
A list of all options is produced by:
.RS
.PP
\f[B]tcpcryptd \-h\f[]
.RE
.PP
Configuration of packet\-diversion rules allows the system administrator
to control which TCP connections are protected by \f[B]tcpcryptd\f[].
The daemon receives packets for transformation via a "divert port",
configurable with \f[B]\-p\f[] \f[I]port\f[].
.PP
The daemon communicates with user programs via a "control socket",
configurable with \f[B]\-u\f[] \f[I]socket_address\f[].
If \f[I]socket_address\f[] begins with "/", it is interpreted as a
filesystem path pointing to a unix\-domain socket; if it is of the form
":\f[I]port\f[]", it is interpreted as the internet address
localhost:\f[I]port\f[].
.PP
Verbosity may be increased with multiple \f[B]\-v\f[] options.
.PP
A "phone\-home" test will be performed at daemon startup to confirm
end\-to\-end functionality of the implementation (by default, with the
authors\[aq] server), but may be redirected to another test\-server with
\f[B]\-s\f[] \f[I]hostname\f[] or disabled completely with \f[B]\-f\f[].
.SH DESCRIPTION
.PP
The \f[B]tcpcryptd\f[] daemon transforms TCP segments via a kernel
"divert" port in order to implement "opportunistic encryption" according
to the \f[I]tcpcrypt\f[] protocol.
.PP
For a peer that signals in the connection handshake that it has support
for the \f[I]tcpcrypt\f[] protocol, ephemeral keys are exchanged and
used to protect the confidentiality and integrity of the
connection\[aq]s application data.
(The protocol protects the integrity of parts of the TCP header as
well.) When a peer does not indicate support for the protocol, the
daemon will pass the remainder of the connection unperturbed (and thus
unprotected).
.PP
Application software need not be modified to take advantage of this
facility, which provides confidentiality in the face of passive network
attackers (those who cannot modify network data in transit).
But in order to protect communication from active attackers, the
application must intentionally authenticate the connection as described
below.
.SS Authentication
.PP
The \f[I]tcpcrypt\f[] protocol does not itself protect communications
against "active attackers", that is, those who are able to modify
network packets in transit.
Such an attacker may perform a "man in the middle" attack that allows
her to behave as the endpoint of the encrypted connection and thus
compromise its security.
.PP
However, applications aware of \f[I]tcpcrypt\f[] may authenticate the
connection in whatever manner they choose, aided by an identifier for
the connection that is derived from the protocol and made available by
\f[B]tcpcryptd\f[]:
.PP
A \f[I]session id\f[] is derived from the ephemeral keys used to encrypt
each connection protected by \f[I]tcpcrypt\f[].
This identifier is (probabalistically) unique over all connections, is
not secret, and may be extracted by applications via the user library
\f[B]libtcpcrypt\f[].
Session ids for all active connections may also be listed with the
netstat\-like utility \f[B]tcnetstat\f[](8).
.PP
Connection peers may ensure they are communicating securely with each
other (enjoying confidentiality and integrity in the face of active
network attackers) by confirming that the \f[I]tcpcrypt\f[] session ids
derived at each end are identical.
For example, they may bind the session id together with a shared secret
such as a password, sign it with public keys, use a voice connection to
speak a fingerprint of it, or simply record it for later confirmation.
.SH SEE ALSO
.PP
\f[B]tcnetstat\f[](8), <http://tcpcrypt.org/>
