[comment {-*- tcl -*- doctools manpage}]
[vset VERSION 0.1]
[manpage_begin canvas::drag n [vset VERSION]]
[keywords canvas]
[keywords dragging]
[moddesc   {Variations on a canvas}]
[titledesc {Manage the dragging of canvas items or item groups}]
[require Tcl 8.5]
[require Tk 8.5]
[require canvas::drag [opt [vset VERSION]]]
[description]

This package provides utility commands to setup and rmeove dragging of
items or item groups on a canvas, hiding all complexity regarding
bindings from the user.

[section API]

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd ::canvas::drag] [method on] [arg canvas] [arg tagOrId] [arg cmd] [arg option]...]

This command initializes item dragging on the [arg canvas] widget,
with the items used as drag handles identified by [arg tagOrId].

The command prefix [arg cmd], invoked for drag start and movement, is
responsible for the initialization and actual execution of the drag
operation.

[para] The signature of the command prefix is described later, in
section [sectref {Drag callback}].

[para] Similarly, the accepted options and their values are described
in section [sectref Options]

[para] The result of the command is the empty string.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd ::canvas::drag] [method off] [arg canvas] [arg tagOrId]]

This command removes any drag operation set on the items of canvas
[arg canvas] identified by [arg tagOrId].

[para] The result of the command is the empty string.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd ::canvas::drag] [method item] [arg canvas] [arg tagOrId] [arg option]...]

This is a convenience command wrapped around method [method on] (see above)
to drag single items of the [arg canvas] widget, identified by [arg tagOrId].

[para] It uses an internal standard callback for this.

[para] The result of the command is the empty string.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd ::canvas::drag] [method group] [arg canvas] [arg tagOrId] [arg cmd] [arg option]...]

This is a convenience command wrapped around method [method on] (see above)
to drag single items of the [arg canvas] widget, identified by [arg tagOrId].

[para] It uses an internal standard callback for this. The callback
[arg cmd] specified has the same signature as the [sectref {Drag callback}],
except that

[list_begin enumerated]
[enum] The [method move] method is not invoked.
[enum] The result of the [method start] method [emph {has to be}] a
canvas tag refering to the whole group of items to move. In other words,
it must convert from drag handle (item id) to dragged groupt (tag).
[list_end]

[para] The result of the command is the empty string.

[list_end]

[subsection {Drag callback}]

The drag callback is a command prefix invoked in the following two
ways:

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd "{*}cmd"] [method start] [arg canvas] [arg item]]

This form is invoked when has initiated dragging using drag handle
identified by the canvas [arg item] id.

The callback now has to perform anything necessary for its type of
drag operation.

[para] The result of the command can be anything. It is stored by the
system as client information and passed unchanged to the movement
callback for its use. In this manner the drag callback is able to
maintain custom state from start to movement.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd "{*}cmd"] [method move] [arg canvas] [arg clientdata] [arg dx] [arg dy]]

This form is invoked when the mouse moved during a drag operation.

It is invoked with the client data from the start callback (or the
previous move callback) and the distances the mouse has traveled in
horizontal and vertical directions.

[para] The result of the command can be anything. It is stored by the
system as client information and passed unchanged to the next movement
callback for its use. In this manner the drag callback is able to
maintain custom state from movement to movement.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd "{*}cmd"] [method done] [arg canvas] [arg clientdata]]

This form is invoked when the drag operation ends.

It is invoked with the client data from the last movement callback (or
start callback if there had been no motion).

[para] The result of the command is ignored.

[list_end]

[subsection Options]

The commands to create drag operations ([method on], [method item],
and [method group]) all accept the following options to configure the
new drag.

[list_begin options]
[opt_def -event [arg spec]]

The value of this option specifies the mouse button used to initiate
the drag operation, and the keyboard modifier, if any. Examples of
specifications:

[para] To initiate a drag operation by pressing mouse button 3 on a
drag handle, use:

[example { -event 3 }]

This is the default as well, if the option is not specified.

[para] To initiate a drag operation by pressing mouse button 2 on a
drag handle while holding down the Control key, use:

[example { -event Control-2 }]

[list_end]
[vset CATEGORY canvas]
[include ../../support/devel/doc/feedback.inc]
[manpage_end]
