.TH XLBIFF 1 "2 June 1994"
.SH NAME
xlbiff \- mailbox message previewer for X
.SH SYNOPSIS
.B xlbiff
[ \fI\-option\fP ... ]
.SH DESCRIPTION
The
.I xlbiff
program lurks in the background, watching your mailbox file, waiting for
new mail.  When mail arrives, it invokes the MH \fIscan\fP(1)
command and pops up a window with the results.  Clicking the left mouse
button anywhere in this window makes it go away.  The window will also
disappear if iconified or if the mailbox size drops to zero.
.PP
.SH OPTIONS
.I Xlbiff
accepts all of the standard X Toolkit command line options along with the
additional options listed below:
.TP 8
.B \-help
This option indicates that a brief summary of the allowed options should be
printed on standard output.
.TP 8
.B \-bottom
This option tells 
.I xlbiff 
to realize/unrealize() the output window instead of using XtPopup/down().
This has the effect of causing the window manager to reposition the window
each time it pops up, and is useful for when you specify negative Y
coordinates, ie, at the bottom of the screen.  Running 
.I xlbiff
in this situation without \-bottom would cause new lines to run off the
bottom edge of the screen.
.TP 8
.B \+bottom
Opposite of \-bottom.
.TP 8
.B \-file \fIfilename\fP
This option specifies the name of the file which should be monitored.  By
default, it watches /usr/spool/mail/\fIusername\fP, where \fIusername\fP
is your login name.
.TP 8
.B \-rows \fIheight\fP
This option specifies the maximum height, in lines of text, of the
.I xlbiff
window.  The default is 20.
.TP 8
.B \-columns \fIwidth\fP
This option specifies the maximum width, in characters, of the
.I xlbiff
window.  The default is 80.
.TP 8
.B \-resetSaver
If this option is set, 
.I xlbiff
will reset the screen saver when new mail comes in.  This is useful if 
you're doing something near your workstation but not on it.
.TP 8
.B \+resetSaver
Opposite of \-resetSaver.
.TP 8
.B \-update \fIseconds\fP
This option specifies the frequency in seconds at which
.I xlbiff
should update its display.  The default is 15 seconds.
.TP 8
.B \-fade \fIseconds\fP
Number of seconds to wait before popping window back down.  This option
can be used to monitor events of non-lasting importance, such as syslog
or UUCP queues.  The default value of 0 disables the
.B fade
option.
.TP 8
.B \-led \fIledNum\fP
This option specifies a keyboard LED to light up when there is mail waiting
in the \fIfile.\fP  The default is zero (do not light a LED).
.TP 8
.B \-ledPopdown
This option indicates that the LED should be turned off when xlbiff is
popped down.  Ordinarily the LED stays lit to remind one of awaiting mail.
This option has no effect if the \-led option is disabled.
.TP 8
.B \+ledPopdown
Opposite of \-ledPopdown.
.TP 8
.B \-refresh \fIseconds\fP
This option specifies the number of seconds to wait before re-posting the
mail window after you acknowledge it, and it still contains the same mail.
The default is 0 (no refresh).  A useful value for this is 1800 (30 minutes).
.TP 8
.B \-mailerCommand \fIcommand\fP
Specifies the command to invoke when the the mailer() action is activated,
eg, "xterm -e elm" or "inc".  By default this is bound to the second
mouse button.
Invoking this action will pop down the main window.  When the command exits,
it will pop up again.  Due to mailbox consistency considerations, the
mailerCommand should not exit before it is finished with the mailbox, i.e.
it should not be run in the background.
.sp
There is no default
.BR mailerCommand .
.TP 8
.B \-scanCommand \fIcommand\fP
Specifies a shell command to be executed to list the contents of mailbox
\fBfile\fP.  The specified string value is used as the
argument to a \fIsystem\fP(3) call and may therefore contain i/o redirection.
The command's stdout is used to generate the window.  
Internally, the command is generated as
.sp
.nf
              sprintf(buf, scanCommand, file, columns)
.fi
.sp
so a %s and %d respectively in \fBscanCommand\fP will generate the values
of \fBfile\fP and \fBcolumns\fP.  The default 
.B scanCommand
is
.sp
.nf
		scan \-file %s \-width %d
.fi
.sp
.TP 8
.B \-checkCommand \fIcommand\fP
Specifies a shell command to be executed to check for new mail (or some
other condition) rather than simply examining the size of the mail file.
The specified string value is used as the argument to a \fIpopen\fP(3) 
call, and the output generated is important.  Like
.I xbiff,
an exit status of 0 indicates that a change in condition demands a new
evaluation of scanCommand and subsequent popup, 1 indicates no change 
in status, and 2 indicates that the condition has been cleared and the
.I xlbiff
window should pop down.  By default, no shell command is provided.
.sp
This option may be useful to monitor logins (by checking update times
of /etc/utmp), when using POP or other custom maildrop mechanisms, and
so forth.
.sp
Similarly to scanCommand, the checkCommand is generated internally as
.sp
.nf
             sprintf(buf, checkCommand, file, previous)
.fi
.sp
.B previous
is the numeric value output by the last time checkCommand was run, or
zero the first time.  This is useful for allowing the checkCommand to
maintain state in a primitive fashion.  For instance, a checkCommand 
such as
.sp
.nf
           compare_size %s %d
.fi
.sp
would "do the right thing" if 
.B compare_size
were a script such as:
.sp
.nf
         #!/bin/sh
         NEWSIZE=`wc -c <$1`
         echo $NEWSIZE
         if [ $NEWSIZE -ne $2 ]; then
             if [ $NEWSIZE -eq 0 ]; then
                 exit 2
             else
                 exit 0
             fi
         fi
         exit 1
.fi
.sp
The author of
.I xlbiff
uses this facility to keep track of several maildrops with one command.
See the 
.I Bcheck
and 
.I Bscan
scripts, included.
.TP 8
.B \-volume \fIpercentage\fP
This option specifies how loud the bell should be rung when new mail comes in.
.PP
The following standard X Toolkit command line arguments are commonly used with 
.I xlbiff:
.TP 8
.B \-display \fIdisplay\fP
This option specifies the X server to contact.
.TP 8
.B \-geometry \fI+x+y\fP
This option specifies the preferred position of the scan window.
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.  
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for the foreground of the window.
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.  This is especially
useful for setting resources that do not have separate command line options.
.SH RESOURCES 
The application class name is XLbiff.
It understands all of the core resource names and classes as well as:
.TP 8
.B bottom (\fPclass\fB Bottom)
Same as the \fB\-bottom\fP option.  
.TP 8
.B file (\fPclass\fB File)
Same as the \fB\-file\fP option.
.TP 8
.B mailerCommand (\fPclass\fB MailerCommand)
Same as the \fB\-mailerCommand\fP option.
.TP 8
.B scanCommand (\fPclass\fB ScanCommand)
Same as the \fB\-scanCommand\fP option.
.TP 8
.B checkCommand (\fPclass\fB CheckCommand)
Same as the \fB\-checkCommand\fP option.
.TP 8
.B resetSaver (\fPclass\fB ResetSaver)
Same as the \fB\-resetSaver\fP option.
.TP 8
.B update (\fPclass\fB Interval)
Same as the \fB\-update\fP option.
.TP 8
.B fade (\fPclass\fB Fade)
Same as the \fB\-fade\fP option.
.TP 8
.B columns (\fPclass\fB Columns)
Same as the \fB\-columns\fP option.
.TP 8
.B rows (\fPclass\fB Rows)
Specifies the maximum height, in lines, of the 
.I xlbiff
window.  The default is 20.
.TP 8
.B led (\fPclass\fB Led)
Same as the \fB\-led\fP option.
.TP 8
.B ledPopdown (\fPclass\fB LedPopdown)
Same as the \fB\-ledPopdown\fP option.
.TP 8
.B refresh (\fPclass\fB Refresh)
Same as the \fB\-refresh\fP option.
.TP 8
.B sound (\fPclass\fB Sound)
Specify a command to be run in place of a bell when new mail arrives.
For example, on a Sun Sparc you might use:
.sp
.nf
 *sound: /usr/demo/SOUND/play \-v %d /usr/demo/SOUND/sounds/doorbell.au
.fi
.sp
The command is generated internally with
.B sprintf,
so the characters ``%d'' will be replaced with the numeric value of the
.B volume
resource.
.TP 8
.B volume (\fPclass\fB Volume)
Same as the \fB\-volume\fP option.
.SH ACTIONS
.I Xlbiff
provides the following actions for use in event translations:
.TP 8
.B popdown()
This action causes the window to vanish.
.TP 8
.B exit()
This action causes 
.I xlbiff
to exit.
.PP
The default translations are 
.sp
.nf
        <Button1Press>:  popdown()
        <Button3Press>:  exit()
.fi
.sp
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
is used to get the default host and display number.
.SH FILES
.TP 8
/usr/spool/mail/\fIusername\fP
default mail file to check.
.SH "SEE ALSO"
.IR X (1),
.IR scan (1)
.SH BUGS
specifying dimensions in \-geometry causes badness.
.PP
The \fBled\fP option does not work on Suns before SunOS 4.1/X11R5.
.SH AUTHOR
Ed Santiago, esm@pobox.com
.SH ACKNOWLEDGEMENTS
.I Xlbiff
took shape around the \fBxgoodbye\fP sample program
in the O'Reilly \fIX Toolkit Intrinsics Programming Manual\fP.  A lot of
code was stolen from \fBxbiff\fP, including this man page.  Thanks also
to Stephen Gildea (gildea@expo.lcs.mit.edu) for the many, many 
contributions that made
.I xlbiff 
grow from a midnight hack to a more mature product.
