/*
 * Compare two fixed-size regions of memory, in a crypto-safe way,
 * i.e. without timing or cache side channels indicating anything
 * about what the answer was or where the first difference (if any)
 * might have been.
 */

#include "defs.h"
#include "misc.h"

bool smemeq(const void *av, const void *bv, size_t len)
{
    const unsigned char *a = (const unsigned char *)av;
    const unsigned char *b = (const unsigned char *)bv;
    unsigned val = 0;

    while (len-- > 0) {
        val |= *a++ ^ *b++;
    }
    /* Now val is 0 iff we want to return 1, and in the range
     * 0x01..0xFF iff we want to return 0. So subtracting from 0x100
     * will clear bit 8 iff we want to return 0, and leave it set iff
     * we want to return 1, so then we can just shift down. */
    return (0x100 - val) >> 8;
}
