<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authn_dbd - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authn_dbd</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authn_dbd.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authn_dbd.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Authentification utilisateur  l'aide d'une base de donnes
SQL</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authn_dbd_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authn_dbd.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.1 d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module permet aux frontaux d'authentification comme
    <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code> et <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code>
    d'authentifier les utilisateurs en les recherchant dans une base de
    donnes SQL. <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code>, par exemple, fournit
    une fonctionnalit similaire.</p>
    <p>Ce module s'appuie sur <code class="module"><a href="../mod/mod_dbd.html">mod_dbd</a></code> pour spcifier le
    pilote de la base de donnes sous-jacente et les paramtres de
    connexion, mais aussi pour grer les connexions  la base de
    donnes.</p>

    <p>Si l'on utilise <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code> ou
    <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code>, on peut invoquer ce module en
    affectant la valeur <code>dbd</code>  la directive <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> ou <code class="directive"><a href="../mod/mod_auth_digest.html#authdigestprovider">AuthDigestProvider</a></code>.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#authdbduserpwquery">AuthDBDUserPWQuery</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authdbduserrealmquery">AuthDBDUserRealmQuery</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#socache">Performances et mise en cache</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#example">Exemple de configuration</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#exposed">Mise  disposition des informations de connexion</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="directive"><a href="../mod/mod_authn_core.html#authname">AuthName</a></code></li>
<li><code class="directive"><a href="../mod/mod_authn_core.html#authtype">AuthType</a></code></li>
<li>
  <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code>
</li>
<li>
  <code class="directive"><a href="../mod/mod_auth_digest.html#authdigestprovider">AuthDigestProvider</a></code>
</li>
<li><code class="directive"><a href="../mod/mod_dbd.html#dbdriver">DBDriver</a></code></li>
<li><code class="directive"><a href="../mod/mod_dbd.html#dbdparams">DBDParams</a></code></li>
<li><a href="../misc/password_encryptions.html">Formats de mots de
passe</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="socache" id="socache">Performances et mise en cache</a></h2>

<p>Certains utilisateurs de l'authentification DBD sous HTTPD 2.2/2.4 ont
signal une charge problmatique au niveau de la base de donnes. Cela
se produit en gnral lorsqu'une page HTML contient des centaines d'objets
(comme des images, des scripts, etc...), chacun d'entre eux ncessitant
une authentification. Les utilisateurs qui rencontrent ce genre de
problme peuvent utiliser le module <code class="module"><a href="../mod/mod_authn_socache.html">mod_authn_socache</a></code>
qui permet de mettre les donnes d'authentification en cache, et
soulager ainsi la base de donnes de la plus grande partie de la charge.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="example" id="example">Exemple de configuration</a></h2>

<p>Voici un exemple simple d'utilisation de ce module dans un contexte
d'authentification et de bases de donnes.</p>
<pre class="prettyprint lang-config"># configuration de mod_dbd
# MISE  JOUR pour inclure la mise en cache de l'authentification
DBDriver pgsql
DBDParams "dbname=apacheauth user=apache password=xxxxxx"

DBDMin  4
DBDKeep 8
DBDMax  20
DBDExptime 300

&lt;Directory /usr/www/mon-serveur/private&gt;
  # configuration de mod_authn_core et mod_auth_basic
  # pour mod_authn_dbd
  AuthType Basic
  AuthName "Mon serveur"

  # Pour mettre en cache les donnes d'authentification, placez socache
  # avant dbd
  AuthBasicProvider socache dbd

  # Aussi ncessaire  la mise en cache : dire au cache de mettre en
  # cache les recherches dbd !
  AuthnCacheProvideFor dbd
  AuthnCacheContext mon-serveur

  # configuration de mod_authz_core
  Require valid-user

  # la requte SQL de mod_authn_dbd pour authentifier un utilisateur
  AuthDBDUserPWQuery "SELECT password FROM authn WHERE user = %s"
&lt;/Directory&gt;</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="exposed" id="exposed">Mise  disposition des informations de connexion</a></h2>

<p>
Si httpd a t compil avec la version 1.3.0 ou suprieure de
l'<a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a>, pour chaque requte envoye au serveur de
base de donnes, toutes les valeurs de colonnes du premier
enregistrement renvoy par la requte sont affectes  des variables
d'environnement avec le prfixe "AUTHENTICATE_".
</p>
<p>Par exemple, si une requte renvoie un nom d'utilisateur, un nom
complet et un numro de tlphone, un programme CGI pourra accder  ces
informations sans avoir besoin d'effectuer une deuxime requte vers la
base de donnes.</p>
<p>Ceci va entraner une simplification considrable du code et de la
configuration ncessaire de certaines applications web.
</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthDBDUserPWQuery" id="AuthDBDUserPWQuery">AuthDBDUserPWQuery</a> <a name="authdbduserpwquery" id="authdbduserpwquery">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Requte SQL servant  vrifier le mot de passe d'un
utilisateur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthDBDUserPWQuery <var>requte</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_dbd</td></tr>
</table>
    <p>La directive <code class="directive">AuthDBDUserPWQuery</code> permet de
    spcifier une requte servant  vrifier le mot de passe d'un
    utilisateur donn. L'identifiant utilisateur sera transmis comme
    paramtre sous forme d'une seule chane de caractres lorsque la
    requte sera excute. Cet identifiant est rfrenc dans la requte
    en utilisant le spcificateur de format <code>%s</code>.</p>
    <pre class="prettyprint lang-config">AuthDBDUserPWQuery "SELECT password FROM authn WHERE user = %s"</pre>

    <p>La premire colonne du premier enregistrement renvoy par la
    requte se prsentera sous la forme d'une chane de caractres
    contenant le mot de passe chiffr. Les enregistrements suivants sont
    ignors. Si aucun enregistrement n'est renvoy, l'utilisateur ne
    sera pas authentifi par <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code>.</p>
    <p>Si httpd a t compil avec la version 1.3.0 ou suprieure de
    l'<a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a>, toute valeur de colonne supplmentaire
    du premier enregistrement renvoy par la requte sera stocke dans
    une variable d'environnement dont le nom aura la forme
    <code>AUTHENTICATE_<var>valeur-colonne</var></code>.
    </p>
    <p>Le format du mot de passe chiffr dpend du frontal
    d'authentification utilis (par exemple
    <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code> ou
    <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code>). Voir la documentation sur les <a href="../misc/password_encryptions.html">Formats de mots de passe</a> pour
    plus de dtails.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthDBDUserRealmQuery" id="AuthDBDUserRealmQuery">AuthDBDUserRealmQuery</a> <a name="authdbduserrealmquery" id="authdbduserrealmquery">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Requte SQL servant  vrifier une empreinte de mot de
passe pour un utilisateur et un identifiant d'authentification.
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthDBDUserRealmQuery <var>requte</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_dbd</td></tr>
</table>
    <p>La directive <code class="directive">AuthDBDUserRealmQuery</code> permet
    de spcifier une requte SQL servant  vrifier une empreinte de mot
    de passe pour un utilisateur et un identifiant d'authentification
    donns au cours d'un processus d'authentification digest. Les
    identifiants de l'utilisateur et de l'authentification
    sont passs dans cet ordre comme paramtres  l'excution de la
    requte. Ils sont rfrencs dans la chane de la requte en
    utilisant des spcificateurs de format <code>%s</code>.</p>
    <pre class="prettyprint lang-config">AuthDBDUserRealmQuery "SELECT password FROM authn WHERE user = %s AND realm = %s"</pre>

    <p>La premire colonne du premier enregistrement renvoy par la
    requte se prsentera sous la forme d'une chane de caractres
    contenant le mot de passe chiffr. Les enregistrements suivants
    seront ignors. Si aucun enregistrement n'est renvoy, l'utilisateur
    ne sera pas authentifi par <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code>.</p>
    <p>Si httpd a t compil avec une version 1.3.0 ou suprieure de
    l'<a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a>, toute valeur de colonne supplmentaire
    du premier enregistrement renvoy par la requte sera stocke dans
    une variable d'environnement avec un nom de la forme
    <code>AUTHENTICATE_<var>COLONNE</var></code>.
    </p>
    <p>Le format du mot de passe chiffr dpend du frontal
    d'authentification utilis (par exemple
    <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code> ou
    <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code>). Voir la documentation sur les <a href="../misc/password_encryptions.html">Formats de mots de passe</a> pour
    plus de dtails.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authn_dbd.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authn_dbd.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_authn_dbd.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2014 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>