#ifndef CEPH_CLS_VERSION_CLIENT_H
#define CEPH_CLS_VERSION_CLIENT_H

#include "cls_version_ops.h"

namespace librados {
  class ObjectWriteOperation;
  class ObjectReadOperation;
  class ObjectOperation;
  class IoCtx;
}

/*
 * version objclass
 */

void cls_version_set(librados::ObjectWriteOperation& op, obj_version& ver);

/* increase anyway */
void cls_version_inc(librados::ObjectWriteOperation& op);

/* conditional increase, return -EAGAIN if condition fails */
void cls_version_inc(librados::ObjectWriteOperation& op, obj_version& ver, VersionCond cond);

void cls_version_read(librados::ObjectReadOperation& op, obj_version *objv);

int cls_version_read(librados::IoCtx& io_ctx, string& oid, obj_version *ver);

void cls_version_check(librados::ObjectOperation& op, obj_version& ver, VersionCond cond);

#endif
