/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.instrumentor.AbstractStrategy;
import alt.jiapi.instrumentor.HotSpot;
import alt.jiapi.instrumentor.Instrumentation;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.instruction.FieldAccess;
import alt.jiapi.reflect.instruction.OpcodeGroups;
import java.util.ArrayList;
import java.util.List;

public class FieldAccessStrategy
extends AbstractStrategy {
    public static final int READ_ACCESS = 1;
    public static final int WRITE_ACCESS = 2;
    private int accessPolicy;

    public FieldAccessStrategy() {
        this(new String[]{"*"}, false, 3);
    }

    public FieldAccessStrategy(String matcher, int accessPolicy) {
        this(new String[]{matcher}, false, accessPolicy);
    }

    public FieldAccessStrategy(String matcher, boolean reverseMatch, int accessPolicy) {
        this(new String[]{matcher}, reverseMatch, accessPolicy);
    }

    public FieldAccessStrategy(String[] matchers, boolean reverseMatch, int accessPolicy) {
        super(matchers, reverseMatch);
        this.accessPolicy = accessPolicy;
    }

    public List findHotSpots(InstructionList il) {
        Instrumentation instrumentation = this.getInstrumentation();
        ArrayList<HotSpot> hotSpots = new ArrayList<HotSpot>();
        int index = 0;
        while ((index = il.indexOf(OpcodeGroups.FIELD_ACCESS_INSTRUCTIONS, index)) != -1) {
            FieldAccess fa = (FieldAccess)il.get(index);
            byte opcode = fa.getOpcode();
            String targetName = fa.getFieldName();
            if (this.match(targetName)) {
                HotSpot h;
                if ((this.accessPolicy & 1) == 1 && (opcode == -76 || opcode == -78)) {
                    h = new HotSpot(index, index + 1);
                    instrumentation.setTargetName(targetName);
                    hotSpots.add(h);
                }
                if ((this.accessPolicy & 2) == 2 && (opcode == -75 || opcode == -77)) {
                    h = new HotSpot(index, index + 1);
                    instrumentation.setTargetName(targetName);
                    hotSpots.add(h);
                }
            }
            ++index;
        }
        return hotSpots;
    }
}

