/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public abstract class ExprInstruction
extends Instruction
implements Expression {
    public Expression simplify() throws XPathException {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (!(this.children[n] instanceof Expression)) {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be Expressions");
                }
                this.children[n] = (ExprInstruction)((Expression)((Object)this.children[n])).simplify();
                ++n;
            }
        }
        return this;
    }

    public ItemType getItemType() {
        return this.getResultType().getPrimaryType();
    }

    public int getCardinality() {
        return this.getResultType().getCardinality();
    }

    public int getDependencies() {
        int n = 0;
        Expression[] expressionArray = this.getSubExpressions();
        int n2 = 0;
        while (n2 < expressionArray.length) {
            n |= expressionArray[n2].getDependencies();
            ++n2;
        }
        return n;
    }

    public int getSpecialProperties() {
        return 0x400000;
    }

    protected abstract void promoteInst(PromotionOffer var1) throws XPathException;

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.promoteInst(promotionOffer);
        return this;
    }

    protected abstract void getXPathExpressions(List var1);

    public Expression[] getSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] instanceof Expression) {
                    Expression[] expressionArray = ((Expression)((Object)this.children[n])).getSubExpressions();
                    int n2 = 0;
                    while (n2 < expressionArray.length) {
                        arrayList.add(expressionArray[n2]);
                        ++n2;
                    }
                } else {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be Expressions");
                }
                ++n;
            }
        }
        this.getXPathExpressions(arrayList);
        Expression[] expressionArray = new Expression[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            expressionArray[n] = (Expression)arrayList.get(n);
            ++n;
        }
        return expressionArray;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.iterate(xPathContext).next();
    }

    public final String evaluateAsString(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        if (item == null) {
            return "";
        }
        return item.getStringValue();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterate(xPathContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return false;
        }
        if (item instanceof NodeInfo) {
            return true;
        }
        return ((AtomicValue)item).effectiveBooleanValue(xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        return SingletonIterator.makeIterator(item);
    }
}

