/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaMarker;
import net.sf.saxon.xpath.XPathException;

public abstract class SchemaType
implements Serializable,
SourceLocator {
    protected int finalProhibitions = 0;
    public static final int DERIVE_BY_RESTRICTION = 1;
    public static final int DERIVE_BY_EXTENSION = 2;
    public static final int DERIVE_BY_UNION = 4;
    public static final int DERIVE_BY_LIST = 8;
    public static final int DERIVE_BY_SUBSTITUTION = 16;
    public static final int ALL_DERIVATIONS = 31;
    private String localName = null;
    private int baseTypeFingerprint = -1;
    private SchemaType baseType = null;
    private int containingDeclarationName = -1;
    private boolean containingDeclarationIsElement = true;
    private NamePool namePool = null;
    private int derivation = 0;
    private int fingerprint = -1;
    private String systemId = null;
    private int lineNumber = -1;
    protected int validationPhase = 0;
    protected static final int UNVALIDATED = 0;
    protected static final int VALIDATING = 1;
    protected static final int VALIDATED = 2;
    protected static final int INVALID = 3;

    public int getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(int fingerprint) {
        this.fingerprint = fingerprint;
    }

    public int getBaseTypeFingerprint() {
        return this.baseTypeFingerprint;
    }

    public void setBaseTypeFingerprint(int fingerprint) {
        this.baseTypeFingerprint = fingerprint;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getDisplayName() {
        return this.namePool.getDisplayName(this.fingerprint);
    }

    public final boolean isComplexType() {
        return !this.isSimpleType();
    }

    public abstract boolean isSimpleType();

    public int getBlock() {
        return 0;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setNamePool(NamePool pool) {
        this.namePool = pool;
    }

    public SchemaType getBaseType() {
        return this.baseType;
    }

    public void setBaseType(SchemaType baseType) throws SchemaException {
        this.baseType = baseType;
    }

    public int getDerivationMethod() {
        return this.derivation;
    }

    public boolean allowsDerivation(int derivation) {
        return (this.finalProhibitions & derivation) == 0;
    }

    public void setDerivationMethodName(String method) throws SchemaException {
        if (method.equals("restriction")) {
            this.derivation = 1;
        } else if (method.equals("union")) {
            this.derivation = 4;
        } else if (method.equals("list")) {
            this.derivation = 8;
        } else if (method.equals("extension")) {
            this.derivation = 2;
        } else {
            throw new SchemaException("Unknown derivation method: " + method);
        }
    }

    public void setDerivationMethod(int method) {
        this.derivation = method;
    }

    public void setFinal(int value) throws SchemaException {
        this.finalProhibitions = value;
    }

    public void setFinalProhibitions(int finalValue) {
        this.finalProhibitions = finalValue;
    }

    public void checkDerivation(SchemaType type, int block) throws SchemaException {
        int derivations = 0;
        SchemaType t = this;
        while (true) {
            if (t == null) {
                if (type instanceof AnyType) {
                    return;
                }
                throw new SchemaException("The requested type " + this.getDescription() + " is not derived from the declared type " + type.getDescription());
            }
            if ((derivations & t.getBlock()) != 0) {
                throw new SchemaException("Derivation of the requested type " + this.getDescription() + " is blocked by the base type " + t.getDescription());
            }
            if (t == type) break;
            derivations |= t.getDerivationMethod();
            t = t.getBaseType();
        }
        if ((derivations & block) != 0) {
            throw new SchemaException("Derivation of the requested type " + this.getDescription() + " is blocked by the element declaration");
        }
    }

    public abstract SequenceIterator getTypedValue(NodeInfo var1) throws XPathException;

    public void setContainingDeclaration(int fingerprint, boolean isElement) {
        this.containingDeclarationName = fingerprint;
        this.containingDeclarationIsElement = isElement;
    }

    public void setLocator(SourceLocator locator) {
        this.systemId = locator.getSystemId();
        this.lineNumber = locator.getLineNumber();
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getDescription() {
        int fp = this.getFingerprint();
        if (fp != -1 && this.getNamePool().getURI(fp) != "http://ns.saxonica.com/anonymous-type") {
            return this.getNamePool().getDisplayName(fp);
        }
        if (this.containingDeclarationName != -1) {
            return "of " + (this.containingDeclarationIsElement ? "element " : "attribute ") + this.getNamePool().getDisplayName(this.containingDeclarationName);
        }
        return "defined at line " + this.getLineNumber() + " of " + this.getSystemId();
    }

    public int getContainingDeclarationName() {
        return this.containingDeclarationName;
    }

    public boolean containingDeclarationIsElement() {
        return this.containingDeclarationIsElement;
    }

    public boolean isValidRestriction(SchemaType base, SchemaMarker schema) throws SchemaException {
        return true;
    }
}

