/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_VCL_OPENGL_OPENGLCONTEXT_HXX
#define INCLUDED_VCL_OPENGL_OPENGLCONTEXT_HXX

class OpenGLContext_Impl;

class OpenGLContext
{
public:
    OpenGLContext();
    ~OpenGLContext();

    bool init();

    void makeCurrent();
    void resetCurrent();
    void swapBuffers();
    void sync();

    void setWinPosAndSize(const int nX, const int nY, const int nWidth, const int nHeight);
    void setWinSize(const int nWidth, const int nHeight);

    bool isInitialized() const;

private:
    OpenGLContext(const OpenGLContext&);
    OpenGLContext& operator=(const OpenGLContext&);

    OpenGLContext_Impl* mpImpl;
    bool mbInitialized;
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
