#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

static UnityWebappsContext *global_context = NULL;

static void
presence_changed (UnityWebappsContext *context, gpointer user_data)
{
  printf("Presence changed: %s \n", unity_webapps_indicator_get_presence (global_context));

  uwa_emit_test_finished ();
}

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  unity_webapps_indicator_on_presence_changed_callback (context, presence_changed, NULL);
  global_context = context;

  printf("Read presence: %s \n", unity_webapps_indicator_get_presence (global_context));
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
