/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-application-info.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_APPLICATION_INFO_H
#define __UNITY_WEBAPPS_APPLICATION_INFO_H

#include <glib-object.h>

#define UNITY_WEBAPPS_TYPE_APPLICATION_INFO              (unity_webapps_application_info_get_type())
#define UNITY_WEBAPPS_APPLICATION_INFO(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_APPLICATION_INFO, UnityWebappsApplicationInfo))
#define UNITY_WEBAPPS_APPLICATION_INFO_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_APPLICATION_INFO, UnityWebappsApplicationInfoClass))
#define UNITY_WEBAPPS_IS_APPLICATION_INFO(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_APPLICATION_INFO))
#define UNITY_WEBAPPS_IS_APPLICATION_INFO_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_APPLICATION_INFO))
#define UNITY_WEBAPPS_APPLICATION_INFO_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_APPLICATION_INFO, UnityWebappsApplicationInfoClass))

typedef struct _UnityWebappsApplicationInfoPrivate UnityWebappsApplicationInfoPrivate;

typedef struct _UnityWebappsApplicationInfo UnityWebappsApplicationInfo;


struct _UnityWebappsApplicationInfo {
	GObject object;

	UnityWebappsApplicationInfoPrivate *priv;
};

typedef struct _UnityWebappsApplicationInfoClass UnityWebappsApplicationInfoClass;

struct _UnityWebappsApplicationInfoClass {
	GObjectClass parent_class;
	
	gchar *(*get_desktop_file_name) (UnityWebappsApplicationInfo *info);
	gchar *(*get_desktop_file_path) (UnityWebappsApplicationInfo *info);
	gboolean (*ensure_desktop_file) (UnityWebappsApplicationInfo *info, GError **error);
};

GType unity_webapps_application_info_get_type (void) G_GNUC_CONST;

UnityWebappsApplicationInfo *unity_webapps_application_info_new (const gchar *name, const gchar *domain, const gchar *icon_url, const gchar *mime_types);

const gchar *unity_webapps_application_info_get_name (UnityWebappsApplicationInfo *info);
const gchar *unity_webapps_application_info_get_domain (UnityWebappsApplicationInfo *info);
const gchar *unity_webapps_application_info_get_icon_url (UnityWebappsApplicationInfo *info);

gchar *unity_webapps_application_info_get_canonical_name (UnityWebappsApplicationInfo *info);
gchar *unity_webapps_application_info_get_canonical_domain (UnityWebappsApplicationInfo *info);
gchar *unity_webapps_application_info_get_canonical_full_name (UnityWebappsApplicationInfo *info);

gchar *unity_webapps_application_info_get_desktop_icon_name (UnityWebappsApplicationInfo *info, gboolean may_be_themed);

gchar *unity_webapps_application_info_get_desktop_file_name (UnityWebappsApplicationInfo *info);
gchar *unity_webapps_application_info_get_desktop_file_path (UnityWebappsApplicationInfo *info);

gboolean unity_webapps_application_info_ensure_desktop_file (UnityWebappsApplicationInfo *info, 
															GError **error);
gboolean unity_webapps_application_info_write_desktop_file_to_path (UnityWebappsApplicationInfo *info, 
																   const gchar *path,
																   GError **error);

gchar *unity_webapps_application_info_save_icon_file (UnityWebappsApplicationInfo *info);

void unity_webapps_application_info_add_icon_at_size (UnityWebappsApplicationInfo *info, const gchar *icon_url, gint size);

void unity_webapps_application_info_set_homepage (UnityWebappsApplicationInfo *info, const gchar *homepage);
gchar *unity_webapps_application_info_get_homepage (UnityWebappsApplicationInfo *info);

gboolean
unity_webapps_application_info_open_new_instance (UnityWebappsApplicationInfo *info);

#endif
