#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"
#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

static UnityWebappsContext *context_one = NULL;
static UnityWebappsService *service = NULL;

static void
callback ()
{
}

static void
context_two_ready (UnityWebappsContext *context, gpointer user_data)
{
  UnityWebappsApplicationActionDesc arg[] = {{"/Action 1", callback, NULL}};

  unity_webapps_context_add_application_actions (context, arg, 1);
  unity_webapps_context_remove_application_action (context_one, "/Action 1");
  unity_webapps_context_destroy (context_one, FALSE);
  
  uwa_emit_test_finished ();
}

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  UnityWebappsApplicationActionDesc arg[] = {{"/Action 1", callback, NULL},
                                             {"/Action 2", callback, NULL}};

  context_one = context;

  unity_webapps_context_add_application_actions (context, arg, 2);

  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_two_ready, NULL);
}

gint
main (gint argc, gchar **argv)
{
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
