/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.InsertPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;

public class VerticalPanel
extends CellPanel
implements HasAlignment,
InsertPanel.ForIsWidget {
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign = ALIGN_DEFAULT;
    private HasVerticalAlignment.VerticalAlignmentConstant vertAlign = ALIGN_TOP;

    public VerticalPanel() {
        DOM.setElementProperty(this.getTable(), "cellSpacing", "0");
        DOM.setElementProperty(this.getTable(), "cellPadding", "0");
    }

    public void add(Widget w) {
        Element tr = DOM.createTR();
        Element td = this.createAlignedTd();
        DOM.appendChild(tr, td);
        DOM.appendChild(this.getBody(), tr);
        this.add(w, td);
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    public HasVerticalAlignment.VerticalAlignmentConstant getVerticalAlignment() {
        return this.vertAlign;
    }

    public void insert(IsWidget w, int beforeIndex) {
        this.insert(VerticalPanel.asWidgetOrNull(w), beforeIndex);
    }

    public void insert(Widget w, int beforeIndex) {
        this.checkIndexBoundsForInsertion(beforeIndex);
        Element tr = DOM.createTR();
        Element td = this.createAlignedTd();
        DOM.appendChild(tr, td);
        DOM.insertChild(this.getBody(), tr, beforeIndex);
        this.insert(w, td, beforeIndex, false);
    }

    public boolean remove(Widget w) {
        Element td = DOM.getParent(w.getElement());
        boolean removed = super.remove(w);
        if (removed) {
            DOM.removeChild(this.getBody(), DOM.getParent(td));
        }
        return removed;
    }

    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.horzAlign = align;
    }

    public void setVerticalAlignment(HasVerticalAlignment.VerticalAlignmentConstant align) {
        this.vertAlign = align;
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        int numChildren = this.getWidgetCount();
        for (int i = 0; i < numChildren; ++i) {
            VerticalPanel.ensureDebugId(this.getWidgetTd(this.getWidget(i)), baseID, "" + i);
        }
    }

    private Element createAlignedTd() {
        Element td = DOM.createTD();
        this.setCellHorizontalAlignment(td, this.horzAlign);
        this.setCellVerticalAlignment(td, this.vertAlign);
        return td;
    }
}

