/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.server;

import com.google.gwt.dev.asm.AnnotationVisitor;
import com.google.gwt.dev.asm.ClassReader;
import com.google.gwt.dev.asm.ClassVisitor;
import com.google.gwt.dev.asm.MethodVisitor;
import com.google.gwt.dev.asm.Type;
import com.google.gwt.dev.asm.commons.EmptyVisitor;
import com.google.gwt.dev.asm.commons.Method;
import com.google.gwt.dev.asm.signature.SignatureReader;
import com.google.gwt.dev.asm.signature.SignatureVisitor;
import com.google.gwt.dev.util.Name;
import com.google.web.bindery.autobean.shared.ValueCodex;
import com.google.web.bindery.requestfactory.server.SignatureAdapter;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.InstanceRequest;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.ProxyForName;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.ServiceName;
import com.google.web.bindery.requestfactory.shared.SkipInterfaceValidation;
import com.google.web.bindery.requestfactory.shared.ValueProxy;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestFactoryInterfaceValidator {
    static final Set<Class<?>> VALUE_TYPES = ValueCodex.getAllValueTypes();
    private final Set<String> badTypes = new HashSet<String>();
    private final Type baseProxyIntf = Type.getType(BaseProxy.class);
    private final Map<Type, Type> clientToDomainType = new HashMap<Type, Type>();
    private final Map<Type, Type> clientToLocatorMap = new HashMap<Type, Type>();
    private final Map<Type, List<Type>> domainToClientType = new HashMap<Type, List<Type>>();
    private final Type entityProxyIntf = Type.getType(EntityProxy.class);
    private final Type enumType = Type.getType(Enum.class);
    private final Type errorType = Type.getType(MissingDomainType.class);
    private final Type instanceRequestIntf = Type.getType(InstanceRequest.class);
    private final Loader loader;
    private final Map<Type, Set<RFMethod>> methodsInHierarchy = new HashMap<Type, Set<RFMethod>>();
    private final Type objectType = Type.getObjectType("java/lang/Object");
    private final ErrorContext parentLogger;
    private boolean poisoned;
    private final Type requestIntf = Type.getType(Request.class);
    private final Type requestContextIntf = Type.getType(RequestContext.class);
    private final Map<Type, List<Type>> supertypes = new HashMap<Type, List<Type>>();
    private final Type valueProxyIntf = Type.getType(ValueProxy.class);
    private final Set<String> validatedTypes = new HashSet<String>();
    private final Set<Type> valueTypes = new HashSet<Type>();
    private final Map<Type, Type> unresolvedKeyTypes = new HashMap<Type, Type>();

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java -cp gwt-servlet.jar:your-code.jar " + RequestFactoryInterfaceValidator.class.getCanonicalName() + " com.example.MyRequestFactory");
            System.exit(1);
        }
        RequestFactoryInterfaceValidator validator = new RequestFactoryInterfaceValidator(Logger.getLogger(RequestFactoryInterfaceValidator.class.getName()), (Loader)new ClassLoaderLoader(Thread.currentThread().getContextClassLoader()));
        validator.validateRequestFactory(args[0]);
        System.exit(validator.isPoisoned() ? 1 : 0);
    }

    static String messageCouldNotFindMethod(Type domainType, List<? extends Method> methods) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Could not find matching method in %s.\nPossible matches:\n", RequestFactoryInterfaceValidator.print(domainType)));
        for (Method method : methods) {
            sb.append("  ").append(RequestFactoryInterfaceValidator.print(method)).append("\n");
        }
        return sb.toString();
    }

    private static String print(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestFactoryInterfaceValidator.print(method.getReturnType())).append(" ").append(method.getName()).append("(");
        for (Type t : method.getArgumentTypes()) {
            sb.append(RequestFactoryInterfaceValidator.print(t)).append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    private static String print(Type type) {
        return Name.SourceOrBinaryName.toSourceName(type.getClassName());
    }

    public RequestFactoryInterfaceValidator(Logger logger, Loader loader) {
        for (Class<?> clazz : VALUE_TYPES) {
            this.valueTypes.add(Type.getType(clazz));
        }
        this.parentLogger = new ErrorContext(logger);
        this.parentLogger.setValidator(this);
        this.loader = loader;
    }

    RequestFactoryInterfaceValidator(ErrorContext errorContext, Loader loader) {
        for (Class<?> clazz : VALUE_TYPES) {
            this.valueTypes.add(Type.getType(clazz));
        }
        this.parentLogger = errorContext;
        this.loader = loader;
        errorContext.setValidator(this);
    }

    public void antidote() {
        this.poisoned = false;
    }

    public boolean isPoisoned() {
        return this.poisoned;
    }

    public void validateEntityProxy(String binaryName) {
        this.validateProxy(binaryName, this.entityProxyIntf, true);
    }

    public void validateProxy(String binaryName) {
        Type proxyType = Type.getObjectType(Name.BinaryName.toInternalName(binaryName));
        if (this.isAssignable(this.parentLogger, this.entityProxyIntf, proxyType)) {
            this.validateEntityProxy(binaryName);
        } else if (this.isAssignable(this.parentLogger, this.valueProxyIntf, proxyType)) {
            this.validateValueProxy(binaryName);
        } else {
            this.parentLogger.poison("%s is neither an %s nor a %s", RequestFactoryInterfaceValidator.print(proxyType), RequestFactoryInterfaceValidator.print(this.entityProxyIntf), RequestFactoryInterfaceValidator.print(this.valueProxyIntf));
        }
    }

    public void validateRequestContext(String binaryName) {
        if (this.fastFail(binaryName)) {
            return;
        }
        Type requestContextType = Type.getObjectType(Name.BinaryName.toInternalName(binaryName));
        ErrorContext logger = this.parentLogger.setType(requestContextType);
        if (!this.isAssignable(logger, this.requestContextIntf, requestContextType)) {
            logger.poison("%s is not a %s", RequestFactoryInterfaceValidator.print(requestContextType), RequestContext.class.getSimpleName());
            return;
        }
        Type domainServiceType = this.getDomainType(logger, requestContextType);
        if (domainServiceType == this.errorType) {
            logger.poison("The type %s must be annotated with a @%s or @%s annotation", Name.BinaryName.toSourceName(binaryName), Service.class.getSimpleName(), ServiceName.class.getSimpleName());
            return;
        }
        for (RFMethod method : this.getMethodsInHierarchy(logger, requestContextType)) {
            if (this.findCompatibleMethod(logger, this.requestContextIntf, method, false, true, true) != null) continue;
            this.checkClientMethodInDomain(logger, method, domainServiceType, !this.clientToLocatorMap.containsKey(requestContextType));
            this.maybeCheckReferredProxies(logger, method);
        }
        this.checkUnresolvedKeyTypes(logger);
    }

    public void validateRequestFactory(String binaryName) {
        if (this.fastFail(binaryName)) {
            return;
        }
        Type requestFactoryType = Type.getObjectType(Name.BinaryName.toInternalName(binaryName));
        ErrorContext logger = this.parentLogger.setType(requestFactoryType);
        if (!this.isAssignable(logger, Type.getType(RequestFactory.class), requestFactoryType)) {
            logger.poison("%s is not a %s", RequestFactoryInterfaceValidator.print(requestFactoryType), RequestFactory.class.getSimpleName());
            return;
        }
        for (RFMethod contextMethod : this.getMethodsInHierarchy(logger, requestFactoryType)) {
            Type returnType = contextMethod.getReturnType();
            if (!this.isAssignable(logger, this.requestContextIntf, returnType)) continue;
            this.validateRequestContext(returnType.getClassName());
        }
    }

    public void validateValueProxy(String binaryName) {
        this.validateProxy(binaryName, this.valueProxyIntf, false);
    }

    String getEntityProxyTypeName(String domainTypeBinaryName, String clientTypeBinaryName) {
        Type key = Type.getObjectType(Name.BinaryName.toInternalName(domainTypeBinaryName));
        List<Type> found = this.domainToClientType.get(key);
        if (found == null || found.isEmpty()) {
            List<Type> types = this.getSupertypes(this.parentLogger, key);
            for (Type type : types) {
                if (this.objectType.equals(type) || (found = this.domainToClientType.get(type)) != null && !found.isEmpty()) break;
            }
        }
        if (found == null || found.isEmpty()) {
            return null;
        }
        Type typeToReturn = null;
        if (found.size() == 1) {
            typeToReturn = found.get(0);
        } else {
            Type assignableTo = Type.getObjectType(Name.BinaryName.toInternalName(clientTypeBinaryName));
            for (Type t : found) {
                if (!this.isAssignable(this.parentLogger, assignableTo, t)) continue;
                typeToReturn = t;
                break;
            }
        }
        return typeToReturn == null ? null : typeToReturn.getClassName();
    }

    private void addToDomainMap(ErrorContext logger, Type domainType, Type clientType) {
        this.clientToDomainType.put(clientType, domainType);
        if (this.isAssignable(logger, this.baseProxyIntf, clientType)) {
            this.maybeCheckProxyType(logger, clientType);
            List<Type> list = this.domainToClientType.get(domainType);
            if (list == null) {
                list = new ArrayList<Type>();
                this.domainToClientType.put(domainType, list);
            }
            list.add(clientType);
        }
    }

    private void checkClientMethodInDomain(ErrorContext logger, RFMethod method, Type domainServiceType, boolean requireStaticMethodsForRequestType) {
        logger = logger.setMethod(method);
        Type returnType = this.getReturnType(logger, method);
        Method searchFor = this.createDomainMethod(logger, new Method(method.getName(), returnType, method.getArgumentTypes()));
        RFMethod found = this.findCompatibleServiceMethod(logger, domainServiceType, searchFor, !method.isValidationSkipped());
        if (found != null) {
            boolean isInstance = this.isAssignable(logger, this.instanceRequestIntf, method.getReturnType());
            if (isInstance && found.isDeclaredStatic()) {
                logger.poison("The method %s is declared to return %s, but the service method is static", method.getName(), InstanceRequest.class.getCanonicalName());
            } else if (requireStaticMethodsForRequestType && !isInstance && !found.isDeclaredStatic()) {
                logger.poison("The method %s is declared to return %s, but the service method is not static", method.getName(), Request.class.getCanonicalName());
            }
        }
    }

    private void checkIdAndVersion(ErrorContext logger, Type domainType) {
        if (this.objectType.equals(domainType)) {
            return;
        }
        logger = logger.setType(domainType);
        String findMethodName = "find" + Name.BinaryName.getShortClassName(domainType.getClassName());
        Type keyType = null;
        Method findMethod = null;
        boolean foundFind = false;
        boolean foundId = false;
        boolean foundVersion = false;
        for (RFMethod method : this.getMethodsInHierarchy(logger, domainType)) {
            if ("getId".equals(method.getName()) && method.getArgumentTypes().length == 0) {
                foundId = true;
                keyType = method.getReturnType();
                if (!this.isResolvedKeyType(logger, keyType)) {
                    this.unresolvedKeyTypes.put(domainType, keyType);
                }
            } else if ("getVersion".equals(method.getName()) && method.getArgumentTypes().length == 0) {
                foundVersion = true;
                if (!this.isResolvedKeyType(logger, method.getReturnType())) {
                    this.unresolvedKeyTypes.put(domainType, method.getReturnType());
                }
            } else if (findMethodName.equals(method.getName()) && method.getArgumentTypes().length == 1) {
                foundFind = true;
                findMethod = method;
            }
            if (!foundFind || !foundId || !foundVersion) continue;
            break;
        }
        if (!foundId) {
            logger.poison("There is no getId() method in type %s", RequestFactoryInterfaceValidator.print(domainType));
        }
        if (!foundVersion) {
            logger.poison("There is no getVersion() method in type %s", RequestFactoryInterfaceValidator.print(domainType));
        }
        if (foundFind) {
            if (keyType != null && !this.isAssignable(logger, findMethod.getArgumentTypes()[0], keyType)) {
                logger.poison("The key type returned by %s getId() cannot be used as the argument to %s(%s)", RequestFactoryInterfaceValidator.print(keyType), findMethod.getName(), RequestFactoryInterfaceValidator.print(findMethod.getArgumentTypes()[0]));
            }
        } else {
            logger.poison("There is no %s method in type %s that returns %2$s", findMethodName, RequestFactoryInterfaceValidator.print(domainType));
        }
    }

    private void checkPropertyMethod(ErrorContext logger, RFMethod clientPropertyMethod, Type domainType) {
        logger = logger.setMethod(clientPropertyMethod);
        this.findCompatiblePropertyMethod(logger, domainType, this.createDomainMethod(logger, clientPropertyMethod), !clientPropertyMethod.isValidationSkipped());
    }

    private void checkUnresolvedKeyTypes(ErrorContext logger) {
        this.unresolvedKeyTypes.values().removeAll(this.domainToClientType.keySet());
        if (this.unresolvedKeyTypes.isEmpty()) {
            return;
        }
        for (Map.Entry<Type, Type> type : this.unresolvedKeyTypes.entrySet()) {
            logger.setType(type.getKey()).poison("The domain type %s uses  a non-simple key type (%s) in its getId() or getVersion() method that does not have a proxy mapping.", RequestFactoryInterfaceValidator.print(type.getKey()), RequestFactoryInterfaceValidator.print(type.getValue()));
        }
    }

    private Method createDomainMethod(ErrorContext logger, Method clientMethod) {
        Type[] args = clientMethod.getArgumentTypes();
        int j = args.length;
        for (int i = 0; i < j; ++i) {
            args[i] = this.getDomainType(logger, args[i]);
        }
        Type returnType = this.getDomainType(logger, clientMethod.getReturnType());
        return new Method(clientMethod.getName(), returnType, args);
    }

    private boolean fastFail(String binaryName) {
        if (!Name.isBinaryName(binaryName)) {
            this.parentLogger.poison("%s is not a binary name", binaryName);
            return true;
        }
        if (this.badTypes.contains(binaryName)) {
            this.parentLogger.poison("Type type %s was previously marked as bad", binaryName);
            return true;
        }
        return !this.validatedTypes.add(binaryName);
    }

    private RFMethod findCompatibleMethod(ErrorContext logger, Type domainType, Method searchFor, boolean mustFind, boolean allowOverloads, boolean boxReturnTypes) {
        String methodName = searchFor.getName();
        Type[] clientArgs = searchFor.getArgumentTypes();
        Type clientReturnType = searchFor.getReturnType();
        if (boxReturnTypes) {
            clientReturnType = this.maybeBoxType(clientReturnType);
        }
        LinkedHashMap<String, ArrayList<RFMethod>> domainLookup = new LinkedHashMap<String, ArrayList<RFMethod>>();
        for (RFMethod method : this.getMethodsInHierarchy(logger, domainType)) {
            ArrayList<RFMethod> list = (ArrayList<RFMethod>)domainLookup.get(method.getName());
            if (list == null) {
                list = new ArrayList<RFMethod>();
                domainLookup.put(method.getName(), list);
            }
            list.add(method);
        }
        List methods = (List)domainLookup.get(methodName);
        if (methods == null) {
            if (mustFind) {
                logger.poison("Could not find any methods named %s in %s", methodName, RequestFactoryInterfaceValidator.print(domainType));
            }
            return null;
        }
        if (methods.size() > 1 && !allowOverloads) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Method overloads found in type %s named %s:\n", RequestFactoryInterfaceValidator.print(domainType), methodName));
            for (RFMethod method : methods) {
                sb.append("  ").append(RequestFactoryInterfaceValidator.print(method)).append("\n");
            }
            logger.poison(sb.toString(), new Object[0]);
            return null;
        }
        for (RFMethod domainMethod : methods) {
            Type[] domainArgs = domainMethod.getArgumentTypes();
            Type domainReturnType = domainMethod.getReturnType();
            if (boxReturnTypes) {
                domainReturnType = this.maybeBoxType(domainReturnType);
            }
            if (!this.isAssignable(logger, domainArgs, clientArgs) || !this.isAssignable(logger, clientReturnType, domainReturnType)) continue;
            logger.spam("Mapped client method " + RequestFactoryInterfaceValidator.print(searchFor) + " to " + RequestFactoryInterfaceValidator.print(domainMethod), new Object[0]);
            return domainMethod;
        }
        if (mustFind) {
            logger.poison(RequestFactoryInterfaceValidator.messageCouldNotFindMethod(domainType, methods), new Object[0]);
        }
        return null;
    }

    private RFMethod findCompatiblePropertyMethod(ErrorContext logger, Type domainType, Method searchFor, boolean mustFind) {
        return this.findCompatibleMethod(logger, domainType, searchFor, mustFind, false, false);
    }

    private RFMethod findCompatibleServiceMethod(ErrorContext logger, Type domainType, Method searchFor, boolean mustFind) {
        return this.findCompatibleMethod(logger, domainType, searchFor, mustFind, false, true);
    }

    private Type getBoxedType(Type primitive) {
        switch (primitive.getSort()) {
            case 1: {
                return Type.getType(Boolean.class);
            }
            case 3: {
                return Type.getType(Byte.class);
            }
            case 2: {
                return Type.getType(Character.class);
            }
            case 8: {
                return Type.getType(Double.class);
            }
            case 6: {
                return Type.getType(Float.class);
            }
            case 5: {
                return Type.getType(Integer.class);
            }
            case 7: {
                return Type.getType(Long.class);
            }
            case 4: {
                return Type.getType(Short.class);
            }
            case 0: {
                return Type.getType(Void.class);
            }
        }
        throw new RuntimeException(primitive.getDescriptor() + " is not a primitive type");
    }

    private Type getDomainType(ErrorContext logger, Type clientType) {
        Type domainType = this.clientToDomainType.get(clientType);
        if (domainType != null) {
            return domainType;
        }
        if (this.isValueType(logger, clientType) || this.isCollectionType(logger, clientType)) {
            domainType = clientType;
        } else if (this.entityProxyIntf.equals(clientType) || this.valueProxyIntf.equals(clientType)) {
            domainType = this.objectType;
        } else {
            logger = logger.setType(clientType);
            DomainMapper pv = new DomainMapper(logger);
            this.visit(logger, clientType.getInternalName(), pv);
            if (pv.getDomainInternalName() == null) {
                logger.poison("%s has no mapping to a domain type (e.g. @%s or @%s)", RequestFactoryInterfaceValidator.print(clientType), ProxyFor.class.getSimpleName(), Service.class.getSimpleName());
                domainType = this.errorType;
            } else {
                domainType = Type.getObjectType(pv.getDomainInternalName());
            }
            if (pv.getLocatorInternalName() != null) {
                Type locatorType = Type.getObjectType(pv.getLocatorInternalName());
                this.clientToLocatorMap.put(clientType, locatorType);
            }
        }
        this.addToDomainMap(logger, domainType, clientType);
        this.maybeCheckProxyType(logger, clientType);
        return domainType;
    }

    private Set<RFMethod> getMethodsInHierarchy(ErrorContext logger, Type domainType) {
        Set<RFMethod> toReturn = this.methodsInHierarchy.get(domainType);
        if (toReturn == null) {
            logger = logger.setType(domainType);
            toReturn = new MethodsInHierarchyCollector(logger).exec(domainType.getInternalName());
            this.methodsInHierarchy.put(domainType, Collections.unmodifiableSet(toReturn));
        }
        return toReturn;
    }

    private Type getReturnType(ErrorContext logger, RFMethod method) {
        int expectedCount;
        logger = logger.setMethod(method);
        final String[] returnType = new String[]{this.objectType.getInternalName()};
        String signature = method.getSignature();
        if (method.getReturnType().equals(this.instanceRequestIntf)) {
            expectedCount = 2;
        } else if (method.getReturnType().equals(this.requestIntf)) {
            expectedCount = 1;
        } else {
            logger.spam("Punting on " + signature, new Object[0]);
            return Type.getObjectType(returnType[0]);
        }
        new SignatureReader(signature).accept(new SignatureAdapter(){

            public SignatureVisitor visitReturnType() {
                return new SignatureAdapter(){
                    int count;

                    public SignatureVisitor visitTypeArgument(char wildcard) {
                        if (++this.count == expectedCount) {
                            return new SignatureAdapter(){

                                public void visitClassType(String name) {
                                    returnType[0] = name;
                                }
                            };
                        }
                        return super.visitTypeArgument(wildcard);
                    }
                };
            }
        });
        logger.spam("Extracted " + returnType[0], new Object[0]);
        return Type.getObjectType(returnType[0]);
    }

    private List<Type> getSupertypes(ErrorContext logger, Type type) {
        if (type.getSort() != 10) {
            return Collections.emptyList();
        }
        List<Type> toReturn = this.supertypes.get(type);
        if (toReturn != null) {
            return toReturn;
        }
        logger = logger.setType(type);
        toReturn = new SupertypeCollector(logger).exec(type);
        this.supertypes.put(type, Collections.unmodifiableList(toReturn));
        return toReturn;
    }

    private boolean isAssignable(ErrorContext logger, Type possibleSupertype, Type possibleSubtype) {
        if (possibleSupertype.equals(possibleSubtype)) {
            return true;
        }
        List<Type> allSupertypes = this.getSupertypes(logger, possibleSubtype);
        return allSupertypes.contains(possibleSupertype);
    }

    private boolean isAssignable(ErrorContext logger, Type[] possibleSupertypes, Type[] possibleSubtypes) {
        if (possibleSupertypes.length != possibleSubtypes.length) {
            return false;
        }
        int j = possibleSupertypes.length;
        for (int i = 0; i < j; ++i) {
            if (this.isAssignable(logger, possibleSupertypes[i], possibleSubtypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isCollectionType(ErrorContext logger, Type type) {
        return "java/util/List".equals(type.getInternalName()) || "java/util/Set".equals(type.getInternalName());
    }

    private boolean isResolvedKeyType(ErrorContext logger, Type type) {
        if (this.isValueType(logger, type)) {
            return true;
        }
        return this.domainToClientType.containsKey(type);
    }

    private boolean isValueType(ErrorContext logger, Type type) {
        if (type.getSort() != 10) {
            return true;
        }
        if (this.valueTypes.contains(type)) {
            return true;
        }
        return this.isAssignable(logger = logger.setType(type), this.enumType, type);
    }

    private Type maybeBoxType(Type maybePrimitive) {
        if (maybePrimitive.getSort() == 10) {
            return maybePrimitive;
        }
        return this.getBoxedType(maybePrimitive);
    }

    private void maybeCheckProxyType(ErrorContext logger, Type ... types) {
        for (Type type : types) {
            if (this.isAssignable(logger, this.entityProxyIntf, type)) {
                this.validateEntityProxy(type.getClassName());
                continue;
            }
            if (this.isAssignable(logger, this.valueProxyIntf, type)) {
                this.validateValueProxy(type.getClassName());
                continue;
            }
            if (!this.isAssignable(logger, this.baseProxyIntf, type)) continue;
            logger.poison("Invalid type hierarchy for %s. Only types derived from %s or %s may be used.", RequestFactoryInterfaceValidator.print(type), RequestFactoryInterfaceValidator.print(this.entityProxyIntf), RequestFactoryInterfaceValidator.print(this.valueProxyIntf));
        }
    }

    private void maybeCheckReferredProxies(ErrorContext logger, RFMethod method) {
        if (method.getSignature() != null) {
            TypesInSignatureCollector collector = new TypesInSignatureCollector();
            SignatureReader reader = new SignatureReader(method.getSignature());
            reader.accept(collector);
            this.maybeCheckProxyType(logger, collector.getFound());
        } else {
            Type[] argTypes = method.getArgumentTypes();
            Type returnType = this.getReturnType(logger, method);
            this.maybeCheckProxyType(logger, argTypes);
            this.maybeCheckProxyType(logger, returnType);
        }
    }

    private void validateProxy(String binaryName, Type expectedType, boolean requireId) {
        Type locatorType;
        if (this.fastFail(binaryName)) {
            return;
        }
        Type proxyType = Type.getObjectType(Name.BinaryName.toInternalName(binaryName));
        ErrorContext logger = this.parentLogger.setType(proxyType);
        if (!this.isAssignable(logger, expectedType, proxyType)) {
            this.parentLogger.poison("%s is not a %s", RequestFactoryInterfaceValidator.print(proxyType), RequestFactoryInterfaceValidator.print(expectedType));
            return;
        }
        Type domainType = this.getDomainType(logger, proxyType);
        if (domainType == this.errorType) {
            logger.poison("The type %s must be annotated with a @%s or @%s annotation", Name.BinaryName.toSourceName(binaryName), ProxyFor.class.getSimpleName(), ProxyForName.class.getSimpleName());
            return;
        }
        if (requireId && (locatorType = this.clientToLocatorMap.get(proxyType)) == null) {
            this.checkIdAndVersion(logger, domainType);
        }
        Set<RFMethod> clientPropertyMethods = this.getMethodsInHierarchy(logger, proxyType);
        for (RFMethod clientPropertyMethod : clientPropertyMethods) {
            if ("stableId".equals(clientPropertyMethod.getName()) && clientPropertyMethod.getArgumentTypes().length == 0) continue;
            this.checkPropertyMethod(logger, clientPropertyMethod, domainType);
            this.maybeCheckReferredProxies(logger, clientPropertyMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean visit(ErrorContext logger, String internalName, ClassVisitor visitor) {
        InputStream inputStream;
        block11: {
            assert (Name.isInternalName(internalName)) : "internalName";
            logger.spam("Visiting " + internalName, new Object[0]);
            inputStream = null;
            inputStream = this.loader.getResourceAsStream(internalName + ".class");
            if (inputStream != null) break block11;
            logger.poison("Could not find class file for " + internalName, new Object[0]);
            boolean bl = false;
            Object var8_8 = null;
            if (inputStream == null) return bl;
            try {
                inputStream.close();
                return bl;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            return bl;
        }
        ClassReader reader = new ClassReader(inputStream);
        reader.accept(visitor, 7);
        boolean bl = true;
        Object var8_9 = null;
        if (inputStream == null) return bl;
        try {
            inputStream.close();
            return bl;
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return bl;
        catch (IOException e) {
            try {
                logger.poison("Unable to open " + internalName, e);
                Object var8_10 = null;
                if (inputStream == null) return false;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return false;
            }
            catch (IOException ignored) {}
            return false;
        }
    }

    private static class TypesInSignatureCollector
    extends SignatureAdapter {
        private final Set<Type> found = new HashSet<Type>();

        private TypesInSignatureCollector() {
        }

        public Type[] getFound() {
            return this.found.toArray(new Type[this.found.size()]);
        }

        public SignatureVisitor visitArrayType() {
            return this;
        }

        public SignatureVisitor visitClassBound() {
            return this;
        }

        public void visitClassType(String name) {
            this.found.add(Type.getObjectType(name));
        }

        public SignatureVisitor visitExceptionType() {
            return this;
        }

        public SignatureVisitor visitInterface() {
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            return this;
        }

        public SignatureVisitor visitParameterType() {
            return this;
        }

        public SignatureVisitor visitReturnType() {
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            return this;
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SupertypeCollector
    extends EmptyVisitor {
        private final ErrorContext logger;
        private final Set<String> seen = new HashSet<String>();
        private final List<Type> supers = new ArrayList<Type>();

        public SupertypeCollector(ErrorContext logger) {
            this.logger = logger;
        }

        public List<Type> exec(Type type) {
            RequestFactoryInterfaceValidator.this.visit(this.logger, type.getInternalName(), this);
            return this.supers;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!this.seen.add(name)) {
                return;
            }
            this.supers.add(Type.getObjectType(name));
            if (!RequestFactoryInterfaceValidator.this.objectType.getInternalName().equals(name)) {
                RequestFactoryInterfaceValidator.this.visit(this.logger, superName, this);
            }
            if (interfaces != null) {
                for (String intf : interfaces) {
                    RequestFactoryInterfaceValidator.this.visit(this.logger, intf, this);
                }
            }
        }
    }

    private static class RFMethod
    extends Method {
        private boolean isDeclaredStatic;
        private String signature;
        private boolean isValidationSkipped;

        public RFMethod(String name, String desc) {
            super(name, desc);
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean isDeclaredStatic() {
            return this.isDeclaredStatic;
        }

        public boolean isValidationSkipped() {
            return this.isValidationSkipped;
        }

        public void setDeclaredSignature(String signature) {
            this.signature = signature;
        }

        public void setDeclaredStatic(boolean value) {
            this.isDeclaredStatic = value;
        }

        public void setValidationSkipped(boolean isValidationSkipped) {
            this.isValidationSkipped = isValidationSkipped;
        }

        public String toString() {
            return (this.isDeclaredStatic ? "static " : "") + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodsInHierarchyCollector
    extends EmptyVisitor {
        private final ErrorContext logger;
        private Set<RFMethod> methods = new LinkedHashSet<RFMethod>();
        private Set<String> seen = new HashSet<String>();

        private MethodsInHierarchyCollector(ErrorContext logger) {
            this.logger = logger;
        }

        public Set<RFMethod> exec(String internalName) {
            RequestFactoryInterfaceValidator.this.visit(this.logger, internalName, this);
            HashMap<RFMethod, RFMethod> toReturn = new HashMap<RFMethod, RFMethod>();
            for (RFMethod method : this.methods) {
                RFMethod key = new RFMethod(method.getName(), Type.getMethodDescriptor(Type.VOID_TYPE, method.getArgumentTypes()));
                RFMethod compareTo = (RFMethod)toReturn.get(key);
                if (compareTo == null) {
                    toReturn.put(key, method);
                    continue;
                }
                if (!RequestFactoryInterfaceValidator.this.isAssignable(this.logger, compareTo.getReturnType(), method.getReturnType())) continue;
                toReturn.put(key, method);
            }
            return new HashSet<RFMethod>(toReturn.values());
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!this.seen.add(name)) {
                return;
            }
            if (!RequestFactoryInterfaceValidator.this.objectType.getInternalName().equals(superName)) {
                RequestFactoryInterfaceValidator.this.visit(this.logger, superName, this);
            }
            if (interfaces != null) {
                for (String intf : interfaces) {
                    RequestFactoryInterfaceValidator.this.visit(this.logger, intf, this);
                }
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ("<clinit>".equals(name) || "<init>".equals(name)) {
                return null;
            }
            final RFMethod method = new RFMethod(name, desc);
            method.setDeclaredStatic((access & 8) != 0);
            method.setDeclaredSignature(signature);
            this.methods.add(method);
            return new EmptyVisitor(){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (desc.equals(Type.getDescriptor(SkipInterfaceValidation.class))) {
                        method.setValidationSkipped(true);
                    }
                    return null;
                }
            };
        }
    }

    private class DomainMapper
    extends EmptyVisitor {
        private final ErrorContext logger;
        private String domainInternalName;
        private List<Class<? extends Annotation>> found = new ArrayList<Class<? extends Annotation>>();
        private String locatorInternalName;

        public DomainMapper(ErrorContext logger) {
            this.logger = logger;
            logger.spam("Finding domain mapping annotation", new Object[0]);
        }

        public String getDomainInternalName() {
            return this.domainInternalName;
        }

        public String getLocatorInternalName() {
            return this.locatorInternalName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if ((access & 0x200) == 0) {
                this.logger.poison("Type must be an interface", new Object[0]);
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            boolean expectClasses = false;
            boolean expectNames = false;
            if (desc.equals(Type.getDescriptor(ProxyFor.class))) {
                expectClasses = true;
                this.found.add(ProxyFor.class);
            } else if (desc.equals(Type.getDescriptor(ProxyForName.class))) {
                expectNames = true;
                this.found.add(ProxyForName.class);
            } else if (desc.equals(Type.getDescriptor(Service.class))) {
                expectClasses = true;
                this.found.add(Service.class);
            } else if (desc.equals(Type.getDescriptor(ServiceName.class))) {
                expectNames = true;
                this.found.add(ServiceName.class);
            }
            if (expectClasses) {
                return new EmptyVisitor(){

                    public void visit(String name, Object value) {
                        if ("value".equals(name)) {
                            DomainMapper.this.domainInternalName = ((Type)value).getInternalName();
                        } else if ("locator".equals(name)) {
                            DomainMapper.this.locatorInternalName = ((Type)value).getInternalName();
                        }
                    }
                };
            }
            if (expectNames) {
                return new EmptyVisitor(){

                    public void visit(String name, Object value) {
                        boolean locatorRequired = "locator".equals(name);
                        boolean valueRequired = "value".equals(name);
                        if (!valueRequired && !locatorRequired) {
                            return;
                        }
                        String sourceName = (String)value;
                        StringBuffer desc = new StringBuffer(sourceName.replace('.', '/'));
                        while (!RequestFactoryInterfaceValidator.this.loader.exists(desc.toString() + ".class")) {
                            DomainMapper.this.logger.spam("Did not find " + desc.toString(), new Object[0]);
                            int idx = desc.lastIndexOf("/");
                            if (idx == -1) {
                                if (locatorRequired) {
                                    DomainMapper.this.logger.poison("Cannot find locator named %s", value);
                                } else if (valueRequired) {
                                    DomainMapper.this.logger.poison("Cannot find domain type named %s", value);
                                }
                                return;
                            }
                            desc.setCharAt(idx, '$');
                        }
                        if (locatorRequired) {
                            DomainMapper.this.locatorInternalName = desc.toString();
                            DomainMapper.this.logger.spam(DomainMapper.this.locatorInternalName, new Object[0]);
                        } else if (valueRequired) {
                            DomainMapper.this.domainInternalName = desc.toString();
                            DomainMapper.this.logger.spam(DomainMapper.this.domainInternalName, new Object[0]);
                        } else {
                            throw new RuntimeException("Should not reach here");
                        }
                    }
                };
            }
            return null;
        }

        public void visitEnd() {
            if (this.found.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (Class<? extends Annotation> clazz : this.found) {
                    sb.append(" @").append(clazz.getSimpleName());
                }
                this.logger.poison("Redundant domain mapping annotations present:%s", sb.toString());
            }
        }
    }

    static interface MissingDomainType {
    }

    static class ErrorContext {
        private final Logger logger;
        private final ErrorContext parent;
        private Type currentType;
        private Method currentMethod;
        private RequestFactoryInterfaceValidator validator;

        public ErrorContext(Logger logger) {
            this.logger = logger;
            this.parent = null;
        }

        protected ErrorContext(ErrorContext parent) {
            this.logger = parent.logger;
            this.parent = parent;
            this.validator = parent.validator;
        }

        public void poison(String msg, Object ... args) {
            this.poison();
            this.logger.logp(Level.SEVERE, this.currentType(), this.currentMethod(), String.format(msg, args));
            this.validator.poisoned = true;
        }

        public void poison(String msg, Throwable t) {
            this.poison();
            this.logger.logp(Level.SEVERE, this.currentType(), this.currentMethod(), msg, t);
            this.validator.poisoned = true;
        }

        public ErrorContext setMethod(Method method) {
            ErrorContext toReturn = this.fork();
            toReturn.currentMethod = method;
            return toReturn;
        }

        public ErrorContext setType(Type type) {
            ErrorContext toReturn = this.fork();
            toReturn.currentType = type;
            return toReturn;
        }

        public void spam(String msg, Object ... args) {
            this.logger.logp(Level.FINEST, this.currentType(), this.currentMethod(), String.format(msg, args));
        }

        protected ErrorContext fork() {
            return new ErrorContext(this);
        }

        void setValidator(RequestFactoryInterfaceValidator validator) {
            assert (this.validator == null) : "Cannot set validator twice";
            this.validator = validator;
        }

        private String currentMethod() {
            if (this.currentMethod != null) {
                return RequestFactoryInterfaceValidator.print(this.currentMethod);
            }
            if (this.parent != null) {
                return this.parent.currentMethod();
            }
            return null;
        }

        private String currentType() {
            if (this.currentType != null) {
                return RequestFactoryInterfaceValidator.print(this.currentType);
            }
            if (this.parent != null) {
                return this.parent.currentType();
            }
            return null;
        }

        private void poison() {
            if (this.currentType != null) {
                this.validator.badTypes.add(this.currentType.getClassName());
            }
            if (this.parent != null) {
                this.parent.poison();
            }
        }
    }

    public static interface Loader {
        public boolean exists(String var1);

        public InputStream getResourceAsStream(String var1);
    }

    public static class ClassLoaderLoader
    implements Loader {
        private final ClassLoader loader;

        public ClassLoaderLoader(ClassLoader loader) {
            this.loader = loader;
        }

        public boolean exists(String resource) {
            return this.loader.getResource(resource) != null;
        }

        public InputStream getResourceAsStream(String resource) {
            return this.loader.getResourceAsStream(resource);
        }
    }
}

