/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "uk" locale.
 */
public class LocalizedNamesImpl_uk extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "UA",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AU",
        "AT",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AW",
        "AF",
        "BS",
        "BD",
        "BB",
        "BH",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BY",
        "BG",
        "BO",
        "BA",
        "BW",
        "BR",
        "IO",
        "BN",
        "BF",
        "BI",
        "BT",
        "VU",
        "VA",
        "GB",
        "VE",
        "UM",
        "VG",
        "VI",
        "AM",
        "VN",
        "GA",
        "HT",
        "GY",
        "GM",
        "GH",
        "GP",
        "GT",
        "GN",
        "GW",
        "GG",
        "GI",
        "HN",
        "HK",
        "GD",
        "GL",
        "GR",
        "GE",
        "GU",
        "DK",
        "JE",
        "DJ",
        "DG",
        "DM",
        "DO",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "EG",
        "YE",
        "ZM",
        "EH",
        "ZW",
        "IL",
        "IN",
        "ID",
        "QO",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "JO",
        "CV",
        "KZ",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "QA",
        "KE",
        "KG",
        "CN",
        "CY",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "CI",
        "CU",
        "KW",
        "LA",
        "LV",
        "LS",
        "LT",
        "LR",
        "LB",
        "LY",
        "LI",
        "LU",
        "MU",
        "MR",
        "MG",
        "YT",
        "MO",
        "MK",
        "MW",
        "MY",
        "ML",
        "MV",
        "MT",
        "MA",
        "MQ",
        "MH",
        "MX",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NL",
        "AN",
        "NI",
        "DE",
        "NU",
        "NZ",
        "NC",
        "NO",
        "AE",
        "OM",
        "BV",
        "AC",
        "CP",
        "IM",
        "NF",
        "CX",
        "BL",
        "MF",
        "SH",
        "CK",
        "SJ",
        "HM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "ZA",
        "PY",
        "PE",
        "GS",
        "KR",
        "KP",
        "MP",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "RU",
        "RW",
        "RO",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "SC",
        "SN",
        "PM",
        "VC",
        "KN",
        "LC",
        "RS",
        "CS",
        "EA",
        "SY",
        "SG",
        "SK",
        "SI",
        "SB",
        "SO",
        "SD",
        "SR",
        "US",
        "SL",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TC",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TR",
        "TM",
        "UG",
        "HU",
        "UZ",
        "UA",
        "WF",
        "UY",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "HR",
        "CF",
        "TD",
        "CZ",
        "CL",
        "ME",
        "CH",
        "SE",
        "LK",
        "JM",
        "JP",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Світ");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Північноамериканський континент");
    namesMap.put("005", "Південна Америка");
    namesMap.put("009", "Океанія");
    namesMap.put("011", "Західна Африка");
    namesMap.put("013", "Центральна Америка");
    namesMap.put("014", "Східна Африка");
    namesMap.put("015", "Північна Африка");
    namesMap.put("017", "Центральна Африка");
    namesMap.put("018", "Південна Африка");
    namesMap.put("019", "Америки");
    namesMap.put("021", "Північна Америка");
    namesMap.put("029", "Карибський басейн");
    namesMap.put("030", "Східна Азія");
    namesMap.put("034", "Південна Азія");
    namesMap.put("035", "Південно-Східна Азія");
    namesMap.put("039", "Південна Європа");
    namesMap.put("053", "Австралія та Нова Зеландія");
    namesMap.put("054", "Меланезія");
    namesMap.put("057", "Мікронезійський регіон");
    namesMap.put("061", "Полінезія");
    namesMap.put("062", "Південно-Центральна Азія");
    namesMap.put("142", "Азія");
    namesMap.put("143", "Центральна Азія");
    namesMap.put("145", "Західна Азія");
    namesMap.put("150", "Європа");
    namesMap.put("151", "Східна Європа");
    namesMap.put("154", "Північна Європа");
    namesMap.put("155", "Західна Європа");
    namesMap.put("172", "Співдружність Незалежних Держав");
    namesMap.put("419", "Латинська Америка і Карибський басейн");
    namesMap.put("830", "Нормандські острови");
    namesMap.put("AC", "Острів Вознесіння");
    namesMap.put("AD", "Андорра");
    namesMap.put("AE", "Обʼєднані Арабські Емірати");
    namesMap.put("AF", "Афганістан");
    namesMap.put("AG", "Антигуа і Барбуда");
    namesMap.put("AI", "Ангілья");
    namesMap.put("AL", "Албанія");
    namesMap.put("AM", "Вірменія");
    namesMap.put("AN", "Нідерландські Антильські Острови");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктида");
    namesMap.put("AR", "Аргентина");
    namesMap.put("AS", "Американське Самоа");
    namesMap.put("AT", "Австрія");
    namesMap.put("AU", "Австралія");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аландські острови");
    namesMap.put("AZ", "Азербайджан");
    namesMap.put("BA", "Боснія і Герцоговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Бельгія");
    namesMap.put("BF", "Буркіна-Фасо");
    namesMap.put("BG", "Болгарія");
    namesMap.put("BH", "Бахрейн");
    namesMap.put("BI", "Бурунді");
    namesMap.put("BJ", "Бенін");
    namesMap.put("BL", "Острів Святого Бартоломея");
    namesMap.put("BM", "Бермуди");
    namesMap.put("BN", "Бруней");
    namesMap.put("BO", "Болівія");
    namesMap.put("BR", "Бразилія");
    namesMap.put("BS", "Багами");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Острів Буве");
    namesMap.put("BW", "Ботсвана");
    namesMap.put("BY", "Білорусь");
    namesMap.put("BZ", "Беліз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокосові острови");
    namesMap.put("CD", "Конґо - Кіншаса");
    namesMap.put("CF", "Центральноафриканська Республіка");
    namesMap.put("CG", "Конґо - Браззавіль");
    namesMap.put("CH", "Швейцарія");
    namesMap.put("CI", "Кот д’Івуар");
    namesMap.put("CK", "Острови Кука");
    namesMap.put("CL", "Чилі");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Китай");
    namesMap.put("CO", "Колумбія");
    namesMap.put("CP", "Острів Кліппертон");
    namesMap.put("CR", "Коста-Рика");
    namesMap.put("CS", "Сербія та Чорногорія");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Кабо-Верде");
    namesMap.put("CX", "Острів Різдва");
    namesMap.put("CY", "Кіпр");
    namesMap.put("CZ", "Чеська республіка");
    namesMap.put("DE", "Німеччина");
    namesMap.put("DG", "Дієґо-Ґарсія");
    namesMap.put("DJ", "Джібуті");
    namesMap.put("DK", "Данія");
    namesMap.put("DM", "Домінік");
    namesMap.put("DO", "Домініканська Республіка");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута і Мелілья");
    namesMap.put("EC", "Еквадор");
    namesMap.put("EE", "Естонія");
    namesMap.put("EG", "Єгипет");
    namesMap.put("EH", "Західна Сахара");
    namesMap.put("ER", "Еритрея");
    namesMap.put("ES", "Іспанія");
    namesMap.put("ET", "Ефіопія");
    namesMap.put("EU", "Європейський Союз");
    namesMap.put("FI", "Фінляндія");
    namesMap.put("FJ", "Фіджі");
    namesMap.put("FK", "Фолклендські острови");
    namesMap.put("FM", "Мікронезія Федеративні Штати");
    namesMap.put("FO", "Фарерські острови");
    namesMap.put("FR", "Франція");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Великобританія");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузія");
    namesMap.put("GF", "Французька Гвіана");
    namesMap.put("GG", "Гернсі");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гібралтар");
    namesMap.put("GL", "Гренландія");
    namesMap.put("GM", "Гамбія");
    namesMap.put("GN", "Гвінея");
    namesMap.put("GP", "Гваделупа");
    namesMap.put("GQ", "Екваторіальна Гвінея");
    namesMap.put("GR", "Греція");
    namesMap.put("GS", "Південна Джорджія та Південні Сандвічеві Острови");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвінея-Біссау");
    namesMap.put("GY", "Гайана");
    namesMap.put("HK", "Гонконґ");
    namesMap.put("HM", "Острови Херд і Мак-Дональд");
    namesMap.put("HN", "Гондурас");
    namesMap.put("HR", "Хорватія");
    namesMap.put("HT", "Гаїті");
    namesMap.put("HU", "Угорщина");
    namesMap.put("IC", "Канарські острови");
    namesMap.put("ID", "Індонезія");
    namesMap.put("IE", "Ірландія");
    namesMap.put("IL", "Ізраїль");
    namesMap.put("IM", "Острів Мен");
    namesMap.put("IN", "Індія");
    namesMap.put("IO", "Британські території Індійського океану");
    namesMap.put("IQ", "Ірак");
    namesMap.put("IR", "Іран");
    namesMap.put("IS", "Ісландія");
    namesMap.put("IT", "Італія");
    namesMap.put("JE", "Джерсі");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Йорданія");
    namesMap.put("JP", "Японія");
    namesMap.put("KE", "Кенія");
    namesMap.put("KG", "Киргизстан");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кірибаті");
    namesMap.put("KM", "Коморські Острови");
    namesMap.put("KN", "Сент-Кітс і Невіс");
    namesMap.put("KP", "Північна Корея");
    namesMap.put("KR", "Південна Корея");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Кайманові острови");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ліван");
    namesMap.put("LC", "Сент-Люсія");
    namesMap.put("LI", "Ліхтенштейн");
    namesMap.put("LK", "Шрі-Ланка");
    namesMap.put("LR", "Ліберія");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвія");
    namesMap.put("LY", "Лівія");
    namesMap.put("MA", "Марокко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова");
    namesMap.put("ME", "Чорногорія");
    namesMap.put("MF", "Острів Святого Мартіна");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршаллові Острови");
    namesMap.put("MK", "Македонія");
    namesMap.put("ML", "Малі");
    namesMap.put("MM", "Мʼянма [Бірма]");
    namesMap.put("MN", "Монголія");
    namesMap.put("MO", "Макао");
    namesMap.put("MP", "Північні Маріанські Острови");
    namesMap.put("MQ", "Мартиніка");
    namesMap.put("MR", "Мавританія");
    namesMap.put("MS", "Монсеррат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Маврикій");
    namesMap.put("MV", "Мальдіви");
    namesMap.put("MW", "Малаві");
    namesMap.put("MX", "Мексика");
    namesMap.put("MY", "Малайзія");
    namesMap.put("MZ", "Мозамбік");
    namesMap.put("NA", "Намібія");
    namesMap.put("NC", "Нова Каледонія");
    namesMap.put("NE", "Нігер");
    namesMap.put("NF", "Острів Норфолк");
    namesMap.put("NG", "Нігерія");
    namesMap.put("NI", "Нікарагуа");
    namesMap.put("NL", "Нідерланди");
    namesMap.put("NO", "Норвегія");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Нія");
    namesMap.put("NZ", "Нова Зеландія");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Французька Полінезія");
    namesMap.put("PG", "Папуа Нова Гвінея");
    namesMap.put("PH", "Філіппіни");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Польща");
    namesMap.put("PM", "Сен-Пʼєр і Мікелон");
    namesMap.put("PN", "Піткерн");
    namesMap.put("PR", "Пуерто-Ріко");
    namesMap.put("PS", "Палестина");
    namesMap.put("PT", "Португалія");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Інша Океанія");
    namesMap.put("RE", "Реюньйон");
    namesMap.put("RO", "Румунія");
    namesMap.put("RS", "Сербія");
    namesMap.put("RU", "Росія");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудівська Аравія");
    namesMap.put("SB", "Соломонові Острови");
    namesMap.put("SC", "Сейшели");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швеція");
    namesMap.put("SG", "Сінгапур");
    namesMap.put("SH", "Острів Святої Єлени");
    namesMap.put("SI", "Словенія");
    namesMap.put("SJ", "Острови Свальбард та Ян-Маєн");
    namesMap.put("SK", "Словакія");
    namesMap.put("SL", "Сьєрра-Леоне");
    namesMap.put("SM", "Сан-Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомалі");
    namesMap.put("SR", "Суринам");
    namesMap.put("ST", "Сан-Томе і Прінсіпі");
    namesMap.put("SV", "Сальвадор");
    namesMap.put("SY", "Сирія");
    namesMap.put("SZ", "Свазіленд");
    namesMap.put("TA", "Трістан-да-Кунья");
    namesMap.put("TC", "Теркс і Кайкос");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Французькі Південні Території");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Таїланд");
    namesMap.put("TJ", "Таджикистан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Тімор-Лешті");
    namesMap.put("TM", "Туркменистан");
    namesMap.put("TN", "Туніс");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Туреччина");
    namesMap.put("TT", "Тринідад і Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайвань");
    namesMap.put("TZ", "Танзанія");
    namesMap.put("UA", "Україна");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "Віддалені Острови США");
    namesMap.put("US", "США");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Узбекистан");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Сент-Вінсент і Гренадини");
    namesMap.put("VE", "Венесуела");
    namesMap.put("VG", "Віргінські острови Британії");
    namesMap.put("VI", "Віргінські острови США");
    namesMap.put("VN", "Вʼєтнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уолліс і Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("YE", "Ємен");
    namesMap.put("YT", "Майот");
    namesMap.put("ZA", "ПАР");
    namesMap.put("ZM", "Замбія");
    namesMap.put("ZW", "Зімбабве");
    namesMap.put("ZZ", "Невідомий або неправильний регіон");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Світ",
        "002": "Африка",
        "003": "Північноамериканський континент",
        "005": "Південна Америка",
        "009": "Океанія",
        "011": "Західна Африка",
        "013": "Центральна Америка",
        "014": "Східна Африка",
        "015": "Північна Африка",
        "017": "Центральна Африка",
        "018": "Південна Африка",
        "019": "Америки",
        "021": "Північна Америка",
        "029": "Карибський басейн",
        "030": "Східна Азія",
        "034": "Південна Азія",
        "035": "Південно-Східна Азія",
        "039": "Південна Європа",
        "053": "Австралія та Нова Зеландія",
        "054": "Меланезія",
        "057": "Мікронезійський регіон",
        "061": "Полінезія",
        "062": "Південно-Центральна Азія",
        "142": "Азія",
        "143": "Центральна Азія",
        "145": "Західна Азія",
        "150": "Європа",
        "151": "Східна Європа",
        "154": "Північна Європа",
        "155": "Західна Європа",
        "172": "Співдружність Незалежних Держав",
        "419": "Латинська Америка і Карибський басейн",
        "830": "Нормандські острови",
        "AC": "Острів Вознесіння",
        "AD": "Андорра",
        "AE": "Обʼєднані Арабські Емірати",
        "AF": "Афганістан",
        "AG": "Антигуа і Барбуда",
        "AI": "Ангілья",
        "AL": "Албанія",
        "AM": "Вірменія",
        "AN": "Нідерландські Антильські Острови",
        "AO": "Ангола",
        "AQ": "Антарктида",
        "AR": "Аргентина",
        "AS": "Американське Самоа",
        "AT": "Австрія",
        "AU": "Австралія",
        "AW": "Аруба",
        "AX": "Аландські острови",
        "AZ": "Азербайджан",
        "BA": "Боснія і Герцоговина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Бельгія",
        "BF": "Буркіна-Фасо",
        "BG": "Болгарія",
        "BH": "Бахрейн",
        "BI": "Бурунді",
        "BJ": "Бенін",
        "BL": "Острів Святого Бартоломея",
        "BM": "Бермуди",
        "BN": "Бруней",
        "BO": "Болівія",
        "BR": "Бразилія",
        "BS": "Багами",
        "BT": "Бутан",
        "BV": "Острів Буве",
        "BW": "Ботсвана",
        "BY": "Білорусь",
        "BZ": "Беліз",
        "CA": "Канада",
        "CC": "Кокосові острови",
        "CD": "Конґо - Кіншаса",
        "CF": "Центральноафриканська Республіка",
        "CG": "Конґо - Браззавіль",
        "CH": "Швейцарія",
        "CI": "Кот д’Івуар",
        "CK": "Острови Кука",
        "CL": "Чилі",
        "CM": "Камерун",
        "CN": "Китай",
        "CO": "Колумбія",
        "CP": "Острів Кліппертон",
        "CR": "Коста-Рика",
        "CS": "Сербія та Чорногорія",
        "CU": "Куба",
        "CV": "Кабо-Верде",
        "CX": "Острів Різдва",
        "CY": "Кіпр",
        "CZ": "Чеська республіка",
        "DE": "Німеччина",
        "DG": "Дієґо-Ґарсія",
        "DJ": "Джібуті",
        "DK": "Данія",
        "DM": "Домінік",
        "DO": "Домініканська Республіка",
        "DZ": "Алжир",
        "EA": "Сеута і Мелілья",
        "EC": "Еквадор",
        "EE": "Естонія",
        "EG": "Єгипет",
        "EH": "Західна Сахара",
        "ER": "Еритрея",
        "ES": "Іспанія",
        "ET": "Ефіопія",
        "EU": "Європейський Союз",
        "FI": "Фінляндія",
        "FJ": "Фіджі",
        "FK": "Фолклендські острови",
        "FM": "Мікронезія Федеративні Штати",
        "FO": "Фарерські острови",
        "FR": "Франція",
        "GA": "Габон",
        "GB": "Великобританія",
        "GD": "Гренада",
        "GE": "Грузія",
        "GF": "Французька Гвіана",
        "GG": "Гернсі",
        "GH": "Гана",
        "GI": "Гібралтар",
        "GL": "Гренландія",
        "GM": "Гамбія",
        "GN": "Гвінея",
        "GP": "Гваделупа",
        "GQ": "Екваторіальна Гвінея",
        "GR": "Греція",
        "GS": "Південна Джорджія та Південні Сандвічеві Острови",
        "GT": "Гватемала",
        "GU": "Гуам",
        "GW": "Гвінея-Біссау",
        "GY": "Гайана",
        "HK": "Гонконґ",
        "HM": "Острови Херд і Мак-Дональд",
        "HN": "Гондурас",
        "HR": "Хорватія",
        "HT": "Гаїті",
        "HU": "Угорщина",
        "IC": "Канарські острови",
        "ID": "Індонезія",
        "IE": "Ірландія",
        "IL": "Ізраїль",
        "IM": "Острів Мен",
        "IN": "Індія",
        "IO": "Британські території Індійського океану",
        "IQ": "Ірак",
        "IR": "Іран",
        "IS": "Ісландія",
        "IT": "Італія",
        "JE": "Джерсі",
        "JM": "Ямайка",
        "JO": "Йорданія",
        "JP": "Японія",
        "KE": "Кенія",
        "KG": "Киргизстан",
        "KH": "Камбоджа",
        "KI": "Кірибаті",
        "KM": "Коморські Острови",
        "KN": "Сент-Кітс і Невіс",
        "KP": "Північна Корея",
        "KR": "Південна Корея",
        "KW": "Кувейт",
        "KY": "Кайманові острови",
        "KZ": "Казахстан",
        "LA": "Лаос",
        "LB": "Ліван",
        "LC": "Сент-Люсія",
        "LI": "Ліхтенштейн",
        "LK": "Шрі-Ланка",
        "LR": "Ліберія",
        "LS": "Лесото",
        "LT": "Литва",
        "LU": "Люксембург",
        "LV": "Латвія",
        "LY": "Лівія",
        "MA": "Марокко",
        "MC": "Монако",
        "MD": "Молдова",
        "ME": "Чорногорія",
        "MF": "Острів Святого Мартіна",
        "MG": "Мадагаскар",
        "MH": "Маршаллові Острови",
        "MK": "Македонія",
        "ML": "Малі",
        "MM": "Мʼянма [Бірма]",
        "MN": "Монголія",
        "MO": "Макао",
        "MP": "Північні Маріанські Острови",
        "MQ": "Мартиніка",
        "MR": "Мавританія",
        "MS": "Монсеррат",
        "MT": "Мальта",
        "MU": "Маврикій",
        "MV": "Мальдіви",
        "MW": "Малаві",
        "MX": "Мексика",
        "MY": "Малайзія",
        "MZ": "Мозамбік",
        "NA": "Намібія",
        "NC": "Нова Каледонія",
        "NE": "Нігер",
        "NF": "Острів Норфолк",
        "NG": "Нігерія",
        "NI": "Нікарагуа",
        "NL": "Нідерланди",
        "NO": "Норвегія",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Нія",
        "NZ": "Нова Зеландія",
        "OM": "Оман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Французька Полінезія",
        "PG": "Папуа Нова Гвінея",
        "PH": "Філіппіни",
        "PK": "Пакистан",
        "PL": "Польща",
        "PM": "Сен-Пʼєр і Мікелон",
        "PN": "Піткерн",
        "PR": "Пуерто-Ріко",
        "PS": "Палестина",
        "PT": "Португалія",
        "PW": "Палау",
        "PY": "Парагвай",
        "QA": "Катар",
        "QO": "Інша Океанія",
        "RE": "Реюньйон",
        "RO": "Румунія",
        "RS": "Сербія",
        "RU": "Росія",
        "RW": "Руанда",
        "SA": "Саудівська Аравія",
        "SB": "Соломонові Острови",
        "SC": "Сейшели",
        "SD": "Судан",
        "SE": "Швеція",
        "SG": "Сінгапур",
        "SH": "Острів Святої Єлени",
        "SI": "Словенія",
        "SJ": "Острови Свальбард та Ян-Маєн",
        "SK": "Словакія",
        "SL": "Сьєрра-Леоне",
        "SM": "Сан-Марино",
        "SN": "Сенегал",
        "SO": "Сомалі",
        "SR": "Суринам",
        "ST": "Сан-Томе і Прінсіпі",
        "SV": "Сальвадор",
        "SY": "Сирія",
        "SZ": "Свазіленд",
        "TA": "Трістан-да-Кунья",
        "TC": "Теркс і Кайкос",
        "TD": "Чад",
        "TF": "Французькі Південні Території",
        "TG": "Того",
        "TH": "Таїланд",
        "TJ": "Таджикистан",
        "TK": "Токелау",
        "TL": "Тімор-Лешті",
        "TM": "Туркменистан",
        "TN": "Туніс",
        "TO": "Тонга",
        "TR": "Туреччина",
        "TT": "Тринідад і Тобаго",
        "TV": "Тувалу",
        "TW": "Тайвань",
        "TZ": "Танзанія",
        "UA": "Україна",
        "UG": "Уганда",
        "UM": "Віддалені Острови США",
        "US": "США",
        "UY": "Уругвай",
        "UZ": "Узбекистан",
        "VA": "Ватикан",
        "VC": "Сент-Вінсент і Гренадини",
        "VE": "Венесуела",
        "VG": "Віргінські острови Британії",
        "VI": "Віргінські острови США",
        "VN": "Вʼєтнам",
        "VU": "Вануату",
        "WF": "Уолліс і Футуна",
        "WS": "Самоа",
        "YE": "Ємен",
        "YT": "Майот",
        "ZA": "ПАР",
        "ZM": "Замбія",
        "ZW": "Зімбабве",
        "ZZ": "Невідомий або неправильний регіон"
    };
  }-*/;
}
