/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.GroupModRequest;
import com.amazonaws.services.identitymanagement.model.UpdateGroupRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMGroupModDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMGroupModDriver.class);

    public void invokeRequestImpl(CLIRequest request) {
        if (request instanceof GroupModRequest) {
            GroupModRequest req = (GroupModRequest)request;
            UpdateGroupRequest groupRequest = new UpdateGroupRequest();
            groupRequest.setGroupName(req.getGroupName());
            groupRequest.setNewGroupName(req.getNewGroupName());
            groupRequest.setNewPath(this.verifyPathAndAddSlashSuffix(req.getNewPath()));
            LOG.debug((Object)("Renaming/updating path for group with request: " + request));
            this.getClient().updateGroup(groupRequest);
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

