/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.pathable;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;

public class ChildFirstTestCase
extends TestCase {
    static /* synthetic */ Class class$org$apache$commons$logging$pathable$ChildFirstTestCase;
    static /* synthetic */ Class class$org$apache$commons$logging$PathableClassLoader;

    public static Test suite() throws Exception {
        Class thisClass = class$org$apache$commons$logging$pathable$ChildFirstTestCase == null ? (class$org$apache$commons$logging$pathable$ChildFirstTestCase = ChildFirstTestCase.class$("org.apache.commons.logging.pathable.ChildFirstTestCase")) : class$org$apache$commons$logging$pathable$ChildFirstTestCase;
        ClassLoader thisClassLoader = thisClass.getClassLoader();
        PathableClassLoader parent = new PathableClassLoader(null);
        parent.setParentFirst(false);
        parent.useExplicitLoader("junit.", thisClassLoader);
        parent.addLogicalLib("commons-logging");
        PathableClassLoader child = new PathableClassLoader(parent);
        child.setParentFirst(false);
        child.addLogicalLib("testclasses");
        child.addLogicalLib("commons-logging-adapters");
        PathableClassLoader context = new PathableClassLoader(child);
        context.setParentFirst(false);
        Class<?> testClass = child.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, context);
    }

    private Set getAncestorCLs() {
        HashSet<ClassLoader> s = new HashSet<ClassLoader>();
        for (ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
            s.add(cl);
        }
        return s;
    }

    public void testPaths() throws Exception {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        Assert.assertNotNull((String)"Context classloader is null", (Object)contextLoader);
        Assert.assertEquals((String)"Context classloader has unexpected type", (String)(class$org$apache$commons$logging$PathableClassLoader == null ? (class$org$apache$commons$logging$PathableClassLoader = ChildFirstTestCase.class$("org.apache.commons.logging.PathableClassLoader")) : class$org$apache$commons$logging$PathableClassLoader).getName(), (String)contextLoader.getClass().getName());
        ClassLoader thisLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Assert.assertNotNull((String)"thisLoader is null", (Object)thisLoader);
        Assert.assertEquals((String)"thisLoader has unexpected type", (String)(class$org$apache$commons$logging$PathableClassLoader == null ? (class$org$apache$commons$logging$PathableClassLoader = ChildFirstTestCase.class$("org.apache.commons.logging.PathableClassLoader")) : class$org$apache$commons$logging$PathableClassLoader).getName(), (String)thisLoader.getClass().getName());
        Assert.assertSame((String)"Context classloader is not child of thisLoader", (Object)thisLoader, (Object)contextLoader.getParent());
        ClassLoader parentLoader = thisLoader.getParent();
        Assert.assertNotNull((String)"Parent classloader is null", (Object)parentLoader);
        Assert.assertEquals((String)"Parent classloader has unexpected type", (String)(class$org$apache$commons$logging$PathableClassLoader == null ? (class$org$apache$commons$logging$PathableClassLoader = ChildFirstTestCase.class$("org.apache.commons.logging.PathableClassLoader")) : class$org$apache$commons$logging$PathableClassLoader).getName(), (String)parentLoader.getClass().getName());
        Assert.assertNull((String)"Parent classloader has non-null parent", (Object)parentLoader.getParent());
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        Assert.assertNotNull((String)"System classloader is null", (Object)systemLoader);
        Assert.assertFalse((String)"System classloader has unexpected type", (boolean)(class$org$apache$commons$logging$PathableClassLoader == null ? (class$org$apache$commons$logging$PathableClassLoader = ChildFirstTestCase.class$("org.apache.commons.logging.PathableClassLoader")) : class$org$apache$commons$logging$PathableClassLoader).getName().equals(systemLoader.getClass().getName()));
        Class<?> junitTest = contextLoader.loadClass("junit.framework.Test");
        Set ancestorCLs = this.getAncestorCLs();
        Assert.assertFalse((String)"Junit not loaded by ancestor classloader", (boolean)ancestorCLs.contains(junitTest.getClassLoader()));
        Class<?> logClass = contextLoader.loadClass("org.apache.commons.logging.Log");
        Assert.assertSame((String)"Log class not loaded via parent", (Object)logClass.getClassLoader(), (Object)parentLoader);
        Class<?> log4jClass = contextLoader.loadClass("org.apache.commons.logging.impl.Log4JLogger");
        Assert.assertSame((String)"Log4JLogger not loaded via child", (Object)log4jClass.getClassLoader(), (Object)thisLoader);
        Class<?> testClass = contextLoader.loadClass("org.apache.commons.logging.PathableTestSuite");
        Assert.assertSame((String)"PathableTestSuite not loaded via child", (Object)testClass.getClassLoader(), (Object)thisLoader);
        try {
            Class<?> noSuchClass = contextLoader.loadClass("no.such.class");
            Assert.fail((String)"Class no.such.class is unexpectedly available");
            Assert.assertNotNull(noSuchClass);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        Class<?> stringClass = contextLoader.loadClass("java.lang.String");
        Assert.assertNull((String)"String class classloader is not null!", (Object)stringClass.getClassLoader());
    }

    public void testResource() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader childLoader = contextLoader.getParent();
        URL resource = childLoader.getResource("nosuchfile");
        Assert.assertNull((String)"Non-null URL returned for invalid resource name", (Object)resource);
        resource = childLoader.getResource("org/apache/commons/logging/Log.class");
        Assert.assertNotNull((String)"Unable to locate Log.class resource", (Object)resource);
        resource = childLoader.getResource("org/apache/commons/logging/PathableTestSuite.class");
        Assert.assertNotNull((String)"Unable to locate PathableTestSuite.class resource", (Object)resource);
        resource = childLoader.getResource("org/apache/commons/logging/impl/Log4JLogger.class");
        Assert.assertNotNull((String)"Unable to locate Log4JLogger.class resource", (Object)resource);
        Assert.assertTrue((String)"Incorrect source for Log4JLogger class", (resource.toString().indexOf("/commons-logging-adapters-1.") > 0 ? 1 : 0) != 0);
    }

    public void testResources() throws Exception {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader childLoader = contextLoader.getParent();
        ClassLoader parentLoader = childLoader.getParent();
        ClassLoader bootLoader = parentLoader.getParent();
        Assert.assertNull((String)"Unexpected classloader hierarchy", (Object)bootLoader);
        Enumeration<URL> resources = childLoader.getResources("nosuchfile");
        URL[] urls = ChildFirstTestCase.toURLArray(resources);
        Assert.assertEquals((String)"Non-null URL returned for invalid resource name", (int)0, (int)urls.length);
        resources = childLoader.getResources("org/apache/commons/logging/Log.class");
        urls = ChildFirstTestCase.toURLArray(resources);
        Assert.assertEquals((String)"Unexpected number of Log.class resources found", (int)1, (int)urls.length);
        resources = childLoader.getResources("org/apache/commons/logging/PathableTestSuite.class");
        urls = ChildFirstTestCase.toURLArray(resources);
        Assert.assertEquals((String)"Unexpected number of PathableTestSuite.class resources found", (int)1, (int)urls.length);
        resources = childLoader.getResources("org/apache/commons/logging/impl/Log4JLogger.class");
        urls = ChildFirstTestCase.toURLArray(resources);
        Assert.assertEquals((String)"Unexpected number of Log4JLogger.class resources found", (int)2, (int)urls.length);
        Object[] urlsToStrings = new String[]{urls[0].toString(), urls[1].toString()};
        Arrays.sort(urlsToStrings);
        Assert.assertTrue((String)"Incorrect source for Log4JLogger class", (((String)urlsToStrings[0]).indexOf("/commons-logging-1.") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect source for Log4JLogger class", (((String)urlsToStrings[1]).indexOf("/commons-logging-adapters-1.") > 0 ? 1 : 0) != 0);
    }

    private static URL[] toURLArray(Enumeration e) {
        ArrayList<URL> l = new ArrayList<URL>();
        while (e.hasMoreElements()) {
            URL u = (URL)e.nextElement();
            l.add(u);
        }
        URL[] tmp = new URL[l.size()];
        return l.toArray(tmp);
    }

    public void testResourceAsStream() throws Exception {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader childLoader = contextLoader.getParent();
        ClassLoader parentLoader = childLoader.getParent();
        ClassLoader bootLoader = parentLoader.getParent();
        Assert.assertNull((String)"Unexpected classloader hierarchy", (Object)bootLoader);
        InputStream is = childLoader.getResourceAsStream("nosuchfile");
        Assert.assertNull((String)"Invalid resource returned non-null stream", (Object)is);
        is = childLoader.getResourceAsStream("org/apache/commons/logging/Log.class");
        Assert.assertNotNull((String)"Null returned for valid resource", (Object)is);
        is.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

