/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.nanoScheduler;

import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.AutoFormattingTime;
import org.broadinstitute.sting.utils.SimpleTimer;

public class NSRuntimeProfile {
    final SimpleTimer outsideSchedulerTimer = new SimpleTimer("outside");
    final SimpleTimer inputTimer = new SimpleTimer("input");
    final SimpleTimer mapTimer = new SimpleTimer("map");
    final SimpleTimer reduceTimer = new SimpleTimer("reduce");

    public void combine(NSRuntimeProfile other) {
        this.outsideSchedulerTimer.addElapsed(other.outsideSchedulerTimer);
        this.inputTimer.addElapsed(other.inputTimer);
        this.mapTimer.addElapsed(other.mapTimer);
        this.reduceTimer.addElapsed(other.reduceTimer);
    }

    public void log(Logger logger) {
        this.log1(logger, "Input   time", this.inputTimer);
        this.log1(logger, "Map     time", this.mapTimer);
        this.log1(logger, "Reduce  time", this.reduceTimer);
        this.log1(logger, "Outside time", this.outsideSchedulerTimer);
    }

    public double totalRuntimeInSeconds() {
        return this.inputTimer.getElapsedTime() + this.mapTimer.getElapsedTime() + this.reduceTimer.getElapsedTime() + this.outsideSchedulerTimer.getElapsedTime();
    }

    private void log1(Logger logger, String label, SimpleTimer timer) {
        double myTimeInSec = timer.getElapsedTime();
        double myTimePercent = myTimeInSec / this.totalRuntimeInSeconds() * 100.0;
        logger.info((Object)String.format("%s: %s (%5.2f%%)", label, new AutoFormattingTime(myTimeInSec), myTimePercent));
    }
}

