/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.rans;

import java.nio.ByteBuffer;

class Encoding {
    Encoding() {
    }

    static void RansEncSymbolInit(RansEncSymbol s, int start, int freq, int scale_bits) {
        s.x_max = (0x800000 >> scale_bits << 8) * freq;
        s.cmpl_freq = (1 << scale_bits) - freq;
        if (freq < 2) {
            s.rcp_freq = -1;
            s.rcp_shift = 0;
            s.bias = start + (1 << scale_bits) - 1;
        } else {
            int shift = 0;
            while ((long)freq > 1L << shift) {
                ++shift;
            }
            s.rcp_freq = (int)(((1L << shift + 31) + (long)freq - 1L) / (long)freq);
            s.rcp_shift = shift - 1;
            s.bias = start;
        }
        s.rcp_shift += 32;
    }

    static int RansEncPutSymbol(int r, ByteBuffer ptr, RansEncSymbol sym) {
        assert (sym.x_max != 0);
        int x = r;
        int x_max = sym.x_max;
        if (x >= x_max && x >= x_max) {
            ptr.put((byte)(x & 0xFF));
            if ((x >>= 8) >= x_max) {
                ptr.put((byte)(x & 0xFF));
                x >>= 8;
            }
        }
        long q = (long)x * (0xFFFFFFFFL & (long)sym.rcp_freq) >> sym.rcp_shift;
        r = (int)((long)(x + sym.bias) + q * (long)sym.cmpl_freq);
        return r;
    }

    static class RansEncSymbol {
        int x_max;
        int rcp_freq;
        int bias;
        int cmpl_freq;
        int rcp_shift;

        RansEncSymbol() {
        }
    }
}

